/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.particles.options.DebrisParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DustParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RhyzaInvisibilityGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Phase currentPhase;

    public RhyzaInvisibilityGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.INVISIBILITY;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.INVISIBILITY;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
        if (!this.rhyza.antiFallMove) {
            this.rhyza.setFadeTicks(0);
            this.rhyza.m_6842_(true);
            this.rhyza.setInvisibilityState(RhyzaEntity.InvisibilityState.START.ordinal());
            this.currentPhase = Phase.START;
        } else {
            this.rhyza.setFadeTicks(30);
            this.rhyza.m_6842_(true);
            this.rhyza.setInvisibilityState(RhyzaEntity.InvisibilityState.ATTACK.ordinal());
            this.rhyza.startTrackingEntity(this.rhyza.m_5448_(), 5, 100.0f);
            this.currentPhase = Phase.ATTACK;
            LivingEntity target = this.rhyza.m_5448_();
            if (target != null) {
                boolean foundSpot = false;
                double radius = 8.0;
                for (int i = 0; i < 10; ++i) {
                    double angle = this.rhyza.m_217043_().m_188500_() * 2.0 * Math.PI;
                    double destX = target.m_20185_() + radius * Math.cos(angle);
                    double destZ = target.m_20189_() + radius * Math.sin(angle);
                    int targetY = target.m_146904_();
                    for (int yOffset = 2; yOffset >= -3; --yOffset) {
                        BlockPos testPos = new BlockPos((int)destX, targetY + yOffset, (int)destZ);
                        BlockState groundState = this.rhyza.m_9236_().m_8055_(testPos);
                        if (!groundState.m_280296_() || !this.rhyza.m_9236_().m_8055_(testPos.m_7494_()).m_60795_() || !this.rhyza.m_9236_().m_8055_(testPos.m_6630_(2)).m_60795_()) continue;
                        this.rhyza.m_6021_(destX, targetY + yOffset + 1, destZ);
                        foundSpot = true;
                        break;
                    }
                    if (foundSpot) break;
                }
            }
            this.rhyza.antiFallMove = false;
        }
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        if (this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.INVISIBILITY) {
            this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        }
        this.rhyza.setRotationManual(false);
        this.rhyza.setInvisibilityState(RhyzaEntity.InvisibilityState.NONE.ordinal());
        this.currentPhase = null;
        this.rhyza.m_6842_(false);
        this.rhyza.setFadeTicks(0);
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case START: {
                if (this.tickCount > 2 && this.tickCount < 5) {
                    Vec3 frontVec = this.rhyza.m_20154_();
                    this.rhyza.m_20256_(frontVec.m_82490_((double)0.3f));
                }
                if (this.tickCount == 5) {
                    this.rhyza.inflictRoar(30.0, 40);
                    this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_ROAR_ENRAGE.get(), this.rhyza.m_5720_(), 5.0f, 1.0f);
                    ModNetwork.sendToClientsTracking(new ScreenShakePacket(120, 1), (Entity)this.rhyza);
                }
                if (this.tickCount > 5 && this.tickCount < 17) {
                    ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)ParticleTypes.f_123747_, this.rhyza.getHeadPart().m_20182_(), Vec3.f_82478_, true), (Entity)this.rhyza);
                }
                if (this.tickCount > 26 && this.tickCount < 30) {
                    Vec3 rightVec = this.rhyza.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0));
                    this.rhyza.m_20256_(rightVec.m_82490_(-1.5));
                    if (this.rhyza.getFadeTicks() < 30) {
                        this.rhyza.setFadeTicks(this.rhyza.getFadeTicks() + 10);
                    }
                }
                int debrisCount = 30;
                int dustCount = 30;
                double spawnRadius = 2.0;
                if (this.tickCount == 28) {
                    double velZ;
                    double velY;
                    double velX;
                    Object options;
                    BlockState groundState;
                    BlockPos groundPos;
                    Vec3 particleSpawnPos;
                    double offsetZ;
                    double offsetX;
                    double distance;
                    double angle;
                    int i;
                    this.rhyza.m_6842_(true);
                    for (i = 0; i < debrisCount; ++i) {
                        angle = this.rhyza.m_217043_().m_188500_() * 2.0 * Math.PI;
                        distance = this.rhyza.m_217043_().m_188500_() * spawnRadius;
                        offsetX = Math.cos(angle) * distance;
                        offsetZ = Math.sin(angle) * distance;
                        particleSpawnPos = this.rhyza.m_20182_().m_82520_(offsetX, 0.2, offsetZ);
                        groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                        groundState = this.rhyza.m_9236_().m_8055_(groundPos);
                        if (groundState.m_60795_()) continue;
                        options = new DebrisParticleOptions(groundState);
                        velX = (this.rhyza.m_217043_().m_188500_() - 0.2) * 0.8;
                        velY = this.rhyza.m_217043_().m_188500_() * 0.3;
                        velZ = (this.rhyza.m_217043_().m_188500_() - 0.2) * 0.8;
                        ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ).m_82549_(this.rhyza.m_20154_().m_82541_().m_82537_(new Vec3(0.0, -1.0, 0.0))).m_82490_(1.0), true), (Entity)this.rhyza);
                    }
                    for (i = 0; i < dustCount; ++i) {
                        angle = this.rhyza.m_217043_().m_188500_() * 2.0 * Math.PI;
                        distance = this.rhyza.m_217043_().m_188500_() * spawnRadius;
                        offsetX = Math.cos(angle) * distance;
                        offsetZ = Math.sin(angle) * distance;
                        particleSpawnPos = this.rhyza.m_20182_().m_82520_(offsetX, 0.2, offsetZ);
                        groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                        groundState = this.rhyza.m_9236_().m_8055_(groundPos);
                        if (groundState.m_60795_()) continue;
                        options = new DustParticleOptions(groundState);
                        velX = (this.rhyza.m_217043_().m_188500_() - 0.2) * 0.15;
                        velY = this.rhyza.m_217043_().m_188500_() * 0.05;
                        velZ = (this.rhyza.m_217043_().m_188500_() - 0.2) * 0.15;
                        ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ).m_82549_(this.rhyza.m_20154_().m_82541_().m_82537_(new Vec3(0.0, -1.0, 0.0))).m_82490_(0.25), true), (Entity)this.rhyza);
                    }
                }
                if (this.tickCount == 36) {
                    LivingEntity target = this.rhyza.m_5448_();
                    this.rhyza.m_6842_(true);
                    this.rhyza.setFadeTicks(30);
                    if (target != null) {
                        boolean foundSpot = false;
                        double radius = 8.0;
                        for (int i = 0; i < 10; ++i) {
                            double angle = this.rhyza.m_217043_().m_188500_() * 2.0 * Math.PI;
                            double destX = target.m_20185_() + radius * Math.cos(angle);
                            double destZ = target.m_20189_() + radius * Math.sin(angle);
                            int targetY = target.m_146904_();
                            for (int yOffset = 2; yOffset >= -3; --yOffset) {
                                BlockPos testPos = new BlockPos((int)destX, targetY + yOffset, (int)destZ);
                                BlockState groundState = this.rhyza.m_9236_().m_8055_(testPos);
                                if (!groundState.m_280296_() || !this.rhyza.m_9236_().m_8055_(testPos.m_7494_()).m_60795_() || !this.rhyza.m_9236_().m_8055_(testPos.m_6630_(2)).m_60795_()) continue;
                                this.rhyza.m_6021_(destX, targetY + yOffset + 1, destZ);
                                foundSpot = true;
                                break;
                            }
                            if (foundSpot) break;
                        }
                    }
                }
                if (this.tickCount == 39) {
                    this.rhyza.startTrackingEntity(this.rhyza.m_5448_(), 10, 100.0f);
                }
                if (this.tickCount <= 40) break;
                this.currentPhase = Phase.ATTACK;
                this.rhyza.setInvisibilityState(RhyzaEntity.InvisibilityState.ATTACK.ordinal());
                this.tickCount = 0;
                break;
            }
            case ATTACK: {
                if (this.rhyza.getFadeTicks() > 0) {
                    this.rhyza.setFadeTicks(this.rhyza.getFadeTicks() - 3);
                }
                if (this.tickCount == 1) {
                    // empty if block
                }
                if (this.tickCount > 3 && this.tickCount < 7) {
                    this.rhyza.m_20256_(this.rhyza.m_20154_().m_82541_().m_82490_((double)1.3f));
                }
                if (this.tickCount >= 7 && this.tickCount < 10) {
                    this.rhyza.m_20256_(this.rhyza.m_20154_().m_82541_().m_82490_(0.25));
                }
                if (this.tickCount == 6) {
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 1.0).ignoreShield().addEffect(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), 200), 1.0f).build();
                    this.rhyza.dealDamageInOrientedBox(this.rhyza.m_20182_(), new Vec3(0.0, 0.0, 3.0), 8.0, 8.0, 6.0, attackDefinition);
                }
                if (this.tickCount != 32) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        START,
        ATTACK;

    }
}

