/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class RhyzaSlamGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private boolean isExecuting = false;

    public RhyzaSlamGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.SLAM;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.SLAM;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
        this.rhyza.resetPartOffsets();
        this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_SLAM.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        if (this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.SLAM) {
            this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        }
        this.rhyza.setRotationManual(false);
        this.rhyza.resetPartOffsets();
    }

    public void m_8037_() {
        Vec3 retreatVector;
        ++this.tickCount;
        if (this.tickCount == 1) {
            this.rhyza.startTrackingEntity(this.rhyza.m_5448_(), 30, 5.0f);
        }
        if (this.tickCount > 1 && this.tickCount <= 10) {
            retreatVector = this.rhyza.m_20154_().m_82490_(0.35);
            this.rhyza.m_20256_(retreatVector);
            this.rhyza.addPartOffset(this.rhyza.getHeadPart(), new Vec3(-0.05, 0.18, -0.1));
        }
        if (this.tickCount >= 10 && this.tickCount <= 12) {
            this.rhyza.m_20256_(Vec3.f_82478_);
        }
        if (this.tickCount == 14) {
            this.rhyza.setPartOffset(this.rhyza.getHeadPart(), new Vec3(0.5, -1.0, 0.15));
        }
        if (this.tickCount >= 14 && this.tickCount <= 15) {
            retreatVector = this.rhyza.m_20154_().m_82490_(1.0);
            this.rhyza.m_20256_(retreatVector);
        }
        if (this.tickCount == 17) {
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 1.0).breakShield(200).stun(45).build();
            this.rhyza.dealDamageInOrientedBox(this.rhyza.m_20182_(), new Vec3(0.0, 0.0, 3.0), 7.0, 7.0, 7.0, attackDefinition);
            this.rhyza.spawnGroundEffects(new Vec3(0.0, 0.0, 3.0), 3.0f, 10, 20, 5);
            this.rhyza.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 3.0), 2.0f, 240);
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
        }
        if (this.tickCount == 20) {
            this.rhyza.resetPartOffsets();
        }
        if (this.tickCount == 25) {
            this.isExecuting = false;
        }
    }
}

