/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.rhyza;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.RhyzaEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class RhyzaTailswipeGoal
extends Goal {
    private RhyzaEntity rhyza;
    private int tickCount = 0;
    private Vec3 direction;
    private float firstBodyYaw;
    private boolean isExecuting = false;

    public RhyzaTailswipeGoal(RhyzaEntity rhyza) {
        this.rhyza = rhyza;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.rhyza.m_5448_() != null && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.TAILSWIPE;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.rhyza.getCurrentAbility() == RhyzaEntity.Ability.TAILSWIPE;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.rhyza.m_21573_().m_26573_();
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setRotationManual(true);
        this.rhyza.resetPartOffsets();
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.rhyza.m_20256_(Vec3.f_82478_);
        this.rhyza.setCurrentAbility(RhyzaEntity.Ability.NONE);
        this.rhyza.setRotationManual(false);
        this.rhyza.resetPartOffsets();
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount <= 1 || this.tickCount < 10) {
            // empty if block
        }
        if (this.tickCount == 1) {
            this.direction = this.rhyza.m_20154_().m_82490_(-1.0);
            this.firstBodyYaw = this.rhyza.f_20883_;
            this.rhyza.setTargetRotation(this.rhyza.f_20883_ + 245.0f, 0.0f, 15, AbstractLargeMonster.TurnDirection.RIGHT, true);
        }
        if (this.tickCount == 8) {
            this.rhyza.setTargetRotation(this.firstBodyYaw + 180.0f, 0.0f, 10, AbstractLargeMonster.TurnDirection.SHORTEST, true);
        }
        if (this.tickCount == 10) {
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_DASH.get(), this.rhyza.m_5720_(), 1.0f, 1.0f);
        }
        if (this.tickCount >= 10 && this.tickCount <= 13) {
            this.rhyza.m_20256_(this.direction.m_82490_((double)1.7f));
        }
        if (this.tickCount == 15) {
            this.rhyza.m_9236_().m_6263_(null, this.rhyza.m_20185_(), this.rhyza.m_20186_(), this.rhyza.m_20189_(), (SoundEvent)ModSounds.RHYZA_DRAG.get(), this.rhyza.m_5720_(), 2.0f, 1.0f);
            this.rhyza.setTargetRotation(this.rhyza.getPredictedAngle(1), 0.0f, 20, AbstractLargeMonster.TurnDirection.LEFT, true);
            this.rhyza.setPartOffset(this.rhyza.getHeadPart(), new Vec3(0.0, -1.5, 0.0));
        }
        if (this.tickCount >= 15 && this.tickCount <= 30) {
            double slideSpeed = Mth.m_14139_((double)((float)(this.tickCount - 15) / 13.0f), (double)1.5, (double)0.0);
            this.rhyza.m_20256_(this.direction.m_82490_(slideSpeed));
        }
        if (this.tickCount == 25) {
            this.rhyza.resetPartOffsets();
            this.rhyza.m_20256_(Vec3.f_82478_);
        }
        if (this.tickCount == 30) {
            this.isExecuting = false;
        }
    }
}

