/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.world.entity.ai.goal.Goal;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;

public class SkrytheFlyGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private Phase currentPhase;

    public SkrytheFlyGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        return this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.FLY;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.FLY;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.skrythe.m_21573_().m_26573_();
        int chanceMul = 0;
        if (this.skrythe.rightWingBroken || this.skrythe.leftWingBroken) {
            chanceMul = 1;
            if (this.skrythe.rightWingBroken && this.skrythe.leftWingBroken) {
                chanceMul = 2;
            }
        }
        if (chanceMul > 0) {
            double baseChance = 0.25;
            double finalChance = baseChance * (double)chanceMul;
            if (this.skrythe.m_217043_().m_188500_() < finalChance) {
                this.currentPhase = Phase.FAIL;
                this.skrythe.setFlyState(SkrytheEntity.FlyState.FAIL.ordinal());
            } else {
                this.currentPhase = Phase.SUCCESS;
                this.skrythe.setFlyState(SkrytheEntity.FlyState.SUCCESS.ordinal());
            }
        } else {
            this.currentPhase = Phase.SUCCESS;
            this.skrythe.setFlyState(SkrytheEntity.FlyState.SUCCESS.ordinal());
        }
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.FLY) {
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case SUCCESS: {
                if (this.tickCount == 5) {
                    this.skrythe.m_20334_(0.0, 0.25, 0.0);
                    this.skrythe.enableFly();
                }
                if (this.tickCount <= 15) break;
                this.isExecuting = false;
                break;
            }
            case FAIL: {
                if (this.tickCount == 7) {
                    this.skrythe.m_20334_(0.0, 0.5, 0.0);
                }
                if (this.tickCount == 13) {
                    this.skrythe.m_20334_(0.0, -1.0, 0.0);
                }
                if (this.tickCount <= 35) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        SUCCESS,
        FAIL;

    }
}

