/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class SkrytheRoarGoal
extends Goal {
    private final SkrytheEntity skrythe;
    private int tickCount = 0;
    private boolean isAbilityEnraged = false;
    private Phase currentPhase;
    private float targetYaw;
    private boolean isExecuting = false;

    public SkrytheRoarGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.ROAR && this.skrythe.m_5448_() != null;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.ROAR;
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.ROAR) {
            this.skrythe.setRotationManual(false);
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        this.skrythe.setRoarState(SkrytheEntity.RoarState.NONE.ordinal());
        this.currentPhase = null;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.isAbilityEnraged = this.skrythe.isAbilityEnraged();
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.setRotationManual(true);
        this.targetYaw = this.skrythe.getPredictedAngle(5, this.skrythe.m_5448_());
        Vec3 vecToTarget = this.skrythe.getPredictedTargetPosition(this.skrythe.m_5448_(), 5).m_82546_(this.skrythe.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.skrythe.m_20154_());
        if (dotProduct > 0.8) {
            this.currentPhase = Phase.FRONT;
            this.skrythe.setRoarState(SkrytheEntity.RoarState.FRONT.ordinal());
        } else if (this.skrythe.isPositionOnLeft(this.skrythe.getPredictedTargetPosition(this.skrythe.m_5448_(), 5))) {
            this.skrythe.setRoarState(SkrytheEntity.RoarState.LEFT.ordinal());
            this.currentPhase = Phase.LEFT;
        } else {
            this.skrythe.setRoarState(SkrytheEntity.RoarState.RIGHT.ordinal());
            this.currentPhase = Phase.RIGHT;
        }
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case LEFT: {
                if (this.tickCount == 5) {
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 15, AbstractLargeMonster.TurnDirection.LEFT, true);
                }
                if (this.tickCount == 16) {
                    ModNetwork.sendToClientsTracking(new ScreenShakePacket(180, 1), (Entity)this.skrythe);
                    this.skrythe.inflictRoar(30.0, 40);
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_ROAR.get(), this.skrythe.m_5720_(), 5.0f, 1.0f);
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.NONE, 1.0).breakShield(200).stun(45).build();
                    this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, 12.0), 8.0, 30.0, 20.0, attackDefinition);
                }
                if (this.tickCount > 16 && this.tickCount <= 27) {
                    ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)ParticleTypes.f_123747_, this.skrythe.getHeadPart().m_20182_(), Vec3.f_82478_, true), (Entity)this.skrythe);
                }
                if (this.tickCount <= 40) break;
                this.isExecuting = false;
                break;
            }
            case RIGHT: {
                if (this.tickCount == 5) {
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 15, AbstractLargeMonster.TurnDirection.RIGHT, true);
                }
                if (this.tickCount == 16) {
                    ModNetwork.sendToClientsTracking(new ScreenShakePacket(180, 1), (Entity)this.skrythe);
                    this.skrythe.inflictRoar(30.0, 40);
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_ROAR.get(), this.skrythe.m_5720_(), 5.0f, 1.0f);
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.NONE, 1.0).breakShield(200).stun(45).build();
                    this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, 12.0), 8.0, 30.0, 20.0, attackDefinition);
                }
                if (this.tickCount > 16 && this.tickCount <= 27) {
                    ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)ParticleTypes.f_123747_, this.skrythe.getHeadPart().m_20182_(), Vec3.f_82478_, true), (Entity)this.skrythe);
                }
                if (this.tickCount <= 40) break;
                this.isExecuting = false;
                break;
            }
            case FRONT: {
                if (this.tickCount == 10) {
                    ModNetwork.sendToClientsTracking(new ScreenShakePacket(240, 1), (Entity)this.skrythe);
                    this.skrythe.inflictRoar(30.0, 40);
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_ROAR.get(), this.skrythe.m_5720_(), 5.0f, 1.0f);
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.NONE, 1.0).breakShield(200).stun(45).build();
                    this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, 12.0), 8.0, 30.0, 20.0, attackDefinition);
                }
                if (this.tickCount > 10 && this.tickCount <= 23) {
                    ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)ParticleTypes.f_123747_, this.skrythe.getHeadPart().m_20182_(), Vec3.f_82478_, true), (Entity)this.skrythe);
                }
                if (this.tickCount <= 30) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        RIGHT,
        LEFT,
        FRONT;

    }
}

