/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class SkrytheRushGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount = 0;
    private boolean isAbilityEnraged = false;
    private EnragedPhase currentPhase;
    private Vec3 direction;
    private float targetYaw;
    private boolean isExecuting = false;
    private boolean hasHitTarget = false;
    private int hitCount = 0;
    private final double SPEED = 0.8;

    public SkrytheRushGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.skrythe.m_5448_() != null && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.RUSH;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.RUSH;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.hasHitTarget = false;
        this.isAbilityEnraged = this.skrythe.isAbilityEnraged();
        this.currentPhase = EnragedPhase.BASE;
        this.skrythe.setEnragedRushState(SkrytheEntity.EnragedRushState.BASE.ordinal());
        this.direction = this.skrythe.getPredictedHorizontalDirection(20);
        this.targetYaw = this.skrythe.getPredictedAngle(20);
        this.skrythe.resetPartOffsets();
        this.hitCount = 0;
        this.skrythe.setRotationManual(true);
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.setRotationManual(true);
        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_RUSH.get(), this.skrythe.m_5720_(), 1.5f, 1.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.RUSH) {
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
            this.skrythe.setRotationManual(false);
        }
        this.skrythe.setEnragedRushState(SkrytheEntity.EnragedRushState.NONE.ordinal());
        this.targetYaw = this.skrythe.getPredictedAngle(20);
        this.direction = this.skrythe.getPredictedHorizontalDirection(20);
        this.currentPhase = null;
        this.skrythe.m_20256_(Vec3.f_82478_);
    }

    public void m_8037_() {
        ++this.tickCount;
        AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 3.0).breakShield(100).stun(25).build();
        AttackDefinition enragedAttackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.FORWARD, 5.0).ignoreShield().stun(35).build();
        if (!this.isAbilityEnraged) {
            if (this.tickCount >= 1 && this.tickCount <= 15) {
                this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -0.15, 0.0));
            }
            if (this.tickCount == 18) {
                this.direction = this.skrythe.getPredictedHorizontalDirection(20);
                this.targetYaw = this.skrythe.getPredictedAngle(20);
                this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 20, AbstractLargeMonster.TurnDirection.SHORTEST, true);
            }
            if (this.tickCount > 18 && this.tickCount < 40) {
                Vec3 speedVec = this.direction.m_82490_(0.8);
                this.skrythe.m_20334_(speedVec.m_82507_(Direction.Axis.X), this.skrythe.m_20184_().m_82507_(Direction.Axis.Y), speedVec.m_82507_(Direction.Axis.Z));
                this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, 4.0), 10.0, 8.0, 6.0, enragedAttackDefinition);
            }
            if (this.tickCount == 35) {
                this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 1.0, 0.0));
            }
            if (this.tickCount == 40) {
                this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 1.0, 0.0));
            }
            if (this.tickCount == 42) {
                this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 1.0, 0.0));
            }
            if (this.tickCount > 50) {
                this.isExecuting = false;
            }
            return;
        }
        switch (this.currentPhase) {
            case BASE: {
                if (this.tickCount >= 1 && this.tickCount <= 15) {
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -0.15, 0.0));
                }
                if (this.tickCount == 18) {
                    this.direction = this.skrythe.getPredictedHorizontalDirection(20);
                    this.targetYaw = this.skrythe.getPredictedAngle(20);
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 20, AbstractLargeMonster.TurnDirection.SHORTEST, true);
                }
                if (this.tickCount > 18 && this.tickCount < 40) {
                    Vec3 speedVec = this.direction.m_82490_(0.8);
                    this.skrythe.m_20334_(speedVec.m_82507_(Direction.Axis.X), this.skrythe.m_20184_().m_82507_(Direction.Axis.Y), speedVec.m_82507_(Direction.Axis.Z));
                    if (this.skrythe.isTargetInOrientedBox(this.skrythe.m_5448_(), Vec3.f_82478_, 10.0, 8.0, 10.0)) {
                        this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, 4.0), 10.0, 8.0, 6.0, enragedAttackDefinition);
                        this.hasHitTarget = true;
                    }
                }
                if (this.tickCount == 35) {
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 1.0, 0.0));
                }
                if (this.tickCount == 40) {
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 1.0, 0.0));
                }
                if (this.tickCount == 42) {
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 1.0, 0.0));
                }
                if (this.tickCount != 45) break;
                this.tickCount = 0;
                this.currentPhase = this.hasHitTarget ? EnragedPhase.END : EnragedPhase.SLIDE;
                this.skrythe.setEnragedRushState(this.hasHitTarget ? SkrytheEntity.EnragedRushState.END.ordinal() : SkrytheEntity.EnragedRushState.SLIDE.ordinal());
                break;
            }
            case SLIDE: {
                this.skrythe.spawnGroundEffects(Vec3.f_82478_, 5.0f, 2, 0, 0);
                if (this.tickCount == 1) {
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_ENRAGED_RUSH_SLIDE.get(), this.skrythe.m_5720_(), 1.35f, 1.0f);
                    this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 2.0, 0.0));
                }
                double slideSpeed = Mth.m_14139_((double)((float)this.tickCount / 13.0f), (double)0.8, (double)0.0);
                this.skrythe.m_20256_(this.direction.m_82490_(slideSpeed));
                if (this.tickCount <= 10) break;
                this.tickCount = 0;
                this.currentPhase = EnragedPhase.TURN;
                this.skrythe.setEnragedRushState(SkrytheEntity.EnragedRushState.TURN.ordinal());
                break;
            }
            case TURN: {
                this.skrythe.resetPartOffsets();
                if (this.tickCount == 1) {
                    this.targetYaw = this.skrythe.getPredictedAngle(1);
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 20, AbstractLargeMonster.TurnDirection.SHORTEST, true);
                }
                if (this.tickCount <= 15) break;
                this.tickCount = 0;
                this.currentPhase = EnragedPhase.RE_RUSH;
                this.skrythe.setEnragedRushState(SkrytheEntity.EnragedRushState.RE_RUSH.ordinal());
                break;
            }
            case RE_RUSH: {
                if (this.tickCount >= 1 && this.tickCount <= 5) {
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -0.5, 0.0));
                }
                if (this.tickCount == 1) {
                    ++this.hitCount;
                    this.direction = this.skrythe.getPredictedHorizontalDirection(10);
                    this.targetYaw = this.skrythe.getPredictedAngle(10);
                    this.skrythe.setTargetRotation(this.targetYaw, 0.0f, 20, AbstractLargeMonster.TurnDirection.SHORTEST, true);
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_ENRAGED_RUSH_RERUSH.get(), this.skrythe.m_5720_(), 1.5f, 1.0f);
                }
                if (this.tickCount > 5 && this.tickCount < 30) {
                    Vec3 speedVec = this.direction.m_82490_(1.2000000000000002);
                    this.skrythe.m_20334_(speedVec.m_82507_(Direction.Axis.X), this.skrythe.m_20184_().m_82507_(Direction.Axis.Y), speedVec.m_82507_(Direction.Axis.Z));
                    if (this.skrythe.isTargetInOrientedBox(this.skrythe.m_5448_(), Vec3.f_82478_, 10.0, 8.0, 10.0)) {
                        this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, 4.0), 10.0, 8.0, 6.0, enragedAttackDefinition);
                        this.hasHitTarget = true;
                    }
                }
                if (this.tickCount > 20 && this.tickCount < 25) {
                    this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 0.5, 0.0));
                }
                if (this.tickCount != 25) break;
                this.tickCount = 0;
                if (this.hitCount >= 3) {
                    this.hasHitTarget = true;
                }
                this.currentPhase = this.hasHitTarget ? EnragedPhase.END : EnragedPhase.SLIDE;
                this.skrythe.setEnragedRushState(this.hasHitTarget ? SkrytheEntity.EnragedRushState.END.ordinal() : SkrytheEntity.EnragedRushState.SLIDE.ordinal());
                break;
            }
            case END: {
                this.skrythe.resetPartOffsets();
                if (this.tickCount <= 10) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum EnragedPhase {
        BASE,
        SLIDE,
        TURN,
        RE_RUSH,
        END;

    }
}

