/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class SkrytheStompGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount = 0;
    private boolean isExecuting = false;
    private final int JUMP_HEIGHT = 2;
    private Phase currentPhase;

    public SkrytheStompGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.skrythe.m_5448_() != null && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.STOMP;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.STOMP;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.currentPhase = Phase.STARTUP;
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.setRotationManual(true);
        this.skrythe.setStompState(SkrytheEntity.StompState.STARTUP.ordinal());
    }

    public void m_8041_() {
        this.isExecuting = false;
        this.skrythe.setStompState(SkrytheEntity.StompState.NONE.ordinal());
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.STOMP) {
            this.skrythe.setRotationManual(false);
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case STARTUP: {
                if (this.tickCount == 7) {
                    this.skrythe.m_20256_(this.skrythe.m_20184_().m_82520_(0.0, 2.0, 0.0));
                }
                if (this.tickCount < 20) break;
                this.tickCount = 0;
                this.currentPhase = Phase.AIRBORNE;
                this.skrythe.setStompState(SkrytheEntity.StompState.AIRBORNE.ordinal());
                float targetYaw = this.skrythe.getPredictedAngle(1);
                this.skrythe.setTargetRotation(targetYaw, 0.0f, 10, AbstractLargeMonster.TurnDirection.SHORTEST, true);
                break;
            }
            case AIRBORNE: {
                if (!this.skrythe.m_20096_() || this.tickCount < 10) break;
                this.tickCount = 0;
                this.currentPhase = Phase.SLAM;
                this.skrythe.setStompState(SkrytheEntity.StompState.SLAM.ordinal());
                break;
            }
            case SLAM: {
                this.skrythe.setRotationManual(false);
                if (this.tickCount == 5) {
                    this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
                    ModNetwork.sendToClientsTracking(new ScreenShakePacket(20, 5), (Entity)this.skrythe);
                    this.skrythe.spawnGroundEffects(new Vec3(0.0, 0.0, 5.0), 10.0f, 80, 80, 20);
                    this.skrythe.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, 5.0), 3.0f, 240);
                    AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(3.0f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 5.0).ignoreShield().stun(55).build();
                    this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, 5.0), 20.0, 8.0, 20.0, attackDefinition);
                }
                if (this.tickCount < 18) break;
                this.isExecuting = false;
            }
        }
    }

    private static enum Phase {
        STARTUP,
        AIRBORNE,
        SLAM;

    }
}

