/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class SkrytheTailSlamGoal
extends Goal {
    private final SkrytheEntity skrythe;
    private int tickCount = 0;
    private boolean isAbilityEnraged = false;
    private boolean isExecuting = false;

    public SkrytheTailSlamGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        return this.skrythe.m_5448_() != null && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.TAIL_SLAM;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.TAIL_SLAM;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.skrythe.m_21573_().m_26573_();
        this.isAbilityEnraged = this.skrythe.isAbilityEnraged();
        this.skrythe.setRotationManual(true);
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentAbility() == SkrytheEntity.Ability.TAIL_SLAM) {
            this.skrythe.setRotationManual(false);
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
    }

    public void m_8037_() {
        ++this.tickCount;
        if (this.tickCount == 4) {
            this.skrythe.setTargetRotation(this.skrythe.getPredictedAngle(20) + 180.0f, 0.0f, 25, AbstractLargeMonster.TurnDirection.SHORTEST, true);
        }
        if (this.tickCount == 1) {
            this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_TAIL_SLAM.get(), this.skrythe.m_5720_(), 1.0f, 1.0f);
        }
        if (this.tickCount == 15) {
            this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
            AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(2.0f).knockback(AbstractLargeMonster.KnockbackType.STANDARD, 4.0).breakShield(100).stun(35).build();
            if (!this.skrythe.isTailCut()) {
                this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, -5.0), 6.0, 10.0, 10.0, attackDefinition);
                this.skrythe.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, -1.0), 1.0f, 240);
                this.skrythe.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, -4.0), 1.0f, 240);
                this.skrythe.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, -7.0), 1.0f, 240);
                this.skrythe.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, -10.0), 3.0f, 240);
                this.skrythe.spawnGroundEffects(new Vec3(0.0, 0.0, -1.0), 2.0f, 10, 10, 1);
                this.skrythe.spawnGroundEffects(new Vec3(0.0, 0.0, -4.0), 2.0f, 10, 10, 1);
                this.skrythe.spawnGroundEffects(new Vec3(0.0, 0.0, -7.0), 2.0f, 10, 10, 1);
                this.skrythe.spawnGroundEffects(new Vec3(0.0, 0.0, -10.0), 2.0f, 10, 10, 1);
                this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, -10.0), 8.0, 10.0, 8.0, attackDefinition);
            } else {
                this.skrythe.dealDamageInOrientedBox(this.skrythe.m_20182_(), new Vec3(0.0, 0.0, -3.0), 6.0, 10.0, 6.0, attackDefinition);
                this.skrythe.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, -1.0), 1.0f, 240);
                this.skrythe.spawnSmashedGroundEffect(new Vec3(0.0, 0.0, -4.0), 1.0f, 240);
                this.skrythe.spawnGroundEffects(new Vec3(0.0, 0.0, -1.0), 2.0f, 10, 10, 1);
                this.skrythe.spawnGroundEffects(new Vec3(0.0, 0.0, -4.0), 2.0f, 10, 10, 1);
            }
        }
        if (this.tickCount > 25) {
            this.isExecuting = false;
        }
    }
}

