/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SkrytheToppleGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount;
    private Phase currentPhase;
    private boolean isAbilityAerial = false;
    private boolean isExecuting;

    public SkrytheToppleGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK, Goal.Flag.JUMP));
    }

    public boolean m_8036_() {
        return this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.TOPPLE;
    }

    public boolean m_8045_() {
        return this.isExecuting && this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.TOPPLE;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        this.skrythe.setCurrentAbility(SkrytheEntity.Ability.STAGGER);
        this.skrythe.m_21573_().m_26573_();
        this.skrythe.m_20256_(Vec3.f_82478_);
        this.isAbilityAerial = this.skrythe.isAerial();
        if (this.isAbilityAerial) {
            this.skrythe.setAirToppleState(SkrytheEntity.AirToppleState.START.ordinal());
            this.currentPhase = Phase.START;
        }
    }

    public void m_8041_() {
        this.isExecuting = false;
        if (this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.TOPPLE) {
            this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
        }
        if (this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.TOPPLE) {
            this.skrythe.setCurrentStaggerState(SkrytheEntity.StaggerState.NONE);
        }
        this.skrythe.setAirToppleState(SkrytheEntity.AirToppleState.NONE.ordinal());
        this.skrythe.disableFly();
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        this.skrythe.setCurrentAbility(SkrytheEntity.Ability.STAGGER);
        if (!this.isAbilityAerial) {
            Vec3 retreatVector;
            if (this.tickCount == 1) {
                this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_GROUND_TOPPLE.get(), this.skrythe.m_5720_(), 3.0f, 1.0f);
            }
            if (this.tickCount == 18) {
                this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
                this.skrythe.spawnGroundEffects(Vec3.f_82478_, 7.0f, 40, 60, 10);
            }
            if (this.tickCount == 30 || this.tickCount == 50 || this.tickCount == 70 || this.tickCount == 90) {
                this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_STRUGGLE.get(), this.skrythe.m_5720_(), 1.0f, 1.0f);
            }
            if (this.tickCount >= 1 && this.tickCount <= 4) {
                this.skrythe.resetPartOffsets();
            }
            if (this.tickCount == 4) {
                this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(-0.8, 4.0, -2.2));
            }
            if (this.tickCount >= 13 && this.tickCount <= 16) {
                this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.85, -1.8, 0.5));
            }
            if (this.tickCount >= 100 && this.tickCount <= 110) {
                this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(-0.25, 0.15, 0.0));
            }
            if (this.tickCount > 110 && this.tickCount <= 120) {
                this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.05, 0.2, 0.0));
            }
            if (this.tickCount <= 8) {
                retreatVector = this.skrythe.m_20154_().m_82490_(-0.7);
                this.skrythe.m_20334_(retreatVector.f_82479_, 0.0, retreatVector.f_82481_);
            }
            if (this.tickCount >= 13 && this.tickCount <= 16) {
                retreatVector = this.skrythe.m_20154_().m_82490_(0.5);
                this.skrythe.m_20334_(retreatVector.f_82479_, 0.0, retreatVector.f_82481_);
            }
            if (this.tickCount > 120) {
                this.isExecuting = false;
            }
        } else {
            switch (this.currentPhase) {
                case START: {
                    if (this.tickCount == 1) {
                        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_AIR_TOPPLE.get(), this.skrythe.m_5720_(), 3.0f, 1.0f);
                    }
                    if (this.tickCount >= 1 && this.tickCount <= 4) {
                        this.skrythe.resetPartOffsets();
                    }
                    if (this.tickCount == 5) {
                        this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, 2.0, -2.0));
                        Vec3 retreatVector = this.skrythe.m_20154_().m_82490_(-0.7);
                        this.skrythe.m_20334_(retreatVector.f_82479_, 0.0, retreatVector.f_82481_);
                    }
                    if (this.tickCount == 10) {
                        this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(0.0, -0.5, 0.0));
                    }
                    if (this.tickCount > 5 && this.tickCount <= 13) {
                        this.skrythe.m_20256_(new Vec3(0.0, -0.5, 0.0));
                    }
                    if (this.tickCount != 15) break;
                    this.skrythe.setAirToppleState(SkrytheEntity.AirToppleState.FALL.ordinal());
                    this.currentPhase = Phase.FALL;
                    this.tickCount = 0;
                    break;
                }
                case FALL: {
                    this.skrythe.m_20256_(new Vec3(0.0, -2.0, 0.0));
                    BlockPos posBelow = this.skrythe.m_20183_().m_6625_(1);
                    if (this.skrythe.m_9236_().m_8055_(posBelow).m_60795_()) break;
                    this.skrythe.setAirToppleState(SkrytheEntity.AirToppleState.CRASH.ordinal());
                    this.skrythe.setPartOffset(this.skrythe.getHeadPart(), new Vec3(2.5, -5.0, -0.5));
                    this.currentPhase = Phase.CRASH;
                    this.tickCount = 0;
                    break;
                }
                case CRASH: {
                    if (this.tickCount >= 83 && this.tickCount <= 93) {
                        this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(-0.25, 0.15, 0.0));
                    }
                    if (this.tickCount > 93 && this.tickCount <= 103) {
                        this.skrythe.addPartOffset(this.skrythe.getHeadPart(), new Vec3(0.05, 0.2, 0.0));
                    }
                    if (this.tickCount == 2) {
                        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
                        this.skrythe.spawnGroundEffects(Vec3.f_82478_, 7.0f, 40, 60, 10);
                    }
                    if (this.tickCount == 10 || this.tickCount == 30 || this.tickCount == 50 || this.tickCount == 70) {
                        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_STRUGGLE.get(), this.skrythe.m_5720_(), 1.0f, 1.0f);
                    }
                    if (this.tickCount != 105) break;
                    this.isExecuting = false;
                }
            }
        }
    }

    private static enum Phase {
        START,
        FALL,
        CRASH;

    }
}

