/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.ai.skrythe;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SkrytheWingBreakGoal
extends Goal {
    private SkrytheEntity skrythe;
    private int tickCount = 0;
    private Phase currentPhase;
    private boolean isExecuting = false;

    public SkrytheWingBreakGoal(SkrytheEntity skrythe) {
        this.skrythe = skrythe;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.LEFT_WING_BREAK || this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.RIGHT_WING_BREAK;
    }

    public boolean m_8045_() {
        return this.m_8036_() && this.isExecuting;
    }

    public void m_8056_() {
        this.tickCount = 0;
        this.isExecuting = true;
        if (this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.LEFT_WING_BREAK) {
            this.currentPhase = Phase.LEFT;
        } else if (this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.RIGHT_WING_BREAK) {
            this.currentPhase = Phase.RIGHT;
        }
        this.skrythe.setCurrentAbility(SkrytheEntity.Ability.STAGGER);
        this.skrythe.m_9236_().m_6263_(null, this.skrythe.m_20185_(), this.skrythe.m_20186_(), this.skrythe.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_WING_BREAK.get(), this.skrythe.m_5720_(), 2.0f, 1.0f);
    }

    public void m_8041_() {
        this.isExecuting = false;
        switch (this.currentPhase) {
            case LEFT: {
                if (this.skrythe.getCurrentStaggerState() == SkrytheEntity.StaggerState.LEFT_WING_BREAK) {
                    this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
                    this.skrythe.setCurrentStaggerState(SkrytheEntity.StaggerState.NONE);
                }
            }
            case RIGHT: {
                if (this.skrythe.getCurrentStaggerState() != SkrytheEntity.StaggerState.RIGHT_WING_BREAK) break;
                this.skrythe.setCurrentAbility(SkrytheEntity.Ability.NONE);
                this.skrythe.setCurrentStaggerState(SkrytheEntity.StaggerState.NONE);
            }
        }
        this.currentPhase = null;
    }

    public void m_8037_() {
        ++this.tickCount;
        switch (this.currentPhase) {
            case LEFT: {
                if (!this.skrythe.isAerial()) {
                    Vec3 retreatVector = this.skrythe.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82490_(-0.25);
                    if (this.tickCount >= 10) break;
                    this.skrythe.m_20256_(retreatVector.m_82549_(retreatVector));
                    break;
                }
                Vec3 retreatVector = this.skrythe.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82490_((double)-0.05f);
                if (this.tickCount >= 10) break;
                this.skrythe.m_20256_(retreatVector.m_82549_(retreatVector));
                break;
            }
            case RIGHT: {
                if (!this.skrythe.isAerial()) {
                    Vec3 retreatVector = this.skrythe.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82490_(0.25);
                    if (this.tickCount >= 10) break;
                    this.skrythe.m_20256_(retreatVector.m_82549_(retreatVector));
                    break;
                }
                Vec3 retreatVector = this.skrythe.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82490_((double)0.05f);
                if (this.tickCount >= 10) break;
                this.skrythe.m_20256_(retreatVector.m_82549_(retreatVector));
            }
        }
        if (this.tickCount > 25 && !this.skrythe.isAerial()) {
            this.isExecuting = false;
        }
        if (this.tickCount > 15 && this.skrythe.isAerial()) {
            this.isExecuting = false;
        }
    }

    private static enum Phase {
        RIGHT,
        LEFT;

    }
}

