/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.animations.hitbox;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.animations.hitbox.AnimationChannel;
import net.saksolm.monsterexpansion.entity.animations.hitbox.AnimationDefinition;
import net.saksolm.monsterexpansion.entity.animations.hitbox.Keyframe;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AnimationPlayer {
    private final Map<String, AnimationDefinition> registeredAnimations = new HashMap<String, AnimationDefinition>();
    private final Map<String, ActiveAnimation> activeAnimations = new HashMap<String, ActiveAnimation>();
    private final Map<String, String> boneHierarchy;
    private final Map<String, Vec3> defaultOffsets;
    private final Map<String, Vec3> defaultRotations;
    private final Map<String, Vector3f> precalculatedDefaultOffsets = new HashMap<String, Vector3f>();
    private final Map<String, Quaternionf> precalculatedDefaultQuats = new HashMap<String, Quaternionf>();
    private final Map<String, Transform> transformCache = new HashMap<String, Transform>();
    private final Map<String, Quaternionf> rotationCache = new HashMap<String, Quaternionf>();
    Map<String, Quaternionf> defaultQuatCache = new HashMap<String, Quaternionf>();
    private final Vector3f scratchVec = new Vector3f();
    private final Vector3f scratchPos = new Vector3f();
    private final Vector3f scratchRot = new Vector3f();
    private final Quaternionf scratchQuat = new Quaternionf();
    private final Map<String, Vector3f> precalculatedDefaultEulers = new HashMap<String, Vector3f>();

    public AnimationPlayer(Map<String, String> boneHierarchy, Map<String, Vec3> defaultOffsets, Map<String, Vec3> defaultRotations) {
        this.boneHierarchy = boneHierarchy;
        this.defaultOffsets = defaultOffsets;
        this.defaultRotations = defaultRotations;
        HashSet<String> allBones = new HashSet<String>();
        allBones.addAll(boneHierarchy.keySet());
        allBones.addAll(boneHierarchy.values());
        for (String boneName : allBones) {
            Quaternionf quat;
            Vec3 vec;
            if (defaultRotations.containsKey(boneName)) {
                vec = defaultRotations.get(boneName);
                quat = new Quaternionf().rotationZYX((float)vec.f_82481_, (float)(-vec.f_82480_), (float)(-vec.f_82479_));
                this.precalculatedDefaultQuats.put(boneName, quat);
                this.precalculatedDefaultEulers.put(boneName, new Vector3f((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_));
            } else {
                this.precalculatedDefaultQuats.put(boneName, new Quaternionf());
                this.precalculatedDefaultEulers.put(boneName, new Vector3f(0.0f, 0.0f, 0.0f));
            }
            if (defaultOffsets.containsKey(boneName)) {
                vec = defaultOffsets.get(boneName);
                this.precalculatedDefaultOffsets.put(boneName, new Vector3f((float)vec.f_82479_, (float)vec.f_82480_, (float)vec.f_82481_));
            } else {
                this.precalculatedDefaultOffsets.put(boneName, new Vector3f(0.0f, 0.0f, 0.0f));
            }
            if (defaultRotations.containsKey(boneName)) {
                vec = defaultRotations.get(boneName);
                quat = new Quaternionf().rotationZYX((float)vec.f_82481_, (float)(-vec.f_82480_), (float)(-vec.f_82479_));
                this.precalculatedDefaultQuats.put(boneName, quat);
                continue;
            }
            this.precalculatedDefaultQuats.put(boneName, new Quaternionf());
        }
    }

    public void tick() {
        this.transformCache.clear();
        this.rotationCache.clear();
        if (this.activeAnimations.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<String, ActiveAnimation>> iterator = this.activeAnimations.entrySet().iterator();
        while (iterator.hasNext()) {
            ActiveAnimation anim = iterator.next().getValue();
            if (anim.externallyManaged) continue;
            anim.animationTick += anim.playbackSpeed;
            float lengthTicks = anim.definition.lengthInSeconds() * 20.0f;
            if (!(anim.animationTick >= lengthTicks)) continue;
            if (anim.definition.looping()) {
                anim.animationTick %= lengthTicks;
                continue;
            }
            iterator.remove();
        }
    }

    public Vec3 getAbsolutePartPosition(String boneName) {
        Transform finalTransform = this.getRecursiveTransform(boneName);
        return new Vec3((double)finalTransform.position.x, (double)finalTransform.position.y, (double)finalTransform.position.z);
    }

    private Transform getRecursiveTransform(String boneName) {
        Transform result;
        if (this.transformCache.containsKey(boneName)) {
            return this.transformCache.get(boneName);
        }
        Vector3f defaultPos = this.precalculatedDefaultOffsets.get(boneName);
        Quaternionf defaultRotQuat = this.precalculatedDefaultQuats.get(boneName);
        Vector3f defaultEuler = this.precalculatedDefaultEulers.get(boneName);
        if (defaultPos == null) {
            defaultPos = new Vector3f();
        }
        if (defaultRotQuat == null) {
            defaultRotQuat = new Quaternionf();
        }
        if (defaultEuler == null) {
            defaultEuler = new Vector3f();
        }
        this.scratchPos.set(0.0f, 0.0f, 0.0f);
        this.scratchRot.set(0.0f, 0.0f, 0.0f);
        for (ActiveAnimation anim : this.activeAnimations.values()) {
            Vec3 animPosVec = this.getInterpolatedVector(anim, boneName, AnimationChannel.Targets.POSITION);
            Vec3 animRotVec = this.getInterpolatedVector(anim, boneName, AnimationChannel.Targets.ROTATION);
            float scale = anim.animationScale;
            this.scratchPos.add((float)(animPosVec.f_82479_ * (double)scale), (float)(animPosVec.f_82480_ * (double)scale), (float)(animPosVec.f_82481_ * (double)scale));
            this.scratchRot.add((float)(animRotVec.f_82479_ * (double)scale), (float)(animRotVec.f_82480_ * (double)scale), (float)(animRotVec.f_82481_ * (double)scale));
        }
        float totalX = defaultEuler.x + this.scratchRot.x;
        float totalY = defaultEuler.y + this.scratchRot.y;
        float totalZ = defaultEuler.z + this.scratchRot.z;
        Quaternionf finalLocalRot = new Quaternionf().rotationZYX(totalZ, -totalY, -totalX);
        Vector3f animatedPos = new Vector3f((Vector3fc)this.scratchPos).mul(0.0625f);
        defaultRotQuat.transform(animatedPos);
        Vector3f finalLocalPos = animatedPos.add((Vector3fc)defaultPos);
        String parentName = this.boneHierarchy.get(boneName);
        if (parentName == null) {
            result = new Transform(finalLocalPos, finalLocalRot);
        } else {
            Transform parentTransform = this.getRecursiveTransform(parentName);
            Quaternionf finalRot = new Quaternionf((Quaternionfc)parentTransform.rotation).mul((Quaternionfc)finalLocalRot);
            Vector3f finalPos = new Vector3f((Vector3fc)finalLocalPos);
            parentTransform.rotation.transform(finalPos);
            finalPos.add((Vector3fc)parentTransform.position);
            result = new Transform(finalPos, finalRot);
        }
        this.transformCache.put(boneName, result);
        return result;
    }

    private Transform getSkeletalTransform(String boneName) {
        Vector3f defaultPos = this.toJomlVec3(this.defaultOffsets.getOrDefault(boneName, Vec3.f_82478_));
        Vector3f defaultRotEuler = this.toJomlVec3(this.defaultRotations.getOrDefault(boneName, Vec3.f_82478_));
        String parentName = this.boneHierarchy.get(boneName);
        Vector3f totalAnimatedRotEuler = new Vector3f();
        for (ActiveAnimation anim : this.activeAnimations.values()) {
            Vec3 animRotVec = this.getInterpolatedVector(anim, boneName, AnimationChannel.Targets.ROTATION);
            totalAnimatedRotEuler.add((float)(animRotVec.f_82479_ * (double)anim.animationScale), (float)(animRotVec.f_82480_ * (double)anim.animationScale), (float)(animRotVec.f_82481_ * (double)anim.animationScale));
        }
        Vector3f finalLocalRotEuler = new Vector3f((Vector3fc)defaultRotEuler).add((Vector3fc)totalAnimatedRotEuler);
        Quaternionf finalLocalRot = new Quaternionf().rotationZYX(finalLocalRotEuler.z, -finalLocalRotEuler.y, -finalLocalRotEuler.x);
        if (parentName == null) {
            return new Transform(defaultPos, finalLocalRot);
        }
        Transform parentSkeletalTransform = this.getSkeletalTransform(parentName);
        Quaternionf finalRot = new Quaternionf((Quaternionfc)parentSkeletalTransform.rotation).mul((Quaternionfc)finalLocalRot);
        Vector3f finalPos = new Vector3f((Vector3fc)defaultPos);
        parentSkeletalTransform.rotation.transform(finalPos);
        finalPos.add((Vector3fc)parentSkeletalTransform.position);
        return new Transform(finalPos, finalRot);
    }

    public Quaternionf getAbsolutePartRotation(String boneName) {
        return this.getRecursiveRotationCorrect(boneName);
    }

    private Quaternionf getRecursiveRotationCorrect(String boneName) {
        Quaternionf finalRotation;
        if (this.rotationCache.containsKey(boneName)) {
            return this.rotationCache.get(boneName);
        }
        Vector3f defaultRotDeg = this.toJomlVec3(this.defaultRotations.getOrDefault(boneName, Vec3.f_82478_));
        Vector3f defaultRotRad = new Vector3f((Vector3fc)defaultRotDeg).mul((float)Math.PI / 180);
        Vector3f totalAnimatedRotRad = new Vector3f();
        for (ActiveAnimation anim : this.activeAnimations.values()) {
            Vec3 animRotVec = this.getInterpolatedVector(anim, boneName, AnimationChannel.Targets.ROTATION);
            float scale = anim.animationScale;
            totalAnimatedRotRad.add((float)(animRotVec.f_82479_ * (double)scale), (float)(animRotVec.f_82480_ * (double)scale), (float)(animRotVec.f_82481_ * (double)scale));
        }
        Vector3f finalLocalRotRad = new Vector3f((Vector3fc)defaultRotRad).add((Vector3fc)totalAnimatedRotRad);
        Quaternionf finalLocalQuat = this.eulerToQuaternionCorrect(this.toVec3(finalLocalRotRad));
        String parentName = this.boneHierarchy.get(boneName);
        if (parentName == null) {
            finalRotation = finalLocalQuat;
        } else {
            Quaternionf parentRotation = this.getRecursiveRotationCorrect(parentName);
            finalRotation = new Quaternionf((Quaternionfc)parentRotation).mul((Quaternionfc)finalLocalQuat);
        }
        this.rotationCache.put(boneName, finalRotation);
        return finalRotation;
    }

    private Quaternionf eulerToQuaternionCorrect(Vec3 eulerRad) {
        return new Quaternionf().rotationZYX((float)eulerRad.f_82481_, (float)(-eulerRad.f_82480_), (float)eulerRad.f_82479_);
    }

    private Quaternionf eulerToQuaternion(Vec3 eulerRad) {
        return new Quaternionf().rotationZYX((float)eulerRad.f_82481_, (float)(-eulerRad.f_82480_), (float)(-eulerRad.f_82479_));
    }

    private Quaternionf eulerToQuaternion(float x, float y, float z) {
        return this.scratchQuat.identity().rotationZYX(z, -y, -x);
    }

    private Vec3 getInterpolatedVector(ActiveAnimation anim, String boneName, AnimationChannel.Targets targetType) {
        List<AnimationChannel> timelines = anim.definition.boneAnimations().get(boneName);
        if (timelines == null) {
            return Vec3.f_82478_;
        }
        for (AnimationChannel timeline : timelines) {
            if (timeline.target() != targetType) continue;
            return this.lerp(anim.animationTick / 20.0f, timeline);
        }
        return Vec3.f_82478_;
    }

    private Vec3 lerp(float currentTime, AnimationChannel timeline) {
        Keyframe[] keyframes = timeline.keyframes();
        if (keyframes.length == 0) {
            return Vec3.f_82478_;
        }
        Keyframe prev = keyframes[0];
        if (currentTime <= prev.timestamp()) {
            return this.toVec3(prev.target());
        }
        Keyframe next = keyframes[keyframes.length - 1];
        for (int i = 1; i < keyframes.length && !(currentTime < (next = keyframes[i]).timestamp()); ++i) {
            prev = next;
        }
        if (next == prev) {
            return this.toVec3(next.target());
        }
        float progress = (currentTime - prev.timestamp()) / (next.timestamp() - prev.timestamp());
        Vector3f interpolated = new Vector3f();
        prev.target().lerp((Vector3fc)next.target(), progress, interpolated);
        return this.toVec3(interpolated);
    }

    public void setScale(String animName, float scale) {
        ActiveAnimation anim = this.activeAnimations.get(animName);
        if (anim != null) {
            anim.animationScale = Mth.m_14036_((float)scale, (float)0.0f, (float)1.0f);
        }
    }

    public void registerAnimation(String name, AnimationDefinition animation) {
        this.registeredAnimations.put(name, animation);
    }

    public void playAnimation(String name, float speed, boolean isExternallyManaged) {
        if (this.registeredAnimations.containsKey(name) && !this.activeAnimations.containsKey(name)) {
            ActiveAnimation newAnim = new ActiveAnimation(this.registeredAnimations.get(name));
            newAnim.playbackSpeed = Math.max(0.0f, speed);
            newAnim.externallyManaged = isExternallyManaged;
            this.activeAnimations.put(name, newAnim);
        }
    }

    public void playAnimation(String name, float speed) {
        this.playAnimation(name, speed, false);
    }

    public void playAnimation(String name) {
        this.playAnimation(name, 1.0f);
    }

    public void stopAnimation(String name) {
        this.activeAnimations.remove(name);
    }

    public boolean isPlaying(String name) {
        return this.activeAnimations.containsKey(name);
    }

    public void setSpeed(String animName, float speed) {
        ActiveAnimation anim = this.activeAnimations.get(animName);
        if (anim != null) {
            anim.playbackSpeed = Math.max(0.0f, speed);
        }
    }

    public void setAnimationTick(String animName, float tick) {
        ActiveAnimation anim = this.activeAnimations.get(animName);
        if (anim != null) {
            anim.animationTick = tick;
        }
    }

    public AnimationDefinition getAnimation(String name) {
        return this.registeredAnimations.get(name);
    }

    private Vec3 toVec3(Vector3f jomlVec) {
        return new Vec3((double)jomlVec.x, (double)jomlVec.y, (double)jomlVec.z);
    }

    private Vector3f toJomlVec3(Vec3 vec) {
        return new Vector3f((float)vec.m_7096_(), (float)vec.m_7098_(), (float)vec.m_7094_());
    }

    private static class ActiveAnimation {
        final AnimationDefinition definition;
        float animationTick = 0.0f;
        float playbackSpeed = 1.0f;
        boolean externallyManaged = false;
        float animationScale = 1.0f;

        ActiveAnimation(AnimationDefinition definition) {
            this.definition = definition;
        }
    }

    private record Transform(Vector3f position, Quaternionf rotation) {
    }
}

