/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorStatus;
import net.saksolm.monsterexpansion.entity.ai.behavior.custom.KobekoBehaviorTree;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoAttackGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoFlashGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoFollowOwnerGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoGuardGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoHealGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoHeavyAttackGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoHornGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoSelfHealGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoStaggerGoal;
import net.saksolm.monsterexpansion.entity.ai.kobeko.KobekoTauntGoal;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.IBehavioralEntity;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.SkrytheEntity;
import net.saksolm.monsterexpansion.entity.custom.effect.ShockwaveEntity;
import net.saksolm.monsterexpansion.entity.custom.effect.SmashedGroundEffectEntity;
import net.saksolm.monsterexpansion.entity.variant.KobekoVariant;
import net.saksolm.monsterexpansion.item.IKobekoArmor;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.particles.options.BigDustParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DebrisParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DustParticleOptions;
import net.saksolm.monsterexpansion.screen.KobekoMenu;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import org.jetbrains.annotations.Nullable;

public class KobekoEntity
extends TamableAnimal
implements MenuProvider,
IBehavioralEntity<Ability> {
    private static final EntityDataAccessor<ItemStack> WEAPON_STACK = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> HELMET_STACK = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> CHESTPLATE_STACK = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> GADGET_STACK_1 = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> GADGET_STACK_2 = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> GADGET_STACK_3 = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<ItemStack> HELD_ITEM_STACK = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Integer> DATA_ID_TYPE_VARIANT = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> TARGET_YAW = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> TARGET_PITCH = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> TURN_DURATION = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Byte> TURN_DIRECTION = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Boolean> MANUAL_ROTAION = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> SMOOTH_ROTATION = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Float> ROTATION_START_YAW = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Float> ROTATION_START_YAW_BODY = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected static final EntityDataAccessor<Integer> ROTATION_TICK_COUNT = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int ticksWithStagger = 0;
    private static final UUID WEAPON_SPEED_MODIFIER_ID = UUID.fromString("7E02DB5E-5389-487D-848C-7E026364936B");
    private static final UUID HELMET_ARMOR_MODIFIER_ID = UUID.fromString("1f5c5b4a-455d-4b8c-8a2b-7b3a6c5d88d1");
    private static final UUID CHESTPLATE_ARMOR_MODIFIER_ID = UUID.fromString("b3c3d5e2-6d8c-4a7d-8e4a-9b4f2a9f1c7e");
    private static final UUID HELMET_TOUGHNESS_MODIFIER_ID = UUID.fromString("c8a5a1e8-9b8c-4f7d-a1b2-3c4d5e6f7a8b");
    private static final UUID CHESTPLATE_TOUGHNESS_MODIFIER_ID = UUID.fromString("d9b6b2f9-ab9d-4e8e-b2c3-4d5e6f7a8b9c");
    protected static final EntityDataAccessor<Boolean> HOLDING_WEAPON = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> HEAVY_WEAPON = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Byte> TAMED_BEHAVIOR = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Byte> TAMED_STANCE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    protected static final EntityDataAccessor<Integer> ABILITY_STATE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> ATTACK_STATE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> GUARD_STATE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> HEAVY_ATTACK_STATE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> HEAL_STATE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> FAINT_STATE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Integer> TAUNT_STATE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_FAINTED = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int faintTicks;
    private KobekoBehaviorTree behaviorTree;
    private UUID lastTargetUUID;
    private TamedBehavior lastBehavior;
    public final SimpleContainer inventory = new SimpleContainer(6);
    public final AnimationState idleAnimation = new AnimationState();
    public final AnimationState gesture1Animation = new AnimationState();
    public final AnimationState gesture2Animation = new AnimationState();
    public final AnimationState gesture3Animation = new AnimationState();
    public final AnimationState gesture4Animation = new AnimationState();
    public final AnimationState gesture5Animation = new AnimationState();
    public final AnimationState attackFastAnimation = new AnimationState();
    public final AnimationState attackSlowAnimation = new AnimationState();
    public final AnimationState heavyIdleAnimation = new AnimationState();
    public final AnimationState heavyIdleStartAnimation = new AnimationState();
    public final AnimationState heavyIdleEndAnimation = new AnimationState();
    public final AnimationState guardAnimation = new AnimationState();
    public final AnimationState guardHitAnimation = new AnimationState();
    public final AnimationState heavyAttackChargeAnimation = new AnimationState();
    public final AnimationState heavyAttackStartAnimation = new AnimationState();
    public final AnimationState heavyAttackHitAnimation = new AnimationState();
    public final AnimationState healChargeAnimation = new AnimationState();
    public final AnimationState healStartAnimation = new AnimationState();
    public final AnimationState healThrowAnimation = new AnimationState();
    public final AnimationState selfHealAnimation = new AnimationState();
    public final AnimationState faintFallAnimation = new AnimationState();
    public final AnimationState faintRecoverAnimation = new AnimationState();
    public final AnimationState flashAnimation = new AnimationState();
    public final AnimationState tauntHoldAnimation = new AnimationState();
    public final AnimationState tauntHitAnimation = new AnimationState();
    public final AnimationState staggerAnimation = new AnimationState();
    public final AnimationState hornAnimation = new AnimationState();
    public final AnimationState sitStartAnimation = new AnimationState();
    public final AnimationState sitEndAnimation = new AnimationState();
    private double staggerHealth = 50.0;
    private final int STAGGER_HEALTH = 50;
    private boolean isLoading = false;
    public boolean tookDamageThisTick = false;
    private boolean wasSittingLastTick = false;
    private final int ATTACK_COOLDOWN = 100;
    private final int HEAVY_ATTACK_COOLDOWN = 200;
    private final int GUARD_COOLDOWN = 50;
    private final int HEAL_COOLDOWN = 400;
    private final int SELF_HEAL_COOLDOWN = 400;
    private final int FLASH_COOLDOWN = 600;
    private final int TAUNT_COOLDOWN = 400;
    private final int HORN_COOLDOWN = 400;
    private int lastHeavyAttack = -1000;
    private int lastAttack = -1000;
    private int lastGuard = -1000;
    private int lastHeal = -1000;
    private int lastSelfHeal = -1000;
    private int lastFlash = -1000;
    private int lastTaunt = -1000;
    private int lastHorn = -1000;
    public HeavyIdleState heavyIdleState = HeavyIdleState.NONE;
    protected static final EntityDataAccessor<Integer> IDLE_STATE = SynchedEntityData.m_135353_(KobekoEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int timeUntilNextIdle;
    private int idleAnimationTicks;

    public KobekoEntity(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.behaviorTree = new KobekoBehaviorTree();
        this.inventory.m_19164_(container -> {
            if (!this.m_9236_().f_46443_) {
                this.setHelmetStack(container.m_8020_(0));
                this.setChestplateStack(container.m_8020_(1));
                this.setWeaponStack(container.m_8020_(2));
                this.setGadgetStack1(container.m_8020_(3));
                this.setGadgetStack2(container.m_8020_(4));
                this.setGadgetStack3(container.m_8020_(5));
                this.setHeldItemStack(this.getWeaponStack());
                this.updateWeaponAttributes();
                this.updateArmorAttributes();
            }
        });
    }

    protected void m_8099_() {
        if (!this.isFainted()) {
            if (this.getTamedStance() == TamedStance.FOLLOWING) {
                this.f_21345_.m_25352_(1, (Goal)new KobekoFollowOwnerGoal(this, 1.0, 30.0f, 3.0f){

                    @Override
                    public boolean m_8036_() {
                        return super.m_8036_() && !KobekoEntity.this.isAttacking();
                    }

                    @Override
                    public boolean m_8045_() {
                        return super.m_8045_() && !KobekoEntity.this.isAttacking();
                    }
                });
            }
            if (!this.m_21824_()) {
                // empty if block
            }
            this.f_21345_.m_25352_(0, (Goal)new KobekoStaggerGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 1.0f){

                public boolean m_8036_() {
                    return super.m_8036_() && !KobekoEntity.this.isAttacking() && KobekoEntity.this.m_5448_() == null;
                }

                public boolean m_8045_() {
                    return super.m_8045_() && !KobekoEntity.this.isAttacking();
                }
            });
            if (this.getTamedBehavior() != TamedBehavior.PASSIVE) {
                this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
                this.f_21346_.m_25352_(2, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
                this.f_21346_.m_25352_(1, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
                this.f_21345_.m_25352_(1, (Goal)new KobekoAttackGoal(this));
                this.f_21345_.m_25352_(1, (Goal)new KobekoHeavyAttackGoal(this));
                this.f_21345_.m_25352_(1, (Goal)new KobekoGuardGoal(this));
                this.f_21345_.m_25352_(1, (Goal)new KobekoTauntGoal(this));
                this.f_21345_.m_25352_(1, (Goal)new KobekoHealGoal(this));
                this.f_21345_.m_25352_(1, (Goal)new KobekoSelfHealGoal(this));
                this.f_21345_.m_25352_(1, (Goal)new KobekoFlashGoal(this));
                this.f_21345_.m_25352_(1, (Goal)new KobekoHornGoal(this));
            }
        }
    }

    public void refreshGoals() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        List<Goal> goalsToRemove = this.f_21345_.m_148105_().stream().map(WrappedGoal::m_26015_).collect(Collectors.toList());
        goalsToRemove.forEach(arg_0 -> ((GoalSelector)this.f_21345_).m_25363_(arg_0));
        List<Goal> targetersToRemove = this.f_21346_.m_148105_().stream().map(WrappedGoal::m_26015_).collect(Collectors.toList());
        targetersToRemove.forEach(arg_0 -> ((GoalSelector)this.f_21346_).m_25363_(arg_0));
        this.m_8099_();
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22284_, 1.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22278_, 0.95).m_22268_(Attributes.f_22288_, 0.5);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HELMET_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(CHESTPLATE_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(WEAPON_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(HELD_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(GADGET_STACK_1, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(GADGET_STACK_2, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(GADGET_STACK_3, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(TAMED_BEHAVIOR, (Object)((byte)TamedBehavior.PASSIVE.ordinal()));
        this.f_19804_.m_135372_(TAMED_STANCE, (Object)((byte)TamedStance.WANDERING.ordinal()));
        this.f_19804_.m_135372_(DATA_ID_TYPE_VARIANT, (Object)0);
        this.f_19804_.m_135372_(ABILITY_STATE, (Object)Ability.NONE.ordinal());
        this.f_19804_.m_135372_(ATTACK_STATE, (Object)AttackState.NONE.ordinal());
        this.f_19804_.m_135372_(GUARD_STATE, (Object)GuardState.NONE.ordinal());
        this.f_19804_.m_135372_(HEAVY_ATTACK_STATE, (Object)HeavyAttackState.NONE.ordinal());
        this.f_19804_.m_135372_(HEAL_STATE, (Object)HealState.NONE.ordinal());
        this.f_19804_.m_135372_(FAINT_STATE, (Object)FaintState.NONE.ordinal());
        this.f_19804_.m_135372_(IDLE_STATE, (Object)IdleState.NONE.ordinal());
        this.f_19804_.m_135372_(TAUNT_STATE, (Object)TauntState.NONE.ordinal());
        this.f_19804_.m_135372_(IS_FAINTED, (Object)false);
        this.f_19804_.m_135372_(TARGET_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TARGET_PITCH, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(TURN_DURATION, (Object)0);
        this.f_19804_.m_135372_(TURN_DIRECTION, (Object)((byte)AbstractLargeMonster.TurnDirection.SHORTEST.ordinal()));
        this.f_19804_.m_135372_(MANUAL_ROTAION, (Object)false);
        this.f_19804_.m_135372_(SMOOTH_ROTATION, (Object)false);
        this.f_19804_.m_135372_(ROTATION_TICK_COUNT, (Object)0);
        this.f_19804_.m_135372_(ROTATION_START_YAW_BODY, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(ROTATION_START_YAW, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(HOLDING_WEAPON, (Object)false);
        this.f_19804_.m_135372_(HEAVY_WEAPON, (Object)false);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (!this.inventory.m_8020_(0).m_41619_()) {
            pCompound.m_128365_("KobekoHelmet", (Tag)this.inventory.m_8020_(0).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(1).m_41619_()) {
            pCompound.m_128365_("KobekoChest", (Tag)this.inventory.m_8020_(1).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(2).m_41619_()) {
            pCompound.m_128365_("KobekoWeapon", (Tag)this.inventory.m_8020_(2).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(3).m_41619_()) {
            pCompound.m_128365_("KobekoGadget1", (Tag)this.inventory.m_8020_(3).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(4).m_41619_()) {
            pCompound.m_128365_("KobekoGadget2", (Tag)this.inventory.m_8020_(4).m_41739_(new CompoundTag()));
        }
        if (!this.inventory.m_8020_(5).m_41619_()) {
            pCompound.m_128365_("KobekoGadget3", (Tag)this.inventory.m_8020_(5).m_41739_(new CompoundTag()));
        }
        if (this.lastTargetUUID != null) {
            pCompound.m_128362_("LastTargetUUID", this.lastTargetUUID);
        }
        pCompound.m_128405_("TamedBehavior", this.getTamedBehavior().ordinal());
        pCompound.m_128405_("TamedStance", this.getTamedStance().ordinal());
        pCompound.m_128405_("Variant", this.getTypeVariant());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("KobekoHelmet", 10)) {
            this.inventory.m_6836_(0, ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("KobekoHelmet")));
        }
        if (pCompound.m_128425_("KobekoChest", 10)) {
            this.inventory.m_6836_(1, ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("KobekoChest")));
        }
        if (pCompound.m_128425_("KobekoWeapon", 10)) {
            this.inventory.m_6836_(2, ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("KobekoWeapon")));
        }
        if (pCompound.m_128425_("KobekoGadget1", 10)) {
            this.inventory.m_6836_(3, ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("KobekoGadget1")));
        }
        if (pCompound.m_128425_("KobekoGadget2", 10)) {
            this.inventory.m_6836_(4, ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("KobekoGadget2")));
        }
        if (pCompound.m_128425_("KobekoGadget3", 10)) {
            this.inventory.m_6836_(5, ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("KobekoGadget3")));
        }
        this.setHelmetStack(this.inventory.m_8020_(0));
        this.setChestplateStack(this.inventory.m_8020_(1));
        this.setWeaponStack(this.inventory.m_8020_(2));
        this.setGadgetStack1(this.inventory.m_8020_(3));
        this.setGadgetStack2(this.inventory.m_8020_(4));
        this.setGadgetStack3(this.inventory.m_8020_(5));
        this.setHeldItemStack(this.getWeaponStack());
        this.updateArmorAttributes();
        this.updateWeaponAttributes();
        if (pCompound.m_128403_("LastTargetUUID")) {
            this.lastTargetUUID = pCompound.m_128342_("LastTargetUUID");
        }
        this.setTamedBehavior(TamedBehavior.values()[pCompound.m_128451_("TamedBehavior")]);
        this.setTamedStance(TamedStance.values()[pCompound.m_128451_("TamedStance")]);
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)pCompound.m_128451_("Variant"));
    }

    public ItemStack getWeaponStack() {
        return (ItemStack)this.f_19804_.m_135370_(WEAPON_STACK);
    }

    public void setWeaponStack(ItemStack stack) {
        this.f_19804_.m_135381_(WEAPON_STACK, (Object)stack);
    }

    public ItemStack getHelmetStack() {
        return (ItemStack)this.f_19804_.m_135370_(HELMET_STACK);
    }

    public void setHelmetStack(ItemStack stack) {
        this.f_19804_.m_135381_(HELMET_STACK, (Object)stack);
    }

    public ItemStack getChestplateStack() {
        return (ItemStack)this.f_19804_.m_135370_(CHESTPLATE_STACK);
    }

    public void setChestplateStack(ItemStack stack) {
        this.f_19804_.m_135381_(CHESTPLATE_STACK, (Object)stack);
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        Item item = itemstack.m_41720_();
        if (this.isFainted()) {
            if (this.m_21830_((LivingEntity)pPlayer)) {
                if (itemstack.m_150930_(Items.f_42436_)) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.revive(0.25f);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                if (itemstack.m_150930_(Items.f_42437_)) {
                    if (!pPlayer.m_150110_().f_35937_) {
                        itemstack.m_41774_(1);
                    }
                    this.revive(1.0f);
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                return InteractionResult.PASS;
            }
            if (!this.m_21824_()) {
                if (itemstack.m_150930_(Items.f_42436_) || itemstack.m_150930_(Items.f_42437_)) {
                    if (!this.m_9236_().f_46443_) {
                        CompoundTag playerData = pPlayer.getPersistentData();
                        if (playerData.m_128403_("TamedKobekoUUID") && !playerData.m_128342_("TamedKobekoUUID").equals(this.m_20148_())) {
                            pPlayer.m_213846_((Component)Component.m_237113_((String)"You can only have one Kobeko at a time.").m_130940_(ChatFormatting.RED));
                            return InteractionResult.FAIL;
                        }
                        if (!pPlayer.m_150110_().f_35937_) {
                            itemstack.m_41774_(1);
                        }
                        this.m_21828_(pPlayer);
                        this.m_9236_().m_7605_((Entity)this, (byte)7);
                        this.revive(0.5f);
                        pPlayer.m_213846_((Component)Component.m_237113_((String)(this.m_7755_().getString() + " has pledged its loyalty to you!")).m_130940_(ChatFormatting.GREEN));
                    }
                    return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
                }
                return InteractionResult.PASS;
            }
        }
        if (this.m_21824_() && this.m_21830_((LivingEntity)pPlayer) && itemstack.m_41619_()) {
            if (!this.m_9236_().f_46443_) {
                NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)pPlayer), (MenuProvider)this, buf -> buf.writeInt(this.m_19879_()));
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_6667_(DamageSource pCause) {
        CompoundTag playerData;
        Player playerOwner;
        LivingEntity owner;
        if (!this.m_9236_().f_46443_ && this.m_21824_() && (owner = this.m_269323_()) instanceof Player && !(playerOwner = (Player)owner).m_213877_() && (playerData = playerOwner.getPersistentData()).m_128403_("TamedKobekoUUID") && playerData.m_128342_("TamedKobekoUUID").equals(this.m_20148_())) {
            playerData.m_128473_("TamedKobekoUUID");
        }
        super.m_6667_(pCause);
    }

    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int pContainerId, Inventory pPlayerInventory, Player pPlayer) {
        return new KobekoMenu(pContainerId, pPlayerInventory, this);
    }

    public void m_8119_() {
        LivingEntity owner;
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.m_21824_() && this.f_19797_ % 100 == 0 && (owner = this.m_269323_()) instanceof ServerPlayer) {
            ServerPlayer playerOwner = (ServerPlayer)owner;
            CompoundTag playerData = playerOwner.getPersistentData();
            playerData.m_128362_("TamedKobekoUUID", this.m_20148_());
            playerData.m_128359_("KobekoLastDim", this.m_9236_().m_46472_().m_135782_().toString());
            playerData.m_128356_("KobekoLastPos", this.m_20183_().m_121878_());
            System.out.println("[KOBEKO-SAVE] Tick-saved pos: " + this.m_20183_().toString() + " in " + this.m_9236_().m_46472_().m_135782_().toString());
        }
        if (this.m_9236_().f_46443_) {
            this.setupAnimationStates();
        } else {
            if (this.getCurrentAbility() == Ability.STAGGER) {
                ++this.ticksWithStagger;
                if (this.ticksWithStagger >= 150) {
                    this.setCurrentAbility(Ability.NONE);
                }
            } else {
                this.ticksWithStagger = 0;
            }
            if (this.f_19797_ % 20 == 0 && this.m_21824_() && this.m_6084_() && !this.isFainted() && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(1.0f);
            }
            if (this.m_20186_() < (double)(this.m_9236_().m_141937_() - 64)) {
                this.teleportToOwner();
            }
            this.handleIdleBehavior();
            this.handleFaint();
            if (this.isRotationManual()) {
                this.handleRotation();
            }
            if (this.getTamedBehavior() != TamedBehavior.PASSIVE && !this.isFainted()) {
                this.behaviorTree.tick(this);
            }
        }
    }

    private void handleIdleBehavior() {
        boolean canBeIdle;
        boolean bl = canBeIdle = !this.isAttacking() && !this.isFainted() && this.m_5448_() == null && this.getTamedStance() != TamedStance.SITTING;
        if (canBeIdle) {
            if (this.idleAnimationTicks > 0) {
                --this.idleAnimationTicks;
                if (this.idleAnimationTicks == 0) {
                    this.setIdleState(IdleState.NONE.ordinal());
                }
            } else if (this.timeUntilNextIdle > 0) {
                --this.timeUntilNextIdle;
            } else {
                ArrayList<IdleState> possibleIdles = new ArrayList<IdleState>(List.of(IdleState.GESTURE_4, IdleState.GESTURE_5));
                if (this.isHoldingWeapon() && !this.isHeavyWeapon()) {
                    possibleIdles.add(IdleState.GESTURE_1);
                    possibleIdles.add(IdleState.GESTURE_2);
                    possibleIdles.add(IdleState.GESTURE_3);
                }
                IdleState chosenState = (IdleState)((Object)possibleIdles.get(this.f_19796_.m_188503_(possibleIdles.size())));
                this.setIdleState(chosenState.ordinal());
                this.idleAnimationTicks = 100;
                this.timeUntilNextIdle = this.f_19796_.m_188503_(600) + 200;
            }
        } else {
            this.timeUntilNextIdle = 0;
            this.idleAnimationTicks = 0;
            if (this.getIdleState() != IdleState.NONE.ordinal()) {
                this.setIdleState(IdleState.NONE.ordinal());
            }
        }
    }

    private void teleportToOwner() {
        LivingEntity owner = this.m_269323_();
        if (owner == null || owner.m_9236_() != this.m_9236_()) {
            return;
        }
        for (int i = 0; i < 10; ++i) {
            int x = this.f_19796_.m_188503_(5) - 2;
            int z = this.f_19796_.m_188503_(5) - 2;
            BlockPos ownerPos = owner.m_20183_();
            BlockPos potentialPos = ownerPos.m_7918_(x, 0, z);
            if (!this.m_9236_().m_46749_(potentialPos)) continue;
            BlockPos groundPos = potentialPos.m_7495_();
            BlockState groundState = this.m_9236_().m_8055_(groundPos);
            if (!groundState.m_60634_((BlockGetter)this.m_9236_(), groundPos, (Entity)this) || !this.m_9236_().m_46859_(potentialPos) || !this.m_9236_().m_46859_(potentialPos.m_7494_())) continue;
            this.m_6021_((double)potentialPos.m_123341_() + 0.5, potentialPos.m_123342_(), (double)potentialPos.m_123343_() + 0.5);
            this.m_21573_().m_26573_();
            this.m_20256_(Vec3.f_82478_);
            return;
        }
    }

    public void updateArmorAttributes() {
        ItemStack chestplate;
        Item item;
        AttributeInstance armorAttribute = this.m_21051_(Attributes.f_22284_);
        AttributeInstance toughnessAttribute = this.m_21051_(Attributes.f_22285_);
        if (armorAttribute == null || toughnessAttribute == null) {
            return;
        }
        armorAttribute.m_22120_(HELMET_ARMOR_MODIFIER_ID);
        armorAttribute.m_22120_(CHESTPLATE_ARMOR_MODIFIER_ID);
        toughnessAttribute.m_22120_(HELMET_TOUGHNESS_MODIFIER_ID);
        toughnessAttribute.m_22120_(CHESTPLATE_TOUGHNESS_MODIFIER_ID);
        ItemStack helmet = this.getHelmetStack();
        Item item2 = helmet.m_41720_();
        if (item2 instanceof IKobekoArmor) {
            IKobekoArmor armorItem = (IKobekoArmor)item2;
            armorAttribute.m_22118_(new AttributeModifier(HELMET_ARMOR_MODIFIER_ID, "Kobeko Helmet Armor", (double)armorItem.getDefense(), AttributeModifier.Operation.ADDITION));
            if (armorItem.getToughness() > 0) {
                toughnessAttribute.m_22118_(new AttributeModifier(HELMET_TOUGHNESS_MODIFIER_ID, "Kobeko Helmet Toughness", (double)armorItem.getToughness(), AttributeModifier.Operation.ADDITION));
            }
        }
        if ((item = (chestplate = this.getChestplateStack()).m_41720_()) instanceof IKobekoArmor) {
            IKobekoArmor armorItem = (IKobekoArmor)item;
            armorAttribute.m_22118_(new AttributeModifier(CHESTPLATE_ARMOR_MODIFIER_ID, "Kobeko Chestplate Armor", (double)armorItem.getDefense(), AttributeModifier.Operation.ADDITION));
            if (armorItem.getToughness() > 0) {
                toughnessAttribute.m_22118_(new AttributeModifier(CHESTPLATE_TOUGHNESS_MODIFIER_ID, "Kobeko Chestplate Toughness", (double)armorItem.getToughness(), AttributeModifier.Operation.ADDITION));
            }
        }
    }

    private void handleFaint() {
        if (this.isFainted()) {
            if (this.faintTicks > 0) {
                --this.faintTicks;
            } else {
                this.revive(0.25f);
            }
            return;
        }
    }

    public float getYawFromDirection(Vec3 pDirection) {
        double dX = pDirection.m_7096_();
        double dZ = pDirection.m_7094_();
        return (float)(Mth.m_14136_((double)dZ, (double)dX) * 57.2957763671875) - 90.0f;
    }

    public void updateWeaponAttributes() {
        AttributeInstance speedAttribute = this.m_21051_(Attributes.f_22279_);
        if (speedAttribute == null) {
            return;
        }
        speedAttribute.m_22120_(WEAPON_SPEED_MODIFIER_ID);
        if (!this.isHoldingWeapon()) {
            return;
        }
        ItemStack weapon = this.getWeaponStack();
        if (!weapon.m_41619_()) {
            double attackSpeedModifier = weapon.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).stream().mapToDouble(a -> a.m_22218_()).findFirst().orElse(0.0);
            if (attackSpeedModifier < -2.6) {
                AttributeModifier speedModifier = new AttributeModifier(WEAPON_SPEED_MODIFIER_ID, "Weapon speed debuff", -0.15, AttributeModifier.Operation.MULTIPLY_BASE);
                this.setHeavyWeapon(true);
                speedAttribute.m_22125_(speedModifier);
            } else {
                this.setHeavyWeapon(false);
            }
        }
    }

    protected void handleRotation() {
        int duration;
        int tickCount = (Integer)this.f_19804_.m_135370_(ROTATION_TICK_COUNT);
        if (tickCount < (duration = ((Integer)this.f_19804_.m_135370_(TURN_DURATION)).intValue())) {
            this.f_19804_.m_135381_(ROTATION_TICK_COUNT, (Object)(tickCount + 1));
            float targetYaw = this.getTargetYaw();
            float targetPitch = this.getTargetPitch();
            TurnDirection turnDirection = TurnDirection.values()[(Byte)this.f_19804_.m_135370_(TURN_DIRECTION)];
            boolean useSmoothing = (Boolean)this.f_19804_.m_135370_(SMOOTH_ROTATION);
            float progress = (float)tickCount / (float)duration;
            float finalProgress = useSmoothing ? (float)Mth.m_14197_((double)progress) : progress;
            float totalYawDifference = Mth.m_14177_((float)(targetYaw - ((Float)this.f_19804_.m_135370_(ROTATION_START_YAW)).floatValue()));
            switch (turnDirection) {
                case RIGHT: {
                    if (!(totalYawDifference < 0.0f)) break;
                    totalYawDifference += 360.0f;
                    break;
                }
                case LEFT: {
                    if (!(totalYawDifference > 0.0f)) break;
                    totalYawDifference -= 360.0f;
                }
            }
            float newHeadYaw = ((Float)this.f_19804_.m_135370_(ROTATION_START_YAW)).floatValue() + totalYawDifference * finalProgress;
            float newBodyYaw = ((Float)this.f_19804_.m_135370_(ROTATION_START_YAW_BODY)).floatValue() + totalYawDifference * finalProgress;
            float newPitch = Mth.m_14179_((float)finalProgress, (float)this.m_146909_(), (float)targetPitch);
            this.m_5616_(newHeadYaw);
            this.m_146926_(newPitch);
            this.f_20883_ = newBodyYaw;
            this.m_146922_(newHeadYaw);
        }
    }

    public boolean m_7327_(Entity pTarget) {
        ItemStack weapon = this.getWeaponStack();
        float totalDamage = 1.0f;
        if (!weapon.m_41619_()) {
            Multimap modifiers = weapon.m_41638_(EquipmentSlot.MAINHAND);
            Collection damageModifiers = modifiers.get((Object)Attributes.f_22281_);
            for (AttributeModifier modifier : damageModifiers) {
                totalDamage = (float)((double)totalDamage + modifier.m_22218_());
            }
        }
        if (pTarget instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)pTarget;
            totalDamage += EnchantmentHelper.m_44833_((ItemStack)weapon, (MobType)livingTarget.m_6336_());
        }
        if (this.getCurrentAbility() == Ability.HEAVY_ATTACK) {
            totalDamage *= 2.0f;
        }
        if (this.getHelmetStack().m_41720_() == ModItems.RAKOTH_KOBEKO_HELMET.get() && this.getChestplateStack().m_41720_() == ModItems.RAKOTH_KOBEKO_CHESTPLATE.get()) {
            this.spawnShockwave(this.m_20182_(), 0.0f, 180.0f, 5.0f, totalDamage, 10);
            this.spawnSmashedGroundEffect(Vec3.f_82478_, 1.0f, 50);
            this.spawnGroundEffects(Vec3.f_82478_, 2.0f, 5, 2, 0);
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), this.m_5720_(), 2.0f, 1.0f);
        }
        if (this.m_20280_(pTarget) < 25.0) {
            int fireAspectLevel;
            boolean hasBeenHurt = pTarget.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), totalDamage);
            if (hasBeenHurt && (fireAspectLevel = EnchantmentHelper.m_44914_((LivingEntity)this)) > 0) {
                pTarget.m_20254_(fireAspectLevel * 4);
            }
            return hasBeenHurt;
        }
        return false;
    }

    public BehaviorStatus updateRepositioningMovement(LivingEntity target, float minDistance, float maxDistance, double speedModifier) {
        if (this.isAttacking()) {
            return BehaviorStatus.FAILURE;
        }
        if (this.getTamedStance() == TamedStance.FOLLOWING) {
            return BehaviorStatus.FAILURE;
        }
        if (target == null || !target.m_6084_()) {
            this.m_21573_().m_26573_();
            return BehaviorStatus.FAILURE;
        }
        if (this.m_21573_().m_26571_()) {
            double distanceSq = this.m_20280_((Entity)target);
            if (distanceSq < (double)(minDistance * minDistance)) {
                Vec3 retreatPos = DefaultRandomPos.m_148407_((PathfinderMob)this, (int)16, (int)7, (Vec3)target.m_20182_());
                if (retreatPos != null) {
                    this.m_21573_().m_26519_(retreatPos.f_82479_, retreatPos.f_82480_, retreatPos.f_82481_, speedModifier);
                }
            } else if (distanceSq > (double)(maxDistance * maxDistance)) {
                this.m_21573_().m_5624_((Entity)target, speedModifier);
            } else {
                Vec3 finalStrafeDir;
                Vec3 strafePos;
                Vec3 vecToTarget = target.m_20182_().m_82546_(this.m_20182_());
                Vec3 strafeDir = new Vec3(-vecToTarget.m_7094_(), 0.0, vecToTarget.m_7096_()).m_82541_();
                if (this.f_19796_.m_188499_()) {
                    strafeDir = strafeDir.m_82548_();
                }
                if ((strafePos = RandomPos.m_148542_((PathfinderMob)this, () -> this.lambda$updateRepositioningMovement$3(finalStrafeDir = strafeDir))) != null) {
                    this.m_21573_().m_26519_(strafePos.f_82479_, strafePos.f_82480_, strafePos.f_82481_, speedModifier * 0.8);
                }
            }
        }
        return this.m_21573_().m_26572_() ? BehaviorStatus.RUNNING : BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus updateRepositioningMovement() {
        float minDistance = 8.0f;
        float maxDistance = 15.0f;
        double speedModifier = 1.0;
        return this.updateRepositioningMovement(this.m_5448_(), minDistance, maxDistance, speedModifier);
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        Entity attacker;
        List<ItemStack> armorList;
        int protectionValue;
        float amount = Mth.m_14036_((float)pAmount, (float)0.0f, (float)30.0f);
        if (pSource.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(pSource, pAmount);
        }
        if (this.isFainted()) {
            return false;
        }
        if (this.getCurrentAbility() == Ability.GUARD && pSource.m_7639_() != null && this.m_142582_(pSource.m_7639_())) {
            this.tookDamageThisTick = true;
            return false;
        }
        if (this.getCurrentAbility() == Ability.TAUNT && pSource.m_7639_() != null && this.m_142582_(pSource.m_7639_())) {
            this.tookDamageThisTick = true;
            return false;
        }
        if (this.getCurrentAbility() == Ability.STAGGER) {
            return false;
        }
        if (!this.m_21824_()) {
            Entity attacker2 = pSource.m_7639_();
            if (attacker2 instanceof Player) {
                return super.m_6469_(pSource, pAmount);
            }
            if (attacker2 instanceof Mob) {
                amount *= 2.0f;
            }
        }
        if (!this.m_9236_().f_46443_ && (protectionValue = EnchantmentHelper.m_44856_(armorList = List.of(this.getHelmetStack(), this.getChestplateStack()), (DamageSource)pSource)) > 0) {
            amount = CombatRules.m_19269_((float)amount, (float)protectionValue);
        }
        float finalHealth = this.m_21223_() - amount;
        if (!this.m_21824_() && (attacker = pSource.m_7639_()) instanceof Player) {
            return super.m_6469_(pSource, pAmount);
        }
        if (finalHealth <= 0.0f) {
            this.m_21153_(1.0f);
            this.f_19804_.m_135381_(IS_FAINTED, (Object)true);
            this.faintTicks = 1200;
            this.f_21344_.m_26573_();
            if (this.m_5448_() != null) {
                this.lastTargetUUID = this.m_5448_().m_20148_();
            }
            this.lastBehavior = this.getTamedBehavior();
            this.setCurrentAbility(Ability.NONE);
            this.m_6710_(null);
            this.setFaintState(FaintState.FALL.ordinal());
            this.refreshGoals();
            this.m_6677_(pSource);
            this.m_9236_().m_7605_((Entity)this, (byte)2);
            LivingEntity owner = this.m_269323_();
            if (owner instanceof Player) {
                Player player = (Player)owner;
                MutableComponent message = Component.m_237113_((String)(this.m_7755_().getString() + " has fainted!")).m_130940_(ChatFormatting.RED);
                player.m_213846_((Component)message);
            }
            return true;
        }
        this.staggerHealth -= (double)amount;
        if (this.staggerHealth <= 0.0) {
            this.staggerHealth = 50.0;
            this.setCurrentAbility(Ability.STAGGER);
        }
        return super.m_6469_(pSource, amount);
    }

    public void spawnShockwave(Vec3 spawnPos, float yaw, float pitch, float maxRadius, float damage, int lifetime) {
        if (!this.m_9236_().f_46443_) {
            ShockwaveEntity shockwave = new ShockwaveEntity(this.m_9236_(), spawnPos, (LivingEntity)this, maxRadius, damage, lifetime);
            shockwave.m_146922_(yaw);
            shockwave.m_146926_(pitch);
            this.m_9236_().m_7967_((Entity)shockwave);
        }
    }

    public void spawnSmashedGroundEffect(Vec3 offset, float radius, int duration) {
        this.spawnSmashedGroundEffect(this.m_20182_(), offset, radius, duration);
    }

    public void spawnSmashedGroundEffect(Vec3 anchor, Vec3 offset, float radius, int duration) {
        if (!this.m_9236_().f_46443_) {
            Vec3 rotatedOffset = offset.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = anchor.m_82549_(rotatedOffset);
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockState> states = new ArrayList<BlockState>();
            BlockPos center = BlockPos.m_274446_((Position)centerPos);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_((int)(-radius), -3, (int)(-radius)), (BlockPos)center.m_7918_((int)radius, 3, (int)radius))) {
                if (!(pos.m_123331_((Vec3i)center) <= (double)(radius * radius))) continue;
                BlockPos.MutableBlockPos groundPos = pos.m_122032_();
                while (this.m_9236_().m_8055_((BlockPos)groundPos).m_60795_() && groundPos.m_123342_() > this.m_9236_().m_141937_()) {
                    groundPos.m_122173_(Direction.DOWN);
                }
                BlockState groundState = this.m_9236_().m_8055_((BlockPos)groundPos);
                if (!groundState.m_280296_() || blocks.contains(groundPos)) continue;
                blocks.add(groundPos.m_7949_());
                states.add(groundState);
            }
            if (!blocks.isEmpty()) {
                SmashedGroundEffectEntity effect = new SmashedGroundEffectEntity(this.m_9236_(), blocks, states, duration, radius);
                effect.m_146884_(centerPos);
                this.m_9236_().m_7967_((Entity)effect);
            }
        }
    }

    public void spawnGroundEffects(Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount) {
        this.spawnGroundEffects(this.m_20182_(), offset, spawnRadius, debrisCount, dustCount, bigDustCount, Vec3.f_82478_, 1.0f, 1.0f);
    }

    public void spawnGroundEffects(Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount, float horizontalPower, float verticalPower) {
        this.spawnGroundEffects(this.m_20182_(), offset, spawnRadius, debrisCount, dustCount, bigDustCount, Vec3.f_82478_, horizontalPower, verticalPower);
    }

    public void spawnGroundEffects(Vec3 anchor, Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount) {
        this.spawnGroundEffects(anchor, offset, spawnRadius, debrisCount, dustCount, bigDustCount, Vec3.f_82478_, 1.0f, 1.0f);
    }

    public void spawnGroundEffects(Vec3 anchor, Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount, float horizontalPower, float verticalPower) {
        this.spawnGroundEffects(anchor, offset, spawnRadius, debrisCount, dustCount, bigDustCount, Vec3.f_82478_, horizontalPower, verticalPower);
    }

    public void spawnGroundEffects(Vec3 anchor, Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount, Vec3 velocityBias, float horizontalPower, float verticalPower) {
        if (!this.m_9236_().f_46443_) {
            Vec3 finalVelocity;
            double randomZ;
            double randomY;
            double randomX;
            Object options;
            BlockState groundState;
            BlockPos groundPos;
            Vec3 particleSpawnPos;
            double offsetZ;
            double offsetX;
            double distance;
            double angle;
            int i;
            Vec3 rotatedOffset = offset.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            Vec3 rotatedVelocityBias = velocityBias.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = anchor.m_82549_(rotatedOffset);
            for (i = 0; i < debrisCount; ++i) {
                angle = this.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = this.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = this.m_9236_().m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DebrisParticleOptions(groundState);
                randomX = (this.m_217043_().m_188500_() - 0.5) * 0.8 * (double)horizontalPower;
                randomY = this.m_217043_().m_188500_() * 0.8 * (double)verticalPower;
                randomZ = (this.m_217043_().m_188500_() - 0.5) * 0.8 * (double)horizontalPower;
                finalVelocity = new Vec3(randomX, randomY, randomZ).m_82549_(rotatedVelocityBias);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, finalVelocity, true), (Entity)this);
            }
            for (i = 0; i < dustCount; ++i) {
                angle = this.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = this.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = this.m_9236_().m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DustParticleOptions(groundState);
                randomX = (this.m_217043_().m_188500_() - 0.5) * 0.15 * (double)horizontalPower;
                randomY = this.m_217043_().m_188500_() * 0.15 * (double)verticalPower;
                randomZ = (this.m_217043_().m_188500_() - 0.5) * 0.15 * (double)horizontalPower;
                finalVelocity = new Vec3(randomX, randomY, randomZ).m_82549_(rotatedVelocityBias);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, finalVelocity, true), (Entity)this);
            }
            for (i = 0; i < bigDustCount; ++i) {
                angle = this.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = this.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                offsetZ = Math.sin(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = this.m_9236_().m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new BigDustParticleOptions(groundState);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, rotatedVelocityBias, true), (Entity)this);
            }
        }
    }

    public double tryAttack() {
        AbstractLargeMonster largeMonster;
        LivingEntity livingEntity;
        if (this.m_5448_() == null || !this.isHoldingWeapon() || !this.m_5448_().m_6084_() || this.isAttacking() || this.f_19797_ - this.lastAttack < 100 || this.getWeaponStack().m_41619_()) {
            return 0.0;
        }
        double score = 0.0;
        if (this.m_21223_() / this.m_21233_() > 0.5f) {
            score = 10.0;
        }
        if ((livingEntity = this.m_5448_()) instanceof AbstractLargeMonster && (largeMonster = (AbstractLargeMonster)livingEntity).getCurrentStaggerState() != largeMonster.getNoneStagger()) {
            score *= 10.0;
        }
        return score;
    }

    public double tryHeavyAttack() {
        AbstractLargeMonster largeMonster;
        LivingEntity livingEntity;
        if (this.m_5448_() == null || !this.isHoldingWeapon() || !this.m_5448_().m_6084_() || this.isAttacking() || this.f_19797_ - this.lastHeavyAttack < 200 || this.getWeaponStack().m_41619_()) {
            return 0.0;
        }
        double score = 0.0;
        if (this.m_20280_((Entity)this.m_5448_()) > 36.0 && this.m_21223_() / this.m_21233_() > 0.5f) {
            score = 10.0;
        }
        if ((livingEntity = this.m_5448_()) instanceof AbstractLargeMonster && (largeMonster = (AbstractLargeMonster)livingEntity).getCurrentStaggerState() != largeMonster.getNoneStagger()) {
            score *= 10.0;
        }
        return score;
    }

    /*
     * Unable to fully structure code
     */
    public double tryGuard() {
        block10: {
            block7: {
                block9: {
                    block8: {
                        if (this.m_5448_() == null || !this.isHoldingWeapon() || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastGuard < 50 || this.getWeaponStack().m_41619_()) {
                            return 0.0;
                        }
                        score = 0.0;
                        if (this.isAttacking()) break block7;
                        var7_2 = this.m_5448_();
                        if (!(var7_2 instanceof AbstractLargeMonster) || !(largeMonster = (AbstractLargeMonster)var7_2).isAttackAbility() || largeMonster.m_5448_() != this || largeMonster.getCurrentStaggerState() != largeMonster.getNoneStagger()) break block8;
                        score = 10.0;
                        break block9;
                    }
                    var7_2 = this.m_5448_();
                    if (!(var7_2 instanceof LargeMonsterPartEntity)) ** GOTO lbl-1000
                    part = (LargeMonsterPartEntity)var7_2;
                    if (part.parent.isAttackAbility() && part.parent.m_5448_() == this && part.parent.getCurrentStaggerState() == part.parent.getNoneStagger()) {
                        score = 10.0;
                    } else if (this.m_20280_((Entity)this.m_5448_()) < 9.0 && (var7_2 = this.m_5448_()) instanceof Mob && (mob = (Mob)var7_2).m_5448_() == this) {
                        score = 15.0;
                    }
                }
                var5_5 = this.m_5448_();
                if (var5_5 instanceof SkrytheEntity && (skrythe = (SkrytheEntity)var5_5).getCurrentAbility() == SkrytheEntity.Ability.SEISMIC_ROAR) {
                    score = 100.0;
                }
                break block10;
            }
            if (this.getAttackState() == AttackState.CHARGE.ordinal() && (var4_4 = this.m_5448_()) instanceof AbstractLargeMonster && (largeMonster = (AbstractLargeMonster)var4_4).m_5448_() == this && largeMonster.isAttackAbility()) {
                score = 10.0;
            }
        }
        if (this.m_5448_().m_21023_((MobEffect)ModEffects.BLINDED.get()) && !(this.m_5448_() instanceof Warden) || this.m_20280_((Entity)this.m_5448_()) > 400.0) {
            score = 0.0;
        }
        return score;
    }

    public double tryHeal() {
        if (this.m_269323_() == null || !this.m_269323_().m_6084_() || this.isAttacking() || this.f_19797_ - this.lastHeal < 400 || !this.hasGadget((Item)ModItems.VIGOR_BELT.get())) {
            return 0.0;
        }
        double score = 0.0;
        double healthPercentage = this.m_269323_().m_21223_() / this.m_269323_().m_21233_();
        if (healthPercentage <= 0.5) {
            score = 5.0;
        }
        return score *= 1.0 / (healthPercentage * healthPercentage);
    }

    public double tryTaunt() {
        if (this.m_269323_() == null || !this.m_269323_().m_6084_() || this.isAttacking() || this.f_19797_ - this.lastTaunt < 400 || !this.hasGadget((Item)ModItems.TAUNT_SHIELD.get())) {
            return 0.0;
        }
        double score = 0.0;
        double healthPercentage = this.m_269323_().m_21223_() / this.m_269323_().m_21233_();
        if (healthPercentage <= (double)0.6f) {
            score = 5.0;
        }
        return score *= 1.0 / (healthPercentage * healthPercentage);
    }

    public double trySelfHeal() {
        if (this.m_269323_() == null || !this.m_269323_().m_6084_() || this.isAttacking() || this.f_19797_ - this.lastSelfHeal < 400 || !this.hasGadget((Item)ModItems.VIGOR_BELT.get())) {
            return 0.0;
        }
        double score = 0.0;
        double healthPercentage = this.m_21223_() / this.m_21233_();
        if (healthPercentage <= 0.5) {
            score = 5.0;
        }
        return score *= 1.0 / (healthPercentage * healthPercentage);
    }

    public double tryFlash() {
        if (this.m_5448_() == null || !this.m_5448_().m_6084_() || this.isAttacking() || this.f_19797_ - this.lastFlash < 600 || !this.hasGadget((Item)ModItems.FLASH_BUNDLE.get())) {
            return 0.0;
        }
        double score = 0.0;
        if (this.m_20280_((Entity)this.m_5448_()) > 100.0) {
            score = 1.0;
        }
        return score;
    }

    public double tryHorn() {
        if (this.m_5448_() == null || !this.m_5448_().m_6084_() || this.isAttacking() || this.f_19797_ - this.lastHorn < 400 || !this.hasGadget((Item)ModItems.WHISTLEWIND_HORN.get())) {
            return 0.0;
        }
        double score = 1.0;
        if (this.m_20280_((Entity)this.m_5448_()) < 100.0) {
            score = 0.0;
        }
        return score;
    }

    public BehaviorStatus startAttack() {
        this.setCurrentAbility(Ability.ATTACK);
        this.lastAttack = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTaunt() {
        this.setCurrentAbility(Ability.TAUNT);
        this.lastTaunt = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startHorn() {
        this.setCurrentAbility(Ability.HORN);
        this.lastHorn = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startFlash() {
        this.setCurrentAbility(Ability.FLASH);
        this.lastFlash = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startHeavyAttack() {
        this.setCurrentAbility(Ability.HEAVY_ATTACK);
        this.lastHeavyAttack = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startGuard() {
        this.setCurrentAbility(Ability.GUARD);
        this.lastGuard = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startHeal() {
        this.setCurrentAbility(Ability.HEAL);
        this.lastHeal = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startSelfHeal() {
        this.setCurrentAbility(Ability.SELF_HEAL);
        this.lastSelfHeal = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    private void setupAnimationStates() {
        this.idleAnimation();
        this.attackAnimation();
        this.guardAnimation();
        this.staggerAnimation();
        this.healAnimation();
        this.faintAnimation();
        this.flashAnimation();
        this.tauntAnimation();
        this.hornAnimation();
        this.sitAnimation();
    }

    private void sitAnimation() {
        if (this.getTamedStance() == TamedStance.SITTING) {
            if (!this.sitStartAnimation.m_216984_()) {
                this.sitStartAnimation.m_216977_(this.f_19797_);
                this.sitEndAnimation.m_216973_();
            }
        } else if (this.wasSittingLastTick && !this.sitEndAnimation.m_216984_()) {
            this.sitEndAnimation.m_216977_(this.f_19797_);
            this.sitStartAnimation.m_216973_();
        }
        this.wasSittingLastTick = this.getTamedStance() == TamedStance.SITTING;
    }

    private void idleAnimation() {
        boolean shouldBeInHeavyIdle;
        if (!this.isFainted()) {
            if (!this.idleAnimation.m_216984_()) {
                this.idleAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.idleAnimation.m_216973_();
        }
        if (this.getIdleState() == IdleState.GESTURE_1.ordinal()) {
            if (!this.gesture1Animation.m_216984_()) {
                this.gesture1Animation.m_216977_(this.f_19797_);
            }
        } else {
            this.gesture1Animation.m_216973_();
        }
        if (this.getIdleState() == IdleState.GESTURE_2.ordinal()) {
            if (!this.gesture2Animation.m_216984_()) {
                this.gesture2Animation.m_216977_(this.f_19797_);
            }
        } else {
            this.gesture2Animation.m_216973_();
        }
        if (this.getIdleState() == IdleState.GESTURE_3.ordinal()) {
            if (!this.gesture3Animation.m_216984_()) {
                this.gesture3Animation.m_216977_(this.f_19797_);
            }
        } else {
            this.gesture3Animation.m_216973_();
        }
        if (this.getIdleState() == IdleState.GESTURE_4.ordinal()) {
            if (!this.gesture4Animation.m_216984_()) {
                this.gesture4Animation.m_216977_(this.f_19797_);
            }
        } else {
            this.gesture4Animation.m_216973_();
        }
        if (this.getIdleState() == IdleState.GESTURE_5.ordinal()) {
            if (!this.gesture5Animation.m_216984_()) {
                this.gesture5Animation.m_216977_(this.f_19797_);
            }
        } else {
            this.gesture5Animation.m_216973_();
        }
        boolean bl = shouldBeInHeavyIdle = this.isHoldingWeapon() && this.isHeavyWeapon() && (!this.isAttacking() || this.getAttackState() == AttackState.CHARGE.ordinal()) && !this.getWeaponStack().m_41619_() && !this.isFainted() && this.getTamedStance() != TamedStance.SITTING;
        if (shouldBeInHeavyIdle) {
            if (this.heavyIdleState == HeavyIdleState.NONE || this.heavyIdleState == HeavyIdleState.ENDING) {
                this.heavyIdleState = HeavyIdleState.STARTING;
                this.heavyIdleStartAnimation.m_216977_(this.f_19797_);
                this.heavyIdleEndAnimation.m_216973_();
            }
        } else if (this.heavyIdleState == HeavyIdleState.STARTING || this.heavyIdleState == HeavyIdleState.IDLING) {
            this.heavyIdleState = HeavyIdleState.ENDING;
            this.heavyIdleStartAnimation.m_216973_();
            this.heavyIdleAnimation.m_216973_();
            this.heavyIdleEndAnimation.m_216977_(this.f_19797_);
        }
        if (this.heavyIdleState == HeavyIdleState.STARTING) {
            if (this.heavyIdleStartAnimation.m_216981_() >= 250L) {
                this.heavyIdleState = HeavyIdleState.IDLING;
                this.heavyIdleAnimation.m_216977_(this.f_19797_);
                this.heavyIdleStartAnimation.m_216973_();
            }
        } else if (this.heavyIdleState == HeavyIdleState.ENDING && this.heavyIdleEndAnimation.m_216981_() >= 250L) {
            this.heavyIdleState = HeavyIdleState.NONE;
        }
    }

    private void attackAnimation() {
        if (this.getCurrentAbility() == Ability.ATTACK && this.getAttackState() == AttackState.FAST.ordinal()) {
            if (!this.attackFastAnimation.m_216984_()) {
                this.attackFastAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.attackFastAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.ATTACK && this.getAttackState() == AttackState.SLOW.ordinal()) {
            if (!this.attackSlowAnimation.m_216984_()) {
                this.attackSlowAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.attackSlowAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.HEAVY_ATTACK && this.getHeavyAttackState() == HeavyAttackState.START.ordinal()) {
            if (!this.heavyAttackStartAnimation.m_216984_()) {
                this.heavyAttackStartAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.heavyAttackStartAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.HEAVY_ATTACK && this.getHeavyAttackState() == HeavyAttackState.CHARGE.ordinal()) {
            if (!this.heavyAttackChargeAnimation.m_216984_()) {
                this.heavyAttackChargeAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.heavyAttackChargeAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.HEAVY_ATTACK && this.getHeavyAttackState() == HeavyAttackState.HIT.ordinal()) {
            if (!this.heavyAttackHitAnimation.m_216984_()) {
                this.heavyAttackHitAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.heavyAttackHitAnimation.m_216973_();
        }
    }

    private void staggerAnimation() {
        if (this.getCurrentAbility() == Ability.STAGGER) {
            if (!this.staggerAnimation.m_216984_()) {
                this.staggerAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.staggerAnimation.m_216973_();
        }
    }

    private void guardAnimation() {
        if (this.getCurrentAbility() == Ability.GUARD && this.getGuardState() == GuardState.HOLD.ordinal()) {
            if (!this.guardAnimation.m_216984_()) {
                this.guardAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.guardAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.GUARD && this.getGuardState() == GuardState.HIT.ordinal()) {
            if (!this.guardHitAnimation.m_216984_()) {
                this.guardHitAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.guardHitAnimation.m_216973_();
        }
    }

    private void healAnimation() {
        if (this.getCurrentAbility() == Ability.HEAL && this.getHealState() == HealState.START.ordinal()) {
            if (!this.healStartAnimation.m_216984_()) {
                this.healStartAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.healStartAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.HEAL && this.getHealState() == HealState.CHARGE.ordinal()) {
            if (!this.healChargeAnimation.m_216984_()) {
                this.healChargeAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.healChargeAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.HEAL && this.getHealState() == HealState.THROW.ordinal()) {
            if (!this.healThrowAnimation.m_216984_()) {
                this.healThrowAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.healThrowAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.SELF_HEAL) {
            if (!this.selfHealAnimation.m_216984_()) {
                this.selfHealAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.selfHealAnimation.m_216973_();
        }
    }

    private void flashAnimation() {
        if (this.getCurrentAbility() == Ability.FLASH) {
            if (!this.flashAnimation.m_216984_()) {
                this.flashAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.flashAnimation.m_216973_();
        }
    }

    private void faintAnimation() {
        if (this.getFaintState() == FaintState.FALL.ordinal()) {
            if (!this.faintFallAnimation.m_216984_()) {
                this.faintFallAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.faintFallAnimation.m_216973_();
        }
        if (this.getFaintState() == FaintState.RECOVER.ordinal()) {
            if (!this.faintRecoverAnimation.m_216984_()) {
                this.faintRecoverAnimation.m_216977_(this.f_19797_);
            }
            if (this.faintRecoverAnimation.m_216981_() >= 1000L) {
                this.setFaintState(FaintState.NONE.ordinal());
            }
        } else {
            this.faintRecoverAnimation.m_216973_();
        }
    }

    private void tauntAnimation() {
        if (this.getCurrentAbility() == Ability.TAUNT && this.getTauntState() == TauntState.HOLD.ordinal()) {
            if (!this.tauntHoldAnimation.m_216984_()) {
                this.tauntHoldAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.tauntHoldAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.TAUNT && this.getTauntState() == TauntState.HIT.ordinal()) {
            if (!this.tauntHitAnimation.m_216984_()) {
                this.tauntHitAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.tauntHitAnimation.m_216973_();
        }
    }

    private void hornAnimation() {
        if (this.getCurrentAbility() == Ability.HORN) {
            if (!this.hornAnimation.m_216984_()) {
                this.hornAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.hornAnimation.m_216973_();
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && this.getCurrentAbility() != Ability.HEAVY_ATTACK && this.getHealState() != HealState.CHARGE.ordinal() && this.getTauntState() != TauntState.HIT.ordinal() ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public TamedBehavior getTamedBehavior() {
        return TamedBehavior.values()[(Byte)this.f_19804_.m_135370_(TAMED_BEHAVIOR)];
    }

    public void setTamedBehavior(TamedBehavior behavior) {
        this.f_19804_.m_135381_(TAMED_BEHAVIOR, (Object)((byte)behavior.ordinal()));
        this.refreshGoals();
        this.setHoldingWeapon(behavior != TamedBehavior.PASSIVE);
    }

    public TamedStance getTamedStance() {
        return TamedStance.values()[(Byte)this.f_19804_.m_135370_(TAMED_STANCE)];
    }

    public void setTamedStance(TamedStance stance) {
        this.f_19804_.m_135381_(TAMED_STANCE, (Object)((byte)stance.ordinal()));
        this.m_21839_(stance == TamedStance.SITTING);
        this.refreshGoals();
    }

    @Override
    public final Ability getCurrentAbility() {
        int ordinal = (Integer)this.f_19804_.m_135370_(ABILITY_STATE);
        return Ability.values()[ordinal];
    }

    @Override
    public void setCurrentAbility(Ability ability) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        this.f_19804_.m_135381_(ABILITY_STATE, (Object)ability.ordinal());
    }

    public int getGuardState() {
        return (Integer)this.f_19804_.m_135370_(GUARD_STATE);
    }

    public void setGuardState(int state) {
        this.f_19804_.m_135381_(GUARD_STATE, (Object)state);
    }

    public int getAttackState() {
        return (Integer)this.f_19804_.m_135370_(ATTACK_STATE);
    }

    public void setAttackState(int state) {
        this.f_19804_.m_135381_(ATTACK_STATE, (Object)state);
    }

    public int getHeavyAttackState() {
        return (Integer)this.f_19804_.m_135370_(HEAVY_ATTACK_STATE);
    }

    public void setHeavyAttackState(int state) {
        this.f_19804_.m_135381_(HEAVY_ATTACK_STATE, (Object)state);
    }

    public int getHealState() {
        return (Integer)this.f_19804_.m_135370_(HEAL_STATE);
    }

    public void setHealState(int state) {
        this.f_19804_.m_135381_(HEAL_STATE, (Object)state);
    }

    public int getFaintState() {
        return (Integer)this.f_19804_.m_135370_(FAINT_STATE);
    }

    public void setFaintState(int state) {
        this.f_19804_.m_135381_(FAINT_STATE, (Object)state);
    }

    public boolean isHeavyWeapon() {
        return (Boolean)this.f_19804_.m_135370_(HEAVY_WEAPON);
    }

    public void setHeavyWeapon(boolean heavy) {
        this.f_19804_.m_135381_(HEAVY_WEAPON, (Object)heavy);
    }

    public boolean isHoldingWeapon() {
        return (Boolean)this.f_19804_.m_135370_(HOLDING_WEAPON);
    }

    public void setHoldingWeapon(boolean holding) {
        this.f_19804_.m_135381_(HOLDING_WEAPON, (Object)holding);
        if (holding) {
            this.setHeldItemStack(this.getWeaponStack());
        } else {
            this.setHeldItemStack(ItemStack.f_41583_);
        }
        this.updateWeaponAttributes();
    }

    @Override
    public Ability getNoneAbility() {
        return Ability.NONE;
    }

    @Override
    public boolean isAttacking() {
        return this.getCurrentAbility() != Ability.NONE;
    }

    public boolean isRotationManual() {
        return (Boolean)this.f_19804_.m_135370_(MANUAL_ROTAION);
    }

    public void setRotationManual(boolean manual) {
        if (!manual) {
            this.setTargetRotation(this.f_20883_, 0.0f, 0);
        }
        this.f_19804_.m_135381_(MANUAL_ROTAION, (Object)manual);
    }

    public void setTargetRotation(float yaw, float pitch, int turnTicks, TurnDirection direction, boolean useSmoothing) {
        this.f_19804_.m_135381_(TARGET_YAW, (Object)Float.valueOf(Mth.m_14177_((float)yaw)));
        this.f_19804_.m_135381_(TARGET_PITCH, (Object)Float.valueOf(Mth.m_14036_((float)pitch, (float)-90.0f, (float)90.0f)));
        this.f_19804_.m_135381_(TURN_DIRECTION, (Object)((byte)direction.ordinal()));
        this.f_19804_.m_135381_(TURN_DURATION, (Object)turnTicks);
        this.f_19804_.m_135381_(ROTATION_TICK_COUNT, (Object)0);
        this.f_19804_.m_135381_(ROTATION_START_YAW, (Object)Float.valueOf(this.m_6080_()));
        this.f_19804_.m_135381_(ROTATION_START_YAW_BODY, (Object)Float.valueOf(this.f_20883_));
        this.f_19804_.m_135381_(SMOOTH_ROTATION, (Object)useSmoothing);
    }

    public void setTargetRotation(float yaw, float pitch, int turnTicks) {
        this.setTargetRotation(yaw, pitch, turnTicks, TurnDirection.SHORTEST, false);
    }

    public float getTargetYaw() {
        return ((Float)this.f_19804_.m_135370_(TARGET_YAW)).floatValue();
    }

    public float getTargetPitch() {
        return ((Float)this.f_19804_.m_135370_(TARGET_PITCH)).floatValue();
    }

    public boolean isFainted() {
        return (Boolean)this.f_19804_.m_135370_(IS_FAINTED);
    }

    public void revive(float healthPercentage) {
        if (!this.m_9236_().f_46443_ && this.isFainted()) {
            Level level;
            this.f_19804_.m_135381_(IS_FAINTED, (Object)false);
            this.faintTicks = 0;
            this.m_21153_(this.m_21233_() * healthPercentage);
            this.setFaintState(FaintState.RECOVER.ordinal());
            this.setTamedBehavior(this.lastBehavior);
            if (this.lastTargetUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
                LivingEntity livingTarget;
                ServerLevel serverLevel = (ServerLevel)level;
                Entity targetEntity = serverLevel.m_8791_(this.lastTargetUUID);
                if (targetEntity instanceof LivingEntity && (livingTarget = (LivingEntity)targetEntity).m_6084_()) {
                    this.m_6710_(livingTarget);
                }
                this.lastTargetUUID = null;
            }
        }
    }

    public ItemStack getGadgetStack1() {
        return (ItemStack)this.f_19804_.m_135370_(GADGET_STACK_1);
    }

    public void setGadgetStack1(ItemStack stack) {
        this.f_19804_.m_135381_(GADGET_STACK_1, (Object)stack);
    }

    public ItemStack getGadgetStack2() {
        return (ItemStack)this.f_19804_.m_135370_(GADGET_STACK_2);
    }

    public void setGadgetStack2(ItemStack stack) {
        this.f_19804_.m_135381_(GADGET_STACK_2, (Object)stack);
    }

    public ItemStack getGadgetStack3() {
        return (ItemStack)this.f_19804_.m_135370_(GADGET_STACK_3);
    }

    public void setGadgetStack3(ItemStack stack) {
        this.f_19804_.m_135381_(GADGET_STACK_3, (Object)stack);
    }

    public ItemStack getHeldItemStack() {
        return (ItemStack)this.f_19804_.m_135370_(HELD_ITEM_STACK);
    }

    public void setHeldItemStack(ItemStack stack) {
        this.f_19804_.m_135381_(HELD_ITEM_STACK, (Object)stack);
    }

    public int getIdleState() {
        return (Integer)this.f_19804_.m_135370_(IDLE_STATE);
    }

    public void setIdleState(int state) {
        this.f_19804_.m_135381_(IDLE_STATE, (Object)state);
    }

    public int getTauntState() {
        return (Integer)this.f_19804_.m_135370_(TAUNT_STATE);
    }

    public void setTauntState(int state) {
        this.f_19804_.m_135381_(TAUNT_STATE, (Object)state);
    }

    public void m_6710_(@Nullable LivingEntity pTarget) {
        if (pTarget == null) {
            super.m_6710_(null);
            return;
        }
        LivingEntity finalTarget = pTarget;
        if (pTarget instanceof AbstractLargeMonster) {
            AbstractLargeMonster parentMonster = (AbstractLargeMonster)pTarget;
            finalTarget = this.findBestReachablePart(parentMonster);
        } else if (pTarget instanceof LargeMonsterPartEntity) {
            LargeMonsterPartEntity part = (LargeMonsterPartEntity)pTarget;
            Object parentMonster = part.parent;
            if (part.m_20186_() >= parentMonster.m_20186_() + 4.0) {
                finalTarget = this.findBestReachablePart((AbstractLargeMonster<?, ?>)parentMonster);
            }
        }
        super.m_6710_(finalTarget);
    }

    private LivingEntity findBestReachablePart(AbstractLargeMonster<?, ?> parentMonster) {
        ArrayList reachableParts = new ArrayList();
        for (LargeMonsterPartEntity<?> part : parentMonster.getBodyParts()) {
            if (!(part.m_20186_() < parentMonster.m_20186_() + 1.0) || !part.m_6084_()) continue;
            reachableParts.add(part);
        }
        Optional<LargeMonsterPartEntity> closestPartOptional = reachableParts.stream().min(Comparator.comparingDouble(p -> p.m_20280_((Entity)this)));
        if (closestPartOptional.isPresent()) {
            return closestPartOptional.get();
        }
        return parentMonster;
    }

    public KobekoVariant getVariant() {
        return KobekoVariant.getById(this.getTypeVariant() & 0xFF);
    }

    private int getTypeVariant() {
        return (Integer)this.f_19804_.m_135370_(DATA_ID_TYPE_VARIANT);
    }

    private void setVariant(KobekoVariant variant) {
        this.f_19804_.m_135381_(DATA_ID_TYPE_VARIANT, (Object)(variant.getId() & 0xFF));
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor pLevel, DifficultyInstance pDifficulty, MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        KobekoVariant variant = (KobekoVariant)((Object)Util.m_214670_((Object[])KobekoVariant.values(), (RandomSource)this.f_19796_));
        this.setVariant(variant);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public boolean hasGadget(Item item) {
        return this.getGadgetStack1().m_41720_() == item || this.getGadgetStack2().m_41720_() == item || this.getGadgetStack3().m_41720_() == item;
    }

    public void m_21828_(Player pPlayer) {
        super.m_21828_(pPlayer);
        if (!this.m_9236_().f_46443_) {
            CompoundTag playerData = pPlayer.getPersistentData();
            playerData.m_128362_("TamedKobekoUUID", this.m_20148_());
            playerData.m_128359_("KobekoLastDim", this.m_9236_().m_46472_().m_135782_().toString());
            playerData.m_128356_("KobekoLastPos", this.m_20183_().m_121878_());
            System.out.println("[KOBEKO-TAME] Tamed and saved initial pos: " + this.m_20183_().toString());
        }
    }

    private /* synthetic */ BlockPos lambda$updateRepositioningMovement$3(Vec3 finalStrafeDir) {
        return this.m_20183_().m_7918_(Mth.m_14107_((double)(finalStrafeDir.f_82479_ * 8.0)), 0, Mth.m_14107_((double)(finalStrafeDir.f_82481_ * 8.0)));
    }

    public static enum HeavyIdleState {
        NONE,
        STARTING,
        IDLING,
        ENDING;

    }

    public static enum TamedStance {
        FOLLOWING,
        SITTING,
        WANDERING;

    }

    public static enum TamedBehavior {
        AGGRESSIVE,
        PASSIVE,
        NEUTRAL;

    }

    public static enum Ability {
        NONE,
        ATTACK,
        GUARD,
        STAGGER,
        HEAVY_ATTACK,
        HEAL,
        SELF_HEAL,
        FLASH,
        TAUNT,
        HORN;

    }

    public static enum AttackState {
        NONE,
        CHARGE,
        FAST,
        SLOW;

    }

    public static enum GuardState {
        NONE,
        HOLD,
        HIT;

    }

    public static enum HeavyAttackState {
        NONE,
        START,
        CHARGE,
        HIT;

    }

    public static enum HealState {
        NONE,
        START,
        CHARGE,
        THROW;

    }

    public static enum FaintState {
        NONE,
        FALL,
        RECOVER;

    }

    public static enum IdleState {
        NONE,
        GESTURE_1,
        GESTURE_2,
        GESTURE_3,
        GESTURE_4,
        GESTURE_5;

    }

    public static enum TauntState {
        NONE,
        HOLD,
        HIT;

    }

    public static enum TurnDirection {
        SHORTEST,
        RIGHT,
        LEFT;

    }
}

