/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.config.ModConfig;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorStatus;
import net.saksolm.monsterexpansion.entity.ai.behavior.custom.LeivekilthAerialBehaviorTree;
import net.saksolm.monsterexpansion.entity.ai.behavior.custom.LeivekilthGroundBehaviorTree;
import net.saksolm.monsterexpansion.entity.ai.behavior.custom.LeivekilthWaterBehaviorTree;
import net.saksolm.monsterexpansion.entity.ai.control.BigMobFlyController;
import net.saksolm.monsterexpansion.entity.ai.control.BigMobMoveControl;
import net.saksolm.monsterexpansion.entity.ai.control.BigMobPathNavigate;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthAirBombardGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthAirBreathGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthAirTailswipeGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthBellyFlopGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthBellySlamGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthBreathForwardGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthBreathSpinGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthEnrageGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthFindLandGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthHeadStabGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthLeftBreathGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthRightBreathGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthRightSlamGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthRoarGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthStaggerGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthSupercoolDetonationGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthTailCutGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthTailswipeGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthToppleGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthTurnFlopGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthTurnGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthTurnSlamGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthWanderSwimGoal;
import net.saksolm.monsterexpansion.entity.ai.leivekilth.LeivekilthWingBreakGoal;
import net.saksolm.monsterexpansion.entity.animations.LeivekilthAnimationState;
import net.saksolm.monsterexpansion.entity.animations.LeivekilthServerAnimations;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.IFlyingMonster;
import net.saksolm.monsterexpansion.entity.custom.IMonsterAbilities;
import net.saksolm.monsterexpansion.entity.custom.IMonsterStaggers;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.LeivekilthPartEntity;
import net.saksolm.monsterexpansion.entity.custom.LeivekilthTailEntity;
import net.saksolm.monsterexpansion.entity.custom.projectile.SupercooledOrbEntity;
import net.saksolm.monsterexpansion.entity.custom.projectile.VolatileGlobEntity;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.particles.options.ColorParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import net.saksolm.monsterexpansion.util.AttackDefinition;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class LeivekilthEntity
extends AbstractLargeMonster<Ability, StaggerState>
implements IFlyingMonster {
    public static final double BASE_MAX_HEALTH = 1000.0;
    public static final double BASE_ATTACK_DAMAGE = 30.0;
    private static final Map<String, String> LEIVEKILTH_HIERARCHY = ImmutableMap.builder().put((Object)"torso", (Object)"Leivekilth").put((Object)"upper", (Object)"torso").put((Object)"lower", (Object)"torso").put((Object)"upper_neck", (Object)"upper").put((Object)"neck", (Object)"upper_neck").put((Object)"head", (Object)"neck").put((Object)"jaw", (Object)"head").put((Object)"head_anchor", (Object)"head").put((Object)"right_arm", (Object)"upper").put((Object)"right_arm_membrane1", (Object)"right_arm").put((Object)"right_arm_membrane2", (Object)"right_arm_membrane1").put((Object)"right_forearm", (Object)"right_arm").put((Object)"right_forearm_membrane1", (Object)"right_forearm").put((Object)"right_forearm_membrane2", (Object)"right_forearm_membrane1").put((Object)"right_arm_tip", (Object)"right_forearm").put((Object)"right_armtip_membrane1", (Object)"right_arm_tip").put((Object)"right_armtip_membrane2", (Object)"right_armtip_membrane1").put((Object)"left_arm", (Object)"upper").put((Object)"left_arm_membrane1", (Object)"left_arm").put((Object)"left_arm_membrane2", (Object)"left_arm_membrane1").put((Object)"left_forearm", (Object)"left_arm").put((Object)"left_forearm_membrane1", (Object)"left_forearm").put((Object)"left_forearm_membrane2", (Object)"left_forearm_membrane1").put((Object)"left_arm_tip", (Object)"left_forearm").put((Object)"left_armtip_membrane1", (Object)"left_arm_tip").put((Object)"left_armtip_membrane2", (Object)"left_armtip_membrane1").put((Object)"tip7", (Object)"upper").put((Object)"tail", (Object)"lower").put((Object)"tail_anchor", (Object)"tail").put((Object)"tail1", (Object)"tail").put((Object)"tail1_anchor", (Object)"tail1").put((Object)"tail2", (Object)"tail1").put((Object)"tail2_anchor", (Object)"tail2").put((Object)"tail3", (Object)"tail2").put((Object)"tail3_anchor", (Object)"tail3").put((Object)"tail4", (Object)"tail3").put((Object)"tail4_anchor", (Object)"tail4").put((Object)"tail5", (Object)"tail4").put((Object)"tail5_anchor", (Object)"tail5").put((Object)"tail6", (Object)"tail5").put((Object)"tail6_anchor", (Object)"tail6").build();
    private static final Map<String, Vec3> LEIVEKILTH_DEFAULT_OFFSETS = ImmutableMap.builder().put((Object)"torso", (Object)new Vec3(0.0, 1.625, 0.0)).put((Object)"upper", (Object)new Vec3(0.0, 1.6875, 1.6875)).put((Object)"upper_neck", (Object)new Vec3(0.0, -1.42150625, -3.24388125)).put((Object)"neck", (Object)new Vec3(0.0, 1.28088125, -0.61549375)).put((Object)"head", (Object)new Vec3(0.0, 0.09375, -1.328125)).put((Object)"jaw", (Object)new Vec3(0.0, -1.0625, 0.0)).put((Object)"head_anchor", (Object)new Vec3(0.0, -0.6875, -1.1875)).put((Object)"right_arm", (Object)new Vec3(1.6875, -0.421875, -2.875)).put((Object)"right_arm_membrane1", (Object)new Vec3(3.3125, -0.140625, -0.125)).put((Object)"right_arm_membrane2", (Object)new Vec3(-1.875, 0.0, 7.1875)).put((Object)"right_forearm", (Object)new Vec3(3.32939375, -0.09248125, 0.13191875)).put((Object)"right_forearm_membrane1", (Object)new Vec3(1.59203125, -0.04771875, 0.08790625)).put((Object)"right_forearm_membrane2", (Object)new Vec3(0.0625, 0.0, 7.1875)).put((Object)"right_arm_tip", (Object)new Vec3(3.04515625, 0.21790625, -0.09959375)).put((Object)"right_armtip_membrane1", (Object)new Vec3(7.234375, -0.265625, -0.375)).put((Object)"right_armtip_membrane2", (Object)new Vec3(-5.75, 0.0, 3.875)).put((Object)"left_arm", (Object)new Vec3(-1.6875, -0.421875, -2.875)).put((Object)"left_arm_membrane1", (Object)new Vec3(-3.3125, -0.140625, -0.125)).put((Object)"left_arm_membrane2", (Object)new Vec3(1.875, 0.0, 7.1875)).put((Object)"left_forearm", (Object)new Vec3(-3.32939375, -0.09248125, 0.13191875)).put((Object)"left_forearm_membrane1", (Object)new Vec3(-1.59203125, -0.04771875, 0.08790625)).put((Object)"left_forearm_membrane2", (Object)new Vec3(-0.0625, 0.0, 7.1875)).put((Object)"left_arm_tip", (Object)new Vec3(-3.04515625, 0.21790625, -0.09959375)).put((Object)"left_armtip_membrane1", (Object)new Vec3(-7.234375, -0.265625, -0.375)).put((Object)"left_armtip_membrane2", (Object)new Vec3(5.75, 0.0, 3.875)).put((Object)"tip7", (Object)new Vec3(-0.125, 5.557875, -0.4900875)).put((Object)"lower", (Object)new Vec3(0.0, 1.6875, 1.6875)).put((Object)"tail", (Object)new Vec3(0.0, 0.078125, 1.96875)).put((Object)"tail_anchor", (Object)new Vec3(0.0, -1.5749375, 0.97229375)).put((Object)"tail1", (Object)new Vec3(0.0, -0.125, 1.96875)).put((Object)"tail1_anchor", (Object)new Vec3(0.0025375, -0.966575, 1.0912)).put((Object)"tail2", (Object)new Vec3(0.0, 0.0, 1.796875)).put((Object)"tail2_anchor", (Object)new Vec3(0.00208125, -0.73938125, 0.996175)).put((Object)"tail3", (Object)new Vec3(0.0, 0.0, 1.921875)).put((Object)"tail3_anchor", (Object)new Vec3(0.00188125, -0.65903125, 0.94126875)).put((Object)"tail4", (Object)new Vec3(0.0, 0.0, 1.859375)).put((Object)"tail4_anchor", (Object)new Vec3(0.00143125, -0.38148125, 0.9327875)).put((Object)"tail5", (Object)new Vec3(0.0, 0.0625, 1.859375)).put((Object)"tail5_anchor", (Object)new Vec3(0.0012125, -0.20065, 1.13484375)).put((Object)"tail6", (Object)new Vec3(0.0, -0.25, 2.515625)).put((Object)"tail6_anchor", (Object)new Vec3(0.00114375, 0.10015625, 2.00626875)).build();
    private static final Map<String, Vec3> LEIVEKILTH_DEFAULT_ROTATIONS = ImmutableMap.builder().put((Object)"torso", (Object)new Vec3((double)-0.4363f, 0.0, 0.0)).put((Object)"upper", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"upper_neck", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"neck", (Object)new Vec3((double)0.0436f, 0.0, 0.0)).put((Object)"head", (Object)new Vec3((double)0.3927f, 0.0, 0.0)).put((Object)"jaw", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"head_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_arm", (Object)new Vec3(0.0, (double)0.3927f, (double)-1.0472f)).put((Object)"right_arm_membrane1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_arm_membrane2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_forearm", (Object)new Vec3((double)1.2915f, (double)-1.0011f, (double)-0.4171f)).put((Object)"right_forearm_membrane1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_forearm_membrane2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_arm_tip", (Object)new Vec3((double)2.8095f, (double)0.8449f, (double)-2.9141f)).put((Object)"right_armtip_membrane1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_armtip_membrane2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_arm", (Object)new Vec3(0.0, (double)-0.3927f, (double)1.0472f)).put((Object)"left_arm_membrane1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_arm_membrane2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_forearm", (Object)new Vec3((double)1.2915f, (double)1.0011f, (double)0.4171f)).put((Object)"left_forearm_membrane1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_forearm_membrane2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_arm_tip", (Object)new Vec3((double)2.8095f, (double)-0.8449f, (double)2.9141f)).put((Object)"left_armtip_membrane1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_armtip_membrane2", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tip7", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"lower", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail", (Object)new Vec3((double)0.0873f, 0.0, 0.0)).put((Object)"tail_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail1", (Object)new Vec3((double)0.0436f, (double)0.0012f, (double)-0.0013f)).put((Object)"tail1_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail2", (Object)new Vec3((double)0.0873f, 0.0, 0.0)).put((Object)"tail2_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail3", (Object)new Vec3((double)0.0436f, 0.0, 0.0)).put((Object)"tail3_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail4", (Object)new Vec3((double)0.0436f, 0.0, 0.0)).put((Object)"tail4_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail5", (Object)new Vec3((double)0.0873f, 0.0, 0.0)).put((Object)"tail5_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail6", (Object)new Vec3((double)0.0873f, 0.0, 0.0)).put((Object)"tail6_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).build();
    public final AnimationState landMembraneScale = new AnimationState();
    public final AnimationState rightSlamAnimation = new AnimationState();
    public final AnimationState headStabAnimation = new AnimationState();
    public final AnimationState turnRightAnimation = new AnimationState();
    public final AnimationState turnLeftAnimation = new AnimationState();
    public final AnimationState bellySlamAnimation = new AnimationState();
    public final AnimationState tailswipeAnimation = new AnimationState();
    public final AnimationState bellyFlopAnimation = new AnimationState();
    public final AnimationState turnSlamLeftAnimation = new AnimationState();
    public final AnimationState turnSlamRightAnimation = new AnimationState();
    public final AnimationState bellyFlopReFlopAnimation = new AnimationState();
    public final AnimationState bellyFlopEndAnimation = new AnimationState();
    public final AnimationState turnFlopAnimation = new AnimationState();
    public final AnimationState breathSpinAnimation = new AnimationState();
    public final AnimationState breathForwardAnimation = new AnimationState();
    public final AnimationState enrageAnimation = new AnimationState();
    public final AnimationState aerialAnimation = new AnimationState();
    public final AnimationState airTailswipeAnimation = new AnimationState();
    public final AnimationState airBombardTurnLeftAnimation = new AnimationState();
    public final AnimationState airBombardTurnRightAnimation = new AnimationState();
    public final AnimationState airBombardStartAnimation = new AnimationState();
    public final AnimationState airBombardGlideAnimation = new AnimationState();
    public final AnimationState airBombardStopAnimation = new AnimationState();
    public final AnimationState airBreathAnimation = new AnimationState();
    public final AnimationState supercoolDetonationAnimation = new AnimationState();
    public final AnimationState groundStaggerAnimation = new AnimationState();
    public final AnimationState groundToppleAnimation = new AnimationState();
    public final AnimationState groundWingBreakRightAnimation = new AnimationState();
    public final AnimationState groundWingBreakLeftAnimation = new AnimationState();
    public final AnimationState groundTailCutAnimation = new AnimationState();
    public final AnimationState airStaggerAnimation = new AnimationState();
    public final AnimationState airWingBreakLeftAnimation = new AnimationState();
    public final AnimationState airWingBreakRightAnimation = new AnimationState();
    public final AnimationState airTailCutStartAnimation = new AnimationState();
    public final AnimationState airTailCutFallAnimation = new AnimationState();
    public final AnimationState airTailCutCrashAnimation = new AnimationState();
    public final AnimationState airToppleStartAnimation = new AnimationState();
    public final AnimationState airToppleFallAnimation = new AnimationState();
    public final AnimationState airToppleCrashAnimation = new AnimationState();
    public final AnimationState swimIdle = new AnimationState();
    public final AnimationState deathAnimation = new AnimationState();
    public final AnimationState rightBreathAnimation = new AnimationState();
    public final AnimationState leftBreathAnimation = new AnimationState();
    public final AnimationState roarAnimation = new AnimationState();
    @Nullable
    private Vec3 waterWanderTarget = null;
    private int ticksStuckClose = 0;
    private int ticksSpentFlying = 0;
    private int pathUpdateCooldown = 0;
    private int flightCooldown = 0;
    private int landingCooldown = 0;
    private int takeoffStartTick = -1;
    private boolean hasLaunched = false;
    private int timeTargetOutOfRange = 0;
    private int timeInRange = 0;
    private float tailHealth;
    private static final EntityDataAccessor<Boolean> TAIL_CUT = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT_UPPER_ICE_BROKEN = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> RIGHT_LOWER_ICE_BROKEN = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT_UPPER_ICE_BROKEN = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> LEFT_LOWER_ICE_BROKEN = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> HEAD_ICE_BROKEN = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private final LeivekilthPartEntity head;
    private final LeivekilthPartEntity tail;
    private final LeivekilthPartEntity tail1;
    private final LeivekilthPartEntity tail2;
    private final LeivekilthPartEntity tail3;
    private final LeivekilthPartEntity tail4;
    private final LeivekilthPartEntity tail5;
    private final LeivekilthPartEntity tail6;
    private final LeivekilthPartEntity left_forearm;
    private final LeivekilthPartEntity right_forearm;
    private final LeivekilthPartEntity left_arm_tip;
    private final LeivekilthPartEntity right_arm_tip;
    private final LeivekilthAnimationState animationState = new LeivekilthAnimationState();
    private final LeivekilthPartEntity[] parts;
    private LeivekilthGroundBehaviorTree groundBehaviorTree;
    private LeivekilthAerialBehaviorTree aerialBehaviorTree;
    private LeivekilthWaterBehaviorTree waterBehaviorTree;
    private final MoveControl groundMoveControl;
    private final LookControl groundLookControl;
    private final MoveControl swimMoveControl;
    private final LookControl swimLookControl;
    private final MoveControl flyMoveControl;
    private boolean iceBreath = false;
    private int lastRightSlam = -1000;
    private int lastHeadStab = -1000;
    private int lastTurn = -1000;
    private int lastBellySlam = -1000;
    private int lastTailswipe = -1000;
    private int lastBellyFlop = -1000;
    private int lastTurnSlam = -1000;
    private int lastTurnFlop = -1000;
    private int lastBreathSpin = -1000;
    private int lastBreathForward = -1000;
    private int lastAirTailswipe = -1000;
    private int lastAirBombard = -1000;
    private int lastAirBreath = -1000;
    private int lastSupercoolDetonation = -1000;
    private int lastGlance = -1000;
    private int lastRightBreath = -1000;
    private int lastLeftBreath = -1000;
    private int lastRoar = -1000;
    private final int ROAR_COOLDOWN = 2000;
    private final int RIGHT_SLAM_COOLDOWN = 120;
    private final int HEAD_STAB_COOLDOWN = 200;
    private final int TURN_COOLDOWN = 200;
    private final int BELLY_SLAM_COOLDOWN = 200;
    private final int TAILSWIPE_COOLDOWN = 200;
    private final int BELLY_FLOP_COOLDOWN = 600;
    private final int TURN_FLOP_COOLDOWN = 600;
    private final int TURN_SLAM_COOLDOWN = 300;
    private final int BREATH_SPIN_COOLDOWN = 600;
    private final int BREATH_FORWARD_COOLDOWN = 600;
    private final int AIR_TAILSWIPE_COOLDOWN = 200;
    private final int AIR_BOMBARD_COOLDOWN = 200;
    private final int AIR_BREATH_COOLDOWN = 200;
    private final int SUPERCOOL_DETONATION_COOLDOWN = 200;
    private final int GLANCE_COOLDOWN = 300;
    private final int RIGHT_BREATH_COOLDOWN = 300;
    private final int LEFT_BREATH_COOLDOWN = 300;
    private static final EntityDataAccessor<Boolean> AERIAL = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> BELLY_FLOP_STATE = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TURN_SLAM_STATE = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TURN_STATE = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AIR_BOMBARD_STATE = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AIR_TAIL_CUT_STATE = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> AIR_TOPPLE_STATE = SynchedEntityData.m_135353_(LeivekilthEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public LivingEntity turnTarget;

    public LeivekilthEntity(EntityType<? extends AbstractLargeMonster<Ability, StaggerState>> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, Ability.class, StaggerState.class);
        this.head = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.tail = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.tail1 = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.tail2 = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.tail3 = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.tail4 = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.tail5 = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.tail6 = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.right_forearm = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.left_forearm = new LeivekilthPartEntity(this, 3.0f, 3.0f);
        this.left_arm_tip = new LeivekilthPartEntity(this, 2.0f, 2.0f);
        this.right_arm_tip = new LeivekilthPartEntity(this, 2.0f, 2.0f);
        this.parts = new LeivekilthPartEntity[]{this.head, this.tail, this.tail1, this.tail2, this.tail3, this.tail4, this.tail5, this.tail6, this.right_forearm, this.left_forearm, this.right_arm_tip, this.left_arm_tip};
        this.groundBehaviorTree = new LeivekilthGroundBehaviorTree();
        this.aerialBehaviorTree = new LeivekilthAerialBehaviorTree();
        this.waterBehaviorTree = new LeivekilthWaterBehaviorTree();
        this.groundMoveControl = this.f_21342_;
        this.groundLookControl = this.f_21365_;
        this.flyMoveControl = new BigMobFlyController((Mob)this);
        this.swimMoveControl = new SmoothSwimmingMoveControl((Mob)this, 85, 10, 0.4f, 0.8f, true);
        this.swimLookControl = new SmoothSwimmingLookControl((Mob)this, 10);
        this.registerBreakablePart("head_stagger", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("head_break", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("right_upper_ice", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("right_lower_ice", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("left_upper_ice", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("left_lower_ice", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("tail", this.m_21233_() * 0.4f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.SLASHING, 0.6f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.SLASHING, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerElementalHitzone("body", DamageTypes.ElementType.ICE, 0.2f);
        this.registerElementalHitzone("head_break", DamageTypes.ElementType.ICE, 0.1f);
        this.registerElementalHitzone("head_stagger", DamageTypes.ElementType.ICE, 0.1f);
        this.registerElementalHitzone("tail", DamageTypes.ElementType.ICE, 0.2f);
        this.registerElementalHitzone("right_lower_ice", DamageTypes.ElementType.ICE, 0.1f);
        this.registerElementalHitzone("right_upper_ice", DamageTypes.ElementType.ICE, 0.1f);
        this.registerElementalHitzone("left_lower_ice", DamageTypes.ElementType.ICE, 0.1f);
        this.registerElementalHitzone("left_upper_ice", DamageTypes.ElementType.ICE, 0.1f);
        this.registerRawHitzone("right_lower_ice", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("right_lower_ice", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("right_lower_ice", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("right_upper_ice", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("right_upper_ice", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("right_upper_ice", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("left_lower_ice", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("left_lower_ice", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("left_lower_ice", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("left_upper_ice", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("left_upper_ice", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("left_upper_ice", DamageTypes.WeaponType.PIERCING, 0.45f);
        if (!pLevel.m_5776_()) {
            this.m_21051_(Attributes.f_22276_).m_22100_(1000.0 * (Double)ModConfig.SERVER.LEIVEKILTH.MAX_HEALTH.get() * (Double)ModConfig.SERVER.GENERAL.MAX_HEALTH.get());
            this.m_21051_(Attributes.f_22281_).m_22100_(30.0 * (Double)ModConfig.SERVER.LEIVEKILTH.ATTACK_DAMAGE.get() * (Double)ModConfig.SERVER.GENERAL.MAX_HEALTH.get());
        }
        this.f_21344_.m_7008_(true);
        this.m_21441_(BlockPathTypes.WATER, 0.0f);
        this.damageUntilEnrage = this.m_21233_() * 0.4f;
    }

    public LeivekilthAnimationState getAnimationState() {
        return this.animationState;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 1000.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22281_, 30.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22280_, 1.0).m_22268_(Attributes.f_22278_, 0.95);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new LeivekilthStaggerGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LeivekilthToppleGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LeivekilthWingBreakGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new LeivekilthTailCutGoal(this));
        if (!this.m_21824_() || this.m_21824_() && this.getTamedBehavior() != AbstractLargeMonster.TamedBehavior.PASSIVE) {
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthRightSlamGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthHeadStabGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthTurnGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthBellySlamGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthTailswipeGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthBellyFlopGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthTurnSlamGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthTurnFlopGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthBreathSpinGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthBreathForwardGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthEnrageGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthAirTailswipeGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthAirBombardGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthAirBreathGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthSupercoolDetonationGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthRightBreathGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthLeftBreathGoal(this));
            this.f_21345_.m_25352_(1, (Goal)new LeivekilthRoarGoal(this));
        }
        this.f_21345_.m_25352_(0, (Goal)new LeivekilthFindLandGoal(this, 1.2));
        this.f_21345_.m_25352_(1, (Goal)new LeivekilthWanderSwimGoal(this, 1.0));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.isTailCut()) {
                this.tail6.m_146870_();
                this.tail5.m_146870_();
            }
            if (this.f_19797_ % 40 == 0 && this.isAerial()) {
                this.spawnBombardmentGlobs();
            }
            if (this.m_5448_() != null) {
                if (!this.isAerial()) {
                    this.groundBehaviorTree.tick(this);
                } else {
                    this.aerialBehaviorTree.tick(this);
                }
            }
            this.handleBreathingParticlesServerSide();
            this.handleWaterFloating();
            --this.pathUpdateCooldown;
        }
    }

    public InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return InteractionResult.PASS;
    }

    private void handleWaterFloating() {
        if (this.m_20069_() && !this.isAerial()) {
            this.m_20242_(true);
            if (this.m_21573_() instanceof FlyingPathNavigation) {
                this.disableFly();
            }
            this.f_21342_ = this.swimMoveControl;
            this.f_21365_ = this.swimLookControl;
        } else if (this.isAerial()) {
            this.m_20242_(true);
            if (!(this.m_21573_() instanceof FlyingPathNavigation)) {
                this.enableFly();
            }
            this.f_21342_ = this.flyMoveControl;
            this.f_21365_ = this.swimLookControl;
        } else {
            this.m_20242_(false);
            if (this.m_21573_() instanceof FlyingPathNavigation) {
                this.disableFly();
            }
            this.f_21342_ = this.groundMoveControl;
            this.f_21365_ = this.groundLookControl;
        }
    }

    public void fireSupercooledOrb(Vec3 moveVec) {
        if (!this.m_9236_().f_46443_) {
            SupercooledOrbEntity orb = new SupercooledOrbEntity(this.m_9236_(), (LivingEntity)this);
            orb.m_146884_(this.head.m_20182_());
            orb.m_20256_(moveVec);
            this.m_9236_().m_7967_((Entity)orb);
            this.m_9236_().m_7605_((Entity)orb, (byte)4);
        }
    }

    private void spawnPartBreakEffects(Vec3 pos) {
        if (!this.m_9236_().f_46443_) {
            int particleCount = 30;
            for (int i = 0; i < 30; ++i) {
                double motionX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double motionY = this.f_19796_.m_188500_() * 0.5;
                double motionZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.ICE_SHARD.get()), 1.0f, 1.0f, 1.0f, 0.3f, -1);
                Vec3 velocity = new Vec3(motionX, motionY, motionZ);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, pos.m_82549_(new Vec3(0.0, 0.5, 0.0)), velocity, true), (Entity)this);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, this.m_5720_(), 1.0f, 1.0f);
        }
    }

    public void spawnBombardmentGlobs() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        List<LeivekilthPartEntity> dropPoints = List.of(this, this.tail1, this.tail2, this.tail3, this.tail4);
        for (Entity entity : dropPoints) {
            Vec3 origin = entity.m_20182_().m_82549_(this.m_20154_().m_82541_().m_82490_(4.0).m_82549_(new Vec3(0.0, 1.0, 0.0)));
            VolatileGlobEntity glob = new VolatileGlobEntity(this.m_9236_(), (LivingEntity)this);
            glob.m_146884_(origin);
            double dirX = (this.f_19796_.m_188500_() - 0.5) * 3.0;
            double dirY = -1.0;
            double dirZ = (this.f_19796_.m_188500_() - 0.5) * 0.9;
            float velocity = 0.4f;
            float inaccuracy = 12.0f;
            glob.m_6686_(dirX, dirY, dirZ, velocity, inaccuracy);
            glob.m_20256_(glob.m_20184_().m_82542_(1.0, 0.7, 1.0));
            this.m_9236_().m_7967_((Entity)glob);
        }
    }

    public void spawnVolatileGlobs() {
        String mouthBoneName = "head_anchor";
        Vec3 origin = this.head.m_20182_().m_82549_(new Vec3(0.0, 1.2, 0.0));
        Quaternionf entityOrientation = new Quaternionf();
        entityOrientation.rotateY(-this.f_20885_ * ((float)Math.PI / 180));
        entityOrientation.rotateX(-this.m_146909_() * ((float)Math.PI / 180));
        Quaternionf animatedBoneRotation = this.animationPlayer.getAbsolutePartRotation(mouthBoneName);
        animatedBoneRotation.conjugate();
        Quaternionf finalRotation = new Quaternionf((Quaternionfc)entityOrientation).mul((Quaternionfc)animatedBoneRotation);
        Vector3f forwardVector = new Vector3f(0.0f, 0.0f, 1.0f);
        forwardVector.rotate((Quaternionfc)finalRotation);
        Vec3 direction = new Vec3((double)forwardVector.x(), (double)forwardVector.y(), (double)forwardVector.z());
        for (int i = 0; i < 1; ++i) {
            VolatileGlobEntity glob = new VolatileGlobEntity(this.m_9236_(), (LivingEntity)this);
            glob.m_146884_(origin);
            float velocity = 0.2f;
            float inaccuracy = 6.0f;
            glob.m_6686_(direction.f_82479_, direction.f_82480_, direction.f_82481_, velocity, inaccuracy);
            this.m_9236_().m_7967_((Entity)glob);
        }
    }

    @Override
    protected SoundEvent getMusic() {
        return (SoundEvent)ModSounds.LEIVEKILTH_THEME.get();
    }

    private void handleBreathingParticlesServerSide() {
        if (this.iceBreath) {
            ColorParticleOptions options;
            Vec3 velocity;
            int i;
            if (this.f_19797_ % 15 == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.LEIVEKILTH_ICE_BREATH_LOOP.get(), this.m_5720_(), 2.0f, 1.0f);
            }
            if (this.f_19797_ % 10 == 0) {
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)ModSounds.LEIVEKILTH_ICE_BREATH_LOOP2.get(), this.m_5720_(), 2.0f, 1.0f);
            }
            String mouthBoneName = "head_anchor";
            Vec3 origin = this.head.m_20182_().m_82549_(new Vec3(0.0, 1.2, 0.0));
            if (this.getCurrentAbility() == Ability.SUPERCOOL_DETONATION) {
                origin = origin.m_82549_(new Vec3(0.0, 1.0, 0.0)).m_82549_(this.m_20154_().m_82541_().m_82490_(1.5));
            }
            Quaternionf entityOrientation = new Quaternionf();
            entityOrientation.rotateY(-this.f_20885_ * ((float)Math.PI / 180));
            entityOrientation.rotateX(-this.m_146909_() * ((float)Math.PI / 180));
            Quaternionf animatedBoneRotation = this.animationPlayer.getAbsolutePartRotation(mouthBoneName);
            Quaternionf finalRotation = new Quaternionf((Quaternionfc)entityOrientation).mul((Quaternionfc)animatedBoneRotation);
            Vector3f forwardVector = new Vector3f(0.0f, 0.0f, 1.0f);
            forwardVector.rotate((Quaternionfc)finalRotation);
            Vec3 direction = new Vec3((double)forwardVector.x(), (double)forwardVector.y(), (double)forwardVector.z());
            RandomSource random = this.m_217043_();
            for (i = 0; i < 3; ++i) {
                velocity = direction.m_82490_(1.5).m_82520_((random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5, (random.m_188500_() - 0.5) * 0.5);
                options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.DRIVING_WIND.get()), 1.0f, 1.0f, 1.0f, 1.5f, this.m_19879_());
                ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, origin, velocity, true), (Entity)this);
            }
            for (i = 0; i < 4; ++i) {
                velocity = direction.m_82490_(2.0).m_82520_((random.m_188500_() - 0.5) * 0.7, (random.m_188500_() - 0.5) * 0.7, (random.m_188500_() - 0.5) * 0.7);
                options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.ICE_SHARD.get()), 1.0f, 1.0f, 1.0f, 0.3f, this.m_19879_());
                ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, origin, velocity, true), (Entity)this);
            }
            Vec3 cross = this.m_20154_().m_82537_(new Vec3(0.0, -1.0, 0.0)).m_82541_();
            if (this.f_19797_ % 2 == 0) {
                velocity = direction.m_82490_(0.4).m_82520_((random.m_188500_() - 0.5) * 0.7, (random.m_188500_() - 0.5) * 0.7, (random.m_188500_() - 0.5) * 0.7);
                options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.FROST_MOTE.get()), 1.0f, 1.0f, 1.0f, 0.25f, this.m_19879_());
                ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, origin, velocity, true), (Entity)this);
            }
        }
    }

    @Override
    public void handleParticleImpact(Vec3 impactPos) {
        if (this.m_9236_().m_5776_()) {
            return;
        }
        AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(1.0f).knockback(AbstractLargeMonster.KnockbackType.NONE, 1.0).addEffect(new MobEffectInstance((MobEffect)ModEffects.FROSTVEIN.get(), 400), 0.5f).withElement(DamageTypes.ElementType.ICE).build();
        this.dealDamageInOrientedBox(impactPos, new Vec3(0.0, 0.0, 0.0), 6.0, 6.0, 6.0, attackDefinition);
    }

    public void spawnIceEffects(Vec3 offset, float spawnRadius, int coreMistCount, int frostMoteCount) {
        if (!this.m_9236_().f_46443_) {
            int i;
            Vec3 rotatedOffset = offset.m_82524_(-this.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = this.m_20182_().m_82549_(rotatedOffset);
            for (i = 0; i < coreMistCount; ++i) {
                double angle = this.m_217043_().m_188500_() * 2.0 * Math.PI;
                double distance = this.m_217043_().m_188500_() * (double)spawnRadius;
                double offsetX = Math.cos(angle) * distance;
                double offsetZ = Math.sin(angle) * distance;
                Vec3 particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ);
                ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.CORE_MIST.get()), 1.0f, 1.0f, 1.0f, 0.8f, this.m_19879_());
                ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, particleSpawnPos, Vec3.f_82478_, true), (Entity)this);
            }
            for (i = 0; i < frostMoteCount; ++i) {
                double distance = this.m_217043_().m_188500_() * (double)spawnRadius * 1.5;
                double phi = this.m_217043_().m_188500_() * 2.0 * Math.PI;
                double cosTheta = 2.0 * this.m_217043_().m_188500_() - 1.0;
                double sinTheta = Math.sqrt(1.0 - cosTheta * cosTheta);
                double offsetX = distance * sinTheta * Math.cos(phi);
                double offsetY = distance * cosTheta;
                double offsetZ = distance * sinTheta * Math.sin(phi);
                Vec3 particleSpawnPos = centerPos.m_82520_(offsetX, offsetY, offsetZ);
                ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.FROST_MOTE.get()), 1.0f, 1.0f, 1.0f, 0.25f, this.m_19879_());
                ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, particleSpawnPos, Vec3.f_82478_, true), (Entity)this);
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TURN_STATE, (Object)TurnState.NONE.ordinal());
        this.f_19804_.m_135372_(TURN_SLAM_STATE, (Object)TurnSlamState.NONE.ordinal());
        this.f_19804_.m_135372_(BELLY_FLOP_STATE, (Object)BellyFlopState.NONE.ordinal());
        this.f_19804_.m_135372_(AIR_BOMBARD_STATE, (Object)AirBombardState.NONE.ordinal());
        this.f_19804_.m_135372_(AIR_TAIL_CUT_STATE, (Object)AirTailCutState.NONE.ordinal());
        this.f_19804_.m_135372_(AIR_TOPPLE_STATE, (Object)AirToppleState.NONE.ordinal());
        this.f_19804_.m_135372_(AERIAL, (Object)false);
        this.f_19804_.m_135372_(TAIL_CUT, (Object)false);
        this.f_19804_.m_135372_(RIGHT_UPPER_ICE_BROKEN, (Object)false);
        this.f_19804_.m_135372_(RIGHT_LOWER_ICE_BROKEN, (Object)false);
        this.f_19804_.m_135372_(LEFT_LOWER_ICE_BROKEN, (Object)false);
        this.f_19804_.m_135372_(LEFT_UPPER_ICE_BROKEN, (Object)false);
        this.f_19804_.m_135372_(HEAD_ICE_BROKEN, (Object)false);
    }

    @Override
    protected Map<String, String> getBoneHierarchy() {
        return LEIVEKILTH_HIERARCHY;
    }

    @Override
    protected Map<String, Vec3> getDefaultOffsets() {
        return LEIVEKILTH_DEFAULT_OFFSETS;
    }

    @Override
    protected Map<String, Vec3> getDefaultRotations() {
        return LEIVEKILTH_DEFAULT_ROTATIONS;
    }

    @Override
    protected String getBoneNameForPart(LargeMonsterPartEntity<?> part) {
        if (part == this.head) {
            return "head_anchor";
        }
        if (part == this.tail) {
            return "tail_anchor";
        }
        if (part == this.tail1) {
            return "tail1_anchor";
        }
        if (part == this.tail2) {
            return "tail2_anchor";
        }
        if (part == this.tail3) {
            return "tail3_anchor";
        }
        if (part == this.tail4) {
            return "tail4_anchor";
        }
        if (part == this.tail5) {
            return "tail5_anchor";
        }
        if (part == this.tail6) {
            return "tail6_anchor";
        }
        if (part == this.left_arm_tip) {
            return "left_armtip_membrane1";
        }
        if (part == this.right_arm_tip) {
            return "right_armtip_membrane1";
        }
        if (part == this.left_forearm) {
            return "left_arm_tip";
        }
        if (part == this.right_forearm) {
            return "right_arm_tip";
        }
        return "";
    }

    @Override
    public boolean m_6469_(DamageSource pSource, float pAmount) {
        float amount = pAmount;
        if (!this.isRightUpperIceBroken()) {
            amount *= 0.9f;
        }
        if (!this.isRightLowerIceBroken()) {
            amount *= 0.9f;
        }
        if (!this.isLeftUpperIceBroken()) {
            amount *= 0.9f;
        }
        if (!this.isLeftLowerIceBroken()) {
            amount *= 0.9f;
        }
        if (!this.isHeadIceBroken()) {
            amount *= 0.9f;
        }
        return super.m_6469_(pSource, amount);
    }

    @Override
    public LargeMonsterPartEntity<?>[] getBodyParts() {
        return this.parts;
    }

    @Override
    protected void onPartBroken(String partName, DamageSource source) {
        switch (partName) {
            case "head_stagger": {
                this.handleStagger(source);
                break;
            }
            case "head_break": {
                if (this.isHeadIceBroken()) break;
                this.setCurrentStaggerState(StaggerState.STAGGER);
                this.setHeadIceBroken(true);
                ItemStack item = new ItemStack((ItemLike)ModItems.HOARFROST_SHARD.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.head.m_20185_(), this.head.m_20186_(), this.head.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                this.spawnPartBreakEffects(this.head.m_20182_());
                break;
            }
            case "right_upper_ice": {
                if (this.isRightUpperIceBroken()) break;
                this.setCurrentStaggerState(StaggerState.WING_BREAK_RIGHT);
                this.setRightUpperIceBroken(true);
                ItemStack item = new ItemStack((ItemLike)ModItems.HOARFROST_SHARD.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.right_forearm.m_20185_(), this.right_forearm.m_20186_(), this.right_forearm.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                this.spawnPartBreakEffects(this.right_forearm.m_20182_());
                break;
            }
            case "right_lower_ice": {
                if (this.isRightLowerIceBroken()) break;
                this.setCurrentStaggerState(StaggerState.WING_BREAK_RIGHT);
                this.setRightLowerIceBroken(true);
                ItemStack item = new ItemStack((ItemLike)ModItems.HOARFROST_SHARD.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.right_arm_tip.m_20185_(), this.right_arm_tip.m_20186_(), this.right_arm_tip.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                this.spawnPartBreakEffects(this.right_arm_tip.m_20182_());
                break;
            }
            case "left_upper_ice": {
                if (this.isLeftUpperIceBroken()) break;
                this.setCurrentStaggerState(StaggerState.WING_BREAK_LEFT);
                this.setLeftUpperIceBroken(true);
                ItemStack item = new ItemStack((ItemLike)ModItems.HOARFROST_SHARD.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.left_forearm.m_20185_(), this.left_forearm.m_20186_(), this.left_forearm.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                this.spawnPartBreakEffects(this.left_forearm.m_20182_());
                break;
            }
            case "left_lower_ice": {
                if (this.isLeftLowerIceBroken()) break;
                this.setCurrentStaggerState(StaggerState.WING_BREAK_LEFT);
                this.setLeftLowerIceBroken(true);
                ItemStack item = new ItemStack((ItemLike)ModItems.HOARFROST_SHARD.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.left_arm_tip.m_20185_(), this.left_arm_tip.m_20186_(), this.left_arm_tip.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                this.spawnPartBreakEffects(this.left_arm_tip.m_20182_());
                break;
            }
            case "tail": {
                if (this.isTailCut()) break;
                this.setTailCut(true);
                this.setCurrentStaggerState(StaggerState.TAIL_CUT);
                Vec3 directionToPart = this.tail4.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                float tailYaw = this.m_146908_();
                LeivekilthPartEntity part = this.tail5;
                double flingSpeed = 0.1;
                double upwardSpeed = 0.8;
                LeivekilthTailEntity tailEntity = new LeivekilthTailEntity(this.m_9236_(), part.m_20185_(), part.m_20186_(), part.m_20189_(), tailYaw);
                tailEntity.m_20334_(directionToPart.f_82479_ * flingSpeed, upwardSpeed, directionToPart.f_82481_ * flingSpeed);
                this.m_9236_().m_7967_((Entity)tailEntity);
            }
        }
    }

    @Override
    @Nullable
    protected List<String> getLogicalPartNamesFor(LargeMonsterPartEntity<?> physicalPart) {
        if (physicalPart == this.head) {
            return List.of("head_stagger", "head_break");
        }
        if (this.isTailPart((LeivekilthPartEntity)physicalPart)) {
            return List.of("tail");
        }
        if (physicalPart == this.right_forearm) {
            return List.of("right_upper_ice");
        }
        if (physicalPart == this.right_arm_tip) {
            return List.of("right_lower_ice");
        }
        if (physicalPart == this.left_forearm) {
            return List.of("left_upper_ice");
        }
        if (physicalPart == this.left_arm_tip) {
            return List.of("left_lower_ice");
        }
        return null;
    }

    private void handleStagger(DamageSource source) {
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE) {
            this.setCurrentStaggerState(StaggerState.STAGGER);
        } else if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        } else if (this.getCurrentAbility() == Ability.SUPERCOOL_DETONATION) {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        } else if (this.staggerCount % 2 != 0 || this.staggerCount == 0) {
            this.setCurrentStaggerState(StaggerState.STAGGER);
        } else {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        }
        float newHealth = this.getStaggerPartBaseHealth() * (1.0f + 0.5f * (float)this.staggerCount);
        this.resetPartHealth(this.getStaggerPartName(), newHealth);
    }

    @Override
    protected void onFlashed(DamageSource source) {
    }

    @Override
    public String getStaggerPartName() {
        return "head_stagger";
    }

    @Override
    public float getStaggerPartBaseHealth() {
        return this.m_21233_() * 0.1f;
    }

    public double tryRightSlam() {
        if (this.isAttacking() || this.f_19797_ - this.lastRightSlam < 120 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 6.0), 6.0, 6.0, 6.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryHeadStab() {
        if (this.isAttacking() || this.f_19797_ - this.lastHeadStab < 200 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 8.0), 6.0, 6.0, 12.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryBellySlam() {
        if (this.isAttacking() || this.f_19797_ - this.lastBellySlam < 200 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 5.0), 20.0, 20.0, 10.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryBellyFlop() {
        if (this.isAttacking() || this.f_19797_ - this.lastBellyFlop < 600 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 20.0), 20.0, 20.0, 10.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryTailswipe() {
        if (this.isAttacking() || this.f_19797_ - this.lastTailswipe < 200 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, -10.0), 20.0, 20.0, 10.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryTurnFlop() {
        if (this.isAttacking() || this.f_19797_ - this.lastTurnFlop < 600 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, -10.0), 10.0, 20.0, 10.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryTurnSlam() {
        if (this.isAttacking() || this.f_19797_ - this.lastTurnSlam < 300 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 0.0;
        boolean zone1 = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(7.0, 0.0, 0.0), 10.0, 10.0, 10.0);
        boolean zone2 = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(-7.0, 0.0, 0.0), 10.0, 10.0, 10.0);
        if (zone1 || zone2) {
            score = 15.0;
        }
        return score;
    }

    public double tryTurn() {
        if (this.isAttacking() || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastTurn < 200) {
            return 0.0;
        }
        Vec3 vecToTarget = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.m_20154_());
        if (dotProduct > 0.25) {
            return 0.0;
        }
        double score = 1.0;
        return score;
    }

    public double tryGlance() {
        if (this.isAttacking() || this.isAerial() || this.findNthHighestThreat(2) == null || !this.findNthHighestThreat(2).m_6084_() || this.f_19797_ - this.lastGlance < 300 || this.lastUsedAbility == Ability.TURN) {
            return 0.0;
        }
        LivingEntity target = this.findNthHighestThreat(2);
        Vec3 vecToTarget = target.m_20182_().m_82546_(this.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.m_20154_());
        if (dotProduct > 0.25) {
            return 0.0;
        }
        double score = 1.0;
        return score;
    }

    public double tryBreathSpin() {
        if (this.isAttacking() || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastBreathSpin < 600) {
            return 0.0;
        }
        double score = 0.0;
        if (this.m_20280_((Entity)this.m_5448_()) < 25.0) {
            score = 30.0;
        }
        return score;
    }

    public double tryBreathForward() {
        if (this.isAttacking() || this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastBreathForward < 600) {
            return 0.0;
        }
        double score = 0.0;
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 15.0), 5.0, 6.0, 30.0);
        if (targetInZone) {
            score = 15.0;
        }
        return score;
    }

    public double tryAirTailswipe() {
        if (this.isAttacking() || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastAirTailswipe < 200) {
            return 0.0;
        }
        double score = 0.0;
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, -10.0, 6.0), 4.0, 20.0, 15.0);
        if (targetInZone) {
            score = 15.0;
        }
        return score;
    }

    public double tryAirBreath() {
        if (this.isAttacking() || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastAirBreath < 200) {
            return 0.0;
        }
        double score = 0.0;
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, -10.0, 17.0), 4.0, 20.0, 20.0);
        if (targetInZone) {
            score = 15.0;
        }
        return score;
    }

    public double tryAirBombard() {
        if (this.isAttacking() || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastAirBombard < 200 || this.lastUsedAbility == Ability.AIR_BOMBARD) {
            return 0.0;
        }
        double score = 1.0;
        return score;
    }

    public double trySupercoolDetonation() {
        if (this.isAttacking() || !this.isAerial() || this.m_5448_() == null || !this.m_5448_().m_6084_() || this.f_19797_ - this.lastSupercoolDetonation < 200) {
            return 0.0;
        }
        double score = 100.0;
        if (this.enrageTicks <= 1000) {
            return 0.0;
        }
        return score;
    }

    public double tryRightBreath() {
        if (this.isAttacking() || this.f_19797_ - this.lastRightBreath < 300 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 0.0;
        boolean zone1 = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(7.0, 0.0, 0.0), 10.0, 10.0, 10.0);
        if (zone1) {
            score = 15.0;
        }
        return score;
    }

    public double tryLeftBreath() {
        if (this.isAttacking() || this.f_19797_ - this.lastLeftBreath < 300 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 0.0;
        boolean zone2 = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(-7.0, 0.0, 0.0), 10.0, 10.0, 10.0);
        if (zone2) {
            score = 15.0;
        }
        return score;
    }

    public double tryRoar() {
        if (this.isAttacking() || this.f_19797_ - this.lastRoar < 2000 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 100.0;
        return score;
    }

    public BehaviorStatus startTurn() {
        this.setCurrentAbility(Ability.TURN);
        this.lastTurn = this.f_19797_;
        this.turnTarget = this.m_5448_();
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startGlance() {
        this.setCurrentAbility(Ability.TURN);
        this.lastGlance = this.f_19797_;
        this.turnTarget = this.findNthHighestThreat(2);
        this.applyTemporaryThreat(this.findNthHighestThreat(2).m_20148_(), 1000.0f, 100);
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startAirBombard() {
        this.setCurrentAbility(Ability.AIR_BOMBARD);
        this.lastAirBombard = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startRoar() {
        this.setCurrentAbility(Ability.ROAR);
        this.lastRoar = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startSupercoolDetonation() {
        this.setCurrentAbility(Ability.SUPERCOOL_DETONATION);
        this.lastSupercoolDetonation = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startAirBreath() {
        this.setCurrentAbility(Ability.AIR_BREATH);
        this.lastAirBreath = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startAirTailswipe() {
        this.setCurrentAbility(Ability.AIR_TAILSWIPE);
        this.lastAirTailswipe = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startBreathSpin() {
        this.setCurrentAbility(Ability.BREATH_SPIN);
        this.lastBreathSpin = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startRightBreath() {
        this.setCurrentAbility(Ability.RIGHT_BREATH);
        this.lastRightBreath = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startLeftBreath() {
        this.setCurrentAbility(Ability.LEFT_BREATH);
        this.lastLeftBreath = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startBreathForward() {
        this.setCurrentAbility(Ability.BREATH_FORWARD);
        this.lastBreathForward = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTurnSlam() {
        this.setCurrentAbility(Ability.TURN_SLAM);
        this.lastTurnSlam = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTurnFlop() {
        this.setCurrentAbility(Ability.TURN_FLOP);
        this.lastTurnFlop = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startHeadStab() {
        this.setCurrentAbility(Ability.HEAD_STAB);
        this.lastHeadStab = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startBellySlam() {
        this.setCurrentAbility(Ability.BELLY_SLAM);
        this.lastBellySlam = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startBellyFlop() {
        this.setCurrentAbility(Ability.BELLY_FLOP);
        this.lastBellyFlop = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startRightSlam() {
        this.setCurrentAbility(Ability.RIGHT_SLAM);
        this.lastRightSlam = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTailswipe() {
        this.setCurrentAbility(Ability.TAILSWIPE);
        this.lastTailswipe = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus updateGroundMovement(LivingEntity target) {
        if (this.m_21824_() && this.getTamedStance() == AbstractLargeMonster.TamedStance.FOLLOWING) {
            return BehaviorStatus.FAILURE;
        }
        if (this.isAttacking()) {
            return BehaviorStatus.FAILURE;
        }
        if (this.m_20069_()) {
            return BehaviorStatus.FAILURE;
        }
        if (target == null || !target.m_6084_()) {
            this.m_21573_().m_26573_();
            return BehaviorStatus.FAILURE;
        }
        if (this.m_20280_((Entity)target) <= 36.0) {
            this.m_21573_().m_26573_();
            return BehaviorStatus.SUCCESS;
        }
        if (this.pathUpdateCooldown <= 0) {
            this.pathUpdateCooldown = 5;
            Vec3 predictedPos = this.getPredictedTargetPosition(target, 10);
            BlockPos targetPos = BlockPos.m_274446_((Position)predictedPos);
            Path path = this.m_21573_().m_7864_(targetPos, 0);
            if (path != null && !path.m_77392_()) {
                this.m_21573_().m_26536_(path, 1.0);
            }
        }
        return this.m_21573_().m_26572_() ? BehaviorStatus.RUNNING : BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus updateGroundMovement() {
        return this.updateGroundMovement(this.m_5448_());
    }

    public BehaviorStatus updateAerialMovement(LivingEntity target) {
        double dynamicSpeed;
        double destinationZ;
        double destinationX;
        double dZ;
        if (this.m_21824_() && this.getTamedStance() == AbstractLargeMonster.TamedStance.FOLLOWING) {
            return BehaviorStatus.FAILURE;
        }
        double HOVER_ALTITUDE_ABOVE_TARGET = 14.0;
        double VERTICAL_TOLERANCE = 1.0;
        double MAX_ENGAGEMENT_DISTANCE_SQUARED = 36.0;
        boolean CHASE_DELAY_TICKS = false;
        int COAST_DURATION_TICKS = 15;
        double CHASE_SPEED = 0.5;
        double APPROACH_SPEED = 0.4;
        double HOVER_SPEED = 0.2;
        if (this.isAttacking() && this.getCurrentAbility() != Ability.AIR_TAILSWIPE) {
            this.timeTargetOutOfRange = 0;
            this.timeInRange = 0;
            return BehaviorStatus.FAILURE;
        }
        if (target == null || !target.m_6084_()) {
            return BehaviorStatus.FAILURE;
        }
        Vec3 dragonPos = this.m_20182_();
        Vec3 targetPos = target.m_20182_();
        double dX = dragonPos.m_7096_() - targetPos.m_7096_();
        double horizontalDistanceSq = dX * dX + (dZ = dragonPos.m_7094_() - targetPos.m_7094_()) * dZ;
        if (horizontalDistanceSq > 36.0) {
            this.timeInRange = 0;
            ++this.timeTargetOutOfRange;
            if (this.timeTargetOutOfRange > 0) {
                destinationX = targetPos.m_7096_();
                destinationZ = targetPos.m_7094_();
                dynamicSpeed = 0.5;
            } else {
                destinationX = dragonPos.m_7096_();
                destinationZ = dragonPos.m_7094_();
                dynamicSpeed = 0.2;
            }
        } else {
            this.timeTargetOutOfRange = 0;
            ++this.timeInRange;
            float progress = (float)this.timeInRange / 15.0f;
            progress = Mth.m_14036_((float)progress, (float)0.0f, (float)1.0f);
            dynamicSpeed = Mth.m_14139_((double)progress, (double)0.4, (double)0.2);
            if (this.timeInRange < 15) {
                destinationX = targetPos.m_7096_();
                destinationZ = targetPos.m_7094_();
            } else {
                destinationX = dragonPos.m_7096_();
                destinationZ = dragonPos.m_7094_();
            }
        }
        double idealAltitude = targetPos.m_7098_() + 14.0;
        double destinationY = Math.abs(dragonPos.m_7098_() - idealAltitude) > 1.0 ? idealAltitude : dragonPos.m_7098_();
        Vec3 finalDestination = new Vec3(destinationX, destinationY, destinationZ);
        this.m_21566_().m_6849_(finalDestination.f_82479_, finalDestination.f_82480_, finalDestination.f_82481_, dynamicSpeed);
        return BehaviorStatus.RUNNING;
    }

    public BehaviorStatus updateAerialMovement() {
        return this.updateAerialMovement(this.m_5448_());
    }

    public BlockPos findNearestLand() {
        return BlockPos.m_121930_((BlockPos)this.m_20183_(), (int)16, (int)8, pos -> this.isSafeLandBlock((BlockPos)pos)).orElse(null);
    }

    private boolean isSafeLandBlock(BlockPos pos) {
        BlockState stateBelow = this.m_9236_().m_8055_(pos.m_7495_());
        BlockState stateAt = this.m_9236_().m_8055_(pos);
        BlockState stateAbove = this.m_9236_().m_8055_(pos.m_7494_());
        boolean isSolidGround = stateBelow.m_60838_((BlockGetter)this.m_9236_(), pos.m_7495_());
        if (!isSolidGround) {
            return false;
        }
        if (stateAt.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return false;
        }
        boolean isClearSpace = !stateAt.m_280555_() && !stateAbove.m_280555_();
        return isClearSpace;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_21515_() && this.m_20069_() && !this.isAerial()) {
            this.m_19920_(this.m_6113_(), pTravelVector);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            this.m_20256_(this.m_20184_().m_82490_(0.95));
            if (this.m_5448_() == null) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.005, 0.0));
            }
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @Override
    public boolean isAttackAbility() {
        return this.getCurrentAbility() != Ability.NONE || this.getCurrentAbility() != Ability.TURN || this.getCurrentAbility() != Ability.ROAR;
    }

    @Override
    protected void setupAnimationStates() {
        this.idleAnimation();
        this.membraneScaleAnimation();
        this.rightSlamAnimation();
        this.headStabAnimation();
        this.turnAnimation();
        this.bellySlamAnimation();
        this.tailswipeAnimation();
        this.bellyFlopAnimation();
        this.turnSlamAnimation();
        this.breathSpinAnimation();
        this.breathForwardAnimation();
        this.breathAnimation();
        this.enrageAnimation();
        this.aerialAnimation();
        this.airTailswipeAnimation();
        this.airBombardAnimation();
        this.airBreathAnimation();
        this.supercoolDetonationAnimation();
        this.staggerAnimation();
        this.deathAnimation();
        this.roarAnimation();
    }

    private void idleAnimation() {
        if (this.m_20069_()) {
            if (!this.swimIdle.m_216984_()) {
                this.swimIdle.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("swim_idle", 1.0f);
            }
        } else {
            this.swimIdle.m_216973_();
            this.animationPlayer.stopAnimation("swim_idle");
        }
    }

    private void membraneScaleAnimation() {
        if (this.getCurrentAbility() != Ability.BELLY_FLOP && this.getCurrentAbility() != Ability.TURN_FLOP && this.getCurrentAbility() != Ability.ENRAGE && !this.isAerial()) {
            if (!this.landMembraneScale.m_216984_()) {
                this.landMembraneScale.m_216977_(this.f_19797_);
            }
        } else {
            this.landMembraneScale.m_216973_();
        }
    }

    private void rightSlamAnimation() {
        if (this.getCurrentAbility() == Ability.RIGHT_SLAM) {
            if (!this.rightSlamAnimation.m_216984_()) {
                this.rightSlamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("right_slam", 1.0f);
            }
        } else {
            this.rightSlamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("right_slam");
        }
    }

    private void headStabAnimation() {
        if (this.getCurrentAbility() == Ability.HEAD_STAB) {
            if (!this.headStabAnimation.m_216984_()) {
                this.headStabAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("head_stab", 1.0f);
            }
        } else {
            this.headStabAnimation.m_216973_();
            this.animationPlayer.stopAnimation("head_stab");
        }
    }

    private void breathAnimation() {
        if (this.getCurrentAbility() == Ability.RIGHT_BREATH) {
            if (!this.rightBreathAnimation.m_216984_()) {
                this.rightBreathAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("right_breath", 1.0f);
            }
        } else {
            this.rightBreathAnimation.m_216973_();
            this.animationPlayer.stopAnimation("right_breath");
        }
        if (this.getCurrentAbility() == Ability.LEFT_BREATH) {
            if (!this.leftBreathAnimation.m_216984_()) {
                this.leftBreathAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("left_breath", 1.0f);
            }
        } else {
            this.leftBreathAnimation.m_216973_();
            this.animationPlayer.stopAnimation("left_breath");
        }
    }

    private void turnAnimation() {
        if (this.getCurrentAbility() == Ability.TURN && this.getTurnState() == TurnState.LEFT.ordinal()) {
            if (!this.turnLeftAnimation.m_216984_()) {
                this.turnLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_left", 1.0f);
            }
        } else {
            this.turnLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_left");
        }
        if (this.getCurrentAbility() == Ability.TURN && this.getTurnState() == TurnState.RIGHT.ordinal()) {
            if (!this.turnRightAnimation.m_216984_()) {
                this.turnRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_right", 1.0f);
            }
        } else {
            this.turnRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_right");
        }
    }

    private void bellySlamAnimation() {
        if (this.getCurrentAbility() == Ability.BELLY_SLAM) {
            if (!this.bellySlamAnimation.m_216984_()) {
                this.bellySlamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("belly_slam", 1.0f);
            }
        } else {
            this.bellySlamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("belly_slam");
        }
    }

    private void tailswipeAnimation() {
        if (this.getCurrentAbility() == Ability.TAILSWIPE) {
            if (!this.tailswipeAnimation.m_216984_()) {
                this.tailswipeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tailswipe", 1.0f);
            }
        } else {
            this.tailswipeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tailswipe");
        }
    }

    private void bellyFlopAnimation() {
        if (this.getCurrentAbility() == Ability.BELLY_FLOP && this.getBellyFlopState() == BellyFlopState.NONE.ordinal()) {
            if (!this.bellyFlopAnimation.m_216984_()) {
                this.bellyFlopAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("belly_flop", 1.0f);
            }
        } else {
            this.bellyFlopAnimation.m_216973_();
            this.animationPlayer.stopAnimation("belly_flop");
        }
        if (this.getCurrentAbility() == Ability.TURN_FLOP && this.getBellyFlopState() == BellyFlopState.NONE.ordinal()) {
            if (!this.turnFlopAnimation.m_216984_()) {
                this.turnFlopAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_flop", 1.0f);
            }
        } else {
            this.turnFlopAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_flop");
        }
        if (this.getBellyFlopState() == BellyFlopState.REFLOP.ordinal()) {
            if (!this.bellyFlopReFlopAnimation.m_216984_()) {
                this.bellyFlopReFlopAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("belly_flop_reflop", 1.0f);
            }
        } else {
            this.bellyFlopReFlopAnimation.m_216973_();
            this.animationPlayer.stopAnimation("belly_flop_reflop");
        }
        if (this.getBellyFlopState() == BellyFlopState.END.ordinal()) {
            if (!this.bellyFlopEndAnimation.m_216984_()) {
                this.bellyFlopEndAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("belly_flop_end", 1.0f);
            }
        } else {
            this.bellyFlopEndAnimation.m_216973_();
            this.animationPlayer.stopAnimation("belly_flop_end");
        }
    }

    private void turnSlamAnimation() {
        if (this.getCurrentAbility() == Ability.TURN_SLAM && this.getTurnSlamState() == TurnState.LEFT.ordinal()) {
            if (!this.turnSlamLeftAnimation.m_216984_()) {
                this.turnSlamLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_slam_left", 1.0f);
            }
        } else {
            this.turnSlamLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_slam_left");
        }
        if (this.getCurrentAbility() == Ability.TURN_SLAM && this.getTurnSlamState() == TurnState.RIGHT.ordinal()) {
            if (!this.turnSlamRightAnimation.m_216984_()) {
                this.turnSlamRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_slam_right", 1.0f);
            }
        } else {
            this.turnSlamRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_slam_right");
        }
    }

    private void breathSpinAnimation() {
        if (this.getCurrentAbility() == Ability.BREATH_SPIN) {
            if (!this.breathSpinAnimation.m_216984_()) {
                this.breathSpinAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("breath_spin", 1.0f);
            }
        } else {
            this.breathSpinAnimation.m_216973_();
            this.animationPlayer.stopAnimation("breath_spin");
        }
    }

    private void breathForwardAnimation() {
        if (this.getCurrentAbility() == Ability.BREATH_FORWARD) {
            if (!this.breathForwardAnimation.m_216984_()) {
                this.breathForwardAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("breath_forward", 1.0f);
            }
        } else {
            this.breathForwardAnimation.m_216973_();
            this.animationPlayer.stopAnimation("breath_forward");
        }
    }

    private void enrageAnimation() {
        if (this.getCurrentAbility() == Ability.ENRAGE) {
            if (!this.enrageAnimation.m_216984_()) {
                this.enrageAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enrage", 1.0f);
            }
        } else {
            this.enrageAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enrage");
        }
    }

    private void aerialAnimation() {
        if (this.isAerial() && (!this.isAttacking() || this.getCurrentAbility() == Ability.AIR_BREATH) || this.getCurrentAbility() == Ability.AIR_BOMBARD && this.getAirBombardState() == AirBombardState.NONE.ordinal()) {
            if (!this.aerialAnimation.m_216984_()) {
                this.aerialAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("aerial", 0.5f);
            }
        } else {
            this.aerialAnimation.m_216973_();
            this.animationPlayer.stopAnimation("aerial");
        }
    }

    private void airTailswipeAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_TAILSWIPE) {
            if (!this.airTailswipeAnimation.m_216984_()) {
                this.airTailswipeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tailswipe", 0.5f);
            }
        } else {
            this.airTailswipeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tailswipe");
        }
    }

    private void airBombardAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_BOMBARD && this.getAirBombardState() == AirBombardState.TURN_LEFT.ordinal()) {
            if (!this.airBombardTurnLeftAnimation.m_216984_()) {
                this.airBombardTurnLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_bombard_turn_left", 0.5f);
            }
        } else {
            this.airBombardTurnLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_bombard_turn_left");
        }
        if (this.getCurrentAbility() == Ability.AIR_BOMBARD && this.getAirBombardState() == AirBombardState.TURN_RIGHT.ordinal()) {
            if (!this.airBombardTurnRightAnimation.m_216984_()) {
                this.airBombardTurnRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_bombard_turn_right", 0.5f);
            }
        } else {
            this.airBombardTurnRightAnimation.m_216973_();
        }
        if (this.getCurrentAbility() == Ability.AIR_BOMBARD && this.getAirBombardState() == AirBombardState.START.ordinal()) {
            if (!this.airBombardStartAnimation.m_216984_()) {
                this.airBombardStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_bombard_start_glide", 0.5f);
            }
        } else {
            this.airBombardStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_bombard_start_glide");
        }
        if (this.getCurrentAbility() == Ability.AIR_BOMBARD && this.getAirBombardState() == AirBombardState.GLIDE.ordinal()) {
            if (!this.airBombardGlideAnimation.m_216984_()) {
                this.airBombardGlideAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_bombard_glide", 0.5f);
            }
        } else {
            this.airBombardGlideAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_bombard_glide");
        }
        if (this.getCurrentAbility() == Ability.AIR_BOMBARD && this.getAirBombardState() == AirBombardState.STOP.ordinal()) {
            if (!this.airBombardStopAnimation.m_216984_()) {
                this.airBombardStopAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_bombard_stop", 0.5f);
            }
        } else {
            this.airBombardStopAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_bombard_stop");
        }
    }

    private void airBreathAnimation() {
        if (this.getCurrentAbility() == Ability.AIR_BREATH) {
            if (!this.airBreathAnimation.m_216984_()) {
                this.airBreathAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_breath", 1.0f);
            }
        } else {
            this.airBreathAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_breath");
        }
    }

    private void supercoolDetonationAnimation() {
        if (this.getCurrentAbility() == Ability.SUPERCOOL_DETONATION) {
            if (!this.supercoolDetonationAnimation.m_216984_()) {
                this.supercoolDetonationAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("supercool_detonation", 1.0f);
            }
        } else {
            this.supercoolDetonationAnimation.m_216973_();
            this.animationPlayer.stopAnimation("supercool_detonation");
        }
    }

    private void staggerAnimation() {
        if (this.getCurrentStaggerState() == StaggerState.STAGGER && !this.isAerial()) {
            if (!this.groundStaggerAnimation.m_216984_()) {
                this.groundStaggerAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_stagger", 1.0f);
            }
        } else {
            this.groundStaggerAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_stagger");
        }
        if (this.getCurrentStaggerState() == StaggerState.STAGGER && this.isAerial()) {
            if (!this.airStaggerAnimation.m_216984_()) {
                this.airStaggerAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_stagger", 1.0f);
            }
        } else {
            this.airStaggerAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_stagger");
        }
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE && !this.isAerial()) {
            if (!this.groundToppleAnimation.m_216984_()) {
                this.groundToppleAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_topple", 0.8f);
            }
        } else {
            this.groundToppleAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_topple");
        }
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE && this.isAerial() && this.getAirToppleState() == AirToppleState.START.ordinal()) {
            if (!this.airToppleStartAnimation.m_216984_()) {
                this.airToppleStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_topple_start", 1.0f);
            }
        } else {
            this.airToppleStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_topple_start");
        }
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE && this.isAerial() && this.getAirToppleState() == AirToppleState.FALL.ordinal()) {
            if (!this.airToppleFallAnimation.m_216984_()) {
                this.airToppleFallAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_topple_fall", 1.0f);
            }
        } else {
            this.airToppleFallAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_topple_fall");
        }
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE && this.isAerial() && this.getAirToppleState() == AirToppleState.CRASH.ordinal()) {
            if (!this.airToppleCrashAnimation.m_216984_()) {
                this.airToppleCrashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_topple_crash", 0.8f);
            }
        } else {
            this.airToppleCrashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_topple_crash");
        }
        if (this.getCurrentStaggerState() == StaggerState.WING_BREAK_RIGHT && !this.isAerial()) {
            if (!this.groundWingBreakRightAnimation.m_216984_()) {
                this.groundWingBreakRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_wing_break_right", 0.8f);
            }
        } else {
            this.groundWingBreakRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_wing_break_right");
        }
        if (this.getCurrentStaggerState() == StaggerState.WING_BREAK_RIGHT && this.isAerial()) {
            if (!this.airWingBreakRightAnimation.m_216984_()) {
                this.airWingBreakRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_wing_break_right", 1.0f);
            }
        } else {
            this.airWingBreakRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_wing_break_right");
        }
        if (this.getCurrentStaggerState() == StaggerState.WING_BREAK_LEFT && !this.isAerial()) {
            if (!this.groundWingBreakLeftAnimation.m_216984_()) {
                this.groundWingBreakLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_wing_break_left", 0.8f);
            }
        } else {
            this.groundWingBreakLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_wing_break_left");
        }
        if (this.getCurrentStaggerState() == StaggerState.WING_BREAK_LEFT && this.isAerial()) {
            if (!this.airWingBreakLeftAnimation.m_216984_()) {
                this.airWingBreakLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_wing_break_left", 1.0f);
            }
        } else {
            this.airWingBreakLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_wing_break_left");
        }
        if (this.getCurrentStaggerState() == StaggerState.TAIL_CUT && !this.isAerial()) {
            if (!this.groundTailCutAnimation.m_216984_()) {
                this.groundTailCutAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("ground_tail_cut", 1.0f);
            }
        } else {
            this.groundTailCutAnimation.m_216973_();
            this.animationPlayer.stopAnimation("ground_tail_cut");
        }
        if (this.getCurrentStaggerState() == StaggerState.TAIL_CUT && this.isAerial() && this.getAirTailCutState() == AirTailCutState.START.ordinal()) {
            if (!this.airTailCutStartAnimation.m_216984_()) {
                this.airTailCutStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tail_cut_start", 1.0f);
            }
        } else {
            this.airTailCutStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tail_cut_start");
        }
        if (this.getCurrentStaggerState() == StaggerState.TAIL_CUT && this.isAerial() && this.getAirTailCutState() == AirTailCutState.FALL.ordinal()) {
            if (!this.airTailCutFallAnimation.m_216984_()) {
                this.airTailCutFallAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tail_cut_fall", 1.0f);
            }
        } else {
            this.airTailCutFallAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tail_cut_fall");
        }
        if (this.getCurrentStaggerState() == StaggerState.TAIL_CUT && this.isAerial() && this.getAirTailCutState() == AirTailCutState.CRASH.ordinal()) {
            if (!this.airTailCutCrashAnimation.m_216984_()) {
                this.airTailCutCrashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("air_tail_cut_crash", 1.0f);
            }
        } else {
            this.airTailCutCrashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("air_tail_cut_crash");
        }
    }

    private void deathAnimation() {
        if (this.getCurrentAbility() == Ability.DEATH) {
            if (!this.deathAnimation.m_216984_()) {
                this.deathAnimation.m_216977_(this.f_19797_);
            }
        } else {
            this.deathAnimation.m_216973_();
        }
    }

    private void roarAnimation() {
        if (this.getCurrentAbility() == Ability.ROAR) {
            if (!this.roarAnimation.m_216984_()) {
                this.roarAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("roar", 1.0f);
            }
        } else {
            this.roarAnimation.m_216973_();
            this.animationPlayer.stopAnimation("roar");
        }
    }

    @Override
    public Ability getNoneAbility() {
        return Ability.NONE;
    }

    @Override
    public StaggerState getNoneStagger() {
        return StaggerState.NONE;
    }

    @Override
    public void setStaggerForFlash() {
    }

    @Override
    public void setToppleForFlashIfAerial() {
    }

    @Override
    public boolean isFlashable() {
        return false;
    }

    @Override
    protected void registerServerAnimations() {
        this.animationPlayer.registerAnimation("right_slam", LeivekilthServerAnimations.right_slam);
        this.animationPlayer.registerAnimation("head_stab", LeivekilthServerAnimations.head_stab);
        this.animationPlayer.registerAnimation("turn_left", LeivekilthServerAnimations.turn_left);
        this.animationPlayer.registerAnimation("turn_right", LeivekilthServerAnimations.turn_right);
        this.animationPlayer.registerAnimation("belly_slam", LeivekilthServerAnimations.belly_slam);
        this.animationPlayer.registerAnimation("tailswipe", LeivekilthServerAnimations.tailswipe);
        this.animationPlayer.registerAnimation("belly_flop", LeivekilthServerAnimations.belly_flop);
        this.animationPlayer.registerAnimation("turn_slam_left", LeivekilthServerAnimations.turn_slam_left);
        this.animationPlayer.registerAnimation("turn_slam_right", LeivekilthServerAnimations.turn_slam_right);
        this.animationPlayer.registerAnimation("belly_flop_reflop", LeivekilthServerAnimations.belly_flop_reflop);
        this.animationPlayer.registerAnimation("belly_flop_end", LeivekilthServerAnimations.belly_flop_end);
        this.animationPlayer.registerAnimation("turn_flop", LeivekilthServerAnimations.turn_flop);
        this.animationPlayer.registerAnimation("breath_spin", LeivekilthServerAnimations.breath_spin);
        this.animationPlayer.registerAnimation("breath_forward", LeivekilthServerAnimations.breath_forward);
        this.animationPlayer.registerAnimation("enrage", LeivekilthServerAnimations.enrage);
        this.animationPlayer.registerAnimation("aerial", LeivekilthServerAnimations.aerial);
        this.animationPlayer.registerAnimation("air_tailswipe", LeivekilthServerAnimations.air_tailswipe);
        this.animationPlayer.registerAnimation("air_bombard_turn_right", LeivekilthServerAnimations.air_bombard_turn_right);
        this.animationPlayer.registerAnimation("air_bombard_turn_left", LeivekilthServerAnimations.air_bombard_turn_left);
        this.animationPlayer.registerAnimation("air_bombard_start_glide", LeivekilthServerAnimations.air_bombard_start_glide);
        this.animationPlayer.registerAnimation("air_bombard_glide", LeivekilthServerAnimations.air_bombard_glide);
        this.animationPlayer.registerAnimation("air_bombard_stop", LeivekilthServerAnimations.air_bombard_stop);
        this.animationPlayer.registerAnimation("air_breath", LeivekilthServerAnimations.air_breath);
        this.animationPlayer.registerAnimation("supercool_detonation", LeivekilthServerAnimations.supercool_detonation);
        this.animationPlayer.registerAnimation("ground_stagger", LeivekilthServerAnimations.ground_stagger);
        this.animationPlayer.registerAnimation("ground_topple", LeivekilthServerAnimations.ground_topple);
        this.animationPlayer.registerAnimation("ground_tail_cut", LeivekilthServerAnimations.ground_tail_cut);
        this.animationPlayer.registerAnimation("ground_wing_break_right", LeivekilthServerAnimations.ground_wing_break_right);
        this.animationPlayer.registerAnimation("ground_wing_break_left", LeivekilthServerAnimations.ground_wing_break_left);
        this.animationPlayer.registerAnimation("air_stagger", LeivekilthServerAnimations.air_stagger);
        this.animationPlayer.registerAnimation("air_wing_break_right", LeivekilthServerAnimations.air_wing_break_right);
        this.animationPlayer.registerAnimation("air_wing_break_left", LeivekilthServerAnimations.air_wing_break_left);
        this.animationPlayer.registerAnimation("air_tail_cut_start", LeivekilthServerAnimations.air_tail_cut_start);
        this.animationPlayer.registerAnimation("air_tail_cut_fall", LeivekilthServerAnimations.air_tail_cut_fall);
        this.animationPlayer.registerAnimation("air_tail_cut_crash", LeivekilthServerAnimations.air_tail_cut_crash);
        this.animationPlayer.registerAnimation("air_topple_start", LeivekilthServerAnimations.air_topple_start);
        this.animationPlayer.registerAnimation("air_topple_fall", LeivekilthServerAnimations.air_topple_fall);
        this.animationPlayer.registerAnimation("air_topple_crash", LeivekilthServerAnimations.air_topple_crash);
        this.animationPlayer.registerAnimation("swim_idle", LeivekilthServerAnimations.swim_idle);
        this.animationPlayer.registerAnimation("right_breath", LeivekilthServerAnimations.right_breath);
        this.animationPlayer.registerAnimation("left_breath", LeivekilthServerAnimations.left_breath);
        this.animationPlayer.registerAnimation("roar", LeivekilthServerAnimations.roar);
    }

    @Override
    public boolean isAerial() {
        return (Boolean)this.f_19804_.m_135370_(AERIAL);
    }

    @Override
    public boolean isFlying() {
        return false;
    }

    @Override
    public boolean isHovering() {
        return false;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && !this.isAerial() && (!this.isAttacking() || this.getCurrentAbility() == Ability.HEAD_STAB) ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    public int getTurnState() {
        return (Integer)this.f_19804_.m_135370_(TURN_STATE);
    }

    public void setTurnState(int state) {
        this.f_19804_.m_135381_(TURN_STATE, (Object)state);
    }

    public int getBellyFlopState() {
        return (Integer)this.f_19804_.m_135370_(BELLY_FLOP_STATE);
    }

    public void setBellyFlopState(int state) {
        this.f_19804_.m_135381_(BELLY_FLOP_STATE, (Object)state);
    }

    public int getTurnSlamState() {
        return (Integer)this.f_19804_.m_135370_(TURN_SLAM_STATE);
    }

    public void setTurnSlamState(int state) {
        this.f_19804_.m_135381_(TURN_SLAM_STATE, (Object)state);
    }

    public int getAirBombardState() {
        return (Integer)this.f_19804_.m_135370_(AIR_BOMBARD_STATE);
    }

    public void setAirBombardState(int state) {
        this.f_19804_.m_135381_(AIR_BOMBARD_STATE, (Object)state);
    }

    public int getAirTailCutState() {
        return (Integer)this.f_19804_.m_135370_(AIR_TAIL_CUT_STATE);
    }

    public void setAirTailCutState(int state) {
        this.f_19804_.m_135381_(AIR_TAIL_CUT_STATE, (Object)state);
    }

    public int getAirToppleState() {
        return (Integer)this.f_19804_.m_135370_(AIR_TOPPLE_STATE);
    }

    public void setAirToppleState(int state) {
        this.f_19804_.m_135381_(AIR_TOPPLE_STATE, (Object)state);
    }

    public boolean isTailPart(LeivekilthPartEntity part) {
        return part == this.tail1 || part == this.tail2 || part == this.tail3 || part == this.tail4 || part == this.tail5 || part == this.tail6;
    }

    public void activateTailParts() {
        for (LeivekilthPartEntity part : this.parts) {
            if (!this.isTailPart(part)) continue;
            this.addActiveDamagePart(part);
        }
    }

    public boolean isIceBreath() {
        return this.iceBreath;
    }

    public void toggleIceBreath(boolean iceBreath) {
        this.iceBreath = iceBreath;
    }

    @Override
    public void enableFly() {
        this.f_19804_.m_135381_(AERIAL, (Object)true);
        this.f_21344_ = new FlyingPathNavigation((Mob)this, this.m_9236_());
        this.m_20242_(true);
    }

    @Override
    public void disableFly() {
        this.f_19804_.m_135381_(AERIAL, (Object)false);
        this.f_21344_ = new BigMobPathNavigate((Mob)this, this.m_9236_());
        ((BigMobPathNavigate)this.f_21344_).m_7008_(true);
        this.m_20242_(false);
    }

    protected void changeNavigation(Level pLevel, boolean flying) {
        this.f_21344_ = flying ? new FlyingPathNavigation((Mob)this, this.m_9236_()) : new BigMobPathNavigate((Mob)this, this.m_9236_());
    }

    protected void changeMoveControl(int moveControl) {
        if (moveControl == 0) {
            this.f_21342_ = new BigMobFlyController((Mob)this);
        }
        if (moveControl == 1) {
            this.f_21342_ = new BigMobMoveControl((Mob)this);
        }
    }

    public boolean isTailCut() {
        return (Boolean)this.f_19804_.m_135370_(TAIL_CUT);
    }

    public void setTailCut(boolean cut) {
        this.f_19804_.m_135381_(TAIL_CUT, (Object)cut);
        this.tail6.m_146870_();
        this.tail5.m_146870_();
    }

    public boolean isRightUpperIceBroken() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_UPPER_ICE_BROKEN);
    }

    public void setRightUpperIceBroken(boolean broken) {
        if (!broken) {
            this.resetPartHealth("right_upper_ice");
        }
        this.f_19804_.m_135381_(RIGHT_UPPER_ICE_BROKEN, (Object)broken);
    }

    public boolean isRightLowerIceBroken() {
        return (Boolean)this.f_19804_.m_135370_(RIGHT_LOWER_ICE_BROKEN);
    }

    public void setRightLowerIceBroken(boolean broken) {
        if (!broken) {
            this.resetPartHealth("right_lower_ice");
        }
        this.f_19804_.m_135381_(RIGHT_LOWER_ICE_BROKEN, (Object)broken);
    }

    public boolean isLeftUpperIceBroken() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_UPPER_ICE_BROKEN);
    }

    public void setLeftUpperIceBroken(boolean broken) {
        if (!broken) {
            this.resetPartHealth("left_upper_ice");
        }
        this.f_19804_.m_135381_(LEFT_UPPER_ICE_BROKEN, (Object)broken);
    }

    public boolean isLeftLowerIceBroken() {
        return (Boolean)this.f_19804_.m_135370_(LEFT_LOWER_ICE_BROKEN);
    }

    public void setLeftLowerIceBroken(boolean broken) {
        if (!broken) {
            this.resetPartHealth("left_lower_ice");
        }
        this.f_19804_.m_135381_(LEFT_LOWER_ICE_BROKEN, (Object)broken);
    }

    public boolean isHeadIceBroken() {
        return (Boolean)this.f_19804_.m_135370_(HEAD_ICE_BROKEN);
    }

    public void setHeadIceBroken(boolean broken) {
        if (!broken) {
            this.resetPartHealth("head_break");
        }
        this.f_19804_.m_135381_(HEAD_ICE_BROKEN, (Object)broken);
    }

    public boolean isRightWingPart(LeivekilthPartEntity part) {
        return part == this.right_arm_tip || part == this.right_forearm;
    }

    public boolean isLeftWingPart(LeivekilthPartEntity part) {
        return part == this.left_arm_tip || part == this.left_forearm;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        this.setCurrentAbility(Ability.DEATH);
        if (this.f_20919_ >= 100 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_6040_() {
        return true;
    }

    public LeivekilthPartEntity getHeadPart() {
        return this.head;
    }

    public static enum Ability implements IMonsterAbilities<Ability>
    {
        NONE,
        RIGHT_SLAM,
        HEAD_STAB,
        TURN,
        BELLY_SLAM,
        TAILSWIPE,
        BELLY_FLOP,
        TURN_SLAM,
        TURN_FLOP,
        BREATH_SPIN,
        BREATH_FORWARD,
        ENRAGE,
        AIR_TAILSWIPE,
        AIR_BOMBARD,
        AIR_BREATH,
        SUPERCOOL_DETONATION,
        STAGGER,
        DEATH,
        RIGHT_BREATH,
        LEFT_BREATH,
        ROAR;


        @Override
        public int getOrdinal() {
            return this.ordinal();
        }

        @Override
        public Ability getNone() {
            return NONE;
        }
    }

    public static enum StaggerState implements IMonsterStaggers<StaggerState>
    {
        NONE,
        STAGGER,
        TOPPLE,
        WING_BREAK_LEFT,
        WING_BREAK_RIGHT,
        TAIL_CUT;

    }

    public static enum TurnState {
        NONE,
        LEFT,
        RIGHT;

    }

    public static enum TurnSlamState {
        NONE,
        LEFT,
        RIGHT;

    }

    public static enum BellyFlopState {
        NONE,
        REFLOP,
        END;

    }

    public static enum AirBombardState {
        NONE,
        TURN_LEFT,
        TURN_RIGHT,
        START,
        GLIDE,
        STOP;

    }

    public static enum AirTailCutState {
        NONE,
        START,
        FALL,
        CRASH;

    }

    public static enum AirToppleState {
        NONE,
        START,
        FALL,
        CRASH;

    }
}

