/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.config.ModConfig;
import net.saksolm.monsterexpansion.entity.ai.behavior.BehaviorStatus;
import net.saksolm.monsterexpansion.entity.ai.behavior.custom.RakothGroundBehaviorTree;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothChargeGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothEnrageGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothHeadSwipeGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothLeftClawBreakGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothRightClawBreakGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothRoarGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothRollGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothSlamGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothSlideGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothSmashGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothSpinGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothStaggerGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothTailCutGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothTailSlamGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothTailSweepGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothTailswipeGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothTemperGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothToppleGoal;
import net.saksolm.monsterexpansion.entity.ai.rakoth.RakothTurnGoal;
import net.saksolm.monsterexpansion.entity.animations.RakothAnimationState;
import net.saksolm.monsterexpansion.entity.animations.RakothServerAnimations;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.custom.IMonsterAbilities;
import net.saksolm.monsterexpansion.entity.custom.IMonsterStaggers;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.entity.custom.RakothPartEntity;
import net.saksolm.monsterexpansion.entity.custom.RakothTailEntity;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.particles.options.ColorParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public class RakothEntity
extends AbstractLargeMonster<Ability, StaggerState> {
    public static final double BASE_MAX_HEALTH = 750.0;
    public static final double BASE_ATTACK_DAMAGE = 20.0;
    private final RakothAnimationState rakothAnimationState;
    private static final Map<String, String> RAKOTH_HIERARCHY = ImmutableMap.builder().put((Object)"torso", (Object)"Rakoth").put((Object)"upper", (Object)"torso").put((Object)"neck1", (Object)"upper").put((Object)"neck2", (Object)"neck1").put((Object)"neck3", (Object)"neck2").put((Object)"head", (Object)"neck3").put((Object)"jaw", (Object)"head").put((Object)"left_arm", (Object)"upper").put((Object)"left_forearm", (Object)"left_arm").put((Object)"left_hand", (Object)"left_forearm").put((Object)"left_finger1", (Object)"left_hand").put((Object)"left_finger2", (Object)"left_hand").put((Object)"left_finger3", (Object)"left_hand").put((Object)"right_arm", (Object)"upper").put((Object)"right_forearm", (Object)"right_arm").put((Object)"right_hand", (Object)"right_forearm").put((Object)"right_finger1", (Object)"right_hand").put((Object)"right_finger2", (Object)"right_hand").put((Object)"right_finger3", (Object)"right_hand").put((Object)"lower", (Object)"torso").put((Object)"hip", (Object)"lower").put((Object)"tail1", (Object)"hip").put((Object)"tail1_anchor", (Object)"tail1").put((Object)"tail2", (Object)"tail1").put((Object)"tail2_anchor", (Object)"tail2").put((Object)"tail3", (Object)"tail2").put((Object)"tail3_anchor", (Object)"tail3").put((Object)"tail4", (Object)"tail3").put((Object)"tail4_anchor", (Object)"tail4").put((Object)"tail5", (Object)"tail4").put((Object)"tail5_anchor", (Object)"tail5").put((Object)"tail6", (Object)"tail5").put((Object)"tail6_anchor", (Object)"tail6").put((Object)"tail7", (Object)"tail6").put((Object)"tail7_anchor", (Object)"tail7").put((Object)"tail8", (Object)"tail7").put((Object)"tail8_anchor", (Object)"tail8").put((Object)"left_leg", (Object)"hip").put((Object)"left_knee", (Object)"left_leg").put((Object)"left_foot", (Object)"left_knee").put((Object)"left_toe1", (Object)"left_foot").put((Object)"left_toe2", (Object)"left_foot").put((Object)"left_toe3", (Object)"left_foot").put((Object)"right_leg", (Object)"hip").put((Object)"right_knee", (Object)"right_leg").put((Object)"right_foot", (Object)"right_knee").put((Object)"right_toe1", (Object)"right_foot").put((Object)"right_toe2", (Object)"right_foot").put((Object)"right_toe3", (Object)"right_foot").build();
    private static final Map<String, Vec3> RAKOTH_DEFAULT_OFFSETS = ImmutableMap.builder().put((Object)"torso", (Object)new Vec3(0.0, 3.0, -1.875)).put((Object)"upper", (Object)new Vec3(0.0, 0.45, 0.975)).put((Object)"neck1", (Object)new Vec3(0.0, 0.0, -1.65)).put((Object)"neck2", (Object)new Vec3(0.0, 0.0, -1.65)).put((Object)"neck3", (Object)new Vec3(0.0, -0.075, -1.425)).put((Object)"head", (Object)new Vec3(0.0, -0.15, -0.975)).put((Object)"jaw", (Object)new Vec3(0.0, -0.74975, -0.0318625)).put((Object)"left_arm", (Object)new Vec3(-0.975, -1.9038, -1.8235)).put((Object)"left_forearm", (Object)new Vec3(-0.075, -0.751425, 0.4923125)).put((Object)"left_hand", (Object)new Vec3(0.1125, -1.2262875, -0.0629125)).put((Object)"left_finger1", (Object)new Vec3(0.0, -0.24375, -0.45375)).put((Object)"left_finger2", (Object)new Vec3(-0.196425, -0.24375, 0.2400375)).put((Object)"left_finger3", (Object)new Vec3(0.196425, -0.24375, 0.2400375)).put((Object)"right_arm", (Object)new Vec3(0.975, -1.9038, -1.8235)).put((Object)"right_forearm", (Object)new Vec3(0.075, -0.751425, -0.1076875)).put((Object)"right_hand", (Object)new Vec3(-0.1125, -1.2262875, -0.0629125)).put((Object)"right_finger1", (Object)new Vec3(0.0, -0.24375, -0.45375)).put((Object)"right_finger2", (Object)new Vec3(0.196425, -0.24375, 0.2400375)).put((Object)"right_finger3", (Object)new Vec3(-0.196425, -0.24375, 0.2400375)).put((Object)"lower", (Object)new Vec3(0.0, 0.45, 0.975)).put((Object)"hip", (Object)new Vec3(0.0, -0.075, 1.65)).put((Object)"tail1", (Object)new Vec3(0.0, -0.075, 1.65)).put((Object)"tail1_anchor", (Object)new Vec3(0.0, -1.05, 0.825)).put((Object)"tail2", (Object)new Vec3(0.0, -0.15, 1.65)).put((Object)"tail2_anchor", (Object)new Vec3(0.0, -0.75, 0.825)).put((Object)"tail3", (Object)new Vec3(0.0, 0.0, 1.65)).put((Object)"tail3_anchor", (Object)new Vec3(0.0, -0.525, 0.825)).put((Object)"tail4", (Object)new Vec3(0.0, 0.0, 1.65)).put((Object)"tail4_anchor", (Object)new Vec3(0.0, -0.45, 0.825)).put((Object)"tail5", (Object)new Vec3(0.0, -0.15, 1.65)).put((Object)"tail5_anchor", (Object)new Vec3(0.0, -0.3, 0.825)).put((Object)"tail6", (Object)new Vec3(0.0, 0.0, 1.65)).put((Object)"tail6_anchor", (Object)new Vec3(0.0, -0.225, 0.75)).put((Object)"tail7", (Object)new Vec3(0.0, 0.0, 1.65)).put((Object)"tail7_anchor", (Object)new Vec3(0.0, -0.15, 0.825)).put((Object)"tail8", (Object)new Vec3(0.0, 0.286525, 1.6249375)).put((Object)"tail8_anchor", (Object)new Vec3(0.0, -0.15, 0.825)).put((Object)"left_leg", (Object)new Vec3(-0.975, -2.01619375, 1.8431625)).put((Object)"left_knee", (Object)new Vec3(-0.075, -1.18158125, -0.1140875)).put((Object)"left_foot", (Object)new Vec3(0.1125, -1.02395, 0.042425)).put((Object)"left_toe1", (Object)new Vec3(0.0, -0.24375, 0.60375)).put((Object)"left_toe2", (Object)new Vec3(-0.196425, -0.24375, -0.0900375)).put((Object)"left_toe3", (Object)new Vec3(0.196425, -0.24375, -0.0900375)).put((Object)"right_leg", (Object)new Vec3(0.975, -2.01619375, 1.8431625)).put((Object)"right_knee", (Object)new Vec3(0.075, -1.18158125, -0.1140875)).put((Object)"right_foot", (Object)new Vec3(-0.1125, -1.02395, 0.042425)).put((Object)"right_toe1", (Object)new Vec3(0.0, -0.24375, 0.60375)).put((Object)"right_toe2", (Object)new Vec3(0.196425, -0.24375, -0.0900375)).put((Object)"right_toe3", (Object)new Vec3(-0.196425, -0.24375, -0.0900375)).build();
    private static final Map<String, Vec3> RAKOTH_DEFAULT_ROTATIONS = ImmutableMap.builder().put((Object)"upper", (Object)new Vec3((double)0.2618f, 0.0, 0.0)).put((Object)"neck1", (Object)new Vec3((double)0.1745f, 0.0, 0.0)).put((Object)"neck2", (Object)new Vec3((double)0.1745f, 0.0, 0.0)).put((Object)"neck3", (Object)new Vec3((double)0.0873f, 0.0, 0.0)).put((Object)"head", (Object)new Vec3((double)0.0436f, 0.0, 0.0)).put((Object)"jaw", (Object)new Vec3((double)0.0873f, 0.0, 0.0)).put((Object)"left_arm", (Object)new Vec3((double)0.5236f, 0.0, 0.0)).put((Object)"left_forearm", (Object)new Vec3((double)-1.4835f, 0.0, 0.0)).put((Object)"left_hand", (Object)new Vec3((double)0.6981f, 0.0, 0.0)).put((Object)"left_finger1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_finger2", (Object)new Vec3(0.0, (double)-0.3054f, 0.0)).put((Object)"left_finger3", (Object)new Vec3(0.0, (double)0.3054f, 0.0)).put((Object)"right_arm", (Object)new Vec3((double)0.5236f, 0.0, 0.0)).put((Object)"right_forearm", (Object)new Vec3((double)-1.4835f, 0.0, 0.0)).put((Object)"right_hand", (Object)new Vec3((double)0.6981f, 0.0, 0.0)).put((Object)"right_finger1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_finger2", (Object)new Vec3(0.0, (double)0.3054f, 0.0)).put((Object)"right_finger3", (Object)new Vec3(0.0, (double)-0.3054f, 0.0)).put((Object)"hip", (Object)new Vec3((double)-0.0436f, 0.0, 0.0)).put((Object)"tail1", (Object)new Vec3((double)-0.1309f, 0.0, 0.0)).put((Object)"tail1_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail2", (Object)new Vec3((double)-0.1309f, 0.0, 0.0)).put((Object)"tail2_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail3", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail3_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail4", (Object)new Vec3((double)0.0436f, 0.0, 0.0)).put((Object)"tail4_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail5", (Object)new Vec3((double)0.0873f, 0.0, 0.0)).put((Object)"tail5_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail6", (Object)new Vec3((double)0.1745f, 0.0, 0.0)).put((Object)"tail6_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail7", (Object)new Vec3((double)0.1745f, 0.0, 0.0)).put((Object)"tail7_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"tail8", (Object)new Vec3((double)0.3927f, 0.0, 0.0)).put((Object)"tail8_anchor", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_leg", (Object)new Vec3((double)-0.829f, 0.0, 0.0)).put((Object)"left_knee", (Object)new Vec3((double)1.6581f, 0.0, 0.0)).put((Object)"left_foot", (Object)new Vec3((double)-0.7854f, 0.0, 0.0)).put((Object)"left_toe1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"left_toe2", (Object)new Vec3(0.0, (double)-0.3054f, 0.0)).put((Object)"left_toe3", (Object)new Vec3(0.0, (double)0.3054f, 0.0)).put((Object)"right_leg", (Object)new Vec3((double)-0.829f, 0.0, 0.0)).put((Object)"right_knee", (Object)new Vec3((double)1.6581f, 0.0, 0.0)).put((Object)"right_foot", (Object)new Vec3((double)-0.7854f, 0.0, 0.0)).put((Object)"right_toe1", (Object)new Vec3(0.0, 0.0, 0.0)).put((Object)"right_toe2", (Object)new Vec3(0.0, (double)0.3054f, 0.0)).put((Object)"right_toe3", (Object)new Vec3(0.0, (double)-0.3054f, 0.0)).build();
    private final RakothPartEntity[] parts;
    public final RakothPartEntity head;
    public final RakothPartEntity right_claw;
    public final RakothPartEntity left_claw;
    public final RakothPartEntity tail1;
    public final RakothPartEntity tail2;
    public final RakothPartEntity tail3;
    public final RakothPartEntity tail4;
    public final RakothPartEntity tail5;
    public final RakothPartEntity tail6;
    public final RakothPartEntity tail7;
    public final RakothPartEntity tail8;
    private int pathUpdateCooldown = 0;
    public LivingEntity turnTarget;
    private boolean wasTurningLeftLastTick = false;
    private boolean wasTurningRightLastTick = false;
    private boolean wasSmashingLastTick = false;
    public final AnimationState smashAnimation = new AnimationState();
    public final AnimationState slideAnimation = new AnimationState();
    public final AnimationState rightSlamAnimation = new AnimationState();
    public final AnimationState frontSlamAnimation = new AnimationState();
    public final AnimationState leftSlamAnimation = new AnimationState();
    public final AnimationState tailswipeAnimation = new AnimationState();
    public final AnimationState tailSlamAnimation = new AnimationState();
    public final AnimationState tailSweepAnimation = new AnimationState();
    public final AnimationState rollStartAnimation = new AnimationState();
    public final AnimationState rollAnimation = new AnimationState();
    public final AnimationState rollEndAnimation = new AnimationState();
    public final AnimationState enrageAnimation = new AnimationState();
    public final AnimationState turnRightAnimation = new AnimationState();
    public final AnimationState turnLeftAnimation = new AnimationState();
    public final AnimationState turnRightEndAnimation = new AnimationState();
    public final AnimationState turnLeftEndAnimation = new AnimationState();
    public final AnimationState chargeAnimation = new AnimationState();
    public final AnimationState temperAnimation = new AnimationState();
    public final AnimationState spinAnimation = new AnimationState();
    public final AnimationState staggerAnimation = new AnimationState();
    public final AnimationState toppleAnimation = new AnimationState();
    public final AnimationState tailCutAnimation = new AnimationState();
    public final AnimationState rightClawBreakAnimation = new AnimationState();
    public final AnimationState leftClawBreakAnimation = new AnimationState();
    public final AnimationState headSwipeAnimation = new AnimationState();
    public final AnimationState enragedHeadSwipeAnimation = new AnimationState();
    public final AnimationState smashEndAnimation = new AnimationState();
    public final AnimationState roarAnimation = new AnimationState();
    public final AnimationState idleAnimation = new AnimationState();
    private int lastRoar = -1000;
    private int lastTemper = -1000;
    private int lastCharge = -1000;
    private int lastTurn = -1000;
    private int lastRoll = -1000;
    private int lastTailSweep = -1000;
    private int lastTailswipe = -1000;
    private int lastTailSlam = -1000;
    private int lastSmash = -1000;
    private int lastSlide = -1000;
    private int lastSlam = -1000;
    private int lastSpin = -1000;
    private int lastHeadSwipe = -1000;
    private final int SMASH_COOLDOWN = 100;
    private final int SLIDE_COOLDOWN = 100;
    private final int SLAM_COOLDOWN = 100;
    private final int TAILSWIPE_COOLDOWN = 500;
    private final int TAIL_SLAM_COOLDOWN = 500;
    private final int TAIL_SWEEP_COOLDOWN = 100;
    private final int ROLL_COOLDOWN = 1500;
    private final int TURN_COOLDOWN = 100;
    private final int CHARGE_COOLDOWN = 700;
    private final int TEMPER_COOLDOWN = 700;
    private final int SPIN_COOLDOWN = 700;
    private final int HEAD_SWIPE_COOLDOWN = 100;
    private final int ROAR_COOLDOWN = 2000;
    private RakothGroundBehaviorTree groundBehaviorTree;
    private static final EntityDataAccessor<Integer> SLAM_STATE = SynchedEntityData.m_135353_(RakothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> ROLL_STATE = SynchedEntityData.m_135353_(RakothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> TURN_STATE = SynchedEntityData.m_135353_(RakothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> TAIL_CUT = SynchedEntityData.m_135353_(RakothEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public RakothEntity(EntityType<? extends AbstractLargeMonster<Ability, StaggerState>> pEntityType, Level pLevel) {
        super(pEntityType, pLevel, Ability.class, StaggerState.class);
        this.head = new RakothPartEntity(this, 2.0f, 2.0f);
        this.right_claw = new RakothPartEntity(this, 2.0f, 2.0f);
        this.left_claw = new RakothPartEntity(this, 2.0f, 2.0f);
        this.tail1 = new RakothPartEntity(this, 2.0f, 2.0f);
        this.tail2 = new RakothPartEntity(this, 2.0f, 2.0f);
        this.tail3 = new RakothPartEntity(this, 2.0f, 2.0f);
        this.tail4 = new RakothPartEntity(this, 2.0f, 2.0f);
        this.tail5 = new RakothPartEntity(this, 2.0f, 2.0f);
        this.tail6 = new RakothPartEntity(this, 2.0f, 2.0f);
        this.tail7 = new RakothPartEntity(this, 2.0f, 2.0f);
        this.tail8 = new RakothPartEntity(this, 2.0f, 2.0f);
        this.parts = new RakothPartEntity[]{this.head, this.tail1, this.tail2, this.tail3, this.tail4, this.tail5, this.tail6, this.tail7, this.tail8, this.right_claw, this.left_claw};
        this.groundBehaviorTree = new RakothGroundBehaviorTree();
        this.registerBreakablePart("head_stagger", this.getStaggerPartBaseHealth());
        this.registerBreakablePart("head_break", this.m_21233_() * 0.4f);
        this.registerBreakablePart("tail", this.m_21233_() * 2.0f / 5.0f);
        this.registerBreakablePart("right_claw", this.m_21233_() * 0.4f);
        this.registerBreakablePart("left_claw", this.m_21233_() * 0.4f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.SLASHING, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("body", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerRawHitzone("right_claw", DamageTypes.WeaponType.SLASHING, 0.3f);
        this.registerRawHitzone("right_claw", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("right_claw", DamageTypes.WeaponType.PIERCING, 0.6f);
        this.registerRawHitzone("left_claw", DamageTypes.WeaponType.SLASHING, 0.3f);
        this.registerRawHitzone("left_claw", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("left_claw", DamageTypes.WeaponType.PIERCING, 0.6f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("head_stagger", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.BLUNT, 0.7f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.SLASHING, 0.45f);
        this.registerRawHitzone("head_break", DamageTypes.WeaponType.PIERCING, 0.45f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.SLASHING, 0.6f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.BLUNT, 0.3f);
        this.registerRawHitzone("tail", DamageTypes.WeaponType.PIERCING, 0.3f);
        this.registerElementalHitzone("head_stagger", DamageTypes.ElementType.ICE, 0.2f);
        this.registerElementalHitzone("head_break", DamageTypes.ElementType.ICE, 0.2f);
        this.registerElementalHitzone("tail", DamageTypes.ElementType.ICE, 0.4f);
        this.registerElementalHitzone("body", DamageTypes.ElementType.ICE, 0.5f);
        this.registerElementalHitzone("head_stagger", DamageTypes.ElementType.ICE, 0.4f);
        this.registerElementalHitzone("head_break", DamageTypes.ElementType.ICE, 0.5f);
        this.registerElementalHitzone("left_claw", DamageTypes.ElementType.ICE, 0.4f);
        this.registerElementalHitzone("right_claw", DamageTypes.ElementType.ICE, 0.4f);
        this.rakothAnimationState = new RakothAnimationState();
        this.m_21051_(Attributes.f_22276_).m_22100_(750.0 * (Double)ModConfig.SERVER.RAKOTH.MAX_HEALTH.get() * (Double)ModConfig.SERVER.GENERAL.MAX_HEALTH.get());
        this.m_21051_(Attributes.f_22281_).m_22100_(20.0 * (Double)ModConfig.SERVER.RAKOTH.ATTACK_DAMAGE.get() * (Double)ModConfig.SERVER.GENERAL.MAX_HEALTH.get());
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Animal.m_21183_().m_22268_(Attributes.f_22276_, 750.0).m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22284_, 5.0).m_22268_(Attributes.f_22277_, 100.0).m_22268_(Attributes.f_22281_, 20.0).m_22268_(Attributes.f_22282_, 5.0).m_22268_(Attributes.f_22278_, 0.95);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new RakothStaggerGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RakothToppleGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RakothTailCutGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RakothRightClawBreakGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new RakothLeftClawBreakGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothSmashGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothSlideGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothSlamGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothTailswipeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothTailSlamGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothTailSweepGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothRollGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothEnrageGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothTurnGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothChargeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothTemperGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothSpinGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothRoarGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new RakothHeadSwipeGoal(this));
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(SLAM_STATE, (Object)SlamState.NONE.ordinal());
        this.f_19804_.m_135372_(ROLL_STATE, (Object)RollState.NONE.ordinal());
        this.f_19804_.m_135372_(TURN_STATE, (Object)TurnState.NONE.ordinal());
        this.f_19804_.m_135372_(TAIL_CUT, (Object)false);
        super.m_8097_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            if (this.f_19797_ % 40 == 0 && this.isEnraged() && this.getRollState() != RollState.ROLL.ordinal()) {
                this.enrageBreath();
                this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11974_, this.m_5720_(), 1.0f, 0.75f);
            }
            if (this.m_5448_() != null) {
                this.groundBehaviorTree.tick(this);
            }
            --this.pathUpdateCooldown;
        }
    }

    private void enrageBreath() {
        Vec3 headCenter = this.head.m_20182_().m_82549_(new Vec3(0.0, 0.5, 0.0));
        Quaternionf entityOrientation = new Quaternionf();
        entityOrientation.rotateY(-this.f_20885_ * ((float)Math.PI / 180));
        entityOrientation.rotateX(-this.m_146909_() * ((float)Math.PI / 180));
        Quaternionf animatedBoneRotation = this.animationPlayer.getAbsolutePartRotation("head");
        Quaternionf finalRotation = new Quaternionf((Quaternionfc)entityOrientation).mul((Quaternionfc)animatedBoneRotation);
        float visualModelOffsetDegrees = 20.0f;
        float divergenceDegrees = 25.0f;
        float nostrilSpacing = 0.2f;
        float forwardOffset = 0.3f;
        for (int side : new int[]{-1, 1}) {
            Vector3f localDir = new Vector3f(0.0f, 0.0f, 1.0f);
            localDir.rotateX((float)Math.toRadians(visualModelOffsetDegrees));
            localDir.rotateY((float)Math.toRadians(divergenceDegrees * (float)side));
            localDir.rotate((Quaternionfc)finalRotation);
            Vec3 velocityDir = new Vec3((double)localDir.x(), (double)localDir.y(), (double)localDir.z()).m_82541_();
            Vector3f localOffset = new Vector3f((float)side * nostrilSpacing, 0.0f, forwardOffset);
            localOffset.rotateX((float)Math.toRadians(visualModelOffsetDegrees));
            localOffset.rotate((Quaternionfc)finalRotation);
            Vec3 spawnOrigin = headCenter.m_82520_((double)localOffset.x(), (double)localOffset.y(), (double)localOffset.z());
            double spread = 0.15;
            int particleCount = 20;
            for (int i = 0; i < particleCount; ++i) {
                Vec3 velocity = velocityDir.m_82490_(0.5).m_82520_((this.f_19796_.m_188500_() - 0.5) * spread, (this.f_19796_.m_188500_() - 0.5) * spread, (this.f_19796_.m_188500_() - 0.5) * spread);
                this.sendParticlePacket(spawnOrigin, velocity);
            }
        }
    }

    private void sendParticlePacket(Vec3 pos, Vec3 velocity) {
        ColorParticleOptions particleOptions = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.BREATH.get()), 1.0f, 1.0f, 1.0f, 0.05f, this.m_19879_());
        ModNetwork.sendToClientsTracking(new GenericParticlePacket(particleOptions, pos, velocity, true), (Entity)this);
    }

    @Override
    protected Map<String, String> getBoneHierarchy() {
        return RAKOTH_HIERARCHY;
    }

    @Override
    protected Map<String, Vec3> getDefaultOffsets() {
        return RAKOTH_DEFAULT_OFFSETS;
    }

    @Override
    protected Map<String, Vec3> getDefaultRotations() {
        return RAKOTH_DEFAULT_ROTATIONS;
    }

    @Override
    protected String getBoneNameForPart(LargeMonsterPartEntity<?> part) {
        if (part == this.head) {
            return "head";
        }
        if (part == this.tail1) {
            return "tail1_anchor";
        }
        if (part == this.tail2) {
            return "tail2_anchor";
        }
        if (part == this.tail3) {
            return "tail3_anchor";
        }
        if (part == this.tail4) {
            return "tail4_anchor";
        }
        if (part == this.tail5) {
            return "tail5_anchor";
        }
        if (part == this.tail6) {
            return "tail6_anchor";
        }
        if (part == this.tail7) {
            return "tail7_anchor";
        }
        if (part == this.tail8) {
            return "tail8_anchor";
        }
        if (part == this.left_claw) {
            return "left_hand";
        }
        if (part == this.right_claw) {
            return "right_hand";
        }
        return "";
    }

    @Override
    public LargeMonsterPartEntity<?>[] getBodyParts() {
        return this.parts;
    }

    @Override
    protected void onPartBroken(String partName, DamageSource source) {
        switch (partName) {
            case "head_break": {
                if (this.hasDroppedToppleLoot) break;
                if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
                    this.setCurrentStaggerState(StaggerState.TOPPLE);
                } else {
                    this.setCurrentStaggerState(StaggerState.STAGGER);
                }
                this.hasDroppedToppleLoot = true;
                ItemStack item = this.m_217043_().m_188503_(3) == 0 ? new ItemStack((ItemLike)ModItems.RAKOTH_HORN.get()) : new ItemStack((ItemLike)ModItems.RAKOTH_CARAPACE.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.head.m_20185_(), this.head.m_20186_(), this.head.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                break;
            }
            case "right_claw": {
                this.setCurrentStaggerState(StaggerState.RIGHT_CLAW_BREAK);
                ItemStack item = new ItemStack((ItemLike)ModItems.SEDIMENTARY_SCARP_SHELL.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.right_claw.m_20185_(), this.right_claw.m_20186_(), this.right_claw.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                break;
            }
            case "left_claw": {
                this.setCurrentStaggerState(StaggerState.LEFT_CLAW_BREAK);
                ItemStack item = new ItemStack((ItemLike)ModItems.SEDIMENTARY_SCARP_SHELL.get());
                ItemEntity itemEntity = new ItemEntity(this.m_9236_(), this.left_claw.m_20185_(), this.left_claw.m_20186_(), this.left_claw.m_20189_(), item);
                this.m_9236_().m_7967_((Entity)itemEntity);
                break;
            }
            case "head_stagger": {
                this.handleStagger(source);
                break;
            }
            case "tail": {
                if (this.isTailCut()) break;
                this.setTailCut(true);
                this.setCurrentStaggerState(StaggerState.TAIL_CUT);
                Vec3 directionToPart = this.tail1.m_20182_().m_82546_(this.m_20182_()).m_82541_();
                float tailYaw = this.m_146908_();
                RakothPartEntity part = this.tail5;
                double flingSpeed = 0.1;
                double upwardSpeed = 0.8;
                RakothTailEntity tailEntity = new RakothTailEntity(this.m_9236_(), part.m_20185_(), part.m_20186_(), part.m_20189_(), tailYaw);
                tailEntity.m_20334_(directionToPart.f_82479_ * flingSpeed, upwardSpeed, directionToPart.f_82481_ * flingSpeed);
                this.m_9236_().m_7967_((Entity)tailEntity);
            }
        }
    }

    private void handleStagger(DamageSource source) {
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE) {
            this.setCurrentStaggerState(StaggerState.STAGGER);
        } else if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        } else if (this.staggerCount % 2 != 0 || this.staggerCount == 0) {
            this.setCurrentStaggerState(StaggerState.STAGGER);
        } else {
            this.setCurrentStaggerState(StaggerState.TOPPLE);
            ++this.toppleCount;
        }
        float newHealth = this.getStaggerPartBaseHealth() * (1.0f + 0.5f * (float)this.staggerCount);
        this.resetPartHealth(this.getStaggerPartName(), newHealth);
    }

    @Override
    protected List<String> getLogicalPartNamesFor(LargeMonsterPartEntity<?> physicalPart) {
        if (physicalPart == this.head) {
            return List.of("head_break", "head_stagger");
        }
        if (this.isTailPart((RakothPartEntity)physicalPart)) {
            return List.of("tail");
        }
        if (physicalPart == this.right_claw) {
            return List.of("right_claw");
        }
        if (physicalPart == this.left_claw) {
            return List.of("left_claw");
        }
        return null;
    }

    @Override
    protected void onFlashed(DamageSource source) {
        this.setStaggerForFlash();
        ++this.staggerCount;
        this.flashProgress = 0;
        this.flashThreshold = (int)Math.pow(2.0, this.staggerCount);
    }

    @Override
    public String getStaggerPartName() {
        return "head_stagger";
    }

    @Override
    public float getStaggerPartBaseHealth() {
        return this.m_21233_() * 0.2f;
    }

    @Override
    public boolean isAttackAbility() {
        return this.getCurrentAbility() != Ability.TURN && this.getCurrentAbility() != Ability.ROAR;
    }

    public double trySmash() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastSmash < 100 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 4.0), 6.0, 6.0, 8.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryTemper() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastTemper < 700 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        if (!this.isEnraged()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 4.0), 30.0, 30.0, 30.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double trySlide() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastSlide < 100 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 7.0), 8.0, 6.0, 10.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryHeadSwipe() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastHeadSwipe < 100 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 0.0;
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 7.0), 8.0, 6.0, 10.0);
        if (!targetInZone) {
            return 0.0;
        }
        score = 15.0;
        if (this.lastUsedAbility == Ability.SLAM) {
            score += 25.0;
        }
        if (this.isEnraged() && this.lastUsedAbility == Ability.HEAD_SWIPE) {
            score += 45.0;
        }
        return score;
    }

    public double tryCharge() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        if (this.f_19797_ - this.lastCharge < 700 && (!this.isEnraged() ? this.lastUsedAbility != Ability.TURN || this.countUsageInLast(Ability.CHARGE, 4) != 1 : this.lastUsedAbility != Ability.TURN && this.countUsageInLast(Ability.CHARGE, 4) > 2)) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 60.0), 8.0, 30.0, 100.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryTailswipe() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastTailswipe < 500 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        if (this.m_21223_() / this.m_21233_() >= 0.5f) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 7.0), 15.0, 10.0, 15.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryTailSweep() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastTailSweep < 100 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, -10.0), 15.0, 10.0, 20.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryTurn() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastTurn < 100 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        Vec3 vecToTarget = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82541_();
        double dotProduct = vecToTarget.m_82526_(this.m_20154_());
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 0.0), 100.0, 10.0, 100.0);
        if (dotProduct > 0.25 || !targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryTailSlam() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastTailSlam < 500 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        if (!this.isEnraged()) {
            return 0.0;
        }
        boolean targetInZone = this.isTargetInOrientedBox(this.m_5448_(), new Vec3(0.0, 0.0, 12.0), 15.0, 20.0, 15.0);
        if (!targetInZone) {
            return 0.0;
        }
        return 15.0;
    }

    public double tryRoll() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastRoll < 1500 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        if (this.m_21223_() / this.m_21233_() >= 0.75f && !this.m_20069_()) {
            return 0.0;
        }
        if (this.m_20280_((Entity)this.m_5448_()) > 10000.0) {
            return 0.0;
        }
        if (this.isEnraged()) {
            return 5.0;
        }
        return 10.0;
    }

    public double trySpin() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastSpin < 700 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        if (this.m_20280_((Entity)this.m_5448_()) > 400.0) {
            return 0.0;
        }
        return 7.0;
    }

    public double trySlam() {
        if (this.isAttacking() || this.f_19797_ - this.lastAbilityFinishTick < 2 || this.f_19797_ - this.lastSlam < 100 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double distanceSqr = this.m_20280_((Entity)this.m_5448_());
        if (distanceSqr > 49.0) {
            return 0.0;
        }
        if (this.isTargetHealing()) {
            return 45.0;
        }
        return 15.0;
    }

    public double tryMove() {
        if (this.isAttacking()) {
            return 0.0;
        }
        if (this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 1.0;
        double distSqr = this.m_20280_((Entity)this.m_5448_());
        if (distSqr > 400.0) {
            score += 7.0;
        } else if (distSqr > 144.0) {
            score += 4.0;
        }
        return score;
    }

    public double tryRoar() {
        if (this.isAttacking() || this.f_19797_ - this.lastRoar < 2000 || this.m_5448_() == null || !this.m_5448_().m_6084_()) {
            return 0.0;
        }
        double score = 100.0;
        return score;
    }

    public BehaviorStatus startMove() {
        this.setCurrentAbility(Ability.MOVE);
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startRoar() {
        this.setCurrentAbility(Ability.ROAR);
        this.lastRoar = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startSmash() {
        this.setCurrentAbility(Ability.SMASH);
        this.lastSmash = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startSpin() {
        this.setCurrentAbility(Ability.SPIN);
        this.lastSpin = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startSlide() {
        this.setCurrentAbility(Ability.SLIDE);
        this.lastSlide = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startHeadSwipe() {
        this.setCurrentAbility(Ability.HEAD_SWIPE);
        this.lastHeadSwipe = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startRoll() {
        this.setCurrentAbility(Ability.ROLL);
        this.lastRoll = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTailswipe() {
        this.setCurrentAbility(Ability.TAILSWIPE);
        this.lastTailswipe = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTailSweep() {
        this.setCurrentAbility(Ability.TAIL_SWEEP);
        this.lastTailSweep = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTailSlam() {
        this.setCurrentAbility(Ability.TAIL_SLAM);
        this.lastTailSlam = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startSlam() {
        this.setCurrentAbility(Ability.SLAM);
        this.lastSlam = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startCharge() {
        this.setCurrentAbility(Ability.CHARGE);
        this.lastCharge = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTemper() {
        this.setCurrentAbility(Ability.TEMPER);
        this.lastTemper = this.f_19797_;
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus startTurn() {
        this.setCurrentAbility(Ability.TURN);
        this.lastTurn = this.f_19797_;
        this.turnTarget = this.m_5448_();
        return BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus updateGroundMovement(LivingEntity target) {
        if (this.m_21824_() && this.getTamedStance() == AbstractLargeMonster.TamedStance.FOLLOWING) {
            return BehaviorStatus.FAILURE;
        }
        if (this.isAttacking()) {
            return BehaviorStatus.FAILURE;
        }
        if (target == null || !target.m_6084_()) {
            this.m_21573_().m_26573_();
            return BehaviorStatus.FAILURE;
        }
        if (this.m_20280_((Entity)target) <= 16.0) {
            this.m_21573_().m_26573_();
            return BehaviorStatus.SUCCESS;
        }
        if (this.pathUpdateCooldown <= 0) {
            this.pathUpdateCooldown = 20;
            Vec3 predictedPos = this.getPredictedTargetPosition(target, 10);
            BlockPos targetPos = BlockPos.m_274446_((Position)predictedPos);
            Path path = this.m_21573_().m_7864_(targetPos, 0);
            if (path != null && !path.m_77392_()) {
                Vec3 finalDestination = path.m_77406_().m_252807_();
                double distanceSq = this.m_20182_().m_82557_(finalDestination);
                double RUN_DISTANCE_THRESHOLD_SQ = 100.0;
                boolean shouldRun = distanceSq > 100.0;
                float speed = 1.0f;
                this.m_21573_().m_26536_(path, (double)speed);
            }
        }
        return this.m_21573_().m_26572_() ? BehaviorStatus.RUNNING : BehaviorStatus.SUCCESS;
    }

    public BehaviorStatus updateGroundMovement() {
        return this.updateGroundMovement(this.m_5448_());
    }

    @Override
    protected void setupAnimationStates() {
        this.idleAnimation();
        this.smashAnimation();
        this.slideAnimation();
        this.slamAnimation();
        this.tailswipeAnimation();
        this.tailSlamAnimation();
        this.tailSweepAnimation();
        this.rollAnimation();
        this.enrageAnimation();
        this.turnAnimation();
        this.chargeAnimation();
        this.temperAnimation();
        this.spinAnimation();
        this.staggerAnimation();
        this.toppleAnimation();
        this.tailCutAnimation();
        this.clawBreakAnimation();
        this.headSwipeAnimation();
        this.roarAnimation();
    }

    private void idleAnimation() {
        if (this.getRollState() != RollState.ROLL.ordinal()) {
            if (!this.idleAnimation.m_216984_()) {
                this.idleAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("idle", 1.0f);
            }
        } else {
            this.idleAnimation.m_216973_();
            this.animationPlayer.stopAnimation("idle");
        }
    }

    private void smashAnimation() {
        if (this.getCurrentAbility() == Ability.SMASH) {
            if (!this.smashAnimation.m_216984_()) {
                this.smashAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("smash", 1.0f);
            }
        } else {
            this.smashAnimation.m_216973_();
            this.animationPlayer.stopAnimation("smash");
        }
        if (this.getCurrentAbility() != Ability.SMASH && this.wasSmashingLastTick && this.isEnraged()) {
            this.smashEndAnimation.m_216977_(this.f_19797_);
        }
        this.wasSmashingLastTick = this.getCurrentAbility() == Ability.SMASH;
    }

    private void slideAnimation() {
        if (this.getCurrentAbility() == Ability.SLIDE) {
            if (!this.slideAnimation.m_216984_()) {
                this.slideAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("slide", 1.0f);
            }
        } else {
            this.slideAnimation.m_216973_();
            this.animationPlayer.stopAnimation("slide");
        }
    }

    private void slamAnimation() {
        if (this.getCurrentAbility() == Ability.SLAM && this.getSlamState() == SlamState.FRONT.ordinal()) {
            if (!this.frontSlamAnimation.m_216984_()) {
                this.frontSlamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("front_slam", 1.0f);
            }
        } else {
            this.frontSlamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("front_slam");
        }
        if (this.getCurrentAbility() == Ability.SLAM && this.getSlamState() == SlamState.RIGHT.ordinal()) {
            if (!this.rightSlamAnimation.m_216984_()) {
                this.rightSlamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("right_slam", 1.0f);
            }
        } else {
            this.rightSlamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("right_slam");
        }
        if (this.getCurrentAbility() == Ability.SLAM && this.getSlamState() == SlamState.LEFT.ordinal()) {
            if (!this.leftSlamAnimation.m_216984_()) {
                this.leftSlamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("left_slam", 1.0f);
            }
        } else {
            this.leftSlamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("left_slam");
        }
    }

    private void tailswipeAnimation() {
        if (this.getCurrentAbility() == Ability.TAILSWIPE) {
            if (!this.tailswipeAnimation.m_216984_()) {
                this.tailswipeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tailswipe", 1.0f);
            }
        } else {
            this.tailswipeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tailswipe");
        }
    }

    private void tailSlamAnimation() {
        if (this.getCurrentAbility() == Ability.TAIL_SLAM) {
            if (!this.tailSlamAnimation.m_216984_()) {
                this.tailSlamAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tail_slam", 1.0f);
            }
        } else {
            this.tailSlamAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tail_slam");
        }
    }

    private void tailSweepAnimation() {
        if (this.getCurrentAbility() == Ability.TAIL_SWEEP) {
            if (!this.tailSweepAnimation.m_216984_()) {
                this.tailSweepAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tail_sweep", 1.0f);
            }
        } else {
            this.tailSweepAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tail_sweep");
        }
    }

    private void rollAnimation() {
        if (this.getCurrentAbility() == Ability.ROLL && this.getRollState() == RollState.START.ordinal()) {
            if (!this.rollStartAnimation.m_216984_()) {
                this.rollStartAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("roll_start", 1.0f);
            }
        } else {
            this.rollStartAnimation.m_216973_();
            this.animationPlayer.stopAnimation("roll_start");
        }
        if (this.getCurrentAbility() == Ability.ROLL && this.getRollState() == RollState.ROLL.ordinal()) {
            if (!this.rollAnimation.m_216984_()) {
                this.rollAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("roll", 1.0f);
            }
        } else {
            this.rollAnimation.m_216973_();
            this.animationPlayer.stopAnimation("roll");
        }
        if (this.getCurrentAbility() == Ability.ROLL && this.getRollState() == RollState.END.ordinal()) {
            if (!this.rollEndAnimation.m_216984_()) {
                this.rollEndAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("roll_end", 1.0f);
            }
        } else {
            this.rollEndAnimation.m_216973_();
            this.animationPlayer.stopAnimation("roll_end");
        }
    }

    private void enrageAnimation() {
        if (this.getCurrentAbility() == Ability.ENRAGE) {
            if (!this.enrageAnimation.m_216984_()) {
                this.enrageAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enrage", 1.0f);
            }
        } else {
            this.enrageAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enrage");
        }
    }

    private void turnAnimation() {
        if (this.getCurrentAbility() == Ability.TURN && this.getTurnState() == TurnState.RIGHT.ordinal()) {
            if (!this.turnRightAnimation.m_216984_()) {
                this.turnRightAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_right", 1.0f);
            }
        } else {
            this.turnRightAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_right");
        }
        if (this.getCurrentAbility() == Ability.TURN && this.getTurnState() == TurnState.LEFT.ordinal()) {
            if (!this.turnLeftAnimation.m_216984_()) {
                this.turnLeftAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("turn_left", 1.0f);
            }
        } else {
            this.turnLeftAnimation.m_216973_();
            this.animationPlayer.stopAnimation("turn_left");
        }
        if (this.getCurrentAbility() != Ability.TURN && this.getTurnState() != TurnState.LEFT.ordinal() && this.wasTurningLeftLastTick) {
            this.turnLeftEndAnimation.m_216977_(this.f_19797_);
        }
        if (this.getCurrentAbility() != Ability.TURN && this.getTurnState() != TurnState.RIGHT.ordinal() && this.wasTurningRightLastTick) {
            this.turnRightEndAnimation.m_216977_(this.f_19797_);
        }
        this.wasTurningLeftLastTick = this.getTurnState() == TurnState.LEFT.ordinal();
        this.wasTurningRightLastTick = this.getTurnState() == TurnState.RIGHT.ordinal();
    }

    private void chargeAnimation() {
        if (this.getCurrentAbility() == Ability.CHARGE) {
            if (!this.chargeAnimation.m_216984_()) {
                this.chargeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("charge", 1.0f);
            }
        } else {
            this.chargeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("charge");
        }
    }

    private void temperAnimation() {
        if (this.getCurrentAbility() == Ability.TEMPER) {
            if (!this.temperAnimation.m_216984_()) {
                this.temperAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("temper", 1.0f);
            }
        } else {
            this.temperAnimation.m_216973_();
            this.animationPlayer.stopAnimation("temper");
        }
    }

    private void spinAnimation() {
        if (this.getCurrentAbility() == Ability.SPIN) {
            if (!this.spinAnimation.m_216984_()) {
                this.spinAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("spin", 1.5f);
            }
        } else {
            this.spinAnimation.m_216973_();
            this.animationPlayer.stopAnimation("spin");
        }
    }

    private void staggerAnimation() {
        if (this.getCurrentStaggerState() == StaggerState.STAGGER) {
            if (!this.staggerAnimation.m_216984_()) {
                this.staggerAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("stagger", 1.0f);
            }
        } else {
            this.staggerAnimation.m_216973_();
            this.animationPlayer.stopAnimation("stagger");
        }
    }

    private void toppleAnimation() {
        if (this.getCurrentStaggerState() == StaggerState.TOPPLE) {
            if (!this.toppleAnimation.m_216984_()) {
                this.toppleAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("topple", 1.0f);
            }
        } else {
            this.toppleAnimation.m_216973_();
            this.animationPlayer.stopAnimation("topple");
        }
    }

    private void tailCutAnimation() {
        if (this.getCurrentStaggerState() == StaggerState.TAIL_CUT) {
            if (!this.tailCutAnimation.m_216984_()) {
                this.tailCutAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("tail_cut", 1.0f);
            }
        } else {
            this.tailCutAnimation.m_216973_();
            this.animationPlayer.stopAnimation("tail_cut");
        }
    }

    private void clawBreakAnimation() {
        if (this.getCurrentStaggerState() == StaggerState.RIGHT_CLAW_BREAK) {
            if (!this.rightClawBreakAnimation.m_216984_()) {
                this.rightClawBreakAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("right_claw_break", 1.0f);
            }
        } else {
            this.rightClawBreakAnimation.m_216973_();
            this.animationPlayer.stopAnimation("right_claw_break");
        }
        if (this.getCurrentStaggerState() == StaggerState.LEFT_CLAW_BREAK) {
            if (!this.leftClawBreakAnimation.m_216984_()) {
                this.leftClawBreakAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("left_claw_break", 1.0f);
            }
        } else {
            this.leftClawBreakAnimation.m_216973_();
            this.animationPlayer.stopAnimation("left_claw_break");
        }
    }

    private void headSwipeAnimation() {
        if (this.getCurrentAbility() == Ability.HEAD_SWIPE && !this.isAbilityEnraged()) {
            if (!this.headSwipeAnimation.m_216984_()) {
                this.headSwipeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("head_swipe", 1.0f);
            }
        } else {
            this.headSwipeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("head_swipe");
        }
        if (this.getCurrentAbility() == Ability.HEAD_SWIPE && this.isAbilityEnraged()) {
            if (!this.enragedHeadSwipeAnimation.m_216984_()) {
                this.enragedHeadSwipeAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("enraged_head_swipe", 1.0f);
            }
        } else {
            this.enragedHeadSwipeAnimation.m_216973_();
            this.animationPlayer.stopAnimation("enraged_head_swipe");
        }
    }

    private void roarAnimation() {
        if (this.getCurrentAbility() == Ability.ROAR) {
            if (!this.roarAnimation.m_216984_()) {
                this.roarAnimation.m_216977_(this.f_19797_);
                this.animationPlayer.playAnimation("roar", 1.0f);
            }
        } else {
            this.roarAnimation.m_216973_();
            this.animationPlayer.stopAnimation("roar");
        }
    }

    protected void m_267689_(float pPartialTick) {
        float f = this.m_20089_() == Pose.STANDING && (!this.isAttacking() || this.getCurrentAbility() == Ability.MOVE) && this.m_20096_() ? Math.min(pPartialTick * 6.0f, 1.0f) : 0.0f;
        this.f_267362_.m_267566_(f, 0.2f);
    }

    @Override
    public Ability getNoneAbility() {
        return Ability.NONE;
    }

    @Override
    public StaggerState getNoneStagger() {
        return StaggerState.NONE;
    }

    @Override
    public void setStaggerForFlash() {
        this.handleStagger(this.m_269291_().m_269425_());
    }

    @Override
    public void setToppleForFlashIfAerial() {
    }

    @Override
    protected SoundEvent getMusic() {
        return (SoundEvent)ModSounds.RAKOTH_THEME.get();
    }

    @Override
    public boolean isFlashable() {
        return true;
    }

    @Override
    protected void registerServerAnimations() {
        this.animationPlayer.registerAnimation("idle", RakothServerAnimations.idle);
        this.animationPlayer.registerAnimation("smash", RakothServerAnimations.smash);
        this.animationPlayer.registerAnimation("slide", RakothServerAnimations.slide);
        this.animationPlayer.registerAnimation("right_slam", RakothServerAnimations.right_slam);
        this.animationPlayer.registerAnimation("left_slam", RakothServerAnimations.left_slam);
        this.animationPlayer.registerAnimation("front_slam", RakothServerAnimations.front_slam);
        this.animationPlayer.registerAnimation("tailswipe", RakothServerAnimations.tailswipe);
        this.animationPlayer.registerAnimation("tail_slam", RakothServerAnimations.tail_slam);
        this.animationPlayer.registerAnimation("tail_sweep", RakothServerAnimations.tail_sweep);
        this.animationPlayer.registerAnimation("roll_start", RakothServerAnimations.roll_start);
        this.animationPlayer.registerAnimation("roll", RakothServerAnimations.roll);
        this.animationPlayer.registerAnimation("roll_end", RakothServerAnimations.roll_end);
        this.animationPlayer.registerAnimation("enrage", RakothServerAnimations.enrage);
        this.animationPlayer.registerAnimation("turn_left", RakothServerAnimations.turn_left);
        this.animationPlayer.registerAnimation("turn_right", RakothServerAnimations.turn_right);
        this.animationPlayer.registerAnimation("charge", RakothServerAnimations.charge);
        this.animationPlayer.registerAnimation("temper", RakothServerAnimations.temper);
        this.animationPlayer.registerAnimation("spin", RakothServerAnimations.spin);
        this.animationPlayer.registerAnimation("stagger", RakothServerAnimations.stagger);
        this.animationPlayer.registerAnimation("topple", RakothServerAnimations.topple);
        this.animationPlayer.registerAnimation("tail_cut", RakothServerAnimations.tail_cut);
        this.animationPlayer.registerAnimation("left_claw_break", RakothServerAnimations.left_claw_break);
        this.animationPlayer.registerAnimation("right_claw_break", RakothServerAnimations.right_claw_break);
        this.animationPlayer.registerAnimation("head_swipe", RakothServerAnimations.head_swipe);
        this.animationPlayer.registerAnimation("enraged_head_swipe", RakothServerAnimations.enraged_head_swipe);
        this.animationPlayer.registerAnimation("roar", RakothServerAnimations.roar);
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return null;
    }

    public boolean isTailPart(RakothPartEntity part) {
        if (!this.isTailCut()) {
            return part == this.tail1 || part == this.tail2 || part == this.tail3 || part == this.tail4 || part == this.tail5 || part == this.tail6 || part == this.tail7 || part == this.tail8;
        }
        return part == this.tail1 || part == this.tail2 || part == this.tail3 || part == this.tail4 || part == this.tail5;
    }

    public void activateTailParts() {
        for (RakothPartEntity part : this.parts) {
            if (!this.isTailPart(part)) continue;
            this.addActiveDamagePart(part);
        }
    }

    public Vec3 getHeadPos() {
        return this.head.m_20182_();
    }

    public int getSlamState() {
        return (Integer)this.f_19804_.m_135370_(SLAM_STATE);
    }

    public void setSlamState(int state) {
        this.f_19804_.m_135381_(SLAM_STATE, (Object)state);
    }

    public int getRollState() {
        return (Integer)this.f_19804_.m_135370_(ROLL_STATE);
    }

    public void setRollState(int state) {
        this.f_19804_.m_135381_(ROLL_STATE, (Object)state);
    }

    public int getTurnState() {
        return (Integer)this.f_19804_.m_135370_(TURN_STATE);
    }

    public void setTurnState(int state) {
        this.f_19804_.m_135381_(TURN_STATE, (Object)state);
    }

    public boolean isTailCut() {
        return (Boolean)this.f_19804_.m_135370_(TAIL_CUT);
    }

    public void setTailCut(boolean tailCut) {
        this.f_19804_.m_135381_(TAIL_CUT, (Object)tailCut);
        if (tailCut) {
            this.tail6.m_146870_();
            this.tail7.m_146870_();
            this.tail8.m_146870_();
        }
    }

    @Override
    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("TailCut", this.isTailCut());
    }

    @Override
    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.f_19804_.m_135381_(TAIL_CUT, (Object)pCompound.m_128471_("TailCut"));
        if (this.isTailCut()) {
            this.tail6.m_146870_();
            this.tail7.m_146870_();
            this.tail8.m_146870_();
        }
    }

    public RakothAnimationState getAnimationState() {
        return this.rakothAnimationState;
    }

    public static enum Ability implements IMonsterAbilities<Ability>
    {
        NONE,
        SMASH,
        SLIDE,
        SLAM,
        TAILSWIPE,
        TAIL_SLAM,
        TAIL_SWEEP,
        ROLL,
        ENRAGE,
        TURN,
        CHARGE,
        TEMPER,
        SPIN,
        STAGGER,
        MOVE,
        HEAD_SWIPE,
        ROAR;


        @Override
        public int getOrdinal() {
            return this.ordinal();
        }

        @Override
        public Ability getNone() {
            return NONE;
        }
    }

    public static enum StaggerState implements IMonsterStaggers<StaggerState>
    {
        NONE,
        STAGGER,
        TOPPLE,
        TAIL_CUT,
        RIGHT_CLAW_BREAK,
        LEFT_CLAW_BREAK;

    }

    public static enum SlamState {
        NONE,
        FRONT,
        RIGHT,
        LEFT;

    }

    public static enum RollState {
        NONE,
        START,
        ROLL,
        END;

    }

    public static enum TurnState {
        NONE,
        RIGHT,
        LEFT;

    }
}

