/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom.effect;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.saksolm.monsterexpansion.entity.ModEntities;
import net.saksolm.monsterexpansion.entity.custom.KobekoEntity;

public class ShockwaveEntity
extends Entity {
    private static final EntityDataAccessor<Float> DATA_MAX_RADIUS = SynchedEntityData.m_135353_(ShockwaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> DATA_RADIUS = SynchedEntityData.m_135353_(ShockwaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> DATA_LIFETIME = SynchedEntityData.m_135353_(ShockwaveEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private LivingEntity owner;
    private float damage;
    private final List<UUID> alreadyHitEntities = new ArrayList<UUID>();

    public ShockwaveEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ShockwaveEntity(Level pLevel, Vec3 position, LivingEntity owner, float maxRadius, float damage, int lifetime) {
        this((EntityType)ModEntities.SHOCKWAVE.get(), pLevel);
        this.m_146884_(position);
        this.owner = owner;
        this.setMaxRadius(maxRadius);
        this.damage = damage;
        this.setLifetime(lifetime);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_RADIUS, (Object)Float.valueOf(0.0f));
        this.f_19804_.m_135372_(DATA_MAX_RADIUS, (Object)Float.valueOf(15.0f));
        this.f_19804_.m_135372_(DATA_LIFETIME, (Object)40);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_9236_().f_46443_) {
            return;
        }
        if (this.f_19797_ >= this.getLifetime()) {
            this.m_146870_();
            return;
        }
        float oldRadius = this.getRadius();
        float newRadius = (float)this.f_19797_ / (float)this.getLifetime() * this.getMaxRadius();
        this.setRadius(newRadius);
        if (this.damage > 0.0f) {
            AABB searchBox = this.m_20191_().m_82400_((double)newRadius);
            List nearbyEntities = this.m_9236_().m_45976_(LivingEntity.class, searchBox);
            for (LivingEntity target : nearbyEntities) {
                double distanceToTarget;
                KobekoEntity kobeko;
                LivingEntity livingEntity;
                if (target == this.owner || this.alreadyHitEntities.contains(target.m_20148_()) || (livingEntity = this.owner) instanceof KobekoEntity && target == (kobeko = (KobekoEntity)livingEntity).m_269323_() || !((distanceToTarget = (double)this.m_20270_((Entity)target)) <= (double)newRadius) || !(distanceToTarget > (double)oldRadius)) continue;
                target.m_6469_(this.m_269291_().m_269333_(this.owner), this.damage);
                Vec3 knockback = target.m_20182_().m_82546_(this.m_20182_()).m_82541_().m_82520_(0.0, 0.5, 0.0).m_82541_().m_82490_(1.2);
                target.m_20256_(target.m_20184_().m_82549_(knockback));
                this.alreadyHitEntities.add(target.m_20148_());
            }
        }
    }

    public float getMaxRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_MAX_RADIUS)).floatValue();
    }

    public void setMaxRadius(float radius) {
        this.f_19804_.m_135381_(DATA_MAX_RADIUS, (Object)Float.valueOf(radius));
    }

    public float getRadius() {
        return ((Float)this.f_19804_.m_135370_(DATA_RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        this.f_19804_.m_135381_(DATA_RADIUS, (Object)Float.valueOf(radius));
    }

    public int getLifetime() {
        return (Integer)this.f_19804_.m_135370_(DATA_LIFETIME);
    }

    public void setLifetime(int lifetime) {
        this.f_19804_.m_135381_(DATA_LIFETIME, (Object)lifetime);
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_((double)this.getMaxRadius() + 2.0);
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.damage = pCompound.m_128457_("Damage");
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128350_("Damage", this.damage);
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

