/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom.effect;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.entity.IEntityAdditionalSpawnData;
import net.minecraftforge.network.NetworkHooks;
import net.saksolm.monsterexpansion.entity.ModEntities;

public class SmashedGroundEffectEntity
extends Entity
implements IEntityAdditionalSpawnData {
    public int animation_duration;
    public float maxRadius;
    public final List<BlockPos> blocksToAnimate = new ArrayList<BlockPos>();
    public final List<BlockState> blockStates = new ArrayList<BlockState>();

    public SmashedGroundEffectEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public SmashedGroundEffectEntity(Level pLevel, List<BlockPos> blocks, List<BlockState> states, int duration, float maxRadius) {
        this((EntityType)ModEntities.SMASHED_GROUND_EFFECT.get(), pLevel);
        this.blocksToAnimate.addAll(blocks);
        this.blockStates.addAll(states);
        this.animation_duration = duration;
        this.maxRadius = maxRadius;
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_ && this.f_19797_ >= this.animation_duration) {
            this.m_146870_();
        }
    }

    public int getAnimationDuration() {
        return this.animation_duration;
    }

    public float getMaxRadius() {
        return this.maxRadius;
    }

    public void writeSpawnData(FriendlyByteBuf buffer) {
        buffer.writeInt(this.animation_duration);
        buffer.writeFloat(this.maxRadius);
        buffer.m_236828_(this.blocksToAnimate, FriendlyByteBuf::m_130064_);
        buffer.m_130130_(this.blockStates.size());
        for (BlockState state : this.blockStates) {
            buffer.m_130130_(Block.m_49956_((BlockState)state));
        }
    }

    public void readSpawnData(FriendlyByteBuf buffer) {
        this.animation_duration = buffer.readInt();
        this.maxRadius = buffer.readFloat();
        this.blocksToAnimate.addAll(buffer.m_236845_(FriendlyByteBuf::m_130135_));
        int size = buffer.m_130242_();
        for (int i = 0; i < size; ++i) {
            this.blockStates.add(Block.m_49803_((int)buffer.m_130242_()));
        }
    }

    public boolean m_6783_(double pDistance) {
        double maxRenderDistance = 64.0;
        return pDistance < maxRenderDistance * maxRenderDistance;
    }

    public AABB m_6921_() {
        return this.m_20191_().m_82400_((double)this.maxRadius + 2.0);
    }

    protected void m_8097_() {
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

