/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.entity.custom.projectile;

import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.ModEntities;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.particles.options.ColorParticleOptions;
import net.saksolm.monsterexpansion.util.AttackDefinition;

public class IceSpikeMarkerEntity
extends Entity {
    private int lifeTicks = 0;
    private LivingEntity owner;
    public AnimationState spawnAnimation = new AnimationState();

    public IceSpikeMarkerEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.f_19794_ = true;
    }

    protected void m_8097_() {
    }

    public IceSpikeMarkerEntity(Level level, Vec3 position, float yaw, LivingEntity owner) {
        this((EntityType)ModEntities.ICE_SPIKE_MARKER.get(), level);
        this.m_146884_(position);
        this.m_146922_(yaw);
        this.owner = owner;
        this.f_19859_ = yaw;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.lifeTicks;
        if (this.lifeTicks == 6) {
            this.m_9236_().m_7605_((Entity)this, (byte)2);
        }
        if (!this.m_9236_().f_46443_ && this.lifeTicks == 5) {
            this.dealDamage();
        }
        if (!this.m_9236_().f_46443_ && this.lifeTicks > 40 + this.f_19796_.m_188503_(10)) {
            this.m_9236_().m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        if (!this.spawnAnimation.m_216984_()) {
            this.spawnAnimation.m_216977_(this.f_19797_);
        }
    }

    public void dealDamage() {
        if (this.m_9236_().f_46443_) {
            return;
        }
        Vec3 center = this.m_20182_();
        AABB damageArea = new AABB(center.m_82492_(2.0, 0.0, 2.0), center.m_82520_(2.0, 2.5, 2.0));
        List targets = this.m_9236_().m_45976_(LivingEntity.class, damageArea);
        DamageSource damageSource = this.owner != null ? this.m_269291_().m_269333_(this.owner) : this.m_269291_().m_269425_();
        for (LivingEntity target : targets) {
            if (target == this.owner) continue;
            LivingEntity livingEntity = this.owner;
            if (livingEntity instanceof AbstractLargeMonster) {
                AbstractLargeMonster largeMonster = (AbstractLargeMonster)livingEntity;
                AttackDefinition attackDefinition = new AttackDefinition.Builder().damage(1.5f).knockback(AbstractLargeMonster.KnockbackType.UPWARD, 0.5).addEffect(new MobEffectInstance((MobEffect)ModEffects.FROSTVEIN.get(), 400), 0.5f).withElement(DamageTypes.ElementType.ICE).build();
                largeMonster.applyDamageToTarget(target, attackDefinition);
                continue;
            }
            livingEntity = this.owner;
            if (!(livingEntity instanceof ServerPlayer)) continue;
            ServerPlayer player = (ServerPlayer)livingEntity;
            target.m_6469_(damageSource, 30.0f);
        }
    }

    public void m_7822_(byte pId) {
        if (pId == 3) {
            int particleCount = 30;
            for (int i = 0; i < 30; ++i) {
                double motionX = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                double motionY = this.f_19796_.m_188500_() * 0.5;
                double motionZ = (this.f_19796_.m_188500_() - 0.5) * 0.3;
                ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.ICE_SHARD.get()), 1.0f, 1.0f, 1.0f, 0.3f, -1);
                this.m_9236_().m_7106_((ParticleOptions)options, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), motionX, motionY, motionZ);
            }
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, this.m_5720_(), 1.0f, 1.0f, false);
        } else if (pId == 2) {
            this.m_9236_().m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11983_, this.m_5720_(), 1.0f, 1.0f, false);
        } else {
            super.m_7822_(pId);
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
    }

    protected void m_7380_(CompoundTag pCompound) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

