/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.effect.ModEffects;

@Mod.EventBusSubscriber(modid="monsterexpansion")
public class BleedingEffectEvents {
    private static final Map<UUID, Vec3> previousPositions = new HashMap<UUID, Vec3>();

    @SubscribeEvent
    public static void onLivingTick(LivingEvent.LivingTickEvent event) {
        Vec3 lastPos;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        if (!player.m_21023_((MobEffect)ModEffects.BLEEDING.get())) {
            previousPositions.remove(player.m_20148_());
            return;
        }
        MobEffectInstance instance = player.m_21124_((MobEffect)ModEffects.BLEEDING.get());
        if (instance == null) {
            return;
        }
        int currentDuration = instance.m_19557_();
        if (currentDuration <= 1) {
            return;
        }
        Vec3 currentPos = player.m_20182_();
        double distSqr = currentPos.m_82557_(lastPos = previousPositions.getOrDefault(player.m_20148_(), currentPos));
        boolean isMoving = distSqr > 4.0E-4;
        previousPositions.put(player.m_20148_(), currentPos);
        int newDuration = currentDuration;
        boolean shouldUpdate = false;
        if (player.m_20142_()) {
            newDuration = currentDuration + 1;
            shouldUpdate = true;
        } else if (player.m_6047_() && !isMoving) {
            if (currentDuration > 4) {
                newDuration = currentDuration - 3;
                shouldUpdate = true;
            }
        } else if (isMoving && player.f_19797_ % 2 == 0) {
            newDuration = currentDuration + 1;
            shouldUpdate = true;
        }
        if (shouldUpdate) {
            MobEffectInstance newInstance = new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), newDuration, instance.m_19564_(), instance.m_19571_(), instance.m_19572_(), instance.m_19575_());
            player.m_21195_((MobEffect)ModEffects.BLEEDING.get());
            player.m_7292_(newInstance);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        previousPositions.remove(event.getEntity().m_20148_());
    }
}

