/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.capabilities.IMonsterArmor;
import net.saksolm.monsterexpansion.capabilities.IMonsterWeapon;
import net.saksolm.monsterexpansion.capabilities.IPlayerStun;
import net.saksolm.monsterexpansion.capabilities.ModCapabilities;
import net.saksolm.monsterexpansion.capabilities.PlayerStunImpl;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;
import net.saksolm.monsterexpansion.item.MaceItem;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.item.MonsterArmorImpl;
import net.saksolm.monsterexpansion.item.MonsterWeaponImpl;
import net.saksolm.monsterexpansion.item.SpearItem;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(modid="monsterexpansion", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEvents {
    @SubscribeEvent
    public static void attachWeaponCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        MonsterWeaponProvider provider;
        ItemStack stack = (ItemStack)event.getObject();
        Item item = stack.m_41720_();
        if (item == Items.f_42423_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42420_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42428_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42425_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42386_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42383_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42433_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42430_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42391_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42388_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42393_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42396_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42411_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.PIERCING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42717_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.PIERCING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == Items.f_42713_) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.PIERCING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == ModItems.RIMESCOURGE.get()) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.BLUNT, DamageTypes.ElementType.ICE, 15.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == ModItems.HORN_OF_THE_SHATTERCRY.get()) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.BLUNT, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == ModItems.DUSKREND.get()) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.SLASHING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item == ModItems.SPIRE_SHELL_BULWARK.get()) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.PIERCING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item instanceof MaceItem) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.BLUNT, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
        if (item instanceof SpearItem) {
            provider = new MonsterWeaponProvider(new MonsterWeaponImpl(DamageTypes.WeaponType.PIERCING, DamageTypes.ElementType.NONE, 0.0f));
            event.addCapability(new ResourceLocation("monsterexpansion", "weapon_data"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void onWeaponTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        List toolTip = event.getToolTip();
        stack.getCapability(ModCapabilities.WEAPON_DATA).ifPresent(weaponData -> {
            DamageTypes.WeaponType weaponType = weaponData.getWeaponType(stack);
            DamageTypes.ElementType elementType = weaponData.getElementType(stack);
            float elementDamage = weaponData.getElementalDamage(stack);
            MutableComponent weaponTypeLine = Component.m_237115_((String)"tooltip.monsterexpansion.weapon_type").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)weaponType.name()).m_130940_(ChatFormatting.GRAY));
            toolTip.add(weaponTypeLine);
            if (elementType != DamageTypes.ElementType.NONE) {
                MutableComponent elementLine = Component.m_237115_((String)"tooltip.monsterexpansion.element").m_130946_(": ").m_7220_((Component)Component.m_237113_((String)(elementType.name() + " " + (int)elementDamage)).m_130940_(CapabilityEvents.getElementColor(elementType)));
                toolTip.add(elementLine);
            }
        });
    }

    private static ChatFormatting getElementColor(DamageTypes.ElementType type) {
        switch (type) {
            case ICE: {
                return ChatFormatting.AQUA;
            }
        }
        return ChatFormatting.GRAY;
    }

    @SubscribeEvent
    public static void attachArmorCapabilities(AttachCapabilitiesEvent<ItemStack> event) {
        ItemStack stack = (ItemStack)event.getObject();
        if (CapabilityEvents.isMonsterArmor(stack)) {
            MonsterArmorProvider provider = new MonsterArmorProvider();
            provider.getCapability(ModCapabilities.ARMOR_DATA, null).ifPresent(cap -> CapabilityEvents.initializeArmorStats(stack, cap));
            event.addCapability(new ResourceLocation("monsterexpansion", "monster_armor"), (ICapabilityProvider)provider);
        }
    }

    private static void initializeArmorStats(ItemStack stack, IMonsterArmor cap) {
        if (stack.m_41720_() == ModItems.SKRYTHE_HELMET.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, -3);
        } else if (stack.m_41720_() == ModItems.SKRYTHE_CHESTPLATE.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, -5);
        } else if (stack.m_41720_() == ModItems.SKRYTHE_LEGGINGS.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, -4);
        } else if (stack.m_41720_() == ModItems.SKRYTHE_BOOTS.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, -3);
        } else if (stack.m_41720_() == ModItems.RHYZA_HELMET.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, 1);
        } else if (stack.m_41720_() == ModItems.RHYZA_CHESTPLATE.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, 3);
        } else if (stack.m_41720_() == ModItems.RHYZA_LEGGINGS.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, 2);
        } else if (stack.m_41720_() == ModItems.RHYZA_BOOTS.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, 1);
        } else if (stack.m_41720_() == ModItems.RAKOTH_HELMET.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, -1);
        } else if (stack.m_41720_() == ModItems.RAKOTH_CHESTPLATE.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, -3);
        } else if (stack.m_41720_() == ModItems.RAKOTH_LEGGINGS.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, -2);
        } else if (stack.m_41720_() == ModItems.RAKOTH_BOOTS.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, -2);
        } else if (stack.m_41720_() == ModItems.LEIVEKILTH_HELMET.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, 3);
        } else if (stack.m_41720_() == ModItems.LEIVEKILTH_CHESTPLATE.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, 5);
        } else if (stack.m_41720_() == ModItems.LEIVEKILTH_LEGGINGS.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, 4);
        } else if (stack.m_41720_() == ModItems.LEIVEKILTH_BOOTS.get()) {
            cap.setResistance(DamageTypes.ElementType.ICE, 3);
        }
    }

    private static boolean isMonsterArmor(ItemStack stack) {
        return stack.m_41720_() == ModItems.SKRYTHE_HELMET.get() || stack.m_41720_() == ModItems.SKRYTHE_CHESTPLATE.get() || stack.m_41720_() == ModItems.SKRYTHE_LEGGINGS.get() || stack.m_41720_() == ModItems.SKRYTHE_BOOTS.get() || stack.m_41720_() == ModItems.LEIVEKILTH_HELMET.get() || stack.m_41720_() == ModItems.LEIVEKILTH_CHESTPLATE.get() || stack.m_41720_() == ModItems.LEIVEKILTH_LEGGINGS.get() || stack.m_41720_() == ModItems.LEIVEKILTH_BOOTS.get() || stack.m_41720_() == ModItems.RHYZA_HELMET.get() || stack.m_41720_() == ModItems.RHYZA_CHESTPLATE.get() || stack.m_41720_() == ModItems.RHYZA_LEGGINGS.get() || stack.m_41720_() == ModItems.RHYZA_BOOTS.get() || stack.m_41720_() == ModItems.RAKOTH_HELMET.get() || stack.m_41720_() == ModItems.RAKOTH_CHESTPLATE.get() || stack.m_41720_() == ModItems.RAKOTH_LEGGINGS.get() || stack.m_41720_() == ModItems.RAKOTH_BOOTS.get();
    }

    @SubscribeEvent
    public static void onArmorTooltip(ItemTooltipEvent event) {
        ItemStack stack = event.getItemStack();
        stack.getCapability(ModCapabilities.ARMOR_DATA).ifPresent(cap -> {
            Map<DamageTypes.ElementType, Integer> resistances = cap.getAllResistances();
            if (!resistances.isEmpty()) {
                event.getToolTip().add(Component.m_237119_());
                event.getToolTip().add(Component.m_237115_((String)"tooltip.monsterexpansion.resistances").m_130940_(ChatFormatting.GRAY).m_130946_(":"));
                resistances.forEach((type, value) -> {
                    if (value != 0) {
                        ChatFormatting color = value > 0 ? ChatFormatting.AQUA : ChatFormatting.RED;
                        String sign = value > 0 ? "+" : "";
                        event.getToolTip().add(Component.m_237113_((String)(" " + type.name() + ": " + sign + value)).m_130940_(color));
                    }
                });
            }
        });
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesPlayer(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof Player && !((Entity)event.getObject()).getCapability(PlayerStunProvider.PLAYER_STUN).isPresent()) {
            event.addCapability(new ResourceLocation("monsterexpansion", "properties_stun"), (ICapabilityProvider)new PlayerStunProvider());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.END) {
            event.player.getCapability(PlayerStunProvider.PLAYER_STUN).ifPresent(IPlayerStun::tick);
        }
    }

    @SubscribeEvent
    public static void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            event.getOriginal().getCapability(PlayerStunProvider.PLAYER_STUN).ifPresent(oldStore -> event.getEntity().getCapability(PlayerStunProvider.PLAYER_STUN).ifPresent(newStore -> {}));
        }
    }

    private static class MonsterWeaponProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        private final IMonsterWeapon implementation;
        private final LazyOptional<IMonsterWeapon> optional;

        public MonsterWeaponProvider(IMonsterWeapon impl) {
            this.implementation = impl;
            this.optional = LazyOptional.of(() -> this.implementation);
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == ModCapabilities.WEAPON_DATA) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return new CompoundTag();
        }

        public void deserializeNBT(CompoundTag nbt) {
        }
    }

    private static class MonsterArmorProvider
    implements ICapabilitySerializable<CompoundTag> {
        private final MonsterArmorImpl backend = new MonsterArmorImpl();
        private final LazyOptional<IMonsterArmor> optional = LazyOptional.of(() -> this.backend);

        private MonsterArmorProvider() {
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == ModCapabilities.ARMOR_DATA) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return this.backend.serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.backend.deserializeNBT(nbt);
        }
    }

    public static class PlayerStunProvider
    implements ICapabilityProvider,
    INBTSerializable<CompoundTag> {
        public static Capability<IPlayerStun> PLAYER_STUN = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPlayerStun>(){});
        private PlayerStunImpl stun = null;
        private final LazyOptional<IPlayerStun> optional = LazyOptional.of(this::createPlayerStun);

        private IPlayerStun createPlayerStun() {
            if (this.stun == null) {
                this.stun = new PlayerStunImpl();
            }
            return this.stun;
        }

        @NotNull
        public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
            if (cap == PLAYER_STUN) {
                return this.optional.cast();
            }
            return LazyOptional.empty();
        }

        public CompoundTag serializeNBT() {
            return (CompoundTag)this.createPlayerStun().serializeNBT();
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.createPlayerStun().deserializeNBT((Tag)nbt);
        }
    }
}

