/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import java.lang.reflect.Field;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.saksolm.monsterexpansion.MonsterExpansion;
import net.saksolm.monsterexpansion.effect.ModEffects;

@Mod.EventBusSubscriber(modid="monsterexpansion", value={Dist.CLIENT})
public class CloakedEffectInvisibilityEvents {
    private static Field shadowRadiusField;
    private static boolean reflectionFailed;

    @SubscribeEvent
    public static void onRenderLivingPre(RenderLivingEvent.Pre event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_21023_((MobEffect)ModEffects.CLOAKED.get())) {
            CloakedEffectInvisibilityEvents.trySetShadowRadius(event.getRenderer(), 0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRenderLivingPost(RenderLivingEvent.Post event) {
        CloakedEffectInvisibilityEvents.trySetShadowRadius(event.getRenderer(), 0.5f);
    }

    private static void trySetShadowRadius(EntityRenderer<?> entityRenderer, float radius) {
        if (reflectionFailed) {
            return;
        }
        try {
            if (shadowRadiusField == null) {
                shadowRadiusField = ObfuscationReflectionHelper.findField(EntityRenderer.class, (String)"shadowRadius");
                shadowRadiusField.setAccessible(true);
            }
            shadowRadiusField.setFloat(entityRenderer, radius);
        }
        catch (Exception e) {
            MonsterExpansion.LOGGER.warn("Could not access shadowRadius field. Shadows will not be hidden for cloaked entities. This is expected with mods like Iris/Oculus.");
            reflectionFailed = true;
        }
    }

    static {
        reflectionFailed = false;
    }
}

