/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.particles.options.ColorParticleOptions;

@Mod.EventBusSubscriber(modid="monsterexpansion", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class LeivekilthSetBonusEvents {
    @SubscribeEvent
    public static void onPlayerHurt(LivingHurtEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player) || (player = (Player)livingEntity).m_9236_().m_5776_()) {
            return;
        }
        if (!LeivekilthSetBonusEvents.isFullSetWorn(player)) {
            return;
        }
        if (player.m_217043_().m_188503_(5) == 0) {
            int particleCount = 30;
            for (int i = 0; i < 30; ++i) {
                double motionX = (player.m_217043_().m_188500_() - 0.5) * 0.3;
                double motionY = player.m_217043_().m_188500_() * 0.5;
                double motionZ = (player.m_217043_().m_188500_() - 0.5) * 0.3;
                ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.ICE_SHARD.get()), 1.0f, 1.0f, 1.0f, 0.3f, -1);
                Vec3 velocity = new Vec3(motionX, motionY, motionZ);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket(options, player.m_20182_().m_82549_(new Vec3(0.0, 0.5, 0.0)), velocity, true), (Entity)player);
                ModNetwork.sendToPlayer(new GenericParticlePacket(options, player.m_20182_().m_82549_(new Vec3(0.0, 0.5, 0.0)), velocity, true), (ServerPlayer)player);
            }
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11983_, player.m_5720_(), 1.0f, 1.0f);
            Vec3 center = player.m_20182_();
            AABB damageArea = new AABB(center.m_82492_(2.0, 0.0, 2.0), center.m_82520_(2.0, 2.5, 2.0));
            List targets = player.m_9236_().m_45976_(LivingEntity.class, damageArea);
            DamageSource damageSource = player.m_269291_().m_269333_((LivingEntity)player);
            for (LivingEntity target : targets) {
                if (target == player) continue;
                target.m_6469_(damageSource, 30.0f);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.player.m_9236_().m_5776_()) {
            return;
        }
        Player player = event.player;
        if (!LeivekilthSetBonusEvents.isFullSetWorn(player)) {
            return;
        }
        if (!player.m_20096_() && !player.m_20069_()) {
            return;
        }
        BlockPos playerPos = player.m_20183_();
        int frostWalkerLevel = 2;
        FrostWalkerEnchantment.m_45018_((LivingEntity)player, (Level)player.m_9236_(), (BlockPos)playerPos, (int)frostWalkerLevel);
    }

    public static boolean isFullSetWorn(Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        return helmet.m_41720_() == ModItems.LEIVEKILTH_HELMET.get() && chestplate.m_41720_() == ModItems.LEIVEKILTH_CHESTPLATE.get() && leggings.m_41720_() == ModItems.LEIVEKILTH_LEGGINGS.get() && boots.m_41720_() == ModItems.LEIVEKILTH_BOOTS.get();
    }
}

