/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.capabilities.ModCapabilities;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;
import net.saksolm.monsterexpansion.util.MonsterElementalDamageSource;

@Mod.EventBusSubscriber(modid="monsterexpansion", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MonsterElementalAttackEvents {
    @SubscribeEvent
    public static void onLivingHurt(LivingHurtEvent event) {
        DamageTypes.ElementType incomingElement;
        DamageSource source = event.getSource();
        if (source instanceof MonsterElementalDamageSource) {
            MonsterElementalDamageSource elementalSource = (MonsterElementalDamageSource)source;
            incomingElement = elementalSource.getElementType();
        } else {
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity;
                ItemStack weapon = attacker.m_21205_();
                incomingElement = weapon.getCapability(ModCapabilities.WEAPON_DATA).map(cap -> cap.getElementType(weapon)).orElse(DamageTypes.ElementType.NONE);
            } else {
                incomingElement = DamageTypes.ElementType.NONE;
            }
        }
        if (incomingElement == DamageTypes.ElementType.NONE) {
            return;
        }
        LivingEntity defender = event.getEntity();
        int totalResistance = 0;
        for (ItemStack stack : defender.m_6168_()) {
            totalResistance += stack.getCapability(ModCapabilities.ARMOR_DATA).map(cap -> cap.getResistance(incomingElement)).orElse(0).intValue();
        }
        if (totalResistance != 0) {
            float originalDamage = event.getAmount();
            float multiplier = 1.0f - (float)totalResistance / 100.0f;
            multiplier = Math.max(0.1f, multiplier);
            float newDamage = originalDamage * multiplier;
            event.setAmount(newDamage);
        }
        if (totalResistance >= 20 && incomingElement == DamageTypes.ElementType.ICE) {
            if (defender.m_21023_((MobEffect)ModEffects.FROSTVEIN.get())) {
                defender.m_21195_((MobEffect)ModEffects.FROSTVEIN.get());
            }
            if (defender.m_21023_(MobEffects.f_19597_)) {
                defender.m_21195_(MobEffects.f_19597_);
            }
        }
    }
}

