/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.item.ModItems;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RakothSetBonusEvents {
    private static final String SPRINT_TAG = "RakothSprintTicks";
    private static final int ACTIVATION_TIME = 40;
    private static final UUID STEP_ASSIST_ID = UUID.fromString("a25d84d7-1337-4a0f-9024-0000000abcde");

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !event.player.m_9236_().m_5776_()) {
            Player player = event.player;
            AttributeInstance stepAttribute = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
            if (RakothSetBonusEvents.hasFullRakothSet(player)) {
                if (stepAttribute != null && stepAttribute.m_22111_(STEP_ASSIST_ID) == null) {
                    stepAttribute.m_22118_(new AttributeModifier(STEP_ASSIST_ID, "Rakoth Step Assist", 0.6, AttributeModifier.Operation.ADDITION));
                }
                if (player.m_20142_()) {
                    int currentTicks = player.getPersistentData().m_128451_(SPRINT_TAG);
                    player.getPersistentData().m_128405_(SPRINT_TAG, currentTicks + 1);
                    if (currentTicks == 40) {
                        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12200_, SoundSource.PLAYERS, 1.0f, 0.5f);
                    }
                    if (currentTicks >= 40) {
                        ((ServerLevel)player.m_9236_()).m_8767_((ParticleOptions)ParticleTypes.f_123797_, player.m_20185_(), player.m_20186_() + 1.0, player.m_20189_(), 2, 0.3, 0.5, 0.3, 0.05);
                    }
                } else if (player.getPersistentData().m_128451_(SPRINT_TAG) > 0) {
                    player.getPersistentData().m_128405_(SPRINT_TAG, 0);
                }
            } else {
                if (player.getPersistentData().m_128451_(SPRINT_TAG) > 0) {
                    player.getPersistentData().m_128405_(SPRINT_TAG, 0);
                }
                if (stepAttribute != null && stepAttribute.m_22111_(STEP_ASSIST_ID) != null) {
                    stepAttribute.m_22120_(STEP_ASSIST_ID);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        DamageSource source;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && !(player = (Player)livingEntity).m_9236_().m_5776_() && RakothSetBonusEvents.hasFullRakothSet(player) && player.getPersistentData().m_128451_(SPRINT_TAG) >= 40 && ((source = event.getSource()).m_269014_() || source.m_7640_() instanceof Projectile)) {
            event.setCanceled(true);
            Entity projectile = source.m_7640_();
            if (projectile != null) {
                Vec3 motion = projectile.m_20184_();
                projectile.m_20256_(motion.m_82490_(-0.5).m_82520_((player.m_217043_().m_188500_() - 0.5) * 0.2, 0.2, (player.m_217043_().m_188500_() - 0.5) * 0.2));
                projectile.m_146922_(player.m_146908_());
            }
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11668_, SoundSource.PLAYERS, 0.5f, 1.5f + player.m_217043_().m_188501_() * 0.5f);
        }
    }

    private static boolean hasFullRakothSet(Player player) {
        return player.m_6844_(EquipmentSlot.HEAD).m_150930_((Item)ModItems.RAKOTH_HELMET.get()) && player.m_6844_(EquipmentSlot.CHEST).m_150930_((Item)ModItems.RAKOTH_CHESTPLATE.get()) && player.m_6844_(EquipmentSlot.LEGS).m_150930_((Item)ModItems.RAKOTH_LEGGINGS.get()) && player.m_6844_(EquipmentSlot.FEET).m_150930_((Item)ModItems.RAKOTH_BOOTS.get());
    }
}

