/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.entity.custom.effect.ShockwaveEntity;
import net.saksolm.monsterexpansion.entity.custom.effect.SmashedGroundEffectEntity;
import net.saksolm.monsterexpansion.item.ModItems;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.particles.options.BigDustParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DebrisParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DustParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;

@Mod.EventBusSubscriber(modid="monsterexpansion", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SkrytheSetBonusEvents {
    private static final UUID KNOCKBACK_RESISTANCE_UUID = UUID.fromString("0a647d95-8857-4148-be26-9a293f0b2f90");

    @SubscribeEvent
    public static void onLivingFall(LivingFallEvent event) {
        ServerPlayer player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof ServerPlayer && SkrytheSetBonusEvents.isFullSetWorn((Player)(player = (ServerPlayer)livingEntity))) {
            float fallDistance = event.getDistance();
            float finalDistance = Mth.m_14036_((float)fallDistance, (float)0.0f, (float)100.0f);
            if (fallDistance > 10.0f) {
                SkrytheSetBonusEvents.spawnShockwave(player.m_20182_(), 0.0f, 180.0f, finalDistance / 5.0f + 5.0f, finalDistance * 1.2f, 10, player.m_9236_(), (LivingEntity)player);
                event.setDistance(4.0f);
                if (fallDistance > 50.0f) {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), player.m_5720_(), 2.0f, 1.0f);
                    SkrytheSetBonusEvents.spawnSmashedGroundEffect(Vec3.f_82478_, 5.0f, 100, player.m_9236_(), (LivingEntity)player);
                    SkrytheSetBonusEvents.spawnGroundEffects(Vec3.f_82478_, 5.0f, 10, 10, 5, player.m_9236_(), (LivingEntity)player);
                    ModNetwork.sendToClientsTracking(new ScreenShakePacket(20, 5), (Entity)player);
                    ModNetwork.sendToPlayer(new ScreenShakePacket(20, 5), player);
                } else {
                    player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.SKRYTHE_LEG_STOMP.get(), player.m_5720_(), 2.0f, 1.0f);
                    SkrytheSetBonusEvents.spawnSmashedGroundEffect(Vec3.f_82478_, 2.0f, 100, player.m_9236_(), (LivingEntity)player);
                    SkrytheSetBonusEvents.spawnGroundEffects(Vec3.f_82478_, 2.0f, 5, 0, 1, player.m_9236_(), (LivingEntity)player);
                }
            } else {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChange(LivingEquipmentChangeEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            AttributeInstance knockbackResistance = player.m_21051_(Attributes.f_22278_);
            if (knockbackResistance == null) {
                return;
            }
            if (SkrytheSetBonusEvents.isFullSetWorn(player)) {
                if (knockbackResistance.m_22111_(KNOCKBACK_RESISTANCE_UUID) == null) {
                    knockbackResistance.m_22118_(new AttributeModifier(KNOCKBACK_RESISTANCE_UUID, "Skrythe Set Bonus", 4.0, AttributeModifier.Operation.ADDITION));
                }
            } else {
                knockbackResistance.m_22120_(KNOCKBACK_RESISTANCE_UUID);
            }
        }
    }

    private static boolean isFullSetWorn(Player player) {
        ItemStack helmet = player.m_6844_(EquipmentSlot.HEAD);
        ItemStack chestplate = player.m_6844_(EquipmentSlot.CHEST);
        ItemStack leggings = player.m_6844_(EquipmentSlot.LEGS);
        ItemStack boots = player.m_6844_(EquipmentSlot.FEET);
        return helmet.m_41720_() == ModItems.SKRYTHE_HELMET.get() && chestplate.m_41720_() == ModItems.SKRYTHE_CHESTPLATE.get() && leggings.m_41720_() == ModItems.SKRYTHE_LEGGINGS.get() && boots.m_41720_() == ModItems.SKRYTHE_BOOTS.get();
    }

    public static void spawnShockwave(Vec3 spawnPos, float yaw, float pitch, float maxRadius, float damage, int lifetime, Level level, LivingEntity owner) {
        if (!level.f_46443_) {
            ShockwaveEntity shockwave = new ShockwaveEntity(level, spawnPos, owner, maxRadius, damage, lifetime);
            shockwave.m_146922_(yaw);
            shockwave.m_146926_(pitch);
            level.m_7967_((Entity)shockwave);
        }
    }

    public static void spawnSmashedGroundEffect(Vec3 offset, float radius, int duration, Level level, LivingEntity owner) {
        if (!level.f_46443_) {
            Vec3 rotatedOffset = offset.m_82524_(-owner.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = owner.m_20182_().m_82549_(rotatedOffset);
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockState> states = new ArrayList<BlockState>();
            BlockPos center = BlockPos.m_274446_((Position)centerPos);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_((int)(-radius), -3, (int)(-radius)), (BlockPos)center.m_7918_((int)radius, 3, (int)radius))) {
                if (!(pos.m_123331_((Vec3i)center) <= (double)(radius * radius))) continue;
                BlockPos.MutableBlockPos groundPos = pos.m_122032_();
                while (level.m_8055_((BlockPos)groundPos).m_60795_() && groundPos.m_123342_() > level.m_141937_()) {
                    groundPos.m_122173_(Direction.DOWN);
                }
                BlockState groundState = level.m_8055_((BlockPos)groundPos);
                if (!groundState.m_280296_() || blocks.contains(groundPos)) continue;
                blocks.add(groundPos.m_7949_());
                states.add(groundState);
            }
            if (!blocks.isEmpty()) {
                SmashedGroundEffectEntity effect = new SmashedGroundEffectEntity(level, blocks, states, duration, radius);
                effect.m_146884_(centerPos);
                level.m_7967_((Entity)effect);
            }
        }
    }

    public static void spawnGroundEffects(Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount, Level level, LivingEntity owner) {
        if (!level.f_46443_) {
            double velZ;
            double velY;
            double velX;
            Object options;
            BlockState groundState;
            BlockPos groundPos;
            Vec3 particleSpawnPos;
            double offsetZ;
            double offsetX;
            double distance;
            double angle;
            int i;
            Vec3 rotatedOffset = offset.m_82524_(-owner.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = owner.m_20182_().m_82549_(rotatedOffset);
            for (i = 0; i < debrisCount; ++i) {
                angle = owner.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = owner.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DebrisParticleOptions(groundState);
                velX = (owner.m_217043_().m_188500_() - 0.5) * 0.8;
                velY = owner.m_217043_().m_188500_() * 0.8;
                velZ = (owner.m_217043_().m_188500_() - 0.5) * 0.8;
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ), true), (Entity)owner);
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, Vec3.f_82478_, true), (ServerPlayer)owner);
            }
            for (i = 0; i < dustCount; ++i) {
                angle = owner.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = owner.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DustParticleOptions(groundState);
                velX = (owner.m_217043_().m_188500_() - 0.5) * 0.15;
                velY = owner.m_217043_().m_188500_() * 0.15;
                velZ = (owner.m_217043_().m_188500_() - 0.5) * 0.15;
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ), true), (Entity)owner);
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, Vec3.f_82478_, true), (ServerPlayer)owner);
            }
            for (i = 0; i < bigDustCount; ++i) {
                angle = owner.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = owner.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new BigDustParticleOptions(groundState);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, Vec3.f_82478_, true), (Entity)owner);
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, Vec3.f_82478_, true), (ServerPlayer)owner);
            }
        }
    }
}

