/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import net.minecraft.client.Minecraft;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.item.SpireShellBulwarkItem;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class SpireShellEvents {
    private static final float MAX_BLOCK_SIZE_H = 3.5f;
    private static final float MAX_BLOCK_SIZE_W = 2.0f;
    private static final double REPEL_FORCE = 1.0;

    @SubscribeEvent
    public static void onLivingAttack(LivingAttackEvent event) {
        ItemStack activeItem;
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21254_() && (activeItem = player.m_21211_()).m_41720_() instanceof SpireShellBulwarkItem) {
            boolean isSmallAttacker;
            DamageSource source = event.getSource();
            String msgId = source.m_19385_();
            LivingEntity attacker = null;
            Entity entity = source.m_7639_();
            if (entity instanceof LivingEntity) {
                LivingEntity living;
                attacker = living = (LivingEntity)entity;
            }
            boolean isSonicBoom = "sonic_boom".equals(msgId);
            boolean isMagic = source.m_276093_(DamageTypes.f_268515_) || "magic".equals(msgId) || "dragonBreath".equals(msgId);
            boolean bl = isSmallAttacker = attacker != null && attacker.m_20206_() <= 3.5f && attacker.m_20205_() <= 2.0f;
            if ((isSonicBoom || isMagic || isSmallAttacker) && !(attacker instanceof AbstractLargeMonster) && SpireShellEvents.canBlockDamageSource(player, source)) {
                if (isSmallAttacker) {
                    Vec3 pushDir = attacker.m_20182_().m_82546_(player.m_20182_()).m_82541_();
                    if (pushDir.m_82556_() < 0.01) {
                        pushDir = player.m_20154_().m_82548_();
                    }
                    attacker.m_5997_(pushDir.f_82479_ * 1.0, 0.4, pushDir.f_82481_ * 1.0);
                    attacker.f_19864_ = true;
                }
                player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12346_, SoundSource.PLAYERS, 1.0f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                activeItem.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
                event.setCanceled(true);
            }
        }
    }

    private static boolean canBlockDamageSource(Player player, DamageSource source) {
        Vec3 sourcePos = source.m_7270_();
        if (sourcePos != null) {
            Vec3 toSourceVec;
            Vec3 viewVec = player.m_20252_(1.0f);
            return viewVec.m_82526_(toSourceVec = sourcePos.m_82546_(player.m_20182_()).m_82541_()) > 0.0;
        }
        return true;
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientEvents {
        @SubscribeEvent
        public static void onClientTick(TickEvent.PlayerTickEvent event) {
            Player player;
            if (event.phase == TickEvent.Phase.END && event.side.isClient() && (player = event.player).m_6117_() && player.m_21211_().m_41720_() instanceof SpireShellBulwarkItem && Minecraft.m_91087_().f_91066_.f_92091_.m_90857_()) {
                player.m_6858_(true);
            }
        }
    }
}

