/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.event;

import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.event.CapabilityEvents;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.StunFlagPacket;

public class StunnedEffectEvents {

    @Mod.EventBusSubscriber(modid="monsterexpansion")
    public static class CommonEvents {
        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onLivingJump(LivingEvent.LivingJumpEvent event) {
            if (event.getEntity().m_21023_((MobEffect)ModEffects.STUNNED.get())) {
                event.getEntity().m_20334_(event.getEntity().m_20184_().f_82479_, 0.0, event.getEntity().m_20184_().f_82481_);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
            if (event.getEntity().m_21023_((MobEffect)ModEffects.STUNNED.get())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onAttackEntity(AttackEntityEvent event) {
            if (event.getEntity().m_21023_((MobEffect)ModEffects.STUNNED.get())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onRightClick(PlayerInteractEvent.RightClickItem event) {
            if (event.getEntity().m_21023_((MobEffect)ModEffects.STUNNED.get())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        public static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            if (event.getEntity().m_21023_((MobEffect)ModEffects.STUNNED.get())) {
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onPlayerTakeDamage(LivingDamageEvent event) {
            Player player;
            LivingEntity livingEntity = event.getEntity();
            if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21023_((MobEffect)ModEffects.STUNNED.get())) {
                DamageSource source = event.getSource();
                if (source.m_276093_(DamageTypes.f_268671_)) {
                    return;
                }
                if (source.m_276093_(DamageTypes.f_268515_) || source.m_276093_(DamageTypes.f_268493_) || source.m_276093_(DamageTypes.f_268722_)) {
                    return;
                }
                player.m_21195_((MobEffect)ModEffects.STUNNED.get());
                player.getCapability(CapabilityEvents.PlayerStunProvider.PLAYER_STUN).ifPresent(stun -> stun.setStunValue(0));
                player.getPersistentData().m_128379_("StunParticlesActive", false);
                if (!player.m_9236_().m_5776_()) {
                    ModNetwork.sendToClientsTracking(new StunFlagPacket(player.m_19879_(), false), (Entity)player);
                    ModNetwork.sendToPlayer(new StunFlagPacket(player.m_19879_(), false), (ServerPlayer)player);
                }
            }
        }

        @Mod.EventBusSubscriber(modid="monsterexpansion", value={Dist.CLIENT})
        public static class ClientEvents {
            @SubscribeEvent
            public static void onInputUpdate(MovementInputUpdateEvent event) {
                if (event.getEntity().m_21023_((MobEffect)ModEffects.STUNNED.get())) {
                    event.getInput().f_108567_ = 0.0f;
                    event.getInput().f_108566_ = 0.0f;
                    event.getInput().f_108572_ = false;
                    event.getInput().f_108573_ = false;
                }
            }

            @SubscribeEvent
            public static void onMouseClick(InputEvent.MouseButton.Pre event) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91080_ != null) {
                    return;
                }
                if (event.getAction() == 0) {
                    return;
                }
                if (mc.f_91074_ != null && mc.f_91074_.m_21023_((MobEffect)ModEffects.STUNNED.get())) {
                    event.setCanceled(true);
                }
            }
        }
    }
}

