/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.item.enchant.ModEnchants;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class DuskrendItem
extends SwordItem {
    private static final String NBT_KEY_STACKS = "DuskrendStacks";
    private static final int STACK_DURATION_TICKS = 100;

    public DuskrendItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        Player player;
        if (pAttacker instanceof Player && !(player = (Player)pAttacker).m_9236_().m_5776_()) {
            CompoundTag nbt = pStack.m_41784_();
            int currentStacks = nbt.m_128451_(NBT_KEY_STACKS);
            int newStacks = Math.min(currentStacks + 1, this.getMaxStacks(pStack));
            nbt.m_128405_(NBT_KEY_STACKS, newStacks);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 100, (newStacks - 1) / 2, false, false, true));
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.RHYZA_FLASHBANG_HUM.get(), player.m_5720_(), 0.5f, 1.5f + (float)newStacks * 0.05f);
        }
        return super.m_7579_(pStack, pTarget, pAttacker);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        CompoundTag nbt = itemstack.m_41784_();
        int stacks = nbt.m_128451_(NBT_KEY_STACKS);
        if (!level.m_5776_() && stacks > 0) {
            float dashStrength = 1.0f + (float)stacks * 0.25f;
            float pitch = player.m_146909_();
            float yaw = player.m_146908_();
            if (pitch < -45.0f) {
                pitch = -45.0f;
            }
            float f = pitch * ((float)Math.PI / 180);
            float f1 = -yaw * ((float)Math.PI / 180);
            float f2 = Mth.m_14089_((float)f1);
            float f3 = Mth.m_14031_((float)f1);
            float f4 = Mth.m_14089_((float)f);
            float f5 = Mth.m_14031_((float)f);
            Vec3 dashDirection = new Vec3((double)(f3 * f4), (double)(-f5), (double)(f2 * f4));
            player.m_20334_(dashDirection.f_82479_ * (double)dashStrength, dashDirection.f_82480_ * (double)dashStrength * 0.6 + 0.2, dashDirection.f_82481_ * (double)dashStrength);
            player.f_19864_ = true;
            player.f_19789_ = 0.0f;
            nbt.m_128405_(NBT_KEY_STACKS, 0);
            player.m_21195_(MobEffects.f_19596_);
            level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.RHYZA_DASH.get(), player.m_5720_(), 1.0f, 1.0f);
            player.m_36335_().m_41524_((Item)this, 40);
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_6883_(ItemStack pStack, Level pLevel, Entity pEntity, int pSlotId, boolean pIsSelected) {
        if (!pLevel.m_5776_() && pEntity instanceof Player) {
            Player player = (Player)pEntity;
            CompoundTag nbt = pStack.m_41784_();
            if (nbt.m_128451_(NBT_KEY_STACKS) > 0 && !player.m_21023_(MobEffects.f_19596_)) {
                nbt.m_128405_(NBT_KEY_STACKS, 0);
            }
        }
        super.m_6883_(pStack, pLevel, pEntity, pSlotId, pIsSelected);
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        CompoundTag nbt = pStack.m_41784_();
        int stacks = nbt.m_128451_(NBT_KEY_STACKS);
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.duskrend.description").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7A7A7A)).m_131155_(Boolean.valueOf(true))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.duskrend.on_hit").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12086828))).m_7220_((Component)Component.m_237115_((String)"tooltip.monsterexpansion.duskrend.on_hit.effect").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xDDDDDD)))));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.duskrend.use").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12086828))).m_7220_((Component)Component.m_237115_((String)"tooltip.monsterexpansion.duskrend.use.effect").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xDDDDDD)))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.duskrend.frenzy_stacks").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xAAAACC))).m_7220_((Component)Component.m_237113_((String)(stacks + " / " + this.getMaxStacks(pStack))).m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xDDA0DD)))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.duskrend.flavor").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7A7A7A)).m_131155_(Boolean.valueOf(true))));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public Component m_7626_(ItemStack pStack) {
        Style nameStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)9055202)).m_131136_(Boolean.valueOf(false));
        return super.m_7626_(pStack).m_6881_().m_6270_(nameStyle);
    }

    public boolean m_5812_(ItemStack pStack) {
        return pStack.m_41784_().m_128451_(NBT_KEY_STACKS) > 0;
    }

    private int getMaxStacks(ItemStack pStack) {
        int enchantLevel = this.getEnchantmentLevel(pStack, (Enchantment)ModEnchants.LUNACY.get());
        return 5 + enchantLevel;
    }
}

