/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.item;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.effect.ShockwaveEntity;
import net.saksolm.monsterexpansion.entity.custom.effect.SmashedGroundEffectEntity;
import net.saksolm.monsterexpansion.entity.custom.projectile.DistortionOrbProjectile;
import net.saksolm.monsterexpansion.entity.custom.projectile.SoundSphereProjectile;
import net.saksolm.monsterexpansion.item.enchant.ModEnchants;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.network.SoundPacket;
import net.saksolm.monsterexpansion.particles.options.BigDustParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DebrisParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DustParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class HornOfTheShattercryItem
extends SwordItem {
    private static final int ROAR_CHARGE_TIME = 100;
    private static final int PROJECTILE_CHARGE_TIME = 31;
    private static final String NBT_KEY_ATTACK_TYPE = "HornAttackType";
    private static final String NBT_KEY_TICK_COUNTER = "HornChargeTicks";

    public HornOfTheShattercryItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pAttackDamageModifier, pAttackSpeedModifier, pProperties);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.BOW;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        CompoundTag nbt = itemstack.m_41784_();
        nbt.m_128379_("is_rotated", true);
        if (!level.f_46443_) {
            ModNetwork.sendToClientsTracking(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_ROAR.get()).m_11660_(), false), (Entity)player);
            ModNetwork.sendToPlayer(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_ROAR.get()).m_11660_(), false), (ServerPlayer)player);
            ModNetwork.sendToClientsTracking(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_CHARGE.get()).m_11660_(), false), (Entity)player);
            ModNetwork.sendToPlayer(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_CHARGE.get()).m_11660_(), false), (ServerPlayer)player);
        }
        if (player.m_6047_() && player.m_20096_()) {
            if (!level.m_5776_()) {
                nbt.m_128359_(NBT_KEY_ATTACK_TYPE, "roar");
                nbt.m_128405_(NBT_KEY_TICK_COUNTER, 0);
                ModNetwork.sendToClientsTracking(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_ROAR.get()).m_11660_(), true), (Entity)player);
                ModNetwork.sendToPlayer(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_ROAR.get()).m_11660_(), true), (ServerPlayer)player);
            }
        } else {
            if (!level.m_5776_()) {
                nbt.m_128359_(NBT_KEY_ATTACK_TYPE, "projectile");
                nbt.m_128405_(NBT_KEY_TICK_COUNTER, 0);
                ModNetwork.sendToClientsTracking(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_CHARGE.get()).m_11660_(), true), (Entity)player);
                ModNetwork.sendToPlayer(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_CHARGE.get()).m_11660_(), true), (ServerPlayer)player);
            }
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5929_(Level level, LivingEntity livingEntity, ItemStack stack, int tickCount) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (!player.m_6117_()) {
            this.m_5551_(stack, level, livingEntity, 0);
            return;
        }
        CompoundTag nbt = stack.m_41784_();
        String attackType = nbt.m_128461_(NBT_KEY_ATTACK_TYPE);
        if ("roar".equals(attackType)) {
            if (!player.m_6047_() || !player.m_20096_()) {
                this.m_5551_(stack, level, livingEntity, 0);
                player.m_36335_().m_41524_((Item)this, 10);
                return;
            }
            if (!level.m_5776_()) {
                int currentTicks = nbt.m_128451_(NBT_KEY_TICK_COUNTER) + 1;
                nbt.m_128405_(NBT_KEY_TICK_COUNTER, currentTicks);
                if (currentTicks >= 100) {
                    int enchantLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchants.ECHOING_REACH.get()), (LivingEntity)livingEntity);
                    this.spawnShockwave(level, livingEntity);
                    this.spawnGroundEffects(level, livingEntity, Vec3.f_82478_, 3 + enchantLevel * 3, 10 + enchantLevel * 10, 20 + enchantLevel * 10, 3 + enchantLevel * 3);
                    this.spawnSmashedGroundEffect(level, livingEntity, Vec3.f_82478_, 3.0f + (float)enchantLevel * 1.5f, 100);
                    ModNetwork.sendToClientsTracking(new ScreenShakePacket(20, 5), (Entity)player);
                    if (player instanceof ServerPlayer) {
                        ModNetwork.sendToPlayer(new ScreenShakePacket(20, 5), (ServerPlayer)player);
                    }
                    AABB hitbox = livingEntity.m_20191_().m_82400_((double)(5.0f + (float)(enchantLevel * 5)));
                    for (LivingEntity entity : level.m_45976_(LivingEntity.class, hitbox)) {
                        if (entity == livingEntity) continue;
                        Multimap modifiers = stack.m_41638_(EquipmentSlot.MAINHAND);
                        double attackDamage = livingEntity.m_21051_(Attributes.f_22281_).m_22135_();
                        entity.m_6469_(livingEntity.m_269291_().m_269333_(livingEntity), (float)(attackDamage * 10.0));
                    }
                    livingEntity.m_9236_().m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), livingEntity.m_5720_(), 2.0f, 1.0f);
                    this.m_5551_(stack, level, livingEntity, 0);
                    player.m_36335_().m_41524_((Item)this, 100);
                }
            }
        } else if ("projectile".equals(attackType)) {
            if (player.m_6047_()) {
                this.m_5551_(stack, level, livingEntity, 0);
                player.m_36335_().m_41524_((Item)this, 10);
                return;
            }
            if (!level.m_5776_()) {
                int currentTicks = nbt.m_128451_(NBT_KEY_TICK_COUNTER) + 1;
                nbt.m_128405_(NBT_KEY_TICK_COUNTER, currentTicks);
                if (currentTicks >= 31) {
                    livingEntity.m_9236_().m_6263_(null, livingEntity.m_20185_(), livingEntity.m_20186_(), livingEntity.m_20189_(), (SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_FIRE.get(), livingEntity.m_5720_(), 1.0f, 1.0f);
                    this.fireOrb(level, livingEntity);
                    this.m_5551_(stack, level, livingEntity, 0);
                    player.m_36335_().m_41524_((Item)this, 31);
                }
            }
        }
    }

    public void m_5551_(ItemStack stack, Level level, LivingEntity livingEntity, int tickCount) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        CompoundTag nbt = stack.m_41784_();
        nbt.m_128379_("is_rotated", false);
        if (!level.f_46443_) {
            nbt.m_128405_(NBT_KEY_TICK_COUNTER, 0);
            nbt.m_128359_(NBT_KEY_ATTACK_TYPE, "");
            ModNetwork.sendToClientsTracking(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_ROAR.get()).m_11660_(), false), (Entity)player);
            ModNetwork.sendToPlayer(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_ROAR.get()).m_11660_(), false), (ServerPlayer)player);
            ModNetwork.sendToClientsTracking(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_CHARGE.get()).m_11660_(), false), (Entity)player);
            ModNetwork.sendToPlayer(new SoundPacket(((SoundEvent)ModSounds.HORN_OF_THE_SHATTERCRY_CHARGE.get()).m_11660_(), false), (ServerPlayer)player);
        }
        livingEntity.m_5810_();
    }

    private void spawnShockwave(Level level, LivingEntity livingEntity) {
        Vec3 spawnPos = livingEntity.m_20182_().m_82520_(0.0, 1.0, 0.0);
        float yaw = livingEntity.m_146908_();
        float pitch = livingEntity.m_146909_();
        int enchantLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchants.ECHOING_REACH.get()), (LivingEntity)livingEntity);
        float maxRadius = 15.0f + (float)(enchantLevel * 10);
        float damage = 5.0f;
        int lifetime = 40;
        ShockwaveEntity shockwave = new ShockwaveEntity(level, spawnPos, livingEntity, maxRadius, damage, lifetime);
        shockwave.m_146922_(0.0f);
        shockwave.m_146926_(180.0f);
        level.m_7967_((Entity)shockwave);
    }

    private void fireOrb(Level level, LivingEntity livingEntity) {
        if (level.f_46443_) {
            return;
        }
        int polyphonyLevel = EnchantmentHelper.m_44836_((Enchantment)((Enchantment)ModEnchants.POLYPHONY.get()), (LivingEntity)livingEntity);
        boolean distoritonOrbCount = true;
        int soundSphereCount = polyphonyLevel * 2;
        Vec3 playerPos = livingEntity.m_20182_().m_82520_(0.0, (double)livingEntity.m_20192_(), 0.0);
        Vec3 lookVec = livingEntity.m_20154_();
        DistortionOrbProjectile orbProjectile = new DistortionOrbProjectile(level, livingEntity);
        orbProjectile.m_146884_(playerPos);
        orbProjectile.m_20256_(lookVec.m_82490_(1.5));
        level.m_7967_((Entity)orbProjectile);
        level.m_7605_((Entity)orbProjectile, (byte)4);
        for (int i = 0; i < soundSphereCount; ++i) {
            float scatterAmount = 0.1f * (float)polyphonyLevel;
            double scatterX = (Math.random() - 0.5) * (double)scatterAmount;
            double scatterY = (Math.random() - 0.5) * (double)scatterAmount;
            double scatterZ = (Math.random() - 0.5) * (double)scatterAmount;
            Vec3 scatteredVec = lookVec.m_82520_(scatterX, scatterY, scatterZ).m_82541_();
            SoundSphereProjectile sphereProjectile = new SoundSphereProjectile(level, livingEntity);
            sphereProjectile.m_146884_(playerPos);
            sphereProjectile.m_20256_(scatteredVec.m_82490_(1.5));
            level.m_7967_((Entity)sphereProjectile);
            level.m_7605_((Entity)sphereProjectile, (byte)4);
        }
    }

    public void spawnSmashedGroundEffect(Level level, LivingEntity entity, Vec3 offset, float radius, int duration) {
        if (!level.f_46443_) {
            Vec3 rotatedOffset = offset.m_82524_(-entity.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = entity.m_20182_().m_82549_(rotatedOffset);
            ArrayList<BlockPos> blocks = new ArrayList<BlockPos>();
            ArrayList<BlockState> states = new ArrayList<BlockState>();
            BlockPos center = BlockPos.m_274446_((Position)centerPos);
            for (BlockPos pos : BlockPos.m_121940_((BlockPos)center.m_7918_((int)(-radius), -3, (int)(-radius)), (BlockPos)center.m_7918_((int)radius, 3, (int)radius))) {
                if (!(pos.m_123331_((Vec3i)center) <= (double)(radius * radius))) continue;
                BlockPos.MutableBlockPos groundPos = pos.m_122032_();
                while (level.m_8055_((BlockPos)groundPos).m_60795_() && groundPos.m_123342_() > level.m_141937_()) {
                    groundPos.m_122173_(Direction.DOWN);
                }
                BlockState groundState = level.m_8055_((BlockPos)groundPos);
                if (!groundState.m_280296_() || blocks.contains(groundPos)) continue;
                blocks.add(groundPos.m_7949_());
                states.add(groundState);
            }
            if (!blocks.isEmpty()) {
                SmashedGroundEffectEntity effect = new SmashedGroundEffectEntity(level, blocks, states, duration, radius);
                effect.m_146884_(centerPos);
                level.m_7967_((Entity)effect);
            }
        }
    }

    public void spawnGroundEffects(Level level, LivingEntity entity, Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount) {
        if (!level.f_46443_) {
            ServerPlayer player;
            double velZ;
            double velY;
            double velX;
            Object options;
            BlockState groundState;
            BlockPos groundPos;
            Vec3 particleSpawnPos;
            double offsetZ;
            double offsetX;
            double distance;
            double angle;
            int i;
            Vec3 rotatedOffset = offset.m_82524_(-entity.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = entity.m_20182_().m_82549_(rotatedOffset);
            for (i = 0; i < debrisCount; ++i) {
                angle = entity.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = entity.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DebrisParticleOptions(groundState);
                velX = (entity.m_217043_().m_188500_() - 0.5) * 0.8;
                velY = entity.m_217043_().m_188500_() * 0.8;
                velZ = (entity.m_217043_().m_188500_() - 0.5) * 0.8;
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ), true), (Entity)entity);
                if (!(entity instanceof ServerPlayer)) continue;
                player = (ServerPlayer)entity;
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ), true), player);
            }
            for (i = 0; i < dustCount; ++i) {
                angle = entity.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = entity.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DustParticleOptions(groundState);
                velX = (entity.m_217043_().m_188500_() - 0.5) * 0.15;
                velY = entity.m_217043_().m_188500_() * 0.15;
                velZ = (entity.m_217043_().m_188500_() - 0.5) * 0.15;
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ), true), (Entity)entity);
                if (!(entity instanceof ServerPlayer)) continue;
                player = (ServerPlayer)entity;
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, new Vec3(velX, velY, velZ), true), player);
            }
            for (i = 0; i < bigDustCount; ++i) {
                angle = entity.m_217043_().m_188500_() * 2.0 * Math.PI;
                distance = entity.m_217043_().m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new BigDustParticleOptions(groundState);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, Vec3.f_82478_, true), (Entity)entity);
                if (!(entity instanceof ServerPlayer)) continue;
                ServerPlayer player2 = (ServerPlayer)entity;
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, Vec3.f_82478_, true), player2);
            }
        }
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.horn_of_shattercry.description").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7A7A7A)).m_131155_(Boolean.valueOf(true))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.horn_of_shattercry.crouch_use").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12086828))).m_7220_((Component)Component.m_237115_((String)"tooltip.monsterexpansion.horn_of_shattercry.roar").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xDDDDDD)))));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.horn_of_shattercry.standing_use").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12086828))).m_7220_((Component)Component.m_237115_((String)"tooltip.monsterexpansion.horn_of_shattercry.projectile").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xDDDDDD)))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.horn_of_shattercry.flavor").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7A7A7A)).m_131155_(Boolean.valueOf(true))));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public Component m_7626_(ItemStack pStack) {
        Component defaultName = super.m_7626_(pStack);
        Style nameStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)14720054)).m_131136_(Boolean.valueOf(false));
        return defaultName.m_6881_().m_6270_(nameStyle);
    }
}

