/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class MaceItem
extends TieredItem {
    private final float attackDamage;
    private final float attackSpeedModifier;

    public MaceItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pProperties);
        this.attackDamage = (float)pAttackDamageModifier + pTier.m_6631_();
        this.attackSpeedModifier = pAttackSpeedModifier;
    }

    public boolean m_7579_(ItemStack pStack, LivingEntity pTarget, LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, player -> player.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.getAttributeModifiers(slot, stack));
        if (slot == EquipmentSlot.MAINHAND) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeedModifier, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return !pPlayer.m_7500_();
    }

    public int m_6473_() {
        return this.m_43314_().m_6601_();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        if (enchantment.f_44672_ == EnchantmentCategory.WEAPON) {
            return true;
        }
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }
}

