/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.saksolm.monsterexpansion.effect.ModEffects;
import net.saksolm.monsterexpansion.network.GenericParticlePacket;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ScreenShakePacket;
import net.saksolm.monsterexpansion.particles.options.BigDustParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DebrisParticleOptions;
import net.saksolm.monsterexpansion.particles.options.DustParticleOptions;
import net.saksolm.monsterexpansion.sounds.ModSounds;

public class SpireShellBulwarkItem
extends TieredItem {
    private static final int SUNDERED_DURATION = 160;
    private static final int SUNDERED_AMPLIFIER = 0;
    private static final float MIN_RAM_DAMAGE = 4.0f;
    private static final float MAX_RAM_DAMAGE = 30.0f;
    private static final float RAM_KNOCKBACK = 1.5f;
    private static final int CRASH_COOLDOWN = 100;
    private static final double MIN_CHARGE_SPEED = 0.15;
    private static final double MAX_CHARGE_SPEED = 0.75;
    private static final float ACCELERATION_TIME = 100.0f;
    private static final double TURN_FACTOR = 0.12;
    private final float attackDamage;
    private final float attackSpeedModifier;

    public SpireShellBulwarkItem(Tier pTier, int pAttackDamageModifier, float pAttackSpeedModifier, Item.Properties pProperties) {
        super(pTier, pProperties);
        this.attackDamage = (float)pAttackDamageModifier + pTier.m_6631_();
        this.attackSpeedModifier = pAttackSpeedModifier;
    }

    public UseAnim m_6164_(ItemStack pStack) {
        return UseAnim.BLOCK;
    }

    public int m_8105_(ItemStack pStack) {
        return 72000;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (pPlayer.m_36335_().m_41519_((Item)this)) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5929_(Level pLevel, LivingEntity pLivingEntity, ItemStack pStack, int pRemainingUseDuration) {
        if (!(pLivingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)pLivingEntity;
        if (player.m_36335_().m_41519_((Item)this)) {
            player.m_5810_();
            return;
        }
        if (player.m_20142_()) {
            Vec3 newVelocity;
            if (!pStack.m_41784_().m_128471_("IsCharging")) {
                pStack.m_41784_().m_128379_("IsCharging", true);
            }
            if (!player.m_20096_()) {
                pStack.m_41784_().m_128473_("IsCharging");
                player.m_36335_().m_41524_((Item)this, 50);
                player.m_5810_();
                Vec3 currentVel = player.m_20184_();
                player.m_20334_(currentVel.f_82479_ * 0.1, currentVel.f_82480_, currentVel.f_82481_ * 0.1);
                player.f_19864_ = true;
                return;
            }
            int durationUsed = this.m_8105_(pStack) - pRemainingUseDuration;
            float progress = Mth.m_14036_((float)((float)durationUsed / 100.0f), (float)0.0f, (float)1.0f);
            double currentSpeed = Mth.m_14139_((double)progress, (double)0.15, (double)0.75);
            float currentDamage = Mth.m_14179_((float)progress, (float)4.0f, (float)30.0f);
            Vec3 currentVel = player.m_20184_();
            Vec3 lookVec = player.m_20154_();
            Vec3 currentDir = new Vec3(currentVel.f_82479_, 0.0, currentVel.f_82481_);
            Vec3 targetDir = new Vec3(lookVec.f_82479_, 0.0, lookVec.f_82481_).m_82541_();
            if (currentDir.m_82556_() < 0.01) {
                newVelocity = targetDir.m_82490_(currentSpeed);
            } else {
                currentDir = currentDir.m_82541_();
                Vec3 steeredDir = currentDir.m_165921_(targetDir, 0.12).m_82541_();
                newVelocity = steeredDir.m_82490_(currentSpeed);
            }
            if (this.willHitWall(pLevel, player, newVelocity)) {
                if (!pLevel.f_46443_) {
                    this.triggerCrash(pLevel, player, pStack);
                }
                return;
            }
            player.m_20334_(newVelocity.f_82479_, currentVel.f_82480_, newVelocity.f_82481_);
            player.f_19864_ = true;
            this.spawnGroundEffects(pLevel, (LivingEntity)player, player.m_20182_(), Vec3.f_82478_, 1.0f, 1, 2, 0, new Vec3(0.0, 0.1, 0.0), 1.0f, 1.0f);
            if (pRemainingUseDuration % 5 == 0) {
                float pitch = 0.5f + progress * 0.3f;
                pLevel.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.RAKOTH_GALLOP.get(), SoundSource.PLAYERS, 0.5f, pitch);
            }
            if (!pLevel.f_46443_) {
                AABB hitbox = player.m_20191_().m_82377_(1.0, 0.2, 1.0).m_82383_(newVelocity);
                List targets = pLevel.m_6443_(LivingEntity.class, hitbox, e -> e != player && e.m_6084_() && !e.m_7307_((Entity)player));
                boolean hitSomething = false;
                for (LivingEntity target : targets) {
                    if (!target.m_6469_(pLevel.m_269111_().m_269075_(player), currentDamage)) continue;
                    hitSomething = true;
                    target.m_5997_(player.m_20154_().f_82479_ * 1.5, 0.4, player.m_20154_().f_82481_ * 1.5);
                    target.m_7292_(new MobEffectInstance((MobEffect)ModEffects.BLEEDING.get(), 160, 0));
                }
                if (hitSomething) {
                    this.triggerCrash(pLevel, player, pStack);
                }
            }
        } else if (pStack.m_41784_().m_128471_("IsCharging")) {
            if (!player.m_36335_().m_41519_((Item)this)) {
                player.m_36335_().m_41524_((Item)this, 50);
            }
            pStack.m_41784_().m_128379_("IsCharging", false);
            player.m_5810_();
        }
    }

    private boolean willHitWall(Level level, Player player, Vec3 velocity) {
        Vec3 direction;
        Vec3 end;
        double stepAddition = 0.0;
        AttributeInstance stepAttr = player.m_21051_((Attribute)ForgeMod.STEP_HEIGHT_ADDITION.get());
        if (stepAttr != null) {
            stepAddition = stepAttr.m_22135_();
        }
        double rayHeight = 0.5 + stepAddition;
        Vec3 start = player.m_20182_().m_82520_(0.0, rayHeight, 0.0);
        BlockHitResult hit = level.m_45547_(new ClipContext(start, end = start.m_82549_((direction = new Vec3(velocity.f_82479_, 0.0, velocity.f_82481_).m_82541_()).m_82490_(1.2)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
        if (hit.m_6662_() == HitResult.Type.BLOCK) {
            return hit.m_82434_().m_122434_().m_122479_();
        }
        return false;
    }

    private void triggerCrash(Level level, Player player, ItemStack stack) {
        level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)ModSounds.GENERIC_LARGE_STOMP.get(), SoundSource.PLAYERS, 1.0f, 0.8f);
        stack.m_41784_().m_128473_("IsCharging");
        this.spawnGroundEffects(level, (LivingEntity)player, player.m_20182_(), Vec3.f_82478_, 2.5f, 8, 15, 3, new Vec3(0.0, 0.2, 0.0), 2.0f, 1.5f);
        ModNetwork.sendToClientsTracking(new ScreenShakePacket(100, 1), (Entity)player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModNetwork.sendToPlayer(new ScreenShakePacket(50, 5), serverPlayer);
        }
        stack.m_41622_(2, (LivingEntity)player, p -> p.m_21190_(player.m_7655_()));
        player.m_36335_().m_41524_((Item)this, 100);
        player.m_5810_();
        player.m_20334_(0.0, 0.0, 0.0);
        player.f_19864_ = true;
    }

    public void m_5551_(ItemStack pStack, Level pLevel, LivingEntity pLivingEntity, int pTimeLeft) {
        Player player;
        pStack.m_41784_().m_128473_("IsCharging");
        if (pLivingEntity instanceof Player && (player = (Player)pLivingEntity).m_20142_() && !player.m_36335_().m_41519_((Item)this)) {
            player.m_36335_().m_41524_((Item)this, 50);
        }
        super.m_5551_(pStack, pLevel, pLivingEntity, pTimeLeft);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return slotChanged || oldStack.m_41720_() != newStack.m_41720_();
    }

    public void spawnGroundEffects(Level level, LivingEntity sourceEntity, Vec3 anchor, Vec3 offset, float spawnRadius, int debrisCount, int dustCount, int bigDustCount, Vec3 velocityBias, float horizontalPower, float verticalPower) {
        if (!level.f_46443_) {
            ServerPlayer player;
            Vec3 finalVelocity;
            double randomZ;
            double randomY;
            double randomX;
            Object options;
            BlockState groundState;
            BlockPos groundPos;
            Vec3 particleSpawnPos;
            double offsetZ;
            double offsetX;
            double distance;
            double angle;
            int i;
            Vec3 rotatedOffset = offset.m_82524_(-sourceEntity.f_20883_ * ((float)Math.PI / 180));
            Vec3 rotatedVelocityBias = velocityBias.m_82524_(-sourceEntity.f_20883_ * ((float)Math.PI / 180));
            Vec3 centerPos = anchor.m_82549_(rotatedOffset);
            for (i = 0; i < debrisCount; ++i) {
                angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
                distance = level.f_46441_.m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DebrisParticleOptions(groundState);
                randomX = (level.f_46441_.m_188500_() - 0.5) * 0.8 * (double)horizontalPower;
                randomY = level.f_46441_.m_188500_() * 0.8 * (double)verticalPower;
                randomZ = (level.f_46441_.m_188500_() - 0.5) * 0.8 * (double)horizontalPower;
                finalVelocity = new Vec3(randomX, randomY, randomZ).m_82549_(rotatedVelocityBias);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, finalVelocity, true), (Entity)sourceEntity);
                if (!(sourceEntity instanceof ServerPlayer)) continue;
                player = (ServerPlayer)sourceEntity;
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, finalVelocity, true), player);
            }
            for (i = 0; i < dustCount; ++i) {
                angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
                distance = level.f_46441_.m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new DustParticleOptions(groundState);
                randomX = (level.f_46441_.m_188500_() - 0.5) * 0.15 * (double)horizontalPower;
                randomY = level.f_46441_.m_188500_() * 0.15 * (double)verticalPower;
                randomZ = (level.f_46441_.m_188500_() - 0.5) * 0.15 * (double)horizontalPower;
                finalVelocity = new Vec3(randomX, randomY, randomZ).m_82549_(rotatedVelocityBias);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, finalVelocity, true), (Entity)sourceEntity);
                if (!(sourceEntity instanceof ServerPlayer)) continue;
                player = (ServerPlayer)sourceEntity;
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, finalVelocity, true), player);
            }
            for (i = 0; i < bigDustCount; ++i) {
                angle = level.f_46441_.m_188500_() * 2.0 * Math.PI;
                distance = level.f_46441_.m_188500_() * (double)spawnRadius;
                offsetX = Math.cos(angle) * distance;
                particleSpawnPos = centerPos.m_82520_(offsetX, 0.2, offsetZ = Math.sin(angle) * distance);
                groundPos = BlockPos.m_274446_((Position)particleSpawnPos).m_7495_();
                groundState = level.m_8055_(groundPos);
                if (groundState.m_60795_()) continue;
                options = new BigDustParticleOptions(groundState);
                ModNetwork.sendToClientsTracking(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, rotatedVelocityBias, true), (Entity)sourceEntity);
                if (!(sourceEntity instanceof ServerPlayer)) continue;
                ServerPlayer player2 = (ServerPlayer)sourceEntity;
                ModNetwork.sendToPlayer(new GenericParticlePacket((ParticleOptions)options, particleSpawnPos, rotatedVelocityBias, true), player2);
            }
        }
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == ToolActions.SHIELD_BLOCK;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.putAll(super.getAttributeModifiers(slot, stack));
        if (slot == EquipmentSlot.MAINHAND) {
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.attackDamage, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.attackSpeedModifier, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22278_, (Object)new AttributeModifier(UUID.randomUUID(), "Shield modifier", 0.2, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public boolean m_6777_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer) {
        return !pPlayer.m_7500_();
    }

    public void m_7373_(ItemStack pStack, @Nullable Level pLevel, List<Component> pTooltipComponents, TooltipFlag pIsAdvanced) {
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.spireshellbulwark.description").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7A7A7A)).m_131155_(Boolean.valueOf(true))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.spireshellbulwark.charge").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12086828))).m_7220_((Component)Component.m_237115_((String)"tooltip.monsterexpansion.spireshellbulwark.charge_details").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xE0E0E0)))));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.spireshellbulwark.passive").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)12086828))).m_7220_((Component)Component.m_237115_((String)"tooltip.monsterexpansion.spireshellbulwark.passive_details").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0xE0E0E0)))));
        pTooltipComponents.add((Component)Component.m_237113_((String)""));
        pTooltipComponents.add((Component)Component.m_237115_((String)"tooltip.monsterexpansion.spireshellbulwark.flavor").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131266_((int)0x7A7A7A)).m_131155_(Boolean.valueOf(true))));
        super.m_7373_(pStack, pLevel, pTooltipComponents, pIsAdvanced);
    }

    public Component m_7626_(ItemStack pStack) {
        Style nameStyle = Style.f_131099_.m_131148_(TextColor.m_131266_((int)13935475)).m_131136_(Boolean.valueOf(false));
        return super.m_7626_(pStack).m_6881_().m_6270_(nameStyle);
    }
}

