/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkEvent;
import net.saksolm.monsterexpansion.particles.ModParticles;

public class ShockwaveEffectPacket {
    public final Vec3 pos;
    public final Vec3 look;

    public ShockwaveEffectPacket(Vec3 pos, Vec3 look) {
        this.pos = pos;
        this.look = look.m_82541_();
    }

    public static void encode(ShockwaveEffectPacket pkt, FriendlyByteBuf buf) {
        buf.writeDouble(pkt.pos.f_82479_);
        buf.writeDouble(pkt.pos.f_82480_);
        buf.writeDouble(pkt.pos.f_82481_);
        buf.writeDouble(pkt.look.f_82479_);
        buf.writeDouble(pkt.look.f_82480_);
        buf.writeDouble(pkt.look.f_82481_);
    }

    public static ShockwaveEffectPacket decode(FriendlyByteBuf buf) {
        Vec3 pos = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        Vec3 look = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        return new ShockwaveEffectPacket(pos, look);
    }

    public static void handle(ShockwaveEffectPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91074_ != null && mc.f_91073_ != null) {
                Vec3 mouthPos = pkt.pos.m_82549_(pkt.look.m_82490_(5.0)).m_82520_(0.0, 5.0, 0.0);
                for (int i = 0; i < 1; ++i) {
                    double angle = (double)i * 0.7853981633974483;
                    double xOffset = Math.cos(angle) * 0.5;
                    double zOffset = Math.sin(angle) * 0.5;
                    mc.f_91073_.m_7106_((ParticleOptions)ModParticles.SHOCKWAVE.get(), mouthPos.f_82479_ + xOffset, mouthPos.f_82480_, mouthPos.f_82481_ + zOffset, xOffset * 0.2, 0.0, zOffset * 0.2);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

