/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.network;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkEvent;
import net.saksolm.monsterexpansion.sounds.ClientSoundManager;

public class SoundPacket {
    public final ResourceLocation soundLocation;
    public final boolean playSound;
    public final SoundType soundType;

    public SoundPacket(ResourceLocation soundLocation, boolean playSound, SoundType soundType) {
        this.soundLocation = soundLocation;
        this.playSound = playSound;
        this.soundType = soundType;
    }

    public SoundPacket(ResourceLocation soundLocation, boolean playSound) {
        this(soundLocation, playSound, SoundType.DEFAULT_UI);
    }

    public static void encode(SoundPacket pkt, FriendlyByteBuf buf) {
        buf.m_130085_(pkt.soundLocation);
        buf.writeBoolean(pkt.playSound);
        buf.m_130068_((Enum)pkt.soundType);
    }

    public static SoundPacket decode(FriendlyByteBuf buf) {
        ResourceLocation soundLocation = buf.m_130281_();
        boolean playSound = buf.readBoolean();
        SoundType soundType = (SoundType)buf.m_130066_(SoundType.class);
        return new SoundPacket(soundLocation, playSound, soundType);
    }

    public static void handle(SoundPacket pkt, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> ClientPacketHandler.handle(pkt)));
        ctx.get().setPacketHandled(true);
    }

    public static enum SoundType {
        DEFAULT_UI,
        LOOPING_MUSIC;

    }

    public static class ClientPacketHandler {
        public static void handle(SoundPacket pkt) {
            if (pkt.playSound) {
                ClientSoundManager.playPacketSound(pkt.soundLocation, pkt.soundType);
            } else {
                ClientSoundManager.stopPacketSound(pkt.soundLocation);
            }
        }
    }
}

