/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkEvent;

public class StunFlagPacket {
    private final int entityId;
    private final boolean isStunned;

    public StunFlagPacket(int entityId, boolean isStunned) {
        this.entityId = entityId;
        this.isStunned = isStunned;
    }

    public StunFlagPacket(FriendlyByteBuf buf) {
        this.entityId = buf.readInt();
        this.isStunned = buf.readBoolean();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeBoolean(this.isStunned);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            Entity entity;
            if (Minecraft.m_91087_().f_91073_ != null && (entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId)) != null) {
                entity.getPersistentData().m_128379_("client_stunned", this.isStunned);
            }
        });
        return true;
    }
}

