/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.particles.client;

import java.util.List;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.saksolm.monsterexpansion.entity.custom.LargeMonsterPartEntity;
import net.saksolm.monsterexpansion.network.ModNetwork;
import net.saksolm.monsterexpansion.network.ParticleImpactPacket;
import net.saksolm.monsterexpansion.particles.IForcedParticle;
import net.saksolm.monsterexpansion.particles.ModParticles;
import net.saksolm.monsterexpansion.particles.options.ColorParticleOptions;

public class DrivingWindParticle
extends TextureSheetParticle
implements IForcedParticle {
    private boolean forceRender = false;
    private final int ownerId;

    protected DrivingWindParticle(ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed, ColorParticleOptions pOptions, SpriteSet pSpriteSet) {
        super(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed);
        this.m_108335_(pSpriteSet);
        this.m_107253_(1.0f, 1.0f, 1.0f);
        this.ownerId = pOptions.getOwnerId();
        this.f_172258_ = 0.99f;
        this.f_107226_ = 0.05f;
        this.f_107663_ = pOptions.getScale() * (0.5f + this.f_107223_.m_188501_() * 0.5f);
        this.f_107225_ = 15 + this.f_107223_.m_188503_(10);
        this.f_107215_ = pXSpeed;
        this.f_107216_ = pYSpeed;
        this.f_107217_ = pZSpeed;
    }

    public void m_5989_() {
        boolean hasHit;
        super.m_5989_();
        AABB searchBox = this.m_107277_().m_82400_(0.2);
        List nearbyEntities = this.f_107208_.m_45976_(LivingEntity.class, searchBox);
        LivingEntity hitTarget = null;
        for (LivingEntity entity : nearbyEntities) {
            if (entity.m_19879_() == this.ownerId || entity instanceof LargeMonsterPartEntity) continue;
            hitTarget = entity;
            break;
        }
        boolean bl = hasHit = hitTarget != null;
        if (hasHit || this.f_107218_) {
            Vec3 impactPos = hasHit ? hitTarget.m_20182_() : new Vec3(this.f_107212_, this.f_107213_, this.f_107214_);
            ModNetwork.sendToServer(new ParticleImpactPacket(impactPos, this.ownerId));
            if (this.f_107223_.m_188500_() < 0.3) {
                this.spawnMistCloud(impactPos);
            }
            this.m_107274_();
            return;
        }
        this.f_107230_ = (1.0f - (float)this.f_107224_ / (float)this.f_107225_) * 0.75f;
    }

    private void spawnMistCloud(Vec3 pos) {
        RandomSource random = this.f_107208_.f_46441_;
        int mistCount = 1;
        for (int i = 0; i < mistCount; ++i) {
            double velX = (random.m_188500_() - 0.5) * 0.3;
            double velY = random.m_188500_() * 0.4;
            double velZ = (random.m_188500_() - 0.5) * 0.3;
            ColorParticleOptions options = new ColorParticleOptions((ParticleType<ColorParticleOptions>)((ParticleType)ModParticles.CORE_MIST.get()), 1.0f, 1.0f, 1.0f, 0.3f, this.ownerId);
            this.f_107208_.m_7106_((ParticleOptions)options, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), velX, velY, velZ);
        }
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @Override
    public void setForceRender(boolean force) {
        this.forceRender = force;
    }

    public boolean shouldCull() {
        return this.forceRender ? false : super.shouldCull();
    }

    public static class Provider
    implements ParticleProvider<ColorParticleOptions> {
        private final SpriteSet sprite;

        public Provider(SpriteSet pSprites) {
            this.sprite = pSprites;
        }

        public Particle createParticle(ColorParticleOptions pType, ClientLevel pLevel, double pX, double pY, double pZ, double pXSpeed, double pYSpeed, double pZSpeed) {
            return new DrivingWindParticle(pLevel, pX, pY, pZ, pXSpeed, pYSpeed, pZSpeed, pType, this.sprite);
        }
    }
}

