/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.particles.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.saksolm.monsterexpansion.particles.client.StunTrailParticle;

public class StunStarParticle
extends TextureSheetParticle {
    private final Entity targetEntity;
    private final double angleOffset;
    private double prevRealX;
    private double prevRealY;
    private double prevRealZ;
    private boolean firstTick = true;
    private final SpriteSet spriteSet;

    protected StunStarParticle(ClientLevel level, double x, double y, double z, SpriteSet spriteSet, double entityIdEncoded, double angleOffsetEncoded, double lifetimeEncoded) {
        super(level, x, y, z, 0.0, 0.0, 0.0);
        this.spriteSet = spriteSet;
        this.f_107663_ *= 2.5f;
        this.m_108339_(spriteSet);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
        this.f_172258_ = 1.0f;
        int entityId = (int)entityIdEncoded;
        this.targetEntity = level.m_6815_(entityId);
        this.angleOffset = angleOffsetEncoded;
        this.f_107225_ = (int)lifetimeEncoded;
        if (this.targetEntity == null) {
            this.m_107274_();
        }
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.f_107204_ = this.f_107231_;
        if (this.f_107224_++ >= this.f_107225_) {
            this.m_107274_();
            return;
        }
        if (this.targetEntity == null || !this.targetEntity.m_6084_()) {
            this.m_107274_();
            return;
        }
        if (!this.targetEntity.getPersistentData().m_128471_("client_stunned")) {
            this.m_107274_();
            return;
        }
        this.f_107231_ += 0.25f;
        double speed = 0.15;
        double currentAngle = (double)this.f_107224_ * speed + this.angleOffset;
        double radius = 0.7;
        double offsetX = Math.cos(currentAngle) * radius;
        double offsetZ = Math.sin(currentAngle) * radius;
        double bobY = (double)Mth.m_14031_((float)((float)((double)this.f_107224_ * 0.1 + this.angleOffset))) * 0.1;
        double newX = this.targetEntity.m_20185_() + offsetX;
        double newY = this.targetEntity.m_20188_() + 0.5 + bobY;
        double newZ = this.targetEntity.m_20189_() + offsetZ;
        if (!this.firstTick) {
            double distance = Math.sqrt(Math.pow(newX - this.prevRealX, 2.0) + Math.pow(newY - this.prevRealY, 2.0) + Math.pow(newZ - this.prevRealZ, 2.0));
            int steps = (int)Math.max(3.0, distance * 20.0);
            for (int i = 0; i < steps; ++i) {
                double t = (double)i / (double)steps;
                double lerpX = this.prevRealX + (newX - this.prevRealX) * t;
                double lerpY = this.prevRealY + (newY - this.prevRealY) * t;
                double lerpZ = this.prevRealZ + (newZ - this.prevRealZ) * t;
                StunTrailParticle trail = new StunTrailParticle(this.f_107208_, lerpX, lerpY, lerpZ, this.spriteSet, this.f_107231_, this.f_107204_);
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)trail);
            }
        }
        this.m_107264_(newX, newY, newZ);
        this.prevRealX = newX;
        this.prevRealY = newY;
        this.prevRealZ = newZ;
        this.firstTick = false;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107431_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet spriteSet;

        public Provider(SpriteSet spriteSet) {
            this.spriteSet = spriteSet;
        }

        public Particle createParticle(SimpleParticleType type, ClientLevel level, double x, double y, double z, double xd, double yd, double zd) {
            return new StunStarParticle(level, x, y, z, this.spriteSet, xd, yd, zd);
        }
    }
}

