/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.saksolm.monsterexpansion.block.ModBlocks;

public class FoundryRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final ItemStack result;
    private final NonNullList<Ingredient> ingredients;
    private final CraftingBookCategory category;
    private final int width;
    private final int height;

    public FoundryRecipe(ResourceLocation id, ItemStack result, NonNullList<Ingredient> ingredients, CraftingBookCategory category) {
        this.id = id;
        this.result = result;
        this.ingredients = ingredients;
        this.category = category;
        this.width = 5;
        this.height = 5;
    }

    public boolean m_5818_(Container pContainer, Level pLevel) {
        if (!(pContainer instanceof CraftingContainer)) {
            return false;
        }
        for (int i = 0; i < this.ingredients.size(); ++i) {
            if (((Ingredient)this.ingredients.get(i)).test(pContainer.m_8020_(i))) continue;
            return false;
        }
        return true;
    }

    public ItemStack m_5874_(Container pContainer, RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public NonNullList<ItemStack> m_7457_(Container pContainer) {
        NonNullList remainingItems = NonNullList.m_122780_((int)pContainer.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack stack = pContainer.m_8020_(i);
            if (stack.hasCraftingRemainingItem()) {
                remainingItems.set(i, (Object)stack.getCraftingRemainingItem());
                continue;
            }
            if (stack.m_41619_() || stack.m_41614_()) continue;
            remainingItems.set(i, (Object)stack.m_255036_(stack.m_41613_() - 1));
        }
        return remainingItems;
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return pWidth == this.width && pHeight == this.height;
    }

    public ItemStack m_8043_(RegistryAccess pRegistryAccess) {
        return this.result.m_41777_();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)ModBlocks.FOUNDRY_RECIPE_TYPE.get();
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public static class Serializer
    implements RecipeSerializer<FoundryRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        public FoundryRecipe fromJson(ResourceLocation pRecipeId, JsonObject pJson) {
            String categoryString;
            CraftingBookCategory category = switch (categoryString = GsonHelper.m_13851_((JsonObject)pJson, (String)"category", (String)"misc")) {
                case "building" -> CraftingBookCategory.BUILDING;
                case "redstone" -> CraftingBookCategory.REDSTONE;
                case "misc" -> CraftingBookCategory.MISC;
                default -> CraftingBookCategory.MISC;
            };
            HashMap<String, Ingredient> keyMap = new HashMap<String, Ingredient>();
            JsonObject keyJson = GsonHelper.m_13930_((JsonObject)pJson, (String)"key");
            for (Map.Entry entry : keyJson.entrySet()) {
                String keyString = (String)entry.getKey();
                if (keyString.length() != 1) {
                    throw new JsonParseException("Invalid key entry '" + keyString + "' - key must be a single character.");
                }
                keyMap.put(keyString, Ingredient.m_43917_((JsonElement)((JsonElement)entry.getValue())));
            }
            NonNullList ingredients = NonNullList.m_122780_((int)25, (Object)Ingredient.f_43901_);
            JsonArray patternJson = GsonHelper.m_13933_((JsonObject)pJson, (String)"pattern");
            if (patternJson.size() != 5) {
                throw new JsonParseException("Invalid pattern: expected 5 rows, got " + patternJson.size());
            }
            int index = 0;
            for (JsonElement element : patternJson) {
                String rowString = element.getAsString();
                if (rowString.length() != 5) {
                    throw new JsonParseException("Invalid pattern: expected 5 characters in row, got " + rowString.length());
                }
                for (char character : rowString.toCharArray()) {
                    String charString = String.valueOf(character);
                    if (charString.equals(" ")) {
                        ingredients.set(index, (Object)Ingredient.f_43901_);
                    } else {
                        Ingredient ingredient = (Ingredient)keyMap.get(charString);
                        if (ingredient == null) {
                            throw new JsonParseException("Pattern references symbol '" + character + "' but it's not defined in the key.");
                        }
                        ingredients.set(index, (Object)ingredient);
                    }
                    ++index;
                }
            }
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)pJson, (String)"result"));
            return new FoundryRecipe(pRecipeId, output, (NonNullList<Ingredient>)ingredients, category);
        }

        public FoundryRecipe fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf pBuffer) {
            CraftingBookCategory category = (CraftingBookCategory)pBuffer.m_130066_(CraftingBookCategory.class);
            NonNullList ingredients = NonNullList.m_122780_((int)pBuffer.m_130242_(), (Object)Ingredient.f_43901_);
            for (int i = 0; i < ingredients.size(); ++i) {
                ingredients.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)pBuffer));
            }
            ItemStack output = pBuffer.m_130267_();
            return new FoundryRecipe(pRecipeId, output, (NonNullList<Ingredient>)ingredients, category);
        }

        public void toNetwork(FriendlyByteBuf pBuffer, FoundryRecipe pRecipe) {
            pBuffer.m_130068_((Enum)pRecipe.category);
            pBuffer.m_130130_(pRecipe.ingredients.size());
            for (Ingredient ingredient : pRecipe.ingredients) {
                ingredient.m_43923_(pBuffer);
            }
            pBuffer.m_130055_(pRecipe.result);
        }
    }
}

