/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.screen;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.saksolm.monsterexpansion.screen.entry.MonsterEntry;
import net.saksolm.monsterexpansion.screen.page.IPage;

public class GuidebookScreen
extends Screen {
    private static final ResourceLocation GUIDE_TEXTURE = new ResourceLocation("monsterexpansion", "textures/gui/guide_background.png");
    private static final ResourceLocation SKRYTHE_ICON = new ResourceLocation("monsterexpansion", "textures/gui/icons/skrythe_icon.png");
    private static final ResourceLocation SKRYTHE_LARGE_ICON = new ResourceLocation("monsterexpansion", "textures/gui/icons/skrythe_large_icon.png");
    private GuiState currentState = GuiState.MAIN_MENU;
    private final int GUI_WIDTH = 500;
    private final int GUI_HEIGHT = 300;
    private int leftPos = 0;
    private int topPos = 0;
    private final int TEXT_COLOR = 0x3F3F3F;
    private final int LINK_COLOR = 255;
    private final int HOVER_COLOR = 0x8800FF;
    private List<MonsterEntry> allMonsters = new ArrayList<MonsterEntry>();
    private MonsterEntry selectedMonster = null;
    private int selectedPageIndex = 0;
    private int monsterInfoButtonX;
    private int monsterInfoButtonY;
    private int monsterInfoButtonW;
    private int monsterInfoButtonH;
    private int backButtonX;
    private int backButtonY;
    private int backButtonW;
    private int backButtonH;
    private Component skrytheLoreText = Component.m_237113_((String)"The Skrythe is a medium-sized flying wyvern...");

    public GuidebookScreen() {
        super((Component)Component.m_237113_((String)"Hunter's Notes"));
    }

    protected void m_7856_() {
        super.m_7856_();
        this.leftPos = (this.f_96543_ - this.GUI_WIDTH) / 2;
        this.topPos = (this.f_96544_ - this.GUI_HEIGHT) / 2;
        this.monsterInfoButtonX = this.leftPos + 20;
        this.monsterInfoButtonY = this.topPos + 30;
        this.monsterInfoButtonW = this.f_96547_.m_92895_("Monster Info");
        Objects.requireNonNull(this.f_96547_);
        this.monsterInfoButtonH = 9;
        this.backButtonX = this.leftPos + 20;
        this.backButtonY = this.topPos + 280;
        this.backButtonW = this.f_96547_.m_92895_("< Back");
        Objects.requireNonNull(this.f_96547_);
        this.backButtonH = 9;
        this.allMonsters.clear();
        int loreTextTop = this.topPos + 180;
        int loreTextWidth = 245;
        int loreTextBottom = this.topPos + 280;
        int loreVisibleHeight = loreTextBottom - loreTextTop;
        MonsterEntry skrythe = new MonsterEntry((Component)Component.m_237113_((String)"Skrythe"), SKRYTHE_ICON, SKRYTHE_LARGE_ICON);
        skrythe.buildPages(this.f_96547_, this.skrytheLoreText, loreTextWidth, loreVisibleHeight);
        skrythe.setPosition(this.leftPos + 250 + 10, this.topPos + 30, 32);
        this.allMonsters.add(skrythe);
    }

    public void m_88315_(GuiGraphics guiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.m_88315_(guiGraphics, pMouseX, pMouseY, pPartialTick);
        guiGraphics.m_280163_(GUIDE_TEXTURE, this.leftPos, this.topPos, 0.0f, 0.0f, this.GUI_WIDTH, this.GUI_HEIGHT, 500, 300);
        switch (this.currentState) {
            case MAIN_MENU: {
                this.renderMainMenu(guiGraphics, pMouseX, pMouseY);
                break;
            }
            case MONSTER_VIEW: {
                this.renderMonsterView(guiGraphics, pMouseX, pMouseY);
            }
        }
    }

    private void renderMainMenu(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        guiGraphics.m_280056_(this.f_96547_, "Hunter's Notes", this.leftPos + 20, this.topPos + 10, 0x3F3F3F, false);
        boolean isHovering = this.isMouseOver(pMouseX, pMouseY, this.monsterInfoButtonX, this.monsterInfoButtonY, this.monsterInfoButtonW, this.monsterInfoButtonH);
        guiGraphics.m_280056_(this.f_96547_, "Monster Info", this.monsterInfoButtonX, this.monsterInfoButtonY, isHovering ? 0x8800FF : 255, false);
    }

    private void renderMonsterView(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        guiGraphics.m_280056_(this.f_96547_, "Monsters", this.leftPos + 250 + 10, this.topPos + 10, 0x3F3F3F, false);
        for (MonsterEntry monster : this.allMonsters) {
            guiGraphics.m_280163_(monster.smallIcon, monster.iconX, monster.iconY, 0.0f, 0.0f, 32, 32, 32, 32);
            if (!monster.isMouseOverIcon(pMouseX, pMouseY)) continue;
            guiGraphics.m_280557_(this.f_96547_, monster.name, pMouseX, pMouseY);
            guiGraphics.m_280509_(monster.iconX, monster.iconY, monster.iconX + 32, monster.iconY + 32, -2130706433);
        }
        if (this.selectedMonster != null) {
            this.renderDetailPanel(guiGraphics, pMouseX, pMouseY);
        } else {
            guiGraphics.m_280488_(this.f_96547_, "Select a monster", this.leftPos + 20, this.topPos + 20, 0x3F3F3F);
        }
        boolean isHovering = this.isMouseOver(pMouseX, pMouseY, this.backButtonX, this.backButtonY, this.backButtonW, this.backButtonH);
        guiGraphics.m_280056_(this.f_96547_, "< Back", this.backButtonX, this.backButtonY, isHovering ? 0x8800FF : 255, false);
    }

    private void renderDetailPanel(GuiGraphics guiGraphics, int pMouseX, int pMouseY) {
        int tabX = this.leftPos + 10;
        int tabY = this.topPos + 10;
        for (int i = 0; i < this.selectedMonster.detailPages.size(); ++i) {
            IPage page = this.selectedMonster.detailPages.get(i);
            boolean isSelected = i == this.selectedPageIndex;
            page.renderTab(guiGraphics, this.f_96547_, tabX, tabY, isSelected);
            tabX += this.f_96547_.m_92852_((FormattedText)page.getTabName()) + 15;
        }
        IPage currentPage = this.selectedMonster.detailPages.get(this.selectedPageIndex);
        currentPage.renderPage(guiGraphics, this.f_96547_, this.leftPos, this.topPos, pMouseX, pMouseY);
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (pButton != 0) {
            return super.m_6375_(pMouseX, pMouseY, pButton);
        }
        switch (this.currentState) {
            case MAIN_MENU: {
                if (!this.isMouseOver(pMouseX, pMouseY, this.monsterInfoButtonX, this.monsterInfoButtonY, this.monsterInfoButtonW, this.monsterInfoButtonH)) break;
                this.currentState = GuiState.MONSTER_VIEW;
                return true;
            }
            case MONSTER_VIEW: {
                if (this.isMouseOver(pMouseX, pMouseY, this.backButtonX, this.backButtonY, this.backButtonW, this.backButtonH)) {
                    if (this.selectedMonster != null) {
                        this.selectedMonster = null;
                    } else {
                        this.currentState = GuiState.MAIN_MENU;
                    }
                    return true;
                }
                for (MonsterEntry monster : this.allMonsters) {
                    if (!monster.isMouseOverIcon(pMouseX, pMouseY)) continue;
                    this.selectedMonster = monster;
                    this.selectedPageIndex = 0;
                    return true;
                }
                if (this.selectedMonster == null) break;
                int tabX = this.leftPos + 10;
                int tabY = this.topPos + 10;
                for (int i = 0; i < this.selectedMonster.detailPages.size(); ++i) {
                    IPage page = this.selectedMonster.detailPages.get(i);
                    int tabW = this.f_96547_.m_92852_((FormattedText)page.getTabName());
                    Objects.requireNonNull(this.f_96547_);
                    int tabH = 9;
                    if (this.isMouseOver(pMouseX, pMouseY, tabX, tabY, tabW, tabH)) {
                        this.selectedPageIndex = i;
                        return true;
                    }
                    tabX += tabW + 15;
                }
                break;
            }
        }
        return super.m_6375_(pMouseX, pMouseY, pButton);
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.currentState == GuiState.MONSTER_VIEW && this.selectedMonster != null) {
            IPage currentPage = this.selectedMonster.detailPages.get(this.selectedPageIndex);
            return currentPage.mouseScrolled(pMouseX, pMouseY, pDelta);
        }
        return super.m_6050_(pMouseX, pMouseY, pDelta);
    }

    private boolean isMouseOver(double pMouseX, double pMouseY, int x, int y, int width, int height) {
        return pMouseX >= (double)x && pMouseX <= (double)(x + width) && pMouseY >= (double)y && pMouseY <= (double)(y + height);
    }

    public boolean m_7043_() {
        return false;
    }

    private static enum GuiState {
        MAIN_MENU,
        MONSTER_VIEW;

    }
}

