/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.screen.entry;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.saksolm.monsterexpansion.screen.page.DropsPage;
import net.saksolm.monsterexpansion.screen.page.HitzonePage;
import net.saksolm.monsterexpansion.screen.page.IPage;
import net.saksolm.monsterexpansion.screen.page.LorePage;

public class MonsterEntry {
    public final Component name;
    public final ResourceLocation smallIcon;
    public final ResourceLocation largeIcon;
    public final List<IPage> detailPages;
    public int iconX;
    public int iconY;
    public int iconSize;

    public MonsterEntry(Component name, ResourceLocation smallIcon, ResourceLocation largeIcon) {
        this.name = name;
        this.smallIcon = smallIcon;
        this.largeIcon = largeIcon;
        this.detailPages = new ArrayList<IPage>();
    }

    public void buildPages(Font font, Component lore, int loreWidth, int loreHeight) {
        this.detailPages.add(new LorePage(lore, this.largeIcon, font, loreWidth, loreHeight));
        this.detailPages.add(new HitzonePage());
        this.detailPages.add(new DropsPage());
    }

    public void setPosition(int x, int y, int size) {
        this.iconX = x;
        this.iconY = y;
        this.iconSize = size;
    }

    public boolean isMouseOverIcon(double pMouseX, double pMouseY) {
        return pMouseX >= (double)this.iconX && pMouseX <= (double)(this.iconX + this.iconSize) && pMouseY >= (double)this.iconY && pMouseY <= (double)(this.iconY + this.iconSize);
    }
}

