/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.screen.page;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;
import net.saksolm.monsterexpansion.screen.page.IPage;

public class LorePage
implements IPage {
    private final Component loreText;
    private final ResourceLocation largeIcon;
    private List<FormattedCharSequence> wrappedLoreText = new ArrayList<FormattedCharSequence>();
    private float loreScroll = 0.0f;
    private int loreTotalHeight = 0;
    private int loreVisibleHeight = 0;
    private final int TAB_COLOR = 0x555555;
    private final int HOVER_COLOR = 0x8800FF;
    private final int SELECTED_TAB_COLOR = 0;
    private final int TEXT_COLOR = 0x3F3F3F;

    public LorePage(Component loreText, ResourceLocation largeIcon, Font font, int width, int height) {
        this.loreText = loreText;
        this.largeIcon = largeIcon;
        this.loreVisibleHeight = height;
        this.wrappedLoreText = font.m_92923_((FormattedText)loreText, width);
        int n = this.wrappedLoreText.size();
        Objects.requireNonNull(font);
        this.loreTotalHeight = n * 9;
    }

    @Override
    public Component getTabName() {
        return Component.m_237113_((String)"Lore");
    }

    @Override
    public void renderTab(GuiGraphics guiGraphics, Font font, int x, int y, boolean isSelected) {
        int color = isSelected ? 0 : 0x555555;
        guiGraphics.m_280614_(font, this.getTabName(), x, y, color, false);
    }

    @Override
    public void renderPage(GuiGraphics guiGraphics, Font font, int leftPos, int topPos, int mouseX, int mouseY) {
        int iconX = leftPos + 55;
        int iconY = topPos + 35;
        guiGraphics.m_280163_(this.largeIcon, iconX, iconY, 0.0f, 0.0f, 128, 128, 128, 128);
        int loreTextLeft = leftPos + 10;
        int loreTextTop = topPos + 180;
        int loreTextBottom = topPos + 280;
        int loreTextRight = leftPos + 245;
        guiGraphics.m_280588_(loreTextLeft, loreTextTop, loreTextRight, loreTextBottom);
        int textY = loreTextTop - (int)this.loreScroll;
        for (FormattedCharSequence line : this.wrappedLoreText) {
            guiGraphics.m_280649_(font, line, loreTextLeft, textY, 0x3F3F3F, false);
            Objects.requireNonNull(font);
            textY += 9;
        }
        guiGraphics.m_280618_();
    }

    @Override
    public void mouseClicked(double mouseX, double mouseY, int button) {
    }

    @Override
    public boolean mouseScrolled(double mouseX, double mouseY, double delta) {
        int maxScroll = Math.max(0, this.loreTotalHeight - this.loreVisibleHeight);
        this.loreScroll -= (float)(delta * 9.0);
        this.loreScroll = Mth.m_14036_((float)this.loreScroll, (float)0.0f, (float)maxScroll);
        return true;
    }
}

