/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.screen.widgets;

import java.util.Objects;
import java.util.function.BooleanSupplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.saksolm.monsterexpansion.screen.widgets.ClickableWidget;

public class TextLinkWidget
extends ClickableWidget {
    private final Font font;
    private final Component message;
    private final Runnable onClick;
    private final boolean isTab;
    private final BooleanSupplier isSelected;
    private final int LINK_COLOR = 255;
    private final int HOVER_COLOR = 0x8800FF;
    private final int SELECTED_TAB_COLOR = 0;
    private final int TAB_COLOR = 0x555555;

    public TextLinkWidget(int pX, int pY, Component pMessage, Font pFont, Runnable pOnClick) {
        int n = pFont.m_92852_((FormattedText)pMessage);
        Objects.requireNonNull(pFont);
        super(pX, pY, n, 9);
        this.LINK_COLOR = 255;
        this.HOVER_COLOR = 0x8800FF;
        this.SELECTED_TAB_COLOR = 0;
        this.TAB_COLOR = 0x555555;
        this.font = pFont;
        this.message = pMessage;
        this.onClick = pOnClick;
        this.isSelected = () -> false;
        this.isTab = false;
    }

    public TextLinkWidget(int pX, int pY, Component pMessage, Font pFont, BooleanSupplier pIsSelected, Runnable pOnClick) {
        int n = pFont.m_92852_((FormattedText)pMessage);
        Objects.requireNonNull(pFont);
        super(pX, pY, n, 9);
        this.LINK_COLOR = 255;
        this.HOVER_COLOR = 0x8800FF;
        this.SELECTED_TAB_COLOR = 0;
        this.TAB_COLOR = 0x555555;
        this.font = pFont;
        this.message = pMessage;
        this.onClick = pOnClick;
        this.isSelected = pIsSelected;
        this.isTab = true;
    }

    @Override
    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        boolean isHovering = this.isMouseOver(pMouseX, pMouseY);
        int color = this.isSelected.getAsBoolean() ? 0 : (isHovering ? 0x8800FF : (this.isTab ? 0x555555 : 255));
        pGuiGraphics.m_280614_(this.font, this.message, this.x, this.y, color, false);
    }

    @Override
    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0 && this.isMouseOver(pMouseX, pMouseY)) {
            this.onClick.run();
            return true;
        }
        return false;
    }
}

