/*
 * Decompiled with CFR 0.152.
 */
package net.saksolm.monsterexpansion.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.saksolm.monsterexpansion.entity.custom.AbstractLargeMonster;
import net.saksolm.monsterexpansion.entity.util.DamageTypes;

public class AttackDefinition {
    public static final AttackDefinition DEFAULT = new Builder().build();
    private final float damageMultiplier;
    private final AbstractLargeMonster.KnockbackType knockbackType;
    private final double knockbackStrength;
    private final boolean shieldIgnore;
    private final boolean shieldBreak;
    private final int shieldDownDuration;
    private final int stunBuildup;
    private final DamageTypes.ElementType elementType;
    private final List<ChanceEffect> effectsToApply;
    private final BiConsumer<AbstractLargeMonster, LivingEntity> onHitCallback;

    private AttackDefinition(Builder builder) {
        this.damageMultiplier = builder.damageMultiplier;
        this.knockbackType = builder.knockbackType;
        this.knockbackStrength = builder.knockbackStrength;
        this.shieldIgnore = builder.shieldIgnore;
        this.shieldBreak = builder.shieldBreak;
        this.shieldDownDuration = builder.shieldDownDuration;
        this.effectsToApply = builder.effectsToApply;
        this.onHitCallback = builder.onHitCallback;
        this.elementType = builder.elementType;
        this.stunBuildup = builder.stunBuildup;
    }

    public DamageTypes.ElementType getElementType() {
        return this.elementType;
    }

    public int getStunBuildup() {
        return this.stunBuildup;
    }

    public float getDamageMultiplier() {
        return this.damageMultiplier;
    }

    public AbstractLargeMonster.KnockbackType getKnockbackType() {
        return this.knockbackType;
    }

    public double getKnockbackStrength() {
        return this.knockbackStrength;
    }

    public boolean isShieldIgnore() {
        return this.shieldIgnore;
    }

    public boolean isShieldBreak() {
        return this.shieldBreak;
    }

    public int getShieldDownDuration() {
        return this.shieldDownDuration;
    }

    public List<ChanceEffect> getEffects() {
        return this.effectsToApply;
    }

    public void onHit(AbstractLargeMonster attacker, LivingEntity target) {
        if (this.onHitCallback != null) {
            this.onHitCallback.accept(attacker, target);
        }
    }

    public static class Builder {
        private DamageTypes.ElementType elementType = DamageTypes.ElementType.NONE;
        private float damageMultiplier = 1.0f;
        private AbstractLargeMonster.KnockbackType knockbackType = AbstractLargeMonster.KnockbackType.STANDARD;
        private double knockbackStrength = 1.0;
        private boolean shieldIgnore = false;
        private boolean shieldBreak = false;
        private int shieldDownDuration = 0;
        private int stunBuildup = 0;
        private List<ChanceEffect> effectsToApply = new ArrayList<ChanceEffect>();
        private BiConsumer<AbstractLargeMonster, LivingEntity> onHitCallback = null;

        public Builder damage(float multiplier) {
            this.damageMultiplier = multiplier;
            return this;
        }

        public Builder knockback(AbstractLargeMonster.KnockbackType type, double strength) {
            this.knockbackType = type;
            this.knockbackStrength = strength;
            return this;
        }

        public Builder withElement(DamageTypes.ElementType type) {
            this.elementType = type;
            return this;
        }

        public Builder ignoreShield() {
            this.shieldIgnore = true;
            return this;
        }

        public Builder breakShield(int duration) {
            this.shieldBreak = true;
            this.shieldDownDuration = duration;
            return this;
        }

        public Builder addEffect(MobEffectInstance effect) {
            return this.addEffect(effect, 1.0f);
        }

        public Builder addEffect(MobEffectInstance effect, float chance) {
            this.effectsToApply.add(new ChanceEffect(effect, chance));
            return this;
        }

        public Builder onHit(BiConsumer<AbstractLargeMonster, LivingEntity> callback) {
            this.onHitCallback = callback;
            return this;
        }

        public Builder stun(int amount) {
            this.stunBuildup = amount;
            return this;
        }

        public AttackDefinition build() {
            return new AttackDefinition(this);
        }
    }

    public record ChanceEffect(MobEffectInstance effect, float chance) {
    }
}

