#version 150

uniform sampler2D DiffuseSampler;

in vec2 texCoord;
out vec4 fragColor;

void main() {
    float strength = 0.1;
    int samples = 12;
    vec2 center = vec2(0.5, 0.5);

    vec4 color = vec4(0.0);
    float total = 0.0;

    for (float i = 0.0; i <= 1.0; i += 1.0 / float(samples)) {
        float scale = 1.0 - strength * i;

        vec2 sampleUV = center + (texCoord - center) * scale;

        color += texture(DiffuseSampler, sampleUV);
        total += 1.0;
    }

    fragColor = vec4(color.rgb / total, 1.0);
}