/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze;

import com.trae.maze.logic.MazeManager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="maze")
public class MazeEventHandler {
    private static final Map<UUID, String> lastPlayerMaze = new HashMap<UUID, String>();

    public static void setPlayerLastMaze(UUID playerId, String mazeName) {
        lastPlayerMaze.put(playerId, mazeName);
    }

    public static String getPlayerLastMaze(UUID playerId) {
        return lastPlayerMaze.get(playerId);
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntity();
            String mazeName = MazeManager.get().findMazeAtPosition(player.m_20183_());
            if (mazeName != null) {
                MazeEventHandler.setPlayerLastMaze(player.m_20148_(), mazeName);
            }
        }
    }

    @SubscribeEvent
    public static void onArrowHit(ProjectileImpactEvent event) {
        if (event.getProjectile() instanceof Arrow) {
            EntityHitResult hit;
            Arrow arrow = (Arrow)event.getProjectile();
            if (event.getRayTraceResult() instanceof EntityHitResult && (hit = (EntityHitResult)event.getRayTraceResult()).m_82443_() instanceof Zombie) {
                Zombie zombie = (Zombie)hit.m_82443_();
                for (String tag : zombie.m_19880_()) {
                    if (!tag.startsWith("MazeZombie_")) continue;
                    zombie.m_21153_(0.0f);
                    zombie.m_6667_(zombie.m_269291_().m_269418_((AbstractArrow)arrow, arrow.m_19749_()));
                    break;
                }
            }
        }
    }
}

