/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze;

import com.mojang.brigadier.CommandDispatcher;
import com.trae.maze.MazeEventHandler;
import com.trae.maze.client.ClientHud;
import com.trae.maze.commands.MazeCommands;
import com.trae.maze.logic.MazeData;
import com.trae.maze.logic.MazeManager;
import com.trae.maze.net.Network;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="maze")
public class MazeMod {
    public static final String MODID = "maze";

    public MazeMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ClientHud.initClient();
    }

    private void setup(FMLCommonSetupEvent event) {
        Network.register();
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        MazeManager.get().onServerStarting(event.getServer());
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        MazeCommands.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        MazeData maze;
        ServerPlayer player;
        String lastMaze;
        if (event.getEntity() instanceof ServerPlayer && (lastMaze = MazeEventHandler.getPlayerLastMaze((player = (ServerPlayer)event.getEntity()).m_20148_())) != null && (maze = MazeManager.get().getMaze(lastMaze)) != null && maze.entrancePos != null) {
            player.m_6021_((double)maze.entrancePos.m_123341_(), (double)maze.entrancePos.m_123342_(), (double)maze.entrancePos.m_123343_());
        }
    }
}

