/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderGuiOverlayEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ClientHud {
    private static int timerSeconds = 0;
    private static int wins = 0;
    private static boolean isVisible = false;
    private static String durability = "";
    private static int lootSeconds = 0;

    public static void initClient() {
        MinecraftForge.EVENT_BUS.register(ClientHud.class);
    }

    public static void update(int seconds, int w, boolean visible, String dura, int lootSec) {
        timerSeconds = seconds;
        wins = w;
        isVisible = visible;
        durability = dura;
        lootSeconds = lootSec;
    }

    @SubscribeEvent
    public static void onRenderGui(RenderGuiOverlayEvent.Post event) {
        if (!isVisible) {
            return;
        }
        if (event.getOverlay() != VanillaGuiOverlay.HOTBAR.type()) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null) {
            return;
        }
        GuiGraphics graphics = event.getGuiGraphics();
        Font font = mc.f_91062_;
        String timerText = "Maze Timer: " + timerSeconds + "s";
        String winsText = "Wins: " + wins;
        String duraText = "Durability: " + durability;
        graphics.m_280488_(font, timerText, 10, 10, 0xFFFFFF);
        graphics.m_280488_(font, winsText, 10, 22, 0xFFFFFF);
        graphics.m_280488_(font, duraText, 10, 34, 0xAAAAAA);
        String lootText = "Items Clean: " + lootSeconds + "s";
        int width = mc.m_91268_().m_85445_();
        graphics.m_280488_(font, lootText, width - font.m_92895_(lootText) - 10, 10, 0xFFAAAA);
    }
}

