/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.trae.maze.config.MazeThemeManager;
import com.trae.maze.logic.MazeData;
import com.trae.maze.logic.MazeManager;
import com.trae.maze.logic.MazeSavedData;
import com.trae.maze.world.MazeGenerator;
import com.trae.maze.world.ZombieManager;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;

public class MazeCommands {
    private static final SuggestionProvider<CommandSourceStack> MAZE_ARGS_SUGGESTIONS = (context, builder) -> {
        String remaining = builder.getRemaining();
        int lastSpace = remaining.lastIndexOf(32);
        String currentArg = remaining;
        if (lastSpace >= 0) {
            builder = builder.createOffset(builder.getStart() + lastSpace + 1);
            currentArg = remaining.substring(lastSpace + 1);
        }
        if (currentArg.indexOf(58) == -1) {
            return SharedSuggestionProvider.m_82970_(List.of("H:", "W:", "WW:", "C:", "F:", "P:", "EX:", "ROOM:", "ER:", "CL:", "THEME:", "T:", "L:", "LE:", "LC:", "LRCC:"), (SuggestionsBuilder)builder);
        }
        String[] parts = currentArg.split(":", 2);
        String key = parts[0];
        if (key.equals("C") || key.equals("F")) {
            return SharedSuggestionProvider.m_82970_(List.of("RED_CONCRETE", "BLUE_CONCRETE", "WHITE_CONCRETE", "BLACK_CONCRETE", "LIME_CONCRETE", "YELLOW_CONCRETE", "ORANGE_CONCRETE", "GRAY_CONCRETE"), (SuggestionsBuilder)builder);
        }
        if (key.equals("THEME")) {
            return SharedSuggestionProvider.m_82970_(MazeThemeManager.getThemeNames(), (SuggestionsBuilder)builder);
        }
        if (key.equals("H")) {
            return SharedSuggestionProvider.m_82970_(List.of("5", "10", "15"), (SuggestionsBuilder)builder);
        }
        if (key.equals("W")) {
            return SharedSuggestionProvider.m_82970_(List.of("1", "2", "3"), (SuggestionsBuilder)builder);
        }
        if (key.equals("WW")) {
            return SharedSuggestionProvider.m_82970_(List.of("1", "2"), (SuggestionsBuilder)builder);
        }
        if (key.equals("P")) {
            return SharedSuggestionProvider.m_82970_(List.of("25", "50", "100"), (SuggestionsBuilder)builder);
        }
        if (key.equals("EX") || key.equals("ROOM") || key.equals("CL") || key.equals("T") || key.equals("L") || key.equals("LC")) {
            return SharedSuggestionProvider.m_82970_(List.of("true", "false"), (SuggestionsBuilder)builder);
        }
        if (key.equals("LE")) {
            return SharedSuggestionProvider.m_82970_(List.of("1", "2", "3", "4"), (SuggestionsBuilder)builder);
        }
        if (key.equals("LRCC")) {
            return SharedSuggestionProvider.m_82970_(List.of("1", "2", "3", "4", "5"), (SuggestionsBuilder)builder);
        }
        if (key.equals("ER")) {
            return SharedSuggestionProvider.m_82970_(List.of("0.1", "0.2", "0.5"), (SuggestionsBuilder)builder);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"maze").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"pos1").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)ctx.getSource()).m_81371_());
            MazeManager.get().getSavedData().pendingPos1.put(name, pos);
            MazeManager.get().getSavedData().m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Pos1 set for '" + name + "' to " + String.valueOf(pos))), false);
            return 1;
        })))).then(Commands.m_82127_((String)"pos2").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            BlockPos pos = BlockPos.m_274446_((Position)((CommandSourceStack)ctx.getSource()).m_81371_());
            MazeManager.get().getSavedData().pendingPos2.put(name, pos);
            MazeManager.get().getSavedData().m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Pos2 set for '" + name + "' to " + String.valueOf(pos))), false);
            return 1;
        })))).then(Commands.m_82127_((String)"poslist").executes(ctx -> {
            MazeSavedData data = MazeManager.get().getSavedData();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83d\udccb === Position List ==="), false);
            HashSet<String> names = new HashSet<String>();
            names.addAll(data.pendingPos1.keySet());
            names.addAll(data.pendingPos2.keySet());
            if (names.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"  (None)"), false);
                return 1;
            }
            for (String n : names) {
                BlockPos p1 = data.pendingPos1.get(n);
                BlockPos p2 = data.pendingPos2.get(n);
                String p1Str = p1 != null ? p1.m_123344_() : "\u274c";
                String p2Str = p2 != null ? p2.m_123344_() : "\u274c";
                String linked = data.getMaze(n) != null ? " [Linked Maze]" : "";
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("  \u2022 " + n + ": P1=" + p1Str + " P2=" + p2Str + linked)), false);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"poscancel").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeSavedData data = MazeManager.get().getSavedData();
            boolean removed = false;
            if (data.pendingPos1.remove(name) != null) {
                removed = true;
            }
            if (data.pendingPos2.remove(name) != null) {
                removed = true;
            }
            if (removed) {
                data.m_77762_();
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Positions cleared for '" + name + "'")), true);
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u274c No positions found for '" + name + "'")));
            }
            return 1;
        })))).then(Commands.m_82127_((String)"ms").then(Commands.m_82129_((String)"enabled", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String enStr = StringArgumentType.getString((CommandContext)ctx, (String)"enabled");
            boolean ban = Boolean.parseBoolean(enStr);
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeData maze = MazeManager.get().getMaze(name);
            if (maze == null) {
                return MazeCommands.fail((CommandContext<CommandSourceStack>)ctx, "Maze not found!");
            }
            maze.mobSpawnBanned = ban;
            MazeManager.get().getSavedData().m_77762_();
            String status = ban ? "\ud83d\udeab BANNED" : "\u2705 ALLOWED";
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Mob Spawn for '" + name + "': " + status)), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"list").executes(ctx -> {
            MazeSavedData data = MazeManager.get().getSavedData();
            Map<String, MazeData> mazes = data.getAllMazes();
            if (mazes.isEmpty()) {
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83d\udccb No mazes found."), false);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\ud83d\udccb === Maze List ==="), false);
            for (Map.Entry<String, MazeData> entry : mazes.entrySet()) {
                String name = entry.getKey();
                MazeData maze = entry.getValue();
                int width = maze.pos1 != null && maze.pos2 != null ? Math.abs(maze.pos2.m_123341_() - maze.pos1.m_123341_()) + 1 : 0;
                int depth = maze.pos1 != null && maze.pos2 != null ? Math.abs(maze.pos2.m_123343_() - maze.pos1.m_123343_()) + 1 : 0;
                String status = maze.running ? "\u2705 Active" : "\u23f8\ufe0f Stopped";
                String sizeInfo = width > 0 ? width + "x" + depth : "Not configured";
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("  \u2022 " + name + " - " + sizeInfo + " - " + status)), false);
            }
            return 1;
        }))).then(Commands.m_82127_((String)"create").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> MazeCommands.createMaze((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), ""))).then(Commands.m_82129_((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests(MAZE_ARGS_SUGGESTIONS).executes(ctx -> MazeCommands.createMaze((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"args"))))))).then(Commands.m_82127_((String)"delete").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeSavedData data = MazeManager.get().getSavedData();
            MazeData maze = data.getMaze(name);
            if (maze == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u274c Error: Maze '" + name + "' not found!")));
                return 0;
            }
            if (maze.pos1 != null && maze.pos2 != null) {
                ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
                BoundingBox box = BoundingBox.m_162375_((Vec3i)maze.pos1, (Vec3i)maze.pos2);
                int height = Math.max(3, maze.height);
                int yMax = box.m_162396_() + height - 1;
                for (int x = box.m_162395_(); x <= box.m_162399_(); ++x) {
                    int y;
                    for (y = box.m_162396_(); y <= yMax; ++y) {
                        for (int z = box.m_162398_(); z <= box.m_162401_(); ++z) {
                            level.m_7731_(new BlockPos(x, y, z), Blocks.f_50016_.m_49966_(), 3);
                        }
                    }
                    for (y = box.m_162396_() - 1; y >= box.m_162396_() - 2; --y) {
                    }
                }
                if (maze.center != null) {
                    for (int bx = -2; bx <= 2; ++bx) {
                        for (int bz = -2; bz <= 2; ++bz) {
                            for (int by = -2; by <= 0; ++by) {
                                BlockPos p = new BlockPos(maze.center.m_123341_() + bx, maze.center.m_123342_() - 1 + by, maze.center.m_123343_() + bz);
                                level.m_7731_(p, Blocks.f_50016_.m_49966_(), 3);
                            }
                        }
                    }
                }
                AABB aabb = new AABB((double)box.m_162395_(), (double)box.m_162396_(), (double)box.m_162398_(), (double)(box.m_162399_() + 1), (double)(yMax + 1), (double)(box.m_162401_() + 1));
                level.m_45976_(ItemEntity.class, aabb).forEach(Entity::m_146870_);
                ZombieManager.get().killAll(level, name);
            }
            data.deleteMaze(name);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Maze '" + name + "' deleted!")), true);
            return 1;
        })))).then(Commands.m_82127_((String)"rebuild").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests(MAZE_ARGS_SUGGESTIONS).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            String args = StringArgumentType.getString((CommandContext)ctx, (String)"args");
            return MazeCommands.rebuildMaze((CommandContext<CommandSourceStack>)ctx, name, args);
        }))).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            return MazeCommands.rebuildMaze((CommandContext<CommandSourceStack>)ctx, name, "");
        })))).then(Commands.m_82127_((String)"start").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeData maze = MazeManager.get().getMaze(name);
            if (maze == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Maze not found!"));
                return 0;
            }
            maze.running = true;
            MazeManager.get().getSavedData().m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Maze '" + name + "' timer started.")), true);
            return 1;
        })))).then(Commands.m_82127_((String)"refresh").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> MazeCommands.refreshMazeCmd((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), ""))).then(Commands.m_82129_((String)"args", (ArgumentType)StringArgumentType.greedyString()).suggests(MAZE_ARGS_SUGGESTIONS).executes(ctx -> MazeCommands.refreshMazeCmd((CommandContext<CommandSourceStack>)ctx, StringArgumentType.getString((CommandContext)ctx, (String)"name"), StringArgumentType.getString((CommandContext)ctx, (String)"args"))))))).then(Commands.m_82127_((String)"wins").then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeData maze = MazeManager.get().getMaze(name);
            if (maze == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Maze not found!"));
                return 0;
            }
            MazeManager.get().resetWins(name);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Wins reset for maze '" + name + "'!")), true);
            return 1;
        }))))).then(Commands.m_82127_((String)"stop").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeData maze = MazeManager.get().getMaze(name);
            if (maze == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Maze not found!"));
                return 0;
            }
            maze.running = false;
            MazeManager.get().getSavedData().m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Maze '" + name + "' timer stopped.")), true);
            return 1;
        })))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeData maze = MazeManager.get().getMaze(name);
            if (maze == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Maze not found!"));
                return 0;
            }
            maze.running = false;
            maze.remainingSeconds = maze.intervalSeconds;
            MazeManager.get().getSavedData().m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Maze '" + name + "' reset.")), true);
            return 1;
        })))).then(Commands.m_82127_((String)"settime").then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"unit", (ArgumentType)StringArgumentType.word()).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            int finalSeconds;
            int time = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time");
            String unit = StringArgumentType.getString((CommandContext)ctx, (String)"unit").toLowerCase();
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeData maze = MazeManager.get().getMaze(name);
            if (maze == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Maze not found!"));
                return 0;
            }
            int seconds = 0;
            if (unit.startsWith("min") || unit.equals("m")) {
                seconds = time * 60;
            } else if (unit.startsWith("sec") || unit.equals("s")) {
                seconds = time;
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Unknown unit. Use: minute/min/second/sec"));
                return 0;
            }
            maze.intervalSeconds = finalSeconds = seconds;
            maze.remainingSeconds = finalSeconds;
            MazeManager.get().getSavedData().m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Timer set to " + finalSeconds + "s for '" + name + "'")), true);
            return 1;
        })))))).then(Commands.m_82127_((String)"zombie").then(Commands.m_82127_((String)"count").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0, (int)50)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            int count = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"number");
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeData maze = MazeManager.get().getMaze(name);
            if (maze == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Maze not found!"));
                return 0;
            }
            maze.zombieCount = count;
            MazeManager.get().getSavedData().m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Zombie count set to " + count + " for '" + name + "'")), true);
            return 1;
        })))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"chest").then(Commands.m_82127_((String)"count").then(Commands.m_82129_((String)"number", (ArgumentType)IntegerArgumentType.integer((int)0, (int)20)).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            int count = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"number");
            String name = StringArgumentType.getString((CommandContext)ctx, (String)"name");
            MazeData maze = MazeManager.get().getMaze(name);
            if (maze == null) {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"\u274c Maze not found!"));
                return 0;
            }
            maze.chestCount = count;
            MazeManager.get().getSavedData().m_77762_();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Chest count set to " + count + " for '" + name + "'")), true);
            return 1;
        }))))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"lootdrop").then(Commands.m_82127_((String)"on").executes(ctx -> {
            MazeManager.get().setLootDropEnabled(true);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u2705 Loot Drop System: ON"), true);
            return 1;
        }))).then(Commands.m_82127_((String)"off").executes(ctx -> {
            MazeManager.get().setLootDropEnabled(false);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"\u274c Loot Drop System: OFF"), true);
            return 1;
        })))).then(Commands.m_82127_((String)"ld").then(Commands.m_82127_((String)"time").then(Commands.m_82129_((String)"time", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.m_82129_((String)"unit", (ArgumentType)StringArgumentType.word()).executes(ctx -> {
            int t = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"time");
            String u = StringArgumentType.getString((CommandContext)ctx, (String)"unit").toLowerCase();
            int sec = 0;
            if (u.startsWith("min")) {
                sec = t * 60;
            } else if (u.startsWith("sec")) {
                sec = t;
            } else {
                ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)"Use minute/second"));
                return 0;
            }
            int finalSec = sec;
            MazeManager.get().setLootDropInterval(finalSec);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2705 Loot Drop Interval: " + finalSec + "s")), true);
            return 1;
        })))))));
    }

    private static int fail(CommandContext<CommandSourceStack> ctx, String msg) {
        ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("\u274c " + msg)));
        return 0;
    }

    private static void applyArgs(MazeData maze, String args) {
        String[] tokens;
        if (args == null || args.isEmpty()) {
            return;
        }
        for (String t : tokens = args.split(" ")) {
            try {
                if (t.startsWith("H:")) {
                    maze.height = Integer.parseInt(t.substring(2));
                    continue;
                }
                if (t.startsWith("W:")) {
                    maze.pathWidth = Integer.parseInt(t.substring(2));
                    continue;
                }
                if (t.startsWith("WW:")) {
                    maze.wallWidth = Integer.parseInt(t.substring(3));
                    continue;
                }
                if (t.startsWith("C:")) {
                    maze.wallColor = t.substring(2);
                    continue;
                }
                if (t.startsWith("F:")) {
                    maze.floorColor = t.substring(2);
                    continue;
                }
                if (t.startsWith("P:")) {
                    maze.stoneChance = Integer.parseInt(t.substring(2));
                    continue;
                }
                if (t.startsWith("EX:")) {
                    maze.hasExits = Boolean.parseBoolean(t.substring(3));
                    continue;
                }
                if (t.startsWith("ROOM:")) {
                    maze.hasRoom = Boolean.parseBoolean(t.substring(5));
                    continue;
                }
                if (t.startsWith("ER:")) {
                    maze.erosion = Float.parseFloat(t.substring(3));
                    continue;
                }
                if (t.startsWith("CL:")) {
                    maze.isClosed = Boolean.parseBoolean(t.substring(3));
                    continue;
                }
                if (t.startsWith("T:")) {
                    maze.hasTorches = Boolean.parseBoolean(t.substring(2));
                    continue;
                }
                if (t.startsWith("L:")) {
                    maze.isLifeRoom = Boolean.parseBoolean(t.substring(2));
                    continue;
                }
                if (t.startsWith("LE:")) {
                    maze.exitsCount = Integer.parseInt(t.substring(3));
                    continue;
                }
                if (t.startsWith("LC:")) {
                    maze.lifeChests = Boolean.parseBoolean(t.substring(3));
                    continue;
                }
                if (t.startsWith("LRCC:")) {
                    maze.lifeRoomChestCount = Integer.parseInt(t.substring(5));
                    continue;
                }
                if (!t.startsWith("THEME:")) continue;
                maze.themeName = t.substring(6);
                MazeThemeManager.reload();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (maze.pathWidth < 1) {
            maze.pathWidth = 1;
        }
    }

    private static int rebuildMaze(CommandContext<CommandSourceStack> ctx, String name, String args) {
        MazeSavedData data = MazeManager.get().getSavedData();
        MazeData existing = data.getMaze(name);
        if (existing == null) {
            return MazeCommands.fail(ctx, "Maze '" + name + "' not found!");
        }
        BlockPos p1 = existing.pos1;
        BlockPos p2 = existing.pos2;
        int h = existing.height;
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).m_81372_();
        BoundingBox box = BoundingBox.m_162375_((Vec3i)p1, (Vec3i)p2);
        int yMax = box.m_162396_() + h + 5;
        AABB aabb = new AABB((double)box.m_162395_(), (double)box.m_162396_(), (double)box.m_162398_(), (double)(box.m_162399_() + 1), (double)yMax, (double)(box.m_162401_() + 1));
        level.m_45976_(ItemEntity.class, aabb).forEach(Entity::m_146870_);
        ZombieManager.get().killAll(level, name);
        data.deleteMaze(name);
        data.pendingPos1.put(name, p1);
        data.pendingPos2.put(name, p2);
        return MazeCommands.createMaze(ctx, name, args);
    }

    private static int createMaze(CommandContext<CommandSourceStack> ctx, String name, String args) {
        MazeSavedData data = MazeManager.get().getSavedData();
        BlockPos p1 = data.pendingPos1.get(name);
        BlockPos p2 = data.pendingPos2.get(name);
        if (p1 == null || p2 == null) {
            return MazeCommands.fail(ctx, "Set pos1 and pos2 for '" + name + "' first using /maze pos1/pos2 <name>!");
        }
        if (data.getMaze(name) != null) {
            return MazeCommands.fail(ctx, "Maze '" + name + "' already exists!");
        }
        MazeData temp = new MazeData(name);
        MazeCommands.applyArgs(temp, args);
        int h = temp.height;
        int x1 = Math.min(p1.m_123341_(), p2.m_123341_());
        int y1 = Math.min(p1.m_123342_(), p2.m_123342_());
        int z1 = Math.min(p1.m_123343_(), p2.m_123343_());
        int x2 = Math.max(p1.m_123341_(), p2.m_123341_());
        int z2 = Math.max(p1.m_123343_(), p2.m_123343_());
        int y2 = y1 + h - 1;
        BoundingBox newBox = new BoundingBox(x1, y1, z1, x2, y2, z2);
        if (data.checkCollision(newBox)) {
            return MazeCommands.fail(ctx, "Collision detected with another maze!");
        }
        MazeData maze = data.createMaze(name);
        maze.pos1 = p1;
        maze.pos2 = p2;
        maze.height = temp.height;
        maze.pathWidth = temp.pathWidth;
        maze.wallWidth = temp.wallWidth;
        maze.wallColor = temp.wallColor;
        maze.floorColor = temp.floorColor;
        maze.stoneChance = temp.stoneChance;
        maze.hasExits = temp.hasExits;
        maze.hasRoom = temp.hasRoom;
        maze.erosion = temp.erosion;
        maze.isClosed = temp.isClosed;
        maze.themeName = temp.themeName;
        maze.hasTorches = temp.hasTorches;
        maze.isLifeRoom = temp.isLifeRoom;
        MazeGenerator.generate(((CommandSourceStack)ctx.getSource()).m_81372_(), newBox, maze, false);
        data.m_77762_();
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2728 Created Maze '" + name + "' (Theme: " + (maze.themeName.isEmpty() ? "None" : maze.themeName) + ")")), true);
        return 1;
    }

    private static int refreshMazeCmd(CommandContext<CommandSourceStack> ctx, String name, String args) {
        MazeSavedData data = MazeManager.get().getSavedData();
        MazeData maze = data.getMaze(name);
        if (maze == null) {
            return MazeCommands.fail(ctx, "Maze not found!");
        }
        MazeThemeManager.reload();
        MazeCommands.applyArgs(maze, args);
        data.m_77762_();
        MazeManager.get().refreshMaze(((CommandSourceStack)ctx.getSource()).m_81372_(), name);
        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("\u2728 Refreshed maze '" + name + "'")), true);
        return 1;
    }
}

