/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;

public class MazeThemeManager {
    private static final Map<String, Theme> THEMES = new HashMap<String, Theme>();

    public static void reload() {
        THEMES.clear();
        try {
            Path file;
            Path configDir = FMLPaths.CONFIGDIR.get().resolve("maze_mod");
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
            }
            if (!Files.exists(file = configDir.resolve("maze_themes.yml"), new LinkOption[0])) {
                MazeThemeManager.createDefault(file);
            }
            MazeThemeManager.parse(file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void createDefault(Path file) throws Exception {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("stone:");
        lines.add("  wall:");
        lines.add("    STONE: 40");
        lines.add("    ANDESITE: 20");
        lines.add("  floor:");
        lines.add("    STONE: 1");
        lines.add("  top:");
        lines.add("    STONE: 10");
        lines.add("forest:");
        lines.add("  wall:");
        lines.add("    OAK_LEAVES: 10");
        lines.add("    OAK_LOG: 5");
        lines.add("  floor:");
        lines.add("    MOSS_BLOCK: 1");
        lines.add("  top:");
        lines.add("    OAK_LOG: 3");
        Files.write(file, lines, new OpenOption[0]);
    }

    private static void parse(Path file) throws Exception {
        List<String> lines = Files.readAllLines(file);
        Theme currentTheme = null;
        String currentSection = null;
        for (String line : lines) {
            ResourceLocation loc;
            String[] parts;
            int indent;
            if (line.trim().isEmpty() || line.trim().startsWith("#")) continue;
            for (indent = 0; indent < line.length() && line.charAt(indent) == ' '; ++indent) {
            }
            String content = line.trim();
            if (indent == 0) {
                String name = content.replace(":", "");
                currentTheme = new Theme();
                THEMES.put(name, currentTheme);
                currentSection = null;
                continue;
            }
            if (indent == 2) {
                if (currentTheme == null) continue;
                currentSection = content.replace(":", "");
                currentTheme.sections.put(currentSection, new WeightedList());
                continue;
            }
            if (indent < 4 || currentTheme == null || currentSection == null || (parts = content.split(":")).length != 2) continue;
            String blockName = parts[0].trim();
            int weight = 1;
            try {
                weight = Integer.parseInt(parts[1].trim());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!ForgeRegistries.BLOCKS.containsKey(loc = new ResourceLocation(blockName.toLowerCase()))) continue;
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(loc);
            currentTheme.sections.get(currentSection).add(b.m_49966_(), weight);
        }
    }

    public static BlockState getBlock(String themeName, String section, Random rand, BlockState fallback) {
        Theme theme = THEMES.get(themeName);
        if (theme == null) {
            return fallback;
        }
        WeightedList list = theme.sections.get(section);
        if (list == null || list.isEmpty()) {
            return fallback;
        }
        return list.getRandom(rand);
    }

    public static boolean hasTheme(String name) {
        if (THEMES.isEmpty()) {
            MazeThemeManager.reload();
        }
        return THEMES.containsKey(name);
    }

    public static Set<String> getThemeNames() {
        if (THEMES.isEmpty()) {
            MazeThemeManager.reload();
        }
        return THEMES.keySet();
    }

    public static class Theme {
        public Map<String, WeightedList> sections = new HashMap<String, WeightedList>();
    }

    public static class WeightedList {
        public List<Entry> entries = new ArrayList<Entry>();
        public int totalWeight = 0;

        public void add(BlockState state, int weight) {
            this.entries.add(new Entry(state, weight));
            this.totalWeight += weight;
        }

        public BlockState getRandom(Random rand) {
            if (this.totalWeight <= 0) {
                return Blocks.f_50069_.m_49966_();
            }
            int r = rand.nextInt(this.totalWeight);
            int current = 0;
            for (Entry e : this.entries) {
                if (r >= (current += e.weight)) continue;
                return e.state;
            }
            return this.entries.get((int)0).state;
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }
    }

    private static class Entry {
        BlockState state;
        int weight;

        Entry(BlockState s, int w) {
            this.state = s;
            this.weight = w;
        }
    }
}

