/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.events;

import com.trae.maze.logic.MazeData;
import com.trae.maze.logic.MazeManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.event.entity.living.LivingChangeTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ZombieAIHandler {
    @SubscribeEvent
    public static void onZombieTargetChange(LivingChangeTargetEvent event) {
        if (!(event.getEntity() instanceof Zombie)) {
            return;
        }
        Zombie zombie = (Zombie)event.getEntity();
        LivingEntity target = event.getNewTarget();
        if (!(target instanceof Player)) {
            return;
        }
        Player player = (Player)target;
        String zombieTag = null;
        for (String tag : zombie.m_19880_()) {
            if (!tag.startsWith("MazeZombie_")) continue;
            zombieTag = tag.substring("MazeZombie_".length());
            break;
        }
        if (zombieTag == null) {
            return;
        }
        MazeData maze = MazeManager.get().getSavedData().getMaze(zombieTag);
        if (maze == null) {
            return;
        }
        if (maze.isLifeRoom && maze.center != null && maze.hasRoom && maze.pos1 != null && maze.pos2 != null) {
            int w = Math.abs(maze.pos1.m_123341_() - maze.pos2.m_123341_()) + 1;
            int d = Math.abs(maze.pos1.m_123343_() - maze.pos2.m_123343_()) + 1;
            int r = Math.max(2, Math.min(w - 2, d - 2) / 6);
            BlockPos playerPos = player.m_20183_();
            if (playerPos.m_123314_((Vec3i)maze.center, (double)(r + 1))) {
                event.setCanceled(true);
                zombie.m_6710_(null);
                zombie.m_21573_().m_26573_();
            }
        }
    }
}

