/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class MazeData {
    public String name;
    public BlockPos pos1 = null;
    public BlockPos pos2 = null;
    public BlockPos center = null;
    public BlockPos entrancePos = null;
    public int height = 5;
    public int pathWidth = 1;
    public int wallWidth = 1;
    public String wallColor = "RED_CONCRETE";
    public String floorColor = "BLUE_CONCRETE";
    public int stoneChance = 0;
    public boolean hasExits = true;
    public boolean hasRoom = true;
    public float erosion = 0.0f;
    public boolean isClosed = false;
    public String themeName = "";
    public boolean hasTorches = false;
    public boolean isLifeRoom = false;
    public int exitsCount = 4;
    public boolean lifeChests = false;
    public int lifeRoomChestCount = 3;
    public boolean mobSpawnBanned = false;
    public boolean running = false;
    public int intervalSeconds;
    public int remainingSeconds = this.intervalSeconds = 600;
    public Integer zombieCount = null;
    public Integer chestCount = null;
    public int zombieTtlSeconds = 120;
    public int difficulty = 0;
    public int lootChancePercent = 20;
    private final Map<UUID, Integer> playerWins = new HashMap<UUID, Integer>();

    public MazeData(String name) {
        this.name = name;
    }

    public void addWin(UUID playerId) {
        this.playerWins.put(playerId, this.playerWins.getOrDefault(playerId, 0) + 1);
    }

    public int getWins(UUID playerId) {
        return this.playerWins.getOrDefault(playerId, 0);
    }

    public void resetWins() {
        this.playerWins.clear();
    }

    public CompoundTag save(CompoundTag tag) {
        tag.m_128359_("name", this.name);
        if (this.pos1 != null) {
            tag.m_128356_("pos1", this.pos1.m_121878_());
        }
        if (this.pos2 != null) {
            tag.m_128356_("pos2", this.pos2.m_121878_());
        }
        if (this.center != null) {
            tag.m_128356_("center", this.center.m_121878_());
        }
        if (this.entrancePos != null) {
            tag.m_128356_("entrancePos", this.entrancePos.m_121878_());
        }
        tag.m_128405_("height", this.height);
        tag.m_128405_("pathWidth", this.pathWidth);
        tag.m_128405_("wallWidth", this.wallWidth);
        tag.m_128359_("wallColor", this.wallColor);
        tag.m_128359_("floorColor", this.floorColor);
        tag.m_128405_("stoneChance", this.stoneChance);
        tag.m_128379_("hasExits", this.hasExits);
        tag.m_128379_("hasRoom", this.hasRoom);
        tag.m_128350_("erosion", this.erosion);
        tag.m_128379_("isClosed", this.isClosed);
        tag.m_128359_("themeName", this.themeName);
        tag.m_128379_("hasTorches", this.hasTorches);
        tag.m_128379_("hasTorches", this.hasTorches);
        tag.m_128379_("isLifeRoom", this.isLifeRoom);
        tag.m_128405_("exitsCount", this.exitsCount);
        tag.m_128379_("lifeChests", this.lifeChests);
        tag.m_128405_("lifeRoomChestCount", this.lifeRoomChestCount);
        tag.m_128379_("mobSpawnBanned", this.mobSpawnBanned);
        tag.m_128379_("running", this.running);
        tag.m_128405_("intervalSeconds", this.intervalSeconds);
        tag.m_128405_("remainingSeconds", this.remainingSeconds);
        if (this.zombieCount != null) {
            tag.m_128405_("zombieCount", this.zombieCount.intValue());
        }
        if (this.chestCount != null) {
            tag.m_128405_("chestCount", this.chestCount.intValue());
        }
        tag.m_128405_("zombieTtlSeconds", this.zombieTtlSeconds);
        tag.m_128405_("difficulty", this.difficulty);
        tag.m_128405_("lootChancePercent", this.lootChancePercent);
        CompoundTag winsTag = new CompoundTag();
        this.playerWins.forEach((uuid, count) -> winsTag.m_128405_(uuid.toString(), count.intValue()));
        tag.m_128365_("playerWins", (Tag)winsTag);
        return tag;
    }

    public static MazeData load(CompoundTag tag) {
        MazeData data = new MazeData(tag.m_128461_("name"));
        if (tag.m_128441_("pos1")) {
            data.pos1 = BlockPos.m_122022_((long)tag.m_128454_("pos1"));
        }
        if (tag.m_128441_("pos2")) {
            data.pos2 = BlockPos.m_122022_((long)tag.m_128454_("pos2"));
        }
        if (tag.m_128441_("center")) {
            data.center = BlockPos.m_122022_((long)tag.m_128454_("center"));
        }
        if (tag.m_128441_("entrancePos")) {
            data.entrancePos = BlockPos.m_122022_((long)tag.m_128454_("entrancePos"));
        }
        if (tag.m_128441_("height")) {
            data.height = tag.m_128451_("height");
        }
        if (tag.m_128441_("pathWidth")) {
            data.pathWidth = tag.m_128451_("pathWidth");
        }
        if (tag.m_128441_("wallWidth")) {
            data.wallWidth = tag.m_128451_("wallWidth");
        }
        if (tag.m_128441_("wallColor")) {
            data.wallColor = tag.m_128461_("wallColor");
        }
        if (tag.m_128441_("floorColor")) {
            data.floorColor = tag.m_128461_("floorColor");
        }
        if (tag.m_128441_("stoneChance")) {
            data.stoneChance = tag.m_128451_("stoneChance");
        }
        if (tag.m_128441_("hasExits")) {
            data.hasExits = tag.m_128471_("hasExits");
        }
        if (tag.m_128441_("hasRoom")) {
            data.hasRoom = tag.m_128471_("hasRoom");
        }
        if (tag.m_128441_("erosion")) {
            data.erosion = tag.m_128457_("erosion");
        }
        if (tag.m_128441_("isClosed")) {
            data.isClosed = tag.m_128471_("isClosed");
        }
        if (tag.m_128441_("themeName")) {
            data.themeName = tag.m_128461_("themeName");
        }
        if (tag.m_128441_("hasTorches")) {
            data.hasTorches = tag.m_128471_("hasTorches");
        }
        if (tag.m_128441_("isLifeRoom")) {
            data.isLifeRoom = tag.m_128471_("isLifeRoom");
        }
        if (tag.m_128441_("exitsCount")) {
            data.exitsCount = tag.m_128451_("exitsCount");
        }
        if (tag.m_128441_("lifeChests")) {
            data.lifeChests = tag.m_128471_("lifeChests");
        }
        if (tag.m_128441_("lifeRoomChestCount")) {
            data.lifeRoomChestCount = tag.m_128451_("lifeRoomChestCount");
        }
        if (tag.m_128441_("mobSpawnBanned")) {
            data.mobSpawnBanned = tag.m_128471_("mobSpawnBanned");
        }
        data.running = tag.m_128471_("running");
        data.intervalSeconds = tag.m_128451_("intervalSeconds");
        data.remainingSeconds = tag.m_128451_("remainingSeconds");
        if (tag.m_128441_("zombieCount")) {
            data.zombieCount = tag.m_128451_("zombieCount");
        }
        if (tag.m_128441_("chestCount")) {
            data.chestCount = tag.m_128451_("chestCount");
        }
        data.zombieTtlSeconds = tag.m_128451_("zombieTtlSeconds");
        data.difficulty = tag.m_128451_("difficulty");
        data.lootChancePercent = tag.m_128451_("lootChancePercent");
        if (tag.m_128441_("playerWins")) {
            CompoundTag winsTag = tag.m_128469_("playerWins");
            for (String key : winsTag.m_128431_()) {
                try {
                    data.playerWins.put(UUID.fromString(key), winsTag.m_128451_(key));
                }
                catch (Exception exception) {}
            }
        }
        return data;
    }

    public int getEffectiveZombieCount() {
        if (this.zombieCount != null) {
            return this.zombieCount;
        }
        if (this.pos1 == null || this.pos2 == null) {
            return 5;
        }
        int width = Math.abs(this.pos2.m_123341_() - this.pos1.m_123341_()) + 1;
        int depth = Math.abs(this.pos2.m_123343_() - this.pos1.m_123343_()) + 1;
        int size = width * depth;
        int count = size / 20;
        return Math.max(1, Math.min(count, 10));
    }

    public int getEffectiveChestCount() {
        if (this.chestCount != null) {
            return this.chestCount;
        }
        if (this.pos1 == null || this.pos2 == null) {
            return 3;
        }
        int width = Math.abs(this.pos2.m_123341_() - this.pos1.m_123341_()) + 1;
        int depth = Math.abs(this.pos2.m_123343_() - this.pos1.m_123343_()) + 1;
        int size = width * depth;
        int count = size / 30;
        if (this.isLifeRoom) {
            count = 2 + (size > 2000 ? 1 : 0);
            return count;
        }
        return Math.max(1, Math.min(count, 6));
    }
}

