/*
 * Decompiled with CFR 0.152.
 */
package com.trae.maze.logic;

import com.trae.maze.MazeEventHandler;
import com.trae.maze.logic.MazeData;
import com.trae.maze.logic.MazeRules;
import com.trae.maze.logic.MazeSavedData;
import com.trae.maze.net.Network;
import com.trae.maze.net.packet.S2CTimerPacket;
import com.trae.maze.world.LootManager;
import com.trae.maze.world.MazeGenerator;
import com.trae.maze.world.ZombieManager;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.network.PacketDistributor;

public class MazeManager {
    private static final MazeManager INSTANCE = new MazeManager();
    private MinecraftServer server;
    private MazeSavedData savedData;
    private final Map<UUID, String> playerCurrentMaze = new HashMap<UUID, String>();
    private final Map<UUID, Integer> centerTime = new HashMap<UUID, Integer>();
    private int tickCounter = 0;
    private boolean lootDropEnabled = true;
    private int lootIntervalTick;
    private int lootTimer = this.lootIntervalTick = 1200;
    private final Map<UUID, Integer> playerHits = new HashMap<UUID, Integer>();

    public static MazeManager get() {
        return INSTANCE;
    }

    public void setLootDropEnabled(boolean v) {
        this.lootDropEnabled = v;
    }

    public void setLootDropInterval(int sec) {
        this.lootTimer = this.lootIntervalTick = sec * 20;
    }

    public void onServerStarting(MinecraftServer server) {
        this.server = server;
        ServerLevel overworld = server.m_129783_();
        this.savedData = (MazeSavedData)overworld.m_8895_().m_164861_(MazeSavedData::load, MazeSavedData::new, "maze_data");
        MinecraftForge.EVENT_BUS.register((Object)this);
        ZombieManager.get().init(server);
        LootManager.get().init(server);
    }

    public MazeSavedData getSavedData() {
        return this.savedData;
    }

    public MazeData getMaze(String name) {
        return this.savedData.getMaze(name);
    }

    public String findMazeAtPosition(BlockPos pos) {
        for (Map.Entry<String, MazeData> entry : this.savedData.getAllMazes().entrySet()) {
            MazeData maze = entry.getValue();
            if (!this.isInsideMaze(maze, pos)) continue;
            return entry.getKey();
        }
        return null;
    }

    public boolean isInsideMaze(MazeData maze, BlockPos pos) {
        if (maze.pos1 == null || maze.pos2 == null) {
            return false;
        }
        int xMin = Math.min(maze.pos1.m_123341_(), maze.pos2.m_123341_());
        int xMax = Math.max(maze.pos1.m_123341_(), maze.pos2.m_123341_());
        int yMin = Math.min(maze.pos1.m_123342_(), maze.pos2.m_123342_());
        int zMin = Math.min(maze.pos1.m_123343_(), maze.pos2.m_123343_());
        int zMax = Math.max(maze.pos1.m_123343_(), maze.pos2.m_123343_());
        int effectiveHeight = Math.max(3, maze.height);
        int yMax = yMin + effectiveHeight - 1;
        return pos.m_123341_() >= xMin && pos.m_123341_() <= xMax && pos.m_123342_() >= yMin && pos.m_123342_() <= yMax && pos.m_123343_() >= zMin && pos.m_123343_() <= zMax;
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || this.server == null) {
            return;
        }
        ++this.tickCounter;
        boolean shouldDecrementTimer = this.tickCounter % 20 == 0;
        ServerLevel level = this.server.m_129783_();
        if (this.lootDropEnabled) {
            --this.lootTimer;
            if (this.lootTimer <= 0) {
                this.lootTimer = this.lootIntervalTick;
                for (MazeData m : this.savedData.getAllMazes().values()) {
                    this.clearDroppedItems(level, m);
                }
            }
        }
        for (Map.Entry<String, MazeData> entry : this.savedData.getAllMazes().entrySet()) {
            String mazeName = entry.getKey();
            MazeData maze = entry.getValue();
            if (!maze.running || !shouldDecrementTimer) continue;
            if (maze.remainingSeconds > 0) {
                --maze.remainingSeconds;
                this.savedData.m_77762_();
                continue;
            }
            this.rebuildMaze(level, mazeName);
            maze.remainingSeconds = maze.intervalSeconds;
            this.savedData.m_77762_();
        }
        Iterator<Object> iterator = this.server.m_6846_().m_11314_().iterator();
        while (true) {
            ServerPlayer player;
            block28: {
                String durability;
                int wins;
                MazeData maze;
                block30: {
                    int hits;
                    block31: {
                        block29: {
                            String currentMaze;
                            block26: {
                                block27: {
                                    String previousMaze;
                                    if (!iterator.hasNext()) {
                                        ZombieManager.get().tick(level, this.savedData);
                                        return;
                                    }
                                    player = (ServerPlayer)iterator.next();
                                    BlockPos playerPos = player.m_20183_();
                                    currentMaze = this.findMazeAtPosition(playerPos);
                                    if (!Objects.equals(currentMaze, previousMaze = this.playerCurrentMaze.get(player.m_20148_()))) {
                                        if (previousMaze != null) {
                                            MazeRules.removeMazeArmor(player);
                                            this.centerTime.remove(player.m_20148_());
                                        }
                                        if (currentMaze != null) {
                                            maze = this.getMaze(currentMaze);
                                            if (maze.isLifeRoom && maze.center != null && previousMaze == null) {
                                                player.m_8999_(level, (double)maze.center.m_123341_() + 0.5, (double)(maze.center.m_123342_() + 1), (double)maze.center.m_123343_() + 0.5, player.m_146908_(), player.m_146909_());
                                            }
                                            wins = maze.getWins(player.m_20148_());
                                            this.resetPlayerHits(player.m_20148_());
                                            MazeRules.applyEnterArmor(player, wins);
                                            MazeEventHandler.setPlayerLastMaze(player.m_20148_(), currentMaze);
                                        }
                                        this.playerCurrentMaze.put(player.m_20148_(), currentMaze);
                                    }
                                    if (currentMaze != null) {
                                        maze = this.getMaze(currentMaze);
                                        if (maze != null && !this.hasCompass(player) && player.m_150109_().m_36054_(this.createCompass(maze, (Level)level))) {
                                            // empty if block
                                        }
                                    } else {
                                        this.removeCompass(player);
                                    }
                                    if (currentMaze == null) break block26;
                                    maze = this.getMaze(currentMaze);
                                    if (maze.center == null || !playerPos.m_123314_((Vec3i)maze.center, 1.5)) break block27;
                                    if (!maze.isLifeRoom) {
                                        this.centerTime.put(player.m_20148_(), this.centerTime.getOrDefault(player.m_20148_(), 0) + 1);
                                        if (this.centerTime.get(player.m_20148_()) >= 50) {
                                            MazeRules.incrementWinsAndTeleportOut(maze, player);
                                            this.centerTime.remove(player.m_20148_());
                                            this.playerCurrentMaze.remove(player.m_20148_());
                                        }
                                    }
                                    break block26;
                                }
                                this.centerTime.remove(player.m_20148_());
                            }
                            if (currentMaze == null) break block28;
                            maze = this.getMaze(currentMaze);
                            wins = maze.getWins(player.m_20148_());
                            hits = this.getPlayerHits(player.m_20148_());
                            durability = "None";
                            if (wins != 1) break block29;
                            durability = hits == 0 ? "High" : "Broken";
                            break block30;
                        }
                        if (wins != 2) break block31;
                        if (hits == 0) {
                            durability = "High";
                            break block30;
                        } else if (hits == 1) {
                            durability = "Low";
                        }
                        break block30;
                    }
                    if (wins >= 3) {
                        if (hits == 0) {
                            durability = "High";
                        } else if (hits == 1) {
                            durability = "Medium";
                        } else if (hits == 2) {
                            durability = "Low";
                        }
                    }
                }
                Network.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CTimerPacket(maze.remainingSeconds, wins, true, durability, this.lootTimer / 20));
                continue;
            }
            Network.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CTimerPacket(0, 0, false, "", this.lootTimer / 20));
        }
    }

    public void rebuildMaze(ServerLevel level, String mazeName) {
        MazeData maze = this.getMaze(mazeName);
        if (maze == null) {
            return;
        }
        BoundingBox box = BoundingBox.m_162375_((Vec3i)maze.pos1, (Vec3i)maze.pos2);
        for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
            if (!this.isInsideMaze(maze, player.m_20183_())) continue;
            player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 100, 1, true, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 100, 1, true, false));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, 255, true, false));
        }
        boolean preserve = maze.isLifeRoom && maze.hasRoom;
        MazeGenerator.generate(level, box, maze, preserve);
        for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
            if (!this.isInsideMaze(maze, player.m_20183_())) continue;
            boolean safe = false;
            if (maze.isLifeRoom && maze.center != null && maze.hasRoom) {
                BoundingBox b = BoundingBox.m_162375_((Vec3i)maze.pos1, (Vec3i)maze.pos2);
                int minDim = Math.min(b.m_71056_() - 2, b.m_71058_() - 2);
                int r = Math.max(2, minDim / 6);
                if (player.m_20183_().m_123314_((Vec3i)maze.center, (double)(r + 2))) {
                    safe = true;
                }
            }
            if (safe) continue;
            player.m_6469_(level.m_269111_().m_269264_(), 1000.0f);
        }
        this.clearEntities(level, maze);
        ZombieManager.get().respawnWave(level, box, maze, mazeName);
    }

    public void forceRebuild(ServerLevel level, String mazeName) {
        this.rebuildMaze(level, mazeName);
    }

    private void clearEntities(ServerLevel level, MazeData maze) {
        if (maze.pos1 == null || maze.pos2 == null) {
            return;
        }
        BoundingBox box = BoundingBox.m_162375_((Vec3i)maze.pos1, (Vec3i)maze.pos2);
        int height = Math.max(3, maze.height);
        AABB aabb = new AABB((double)(box.m_162395_() - 2), (double)(box.m_162396_() - 2), (double)(box.m_162398_() - 2), (double)(box.m_162399_() + 2), (double)(box.m_162396_() + height + 2), (double)(box.m_162401_() + 2));
        List items = level.m_45976_(ItemEntity.class, aabb);
        for (ItemEntity e : items) {
            e.m_6074_();
        }
        ZombieManager.get().killAll(level, maze.name);
    }

    private void clearDroppedItems(ServerLevel level, MazeData maze) {
        if (maze.pos1 == null || maze.pos2 == null) {
            return;
        }
        BoundingBox box = BoundingBox.m_162375_((Vec3i)maze.pos1, (Vec3i)maze.pos2);
        int height = Math.max(3, maze.height);
        AABB aabb = new AABB((double)(box.m_162395_() - 2), (double)(box.m_162396_() - 2), (double)(box.m_162398_() - 2), (double)(box.m_162399_() + 2), (double)(box.m_162396_() + height + 2), (double)(box.m_162401_() + 2));
        level.m_45976_(ItemEntity.class, aabb).forEach(Entity::m_6074_);
    }

    public void refreshMaze(ServerLevel level, String mazeName) {
        MazeData maze = this.getMaze(mazeName);
        if (maze == null) {
            return;
        }
        BoundingBox box = BoundingBox.m_162375_((Vec3i)maze.pos1, (Vec3i)maze.pos2);
        for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
            if (!this.isInsideMaze(maze, player.m_20183_())) continue;
            if (maze.isLifeRoom && maze.hasRoom && maze.center != null) {
                BoundingBox b = BoundingBox.m_162375_((Vec3i)maze.pos1, (Vec3i)maze.pos2);
                int minDim = Math.min(b.m_71056_() - 2, b.m_71058_() - 2);
                int r = Math.max(2, minDim / 6);
                if (player.m_20183_().m_123314_((Vec3i)maze.center, (double)(r + 2))) continue;
            }
            player.m_21219_();
            MazeRules.removeMazeArmor(player);
            player.m_150109_().m_36022_(itemStack -> true, -1, (Container)player.f_36095_.m_39730_());
            player.m_150109_().m_6211_();
            this.resetPlayerHits(player.m_20148_());
            if (maze.entrancePos != null) {
                player.m_6021_((double)maze.entrancePos.m_123341_(), (double)maze.entrancePos.m_123342_(), (double)maze.entrancePos.m_123343_());
                continue;
            }
            BlockPos spawn = level.m_220360_();
            player.m_6021_((double)spawn.m_123341_(), (double)spawn.m_123342_(), (double)spawn.m_123343_());
        }
        this.clearEntities(level, maze);
        boolean preserve = maze.isLifeRoom && maze.hasRoom;
        MazeGenerator.generate(level, box, maze, preserve);
        ZombieManager.get().respawnWave(level, box, maze, mazeName);
        maze.remainingSeconds = maze.intervalSeconds;
        this.savedData.m_77762_();
    }

    public void resetWins(String mazeName) {
        MazeData maze = this.getMaze(mazeName);
        if (maze == null) {
            return;
        }
        maze.resetWins();
        this.savedData.m_77762_();
        if (this.server != null) {
            for (ServerPlayer player : this.server.m_6846_().m_11314_()) {
                if (!this.isInsideMaze(maze, player.m_20183_())) continue;
                this.resetPlayerHits(player.m_20148_());
                MazeRules.removeMazeArmor(player);
                Network.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new S2CTimerPacket(maze.remainingSeconds, 0, true, "None", this.lootTimer / 20));
            }
        }
    }

    public int getPlayerHits(UUID playerId) {
        return this.playerHits.getOrDefault(playerId, 0);
    }

    public void addPlayerHit(UUID playerId) {
        this.playerHits.put(playerId, this.getPlayerHits(playerId) + 1);
    }

    public void resetPlayerHits(UUID playerId) {
        this.playerHits.remove(playerId);
    }

    @SubscribeEvent
    public void onPlayerAttacked(LivingAttackEvent event) {
        MazeRules.onPlayerAttacked(this, event);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        String mazeName = this.findMazeAtPosition(event.getPos());
        if (mazeName != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onBlockPlace(BlockEvent.EntityPlaceEvent event) {
        String mazeName = this.findMazeAtPosition(event.getPos());
        if (mazeName != null) {
            if (event.getState().m_60713_(Blocks.f_50088_)) {
                return;
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onSpawn(MobSpawnEvent.FinalizeSpawn event) {
        MazeData maze;
        String mazeName;
        MobSpawnType reason = event.getSpawnType();
        if ((reason == MobSpawnType.NATURAL || reason == MobSpawnType.CHUNK_GENERATION || reason == MobSpawnType.STRUCTURE) && (mazeName = this.findMazeAtPosition(new BlockPos((int)event.getX(), (int)event.getY(), (int)event.getZ()))) != null && (maze = this.getMaze(mazeName)) != null && maze.mobSpawnBanned) {
            event.setSpawnCancelled(true);
        }
    }

    private boolean hasCompass(ServerPlayer player) {
        for (ItemStack s : player.m_150109_().f_35974_) {
            if (s.m_41619_() || s.m_41720_() != Items.f_42522_ || !s.m_41782_() || !s.m_41783_().m_128441_("MazeCompass")) continue;
            return true;
        }
        return player.m_21206_().m_41720_() == Items.f_42522_ && player.m_21206_().m_41782_() && player.m_21206_().m_41783_().m_128441_("MazeCompass");
    }

    private void removeCompass(ServerPlayer player) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_() || stack.m_41720_() != Items.f_42522_ || !stack.m_41782_() || !stack.m_41783_().m_128441_("MazeCompass")) continue;
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
        }
    }

    private ItemStack createCompass(MazeData maze, Level level) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42522_);
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("MazeCompass", true);
        if (maze.center != null) {
            tag.m_128365_("LodestonePos", (Tag)NbtUtils.m_129224_((BlockPos)maze.center));
            tag.m_128359_("LodestoneDimension", level.m_46472_().m_135782_().toString());
            tag.m_128379_("LodestoneTracked", false);
        }
        stack.m_41751_(tag);
        stack.m_41663_(Enchantments.f_44963_, 1);
        stack.m_41714_((Component)Component.m_237113_((String)"Maze Compass").m_130940_(ChatFormatting.GOLD));
        return stack;
    }
}

